/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import org.odpi.openmetadata.accessservices.datamanager.api.MetadataSourceInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseManagerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileManagerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileSystemProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseManagerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileManagerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileSystemRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetClientBase;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class MetadataSourceClient
extends ConnectedAssetClientBase
implements MetadataSourceInterface {
    private DataManagerRESTClient restClient;
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources";

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
        this.restClient = restClient;
    }

    public String createFileSystem(String userId, String externalSourceGUID, String externalSourceName, FileSystemProperties fileSystemProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createFileSystem";
        String propertiesParameterName = "fileSystemProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createFileSystem");
        this.invalidParameterHandler.validateObject((Object)fileSystemProperties, "fileSystemProperties", "createFileSystem");
        this.invalidParameterHandler.validateName(fileSystemProperties.getQualifiedName(), "qualifiedName", "createFileSystem");
        FileSystemRequestBody requestBody = new FileSystemRequestBody(fileSystemProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources" + "/filesystems";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createFileSystem", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createFileManager(String userId, String externalSourceGUID, String externalSourceName, FileManagerProperties fileManagerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createFileManager";
        String propertiesParameterName = "fileManagerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createFileManager");
        this.invalidParameterHandler.validateObject((Object)fileManagerProperties, "fileManagerProperties", "createFileManager");
        this.invalidParameterHandler.validateName(fileManagerProperties.getQualifiedName(), "qualifiedName", "createFileManager");
        FileManagerRequestBody requestBody = new FileManagerRequestBody(fileManagerProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources" + "/file-managers";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createFileManager", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createDatabaseManager(String userId, String externalSourceGUID, String externalSourceName, DatabaseManagerProperties databaseManagerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseManager";
        String propertiesParameterName = "databaseManagerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseManager");
        this.invalidParameterHandler.validateObject((Object)databaseManagerProperties, "databaseManagerProperties", "createDatabaseManager");
        this.invalidParameterHandler.validateName(databaseManagerProperties.getQualifiedName(), "qualifiedName", "createDatabaseManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources" + "/database-managers";
        DatabaseManagerRequestBody requestBody = new DatabaseManagerRequestBody(databaseManagerProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseManager", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String getMetadataSourceGUID(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataSourceGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataSourceGUID");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getMetadataSourceGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources" + "/by-name/{2}";
        GUIDResponse restResult = this.restClient.callGUIDGetRESTCall("getMetadataSourceGUID", urlTemplate, new Object[]{this.serverName, userId, qualifiedName});
        return restResult.getGUID();
    }
}

