/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.APIManagerInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.SchemaManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIOperationElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIParameterListElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIOperationProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIParameterListProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIParameterListType;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIOperationRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIOperationResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIOperationsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class APIManagerClient
extends SchemaManagerClient
implements APIManagerInterface {
    private static final String apiURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis";
    private static final String defaultSchemaAttributeName = "APIParameter";

    public APIManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, auditLog);
    }

    public APIManagerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot);
    }

    public APIManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public APIManagerClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public APIManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, userId, password);
    }

    public String createAPI(String userId, String apiManagerGUID, String apiManagerName, boolean apiManagerIsHome, APIProperties apiProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAPI";
        String propertiesParameterName = "apiProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createAPI");
        this.invalidParameterHandler.validateObject((Object)apiProperties, "apiProperties", "createAPI");
        this.invalidParameterHandler.validateName(apiProperties.getQualifiedName(), "qualifiedName", "createAPI");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "?apiManagerIsHome={2}";
        APIRequestBody requestBody = new APIRequestBody(apiProperties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createAPI", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiManagerIsHome});
        return restResult.getGUID();
    }

    public String createAPIFromTemplate(String userId, String apiManagerGUID, String apiManagerName, boolean apiManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAPIFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createAPIFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createAPIFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createAPIFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createAPIFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/from-template/{2}?apiManagerIsHome={3}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createAPIFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, apiManagerIsHome});
        return restResult.getGUID();
    }

    public void updateAPI(String userId, String apiManagerGUID, String apiManagerName, String apiGUID, boolean isMergeUpdate, APIProperties apiProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAPI";
        String elementGUIDParameterName = "apiGUID";
        String propertiesParameterName = "apiProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateAPI");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "updateAPI");
        this.invalidParameterHandler.validateObject((Object)apiProperties, "apiProperties", "updateAPI");
        this.invalidParameterHandler.validateName(apiProperties.getQualifiedName(), "qualifiedName", "updateAPI");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/{2}?isMergeUpdate={3}";
        APIRequestBody requestBody = new APIRequestBody(apiProperties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        this.restClient.callVoidPostRESTCall("updateAPI", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiGUID, isMergeUpdate});
    }

    public void publishAPI(String userId, String apiGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishAPI";
        String elementGUIDParameterName = "apiGUID";
        this.invalidParameterHandler.validateUserId(userId, "publishAPI");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "publishAPI");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/{2}/publish";
        this.restClient.callVoidPostRESTCall("publishAPI", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, apiGUID});
    }

    public void withdrawAPI(String userId, String apiGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawAPI";
        String elementGUIDParameterName = "apiGUID";
        this.invalidParameterHandler.validateUserId(userId, "withdrawAPI");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "withdrawAPI");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/{2}/withdraw";
        this.restClient.callVoidPostRESTCall("withdrawAPI", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, apiGUID});
    }

    public void removeAPI(String userId, String apiManagerGUID, String apiManagerName, String apiGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeAPI";
        String apiManagerGUIDParameterName = "apiManagerGUID";
        String apiManagerNameParameterName = "apiManagerName";
        String elementGUIDParameterName = "apiGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeAPI");
        this.invalidParameterHandler.validateGUID(apiManagerGUID, "apiManagerGUID", "removeAPI");
        this.invalidParameterHandler.validateName(apiManagerName, "apiManagerName", "removeAPI");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "removeAPI");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeAPI");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/{2}/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        this.restClient.callVoidPostRESTCall("removeAPI", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiManagerGUID, apiManagerName, apiGUID, qualifiedName});
    }

    public List<APIElement> findAPIs(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findAPIs";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findAPIs");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findAPIs");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findAPIs");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/by-search-string/{2}?startFrom={3}&pageSize={4}";
        APIsResponse restResult = this.restClient.callAPIsGetRESTCall("findAPIs", urlTemplate, this.serverName, userId, searchString, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<APIElement> getAPIsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAPIsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getAPIsByName");
        this.invalidParameterHandler.validateName(name, "name", "getAPIsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAPIsByName");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/by-name/{2}?startFrom={3}&pageSize={4}";
        APIsResponse restResult = this.restClient.callAPIsGetRESTCall("getAPIsByName", urlTemplate, this.serverName, userId, name, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<APIElement> getAPIsForAPIManager(String userId, String apiManagerGUID, String apiManagerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAPIsForAPIManager";
        String apiManagerGUIDParameterName = "apiManagerGUID";
        String apiManagerNameParameterName = "apiManagerName";
        this.invalidParameterHandler.validateUserId(userId, "getAPIsForAPIManager");
        this.invalidParameterHandler.validateGUID(apiManagerGUID, "apiManagerGUID", "getAPIsForAPIManager");
        this.invalidParameterHandler.validateName(apiManagerName, "apiManagerName", "getAPIsForAPIManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAPIsForAPIManager");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/api-managers/{2}/{3}?startFrom={4}&pageSize={5}";
        APIsResponse restResult = this.restClient.callAPIsGetRESTCall("getAPIsForAPIManager", urlTemplate, this.serverName, userId, apiManagerGUID, apiManagerName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public APIElement getAPIByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAPIByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getAPIByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getAPIByGUID");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/{2}";
        APIResponse restResult = this.restClient.callAPIGetRESTCall("getAPIByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public String createAPIOperation(String userId, String apiManagerGUID, String apiManagerName, boolean apiManagerIsHome, String apiGUID, APIOperationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAPIOperation";
        String parentElementGUIDParameterName = "apiGUID";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "createAPIOperation");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "createAPIOperation");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createAPIOperation");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/{2}/api-operations?apiManagerIsHome={3}";
        APIOperationRequestBody requestBody = new APIOperationRequestBody(properties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createAPIOperation", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiGUID, apiManagerIsHome});
        return restResult.getGUID();
    }

    public String createAPIOperationFromTemplate(String userId, String apiManagerGUID, String apiManagerName, boolean apiManagerIsHome, String templateGUID, String apiGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAPIOperationFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "apiGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createAPIOperationFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createAPIOperationFromTemplate");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "createAPIOperationFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createAPIOperationFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createAPIOperationFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/{2}/api-operations/from-template/{3}?apiManagerIsHome={4}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createAPIOperationFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiGUID, templateGUID, apiManagerIsHome});
        return restResult.getGUID();
    }

    public void updateAPIOperation(String userId, String apiManagerGUID, String apiManagerName, String apiOperationGUID, boolean isMergeUpdate, APIOperationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAPIOperation";
        String elementGUIDParameterName = "apiOperationGUID";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "updateAPIOperation");
        this.invalidParameterHandler.validateGUID(apiOperationGUID, "apiOperationGUID", "updateAPIOperation");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateAPIOperation");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/api-operations/{2}?isMergeUpdate={3}";
        APIOperationRequestBody requestBody = new APIOperationRequestBody(properties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        this.restClient.callVoidPostRESTCall("updateAPIOperation", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiOperationGUID, isMergeUpdate});
    }

    public void removeAPIOperation(String userId, String apiManagerGUID, String apiManagerName, String apiOperationGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeAPIOperation";
        String elementGUIDParameterName = "apiOperationGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeAPIOperation");
        this.invalidParameterHandler.validateGUID(apiOperationGUID, "apiOperationGUID", "removeAPIOperation");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeAPIOperation");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/api-operations/{2}/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        this.restClient.callVoidPostRESTCall("removeAPIOperation", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiOperationGUID, qualifiedName});
    }

    public List<APIOperationElement> findAPIOperations(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findAPIOperations";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findAPIOperations");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findAPIOperations");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findAPIOperations");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/api-operations/by-search-string/{2}?startFrom={3}&pageSize={4}";
        APIOperationsResponse restResult = this.restClient.callAPIOperationsGetRESTCall("findAPIOperations", urlTemplate, this.serverName, userId, searchString, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<APIOperationElement> getOperationsForAPI(String userId, String apiGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getOperationsForAPI";
        String parentElementGUIDParameterName = "apiGUID";
        this.invalidParameterHandler.validateUserId(userId, "getOperationsForAPI");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "getOperationsForAPI");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getOperationsForAPI");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/{2}/api-operations?startFrom={3}&pageSize={4}";
        APIOperationsResponse restResult = this.restClient.callAPIOperationsGetRESTCall("getOperationsForAPI", urlTemplate, this.serverName, userId, apiGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<APIOperationElement> getAPIOperationsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAPIOperationsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getAPIOperationsByName");
        this.invalidParameterHandler.validateName(name, "name", "getAPIOperationsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAPIOperationsByName");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/api-operations/by-name/{2}?startFrom={3}&pageSize={4}";
        APIOperationsResponse restResult = this.restClient.callAPIOperationsGetRESTCall("getAPIOperationsByName", urlTemplate, this.serverName, userId, name, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public APIOperationElement getAPIOperationByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAPIOperationByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getAPIOperationByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getAPIOperationByGUID");
        String urlTemplate = this.serverPlatformURLRoot + apiURLTemplatePrefix + "/api-operations/{2}";
        APIOperationResponse restResult = this.restClient.callAPIOperationGetRESTCall("getAPIOperationByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public String createAPIParameterList(String userId, String apiManagerGUID, String apiManagerName, boolean apiManagerIsHome, String apiOperationGUID, APIParameterListType parameterListType, APIParameterListProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public String createAPIParameterListFromTemplate(String userId, String apiManagerGUID, String apiManagerName, boolean apiManagerIsHome, String templateGUID, String apiOperationGUID, APIParameterListType parameterListType, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void updateAPIParameterList(String userId, String apiManagerGUID, String apiManagerName, String apiParameterListGUID, boolean isMergeUpdate, APIParameterListProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void removeAPIParameterList(String userId, String apiManagerGUID, String apiManagerName, String apiParameterListGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public List<APIParameterListElement> findAPIParameterLists(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public List<APIParameterListElement> getParameterListsForAPIOperation(String userId, String apiOperationGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public List<APIParameterListElement> getAPIParameterListsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public APIParameterListElement getAPIParameterListByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }
}

