/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.FilesAndFoldersInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFileElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataFileProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileFolderProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFileRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFileResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFilesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFolderRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileFolderResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileFoldersResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.PathNameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class FilesAndFoldersClient
implements FilesAndFoldersInterface {
    private final String fileServerCapabilityGUIDParameterName = "fileServerCapabilityGUID";
    private final String fileServerCapabilityNameParameterName = "FileServerCapabilityName";
    private final String editURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/file-server-capability/{2}/{3}";
    private final String retrieveURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}";
    private final String governanceURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}";
    private String serverName;
    private String serverPlatformURLRoot;
    private AuditLog auditLog = null;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private DataManagerRESTClient restClient;
    private static NullRequestBody nullRequestBody = new NullRequestBody();

    public FilesAndFoldersClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public FilesAndFoldersClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot);
    }

    public FilesAndFoldersClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public FilesAndFoldersClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public FilesAndFoldersClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = restClient;
    }

    public List<String> createNestedFolders(String userId, String fileServerCapabilityGUID, String fileServerCapabilityName, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createNestedFolders";
        String pathNameParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, "createNestedFolders");
        this.invalidParameterHandler.validateGUID(fileServerCapabilityGUID, "fileServerCapabilityGUID", "createNestedFolders");
        this.invalidParameterHandler.validateName(fileServerCapabilityName, "FileServerCapabilityName", "createNestedFolders");
        this.invalidParameterHandler.validateName(pathName, "pathName", "createNestedFolders");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/file-server-capability/{2}/{3}" + "/folders/top-level";
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setFullPath(pathName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("createNestedFolders", urlTemplate, requestBody, new Object[]{this.serverName, userId, fileServerCapabilityGUID, fileServerCapabilityName});
        return restResult.getGUIDs();
    }

    public List<String> createNestedFolders(String userId, String fileServerCapabilityGUID, String fileServerCapabilityName, String parentFolderGUID, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createNestedFolders";
        String parentGUIDParameterName = "parentFolderGUID";
        String pathNameParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, "createNestedFolders");
        this.invalidParameterHandler.validateGUID(fileServerCapabilityGUID, "fileServerCapabilityGUID", "createNestedFolders");
        this.invalidParameterHandler.validateName(fileServerCapabilityName, "FileServerCapabilityName", "createNestedFolders");
        this.invalidParameterHandler.validateGUID(parentFolderGUID, "parentFolderGUID", "createNestedFolders");
        this.invalidParameterHandler.validateName(pathName, "pathName", "createNestedFolders");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/file-server-capability/{2}/{3}" + "/folders/{4}/nested-folders";
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setFullPath(pathName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("createNestedFolders", urlTemplate, requestBody, new Object[]{this.serverName, userId, fileServerCapabilityGUID, fileServerCapabilityName, parentFolderGUID});
        return restResult.getGUIDs();
    }

    public void attachTopLevelFolder(String userId, String fileServerCapabilityGUID, String fileServerCapabilityName, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachTopLevelFolder";
        String folderGUIDParameterName = "folderGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachTopLevelFolder");
        this.invalidParameterHandler.validateGUID(fileServerCapabilityGUID, "fileServerCapabilityGUID", "attachTopLevelFolder");
        this.invalidParameterHandler.validateName(fileServerCapabilityName, "FileServerCapabilityName", "attachTopLevelFolder");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "attachTopLevelFolder");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/file-server-capability/{2}/{3}" + "/folders/top-level/{4}";
        this.restClient.callVoidPostRESTCall("attachTopLevelFolder", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, fileServerCapabilityGUID, fileServerCapabilityName});
    }

    public void detachTopLevelFolder(String userId, String fileServerCapabilityGUID, String fileServerCapabilityName, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachTopLevelFolder";
        String folderGUIDParameterName = "folderGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachTopLevelFolder");
        this.invalidParameterHandler.validateGUID(fileServerCapabilityGUID, "fileServerCapabilityGUID", "detachTopLevelFolder");
        this.invalidParameterHandler.validateName(fileServerCapabilityName, "FileServerCapabilityName", "detachTopLevelFolder");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "detachTopLevelFolder");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/file-server-capability/{2}/{3}" + "/folders/top-level/{4}/detach";
        this.restClient.callVoidPostRESTCall("detachTopLevelFolder", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, fileServerCapabilityGUID, fileServerCapabilityName});
    }

    public List<String> addDataFileToCatalog(String userId, String fileServerCapabilityGUID, String fileServerCapabilityName, DataFileProperties dataFileProperties, String connectorProviderName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDataFileToCatalog";
        String propertiesParameterName = "dataFileProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "addDataFileToCatalog");
        this.invalidParameterHandler.validateGUID(fileServerCapabilityGUID, "fileServerCapabilityGUID", "addDataFileToCatalog");
        this.invalidParameterHandler.validateName(fileServerCapabilityName, "FileServerCapabilityName", "addDataFileToCatalog");
        this.invalidParameterHandler.validateObject((Object)dataFileProperties, "dataFileProperties", "addDataFileToCatalog");
        this.invalidParameterHandler.validateName(dataFileProperties.getQualifiedName(), "qualifiedName", "addDataFileToCatalog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/file-server-capability/{2}/{3}" + "/files";
        DataFileRequestBody requestBody = new DataFileRequestBody(dataFileProperties);
        requestBody.setConnectorProviderClassName(connectorProviderName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addDataFileToCatalog", urlTemplate, requestBody, new Object[]{this.serverName, userId, fileServerCapabilityGUID, fileServerCapabilityName});
        return restResult.getGUIDs();
    }

    public List<String> addDataFolderToCatalog(String userId, String fileServerCapabilityGUID, String fileServerCapabilityName, FileFolderProperties fileFolderProperties, String connectorProviderName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDataFolderToCatalog";
        String propertiesParameterName = "fileFolderProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "addDataFolderToCatalog");
        this.invalidParameterHandler.validateGUID(fileServerCapabilityGUID, "fileServerCapabilityGUID", "addDataFolderToCatalog");
        this.invalidParameterHandler.validateName(fileServerCapabilityName, "FileServerCapabilityName", "addDataFolderToCatalog");
        this.invalidParameterHandler.validateObject((Object)fileFolderProperties, "fileFolderProperties", "addDataFolderToCatalog");
        this.invalidParameterHandler.validateName(fileFolderProperties.getQualifiedName(), "qualifiedName", "addDataFolderToCatalog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/file-server-capability/{2}/{3}" + "/files";
        DataFolderRequestBody requestBody = new DataFolderRequestBody(fileFolderProperties);
        requestBody.setConnectorProviderClassName(connectorProviderName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addDataFolderToCatalog", urlTemplate, requestBody, new Object[]{this.serverName, userId, fileServerCapabilityGUID, fileServerCapabilityName});
        return restResult.getGUIDs();
    }

    public void attachDataFileAssetToFolder(String userId, String fileServerCapabilityGUID, String fileServerCapabilityName, String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachDataFileAssetToFolder";
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachDataFileAssetToFolder");
        this.invalidParameterHandler.validateGUID(fileServerCapabilityGUID, "fileServerCapabilityGUID", "attachDataFileAssetToFolder");
        this.invalidParameterHandler.validateName(fileServerCapabilityName, "FileServerCapabilityName", "attachDataFileAssetToFolder");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "attachDataFileAssetToFolder");
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", "attachDataFileAssetToFolder");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/file-server-capability/{2}/{3}" + "/folders/{4}/files/{5}";
        this.restClient.callVoidPostRESTCall("attachDataFileAssetToFolder", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, fileServerCapabilityGUID, fileServerCapabilityName, folderGUID, fileGUID});
    }

    public void detachDataFileAssetFromFolder(String userId, String fileServerCapabilityGUID, String fileServerCapabilityName, String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachDataFileAssetFromFolder";
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachDataFileAssetFromFolder");
        this.invalidParameterHandler.validateGUID(fileServerCapabilityGUID, "fileServerCapabilityGUID", "detachDataFileAssetFromFolder");
        this.invalidParameterHandler.validateName(fileServerCapabilityName, "FileServerCapabilityName", "detachDataFileAssetFromFolder");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "detachDataFileAssetFromFolder");
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", "detachDataFileAssetFromFolder");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/file-server-capability/{2}/{3}" + "/folders/{4}/files/{5}/detach";
        this.restClient.callVoidPostRESTCall("detachDataFileAssetFromFolder", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, fileServerCapabilityGUID, fileServerCapabilityName, folderGUID, fileGUID});
    }

    public FileFolderElement getFolderByGUID(String userId, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFolderByGUID";
        String guidParameterName = "folderGUID";
        this.invalidParameterHandler.validateUserId(userId, "getFolderByGUID");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "getFolderByGUID");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/folders/{2}";
        FileFolderResponse restResult = this.restClient.callFileFolderGetRESTCall("getFolderByGUID", "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/folders/{2}", this.serverName, userId, folderGUID);
        return restResult.getFolder();
    }

    public FileFolderElement getFolderByPathName(String userId, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFolderByPathName";
        String nameParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, "getFolderByPathName");
        this.invalidParameterHandler.validateName(pathName, "pathName", "getFolderByPathName");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/folders/by-name";
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setFullPath(pathName);
        FileFolderResponse restResult = this.restClient.callFileFolderPostRESTCall("getFolderByPathName", "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/folders/by-name", requestBody, this.serverName, userId, pathName);
        return restResult.getFolder();
    }

    public List<FileFolderElement> getTopLevelFolders(String userId, String fileServerCapabilityGUID, String fileServerCapabilityName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTopLevelFolders";
        this.invalidParameterHandler.validateUserId(userId, "getTopLevelFolders");
        this.invalidParameterHandler.validateGUID(fileServerCapabilityGUID, "fileServerCapabilityGUID", "getTopLevelFolders");
        this.invalidParameterHandler.validateName(fileServerCapabilityName, "FileServerCapabilityName", "getTopLevelFolders");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTopLevelFolders");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/folders?startFrom={3}&pageSize={4}";
        FileFoldersResponse restResult = this.restClient.callFileFoldersGetRESTCall("getTopLevelFolders", "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/folders?startFrom={3}&pageSize={4}", this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<FileFolderElement> getNestedFolders(String userId, String parentFolderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFolderFiles";
        String guidParameterName = "parentFolderGUID";
        this.invalidParameterHandler.validateUserId(userId, "getFolderFiles");
        this.invalidParameterHandler.validateGUID(parentFolderGUID, "parentFolderGUID", "getFolderFiles");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getFolderFiles");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/folders/{2}/folders?startFrom={3}&pageSize={4}";
        FileFoldersResponse restResult = this.restClient.callFileFoldersGetRESTCall("getFolderFiles", "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/folders/{2}/folders?startFrom={3}&pageSize={4}", this.serverName, userId, parentFolderGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DataFileElement> getTopLevelDataFiles(String userId, String fileServerCapabilityGUID, String fileServerCapabilityName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTopLevelDataFiles";
        this.invalidParameterHandler.validateUserId(userId, "getTopLevelDataFiles");
        this.invalidParameterHandler.validateGUID(fileServerCapabilityGUID, "fileServerCapabilityGUID", "getTopLevelDataFiles");
        this.invalidParameterHandler.validateName(fileServerCapabilityName, "FileServerCapabilityName", "getTopLevelDataFiles");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTopLevelDataFiles");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/files?startFrom={3}&pageSize={4}";
        DataFilesResponse restResult = this.restClient.callDataFilesGetRESTCall("getTopLevelDataFiles", "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/files?startFrom={3}&pageSize={4}", this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DataFileElement> getFolderFiles(String userId, String folderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFolderFiles";
        String guidParameterName = "folderGUID";
        this.invalidParameterHandler.validateUserId(userId, "getFolderFiles");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "getFolderFiles");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getFolderFiles");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/folders/{2}/files?startFrom={3}&pageSize={4}";
        DataFilesResponse restResult = this.restClient.callDataFilesGetRESTCall("getFolderFiles", "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/folders/{2}/files?startFrom={3}&pageSize={4}", this.serverName, userId, folderGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public DataFileElement getFileByGUID(String userId, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileByGUID";
        String guidParameterName = "fileGUID";
        this.invalidParameterHandler.validateUserId(userId, "getFileByGUID");
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", "getFileByGUID");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/files/{2}";
        DataFileResponse restResult = this.restClient.callDataFileGetRESTCall("getFileByGUID", "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/files/{2}", this.serverName, userId, fileGUID);
        return restResult.getDataFile();
    }

    public DataFileElement getFileByPathName(String userId, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileByPathName";
        String nameParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, "getFileByPathName");
        this.invalidParameterHandler.validateName(pathName, "pathName", "getFileByPathName");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/files/by-name";
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setFullPath(pathName);
        DataFileResponse restResult = this.restClient.callDataFilePostRESTCall("getFileByPathName", "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/files/by-name", requestBody, this.serverName, userId, pathName);
        return restResult.getDataFile();
    }
}

