/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ClassificationProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class DataManagerBaseClient {
    final String serverName;
    final String serverPlatformURLRoot;
    final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    final DataManagerRESTClient restClient;

    public DataManagerBaseClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public DataManagerBaseClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot);
    }

    public DataManagerBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public DataManagerBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public DataManagerBaseClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    String createReferenceable(String userId, String externalSourceGUID, String externalSourceName, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    String createReferenceableFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, TemplateProperties templateProperties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", methodName);
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    String createReferenceableFromTemplateWithParent(String userId, String externalSourceGUID, String externalSourceName, String parentGUID, String parentGUIDParameterName, String templateGUID, TemplateProperties templateProperties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateGUID(parentGUID, parentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", methodName);
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setParentGUID(parentGUID);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    String createReferenceableWithParent(String userId, String externalSourceGUID, String externalSourceName, String parentGUID, String parentGUIDParameterName, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentGUID, parentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setParentGUID(parentGUID);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    void updateReferenceable(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, boolean isMergeUpdate, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        }
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID, isMergeUpdate});
    }

    void setReferenceableClassification(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameter, ClassificationProperties properties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ClassificationRequestBody requestBody = new ClassificationRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    void removeReferenceableClassification(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameter, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    void setupRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID});
    }

    void setupRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, String relationshipTypeName, String relationshipTypeNameParameterName, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, relationshipTypeNameParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, relationshipTypeName, secondaryElementGUID});
    }

    void clearRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID});
    }

    void clearRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, String relationshipTypeName, String relationshipTypeNameParameterName, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, relationshipTypeNameParameterName, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, relationshipTypeName, secondaryElementGUID});
    }

    List<RelatedElement> getRelatedElements(String userId, String startingElementGUID, String startingElementGUIDParameterName, String urlTemplate, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingElementGUIDParameterName, methodName);
        RelatedElementListResponse restResult = this.restClient.callRelatedElementListGetRESTCall(methodName, urlTemplate, this.serverName, userId, startingElementGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public void removeReferenceable(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }
}

