/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.DatabaseManagerInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseTableElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseViewElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseForeignKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabasePrimaryKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseSchemaProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseTableProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseViewProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseColumnResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseColumnsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseSchemaResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseSchemasResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseTableResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseTablesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseViewResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseViewsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabasesResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class DatabaseManagerClient
implements DatabaseManagerInterface {
    private final String databaseManagerGUIDParameterName = "databaseManagerGUID";
    private final String databaseManagerNameParameterName = "databaseManagerName";
    private final String editURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases";
    private final String retrieveURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases";
    private final String governanceURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases";
    private String serverName;
    private String serverPlatformURLRoot;
    private AuditLog auditLog = null;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private DataManagerRESTClient restClient;
    private static NullRequestBody nullRequestBody = new NullRequestBody();

    public DatabaseManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public DatabaseManagerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot);
    }

    public DatabaseManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public DatabaseManagerClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    public DatabaseManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public String createDatabase(String userId, String databaseManagerGUID, String databaseManagerName, DatabaseProperties databaseProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabase";
        String propertiesParameterName = "databaseProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDatabase");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "createDatabase");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "createDatabase");
        this.invalidParameterHandler.validateObject((Object)databaseProperties, "databaseProperties", "createDatabase");
        this.invalidParameterHandler.validateName(databaseProperties.getQualifiedName(), "qualifiedName", "createDatabase");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabase", urlTemplate, databaseProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName});
        return restResult.getGUID();
    }

    public String createDatabaseFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseFromTemplate");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "createDatabaseFromTemplate");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "createDatabaseFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createDatabaseFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createDatabaseFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createDatabaseFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/from-template/{4}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseFromTemplate", urlTemplate, templateProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, templateGUID});
        return restResult.getGUID();
    }

    public void updateDatabase(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, DatabaseProperties databaseProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDatabase";
        String elementGUIDParameterName = "databaseGUID";
        String propertiesParameterName = "databaseProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateDatabase");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "updateDatabase");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "updateDatabase");
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", "updateDatabase");
        this.invalidParameterHandler.validateObject((Object)databaseProperties, "databaseProperties", "updateDatabase");
        this.invalidParameterHandler.validateName(databaseProperties.getQualifiedName(), "qualifiedName", "updateDatabase");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/{4}";
        this.restClient.callVoidPostRESTCall("updateDatabase", urlTemplate, databaseProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseGUID});
    }

    public void publishDatabase(String userId, String databaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishDatabase";
        String elementGUIDParameterName = "databaseGUID";
        this.invalidParameterHandler.validateUserId(userId, "publishDatabase");
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", "publishDatabase");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/{4}/publish";
        this.restClient.callVoidPostRESTCall("publishDatabase", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, databaseGUID});
    }

    public void withdrawDatabase(String userId, String databaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawDatabase";
        String elementGUIDParameterName = "databaseGUID";
        this.invalidParameterHandler.validateUserId(userId, "withdrawDatabase");
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", "withdrawDatabase");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databasesdatabases/{4}/withdraw";
        this.restClient.callVoidPostRESTCall("withdrawDatabase", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, databaseGUID});
    }

    public void removeDatabase(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDatabase";
        String databaseManagerGUIDParameterName = "databaseManagerGUID";
        String databaseManagerNameParameterName = "databaseManagerName";
        String elementGUIDParameterName = "databaseGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeDatabase");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "removeDatabase");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "removeDatabase");
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", "removeDatabase");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeDatabase");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/{4}/{5}/delete";
        this.restClient.callVoidPostRESTCall("removeDatabase", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseGUID, qualifiedName});
    }

    public List<DatabaseElement> findDatabases(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDatabases";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDatabases");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDatabases");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDatabases");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        DatabasesResponse restResult = this.restClient.callDatabasesPostRESTCall("findDatabases", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DatabaseElement> getDatabasesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabasesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDatabasesByName");
        this.invalidParameterHandler.validateName(name, "name", "getDatabasesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDatabasesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        DatabasesResponse restResult = this.restClient.callDatabasesPostRESTCall("getDatabasesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DatabaseElement> getDatabasesForDatabaseManager(String userId, String databaseManagerGUID, String databaseManagerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabasesForDatabaseManager";
        this.invalidParameterHandler.validateUserId(userId, "getDatabasesForDatabaseManager");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "getDatabasesForDatabaseManager");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "getDatabasesForDatabaseManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDatabasesForDatabaseManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases?startFrom={4}&pageSize={5}";
        DatabasesResponse restResult = this.restClient.callDatabasesGetRESTCall("getDatabasesForDatabaseManager", urlTemplate, this.serverName, userId, databaseManagerGUID, databaseManagerName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public DatabaseElement getDatabaseByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDatabaseByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/{2}";
        DatabaseResponse restResult = this.restClient.callDatabaseGetRESTCall("getDatabaseByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public String createDatabaseSchema(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, DatabaseSchemaProperties databaseSchemaProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseSchema";
        String parentElementGUIDParameterName = "databaseGUID";
        String propertiesParameterName = "databaseSchemaProperties";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseSchema");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "createDatabaseSchema");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "createDatabaseSchema");
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", "createDatabaseSchema");
        this.invalidParameterHandler.validateObject((Object)databaseSchemaProperties, "databaseSchemaProperties", "createDatabaseSchema");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/{4}/schemas";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseSchema", urlTemplate, databaseSchemaProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseGUID});
        return restResult.getGUID();
    }

    public String createDatabaseSchemaFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseSchemaFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "databaseGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseSchemaFromTemplate");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "createDatabaseSchemaFromTemplate");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "createDatabaseSchemaFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createDatabaseSchemaFromTemplate");
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", "createDatabaseSchemaFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createDatabaseSchemaFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/{4}/schemas/from-template/{5}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseSchemaFromTemplate", urlTemplate, templateProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseGUID, templateGUID});
        return restResult.getGUID();
    }

    public void updateDatabaseSchema(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, DatabaseSchemaProperties databaseSchemaProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDatabaseSchema";
        String elementGUIDParameterName = "databaseSchemaGUID";
        String propertiesParameterName = "databaseProperties";
        this.invalidParameterHandler.validateUserId(userId, "updateDatabaseSchema");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "updateDatabaseSchema");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "updateDatabaseSchema");
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", "updateDatabaseSchema");
        this.invalidParameterHandler.validateObject((Object)databaseSchemaProperties, "databaseProperties", "updateDatabaseSchema");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/{4}";
        this.restClient.callVoidPostRESTCall("updateDatabaseSchema", urlTemplate, databaseSchemaProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID});
    }

    public void publishDatabaseSchema(String userId, String databaseSchemaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishDatabaseSchema";
        String elementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, "publishDatabaseSchema");
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", "publishDatabaseSchema");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/{4}/publish";
        this.restClient.callVoidPostRESTCall("publishDatabaseSchema", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, databaseSchemaGUID});
    }

    public void withdrawDatabaseSchema(String userId, String databaseSchemaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawDatabase";
        String elementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, "withdrawDatabase");
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", "withdrawDatabase");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/{4}/withdraw";
        this.restClient.callVoidPostRESTCall("withdrawDatabase", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, databaseSchemaGUID});
    }

    public void removeDatabaseSchema(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDatabaseSchema";
        String elementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeDatabaseSchema");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "removeDatabaseSchema");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "removeDatabaseSchema");
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", "removeDatabaseSchema");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeDatabaseSchema");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/{4}/{5}/delete";
        this.restClient.callVoidPostRESTCall("removeDatabaseSchema", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, qualifiedName});
    }

    public List<DatabaseSchemaElement> findDatabaseSchemas(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDatabaseSchemas";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDatabaseSchemas");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDatabaseSchemas");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDatabaseSchemas");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        DatabaseSchemasResponse restResult = this.restClient.callDatabaseSchemasPostRESTCall("findDatabaseSchemas", urlTemplate, requestBody, this.serverName, userId, searchString, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DatabaseSchemaElement> getSchemasForDatabase(String userId, String databaseGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemasForDatabase";
        String parentElementGUIDParameterName = "databaseGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemasForDatabase");
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", "getSchemasForDatabase");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSchemasForDatabase");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/{2}/schemas?startFrom={3}&pageSize={4}";
        DatabaseSchemasResponse restResult = this.restClient.callDatabaseSchemasGetRESTCall("getSchemasForDatabase", urlTemplate, this.serverName, userId, databaseGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DatabaseSchemaElement> getDatabaseSchemasByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseSchemasByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseSchemasByName");
        this.invalidParameterHandler.validateName(name, "name", "getDatabaseSchemasByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDatabaseSchemasByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        DatabaseSchemasResponse restResult = this.restClient.callDatabaseSchemasPostRESTCall("getDatabaseSchemasByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public DatabaseSchemaElement getDatabaseSchemaByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseSchemaByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseSchemaByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDatabaseSchemaByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/{2}";
        DatabaseSchemaResponse restResult = this.restClient.callDatabaseSchemaGetRESTCall("getDatabaseSchemaByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public String createDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, DatabaseTableProperties databaseTableProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseTable";
        String parentElementGUIDParameterName = "databaseSchemaGUID";
        String propertiesParameterName = "databaseTableProperties";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseTable");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "createDatabaseTable");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "createDatabaseTable");
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", "createDatabaseTable");
        this.invalidParameterHandler.validateObject((Object)databaseTableProperties, "databaseTableProperties", "createDatabaseTable");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/{4}/tables";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseTable", urlTemplate, databaseTableProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID});
        return restResult.getGUID();
    }

    public String createDatabaseTableFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseSchemaGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseTableFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "databaseSchemaGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseTableFromTemplate");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "createDatabaseTableFromTemplate");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "createDatabaseTableFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createDatabaseTableFromTemplate");
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", "createDatabaseTableFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createDatabaseTableFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/{4}/tables/from-template/{5}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseTableFromTemplate", urlTemplate, templateProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, templateGUID});
        return restResult.getGUID();
    }

    public void updateDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, DatabaseTableProperties databaseTableProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDatabaseTable";
        String elementGUIDParameterName = "databaseTableGUID";
        String propertiesParameterName = "databaseTableProperties";
        this.invalidParameterHandler.validateUserId(userId, "updateDatabaseTable");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "updateDatabaseTable");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "updateDatabaseTable");
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", "updateDatabaseTable");
        this.invalidParameterHandler.validateObject((Object)databaseTableProperties, "databaseTableProperties", "updateDatabaseTable");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/tables/{4}";
        this.restClient.callVoidPostRESTCall("updateDatabaseTable", urlTemplate, databaseTableProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseTableGUID});
    }

    public void removeDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDatabaseTable";
        String elementGUIDParameterName = "databaseTableGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeDatabaseTable");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "removeDatabaseTable");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "removeDatabaseTable");
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", "removeDatabaseTable");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeDatabaseTable");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/tables/{4}/{5}/delete";
        this.restClient.callVoidPostRESTCall("removeDatabaseTable", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, qualifiedName});
    }

    public List<DatabaseTableElement> findDatabaseTables(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDatabaseTables";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDatabaseTables");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDatabaseTables");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDatabaseTables");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/tables/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        DatabaseTablesResponse restResult = this.restClient.callDatabaseTablesPostRESTCall("findDatabaseTables", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DatabaseTableElement> getTablesForDatabaseSchema(String userId, String databaseSchemaGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTablesForDatabaseSchema";
        String parentElementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, "getTablesForDatabaseSchema");
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", "getTablesForDatabaseSchema");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTablesForDatabaseSchema");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/{2}/tables?startFrom={3}&pageSize={4}";
        DatabaseTablesResponse restResult = this.restClient.callDatabaseTablesGetRESTCall("getTablesForDatabaseSchema", urlTemplate, this.serverName, userId, databaseSchemaGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DatabaseTableElement> getDatabaseTablesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseTablesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseTablesByName");
        this.invalidParameterHandler.validateName(name, "name", "getDatabaseTablesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDatabaseTablesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/tables/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        DatabaseTablesResponse restResult = this.restClient.callDatabaseTablesPostRESTCall("getDatabaseTablesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public DatabaseTableElement getDatabaseTableByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseTableByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseTableByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDatabaseTableByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/tables/{2}";
        DatabaseTableResponse restResult = this.restClient.callDatabaseTableGetRESTCall("getDatabaseTableByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public String createDatabaseView(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, DatabaseViewProperties databaseViewProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseView";
        String parentElementGUIDParameterName = "databaseSchemaGUID";
        String propertiesParameterName = "databaseViewProperties";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseView");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "createDatabaseView");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "createDatabaseView");
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", "createDatabaseView");
        this.invalidParameterHandler.validateObject((Object)databaseViewProperties, "databaseViewProperties", "createDatabaseView");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/{4}/tables/views";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseView", urlTemplate, databaseViewProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID});
        return restResult.getGUID();
    }

    public String createDatabaseViewFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseSchemaGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseViewFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "databaseSchemaGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseViewFromTemplate");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "createDatabaseViewFromTemplate");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "createDatabaseViewFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createDatabaseViewFromTemplate");
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", "createDatabaseViewFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createDatabaseViewFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/{4}/tables/views/from-template/{5}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseViewFromTemplate", urlTemplate, templateProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, templateGUID});
        return restResult.getGUID();
    }

    public void updateDatabaseView(String userId, String databaseManagerGUID, String databaseManagerName, String databaseViewGUID, DatabaseViewProperties databaseViewProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDatabaseView";
        String elementGUIDParameterName = "databaseViewGUID";
        String propertiesParameterName = "databaseViewProperties";
        this.invalidParameterHandler.validateUserId(userId, "updateDatabaseView");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "updateDatabaseView");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "updateDatabaseView");
        this.invalidParameterHandler.validateGUID(databaseViewGUID, "databaseViewGUID", "updateDatabaseView");
        this.invalidParameterHandler.validateObject((Object)databaseViewProperties, "databaseViewProperties", "updateDatabaseView");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/tables/views/{4}";
        this.restClient.callVoidPostRESTCall("updateDatabaseView", urlTemplate, databaseViewProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseViewGUID});
    }

    public void removeDatabaseView(String userId, String databaseManagerGUID, String databaseManagerName, String databaseViewGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDatabaseView";
        String elementGUIDParameterName = "databaseViewGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeDatabaseView");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "removeDatabaseView");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "removeDatabaseView");
        this.invalidParameterHandler.validateGUID(databaseViewGUID, "databaseViewGUID", "removeDatabaseView");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeDatabaseView");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/tables/views/{4}/{5}/delete";
        this.restClient.callVoidPostRESTCall("removeDatabaseView", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseViewGUID, qualifiedName});
    }

    public List<DatabaseViewElement> findDatabaseViews(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDatabaseViews";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDatabaseViews");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDatabaseViews");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDatabaseViews");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/tables/views/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        DatabaseViewsResponse restResult = this.restClient.callDatabaseViewsPostRESTCall("findDatabaseViews", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DatabaseViewElement> getViewsForDatabaseSchema(String userId, String databaseSchemaGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getViewsForDatabaseSchema";
        String parentElementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, "getViewsForDatabaseSchema");
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", "getViewsForDatabaseSchema");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getViewsForDatabaseSchema");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/{2}/tables/views?startFrom={3}&pageSize={4}";
        DatabaseViewsResponse restResult = this.restClient.callDatabaseViewsGetRESTCall("getViewsForDatabaseSchema", urlTemplate, this.serverName, userId, databaseSchemaGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DatabaseViewElement> getDatabaseViewsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseViewsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseViewsByName");
        this.invalidParameterHandler.validateName(name, "name", "getDatabaseViewsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDatabaseViewsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/tables/views/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        DatabaseViewsResponse restResult = this.restClient.callDatabaseViewsPostRESTCall("getDatabaseViewsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public DatabaseViewElement getDatabaseViewByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseViewByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseViewByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDatabaseViewByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/tables/views/{2}";
        DatabaseViewResponse restResult = this.restClient.callDatabaseViewGetRESTCall("getDatabaseViewByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public String createDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, DatabaseColumnProperties databaseColumnProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseColumn";
        String parentElementGUIDParameterName = "databaseTableGUID";
        String propertiesParameterName = "databaseColumnProperties";
        String dataTypeParameterName = "databaseColumnProperties.dataType";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseColumn");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "createDatabaseColumn");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "createDatabaseColumn");
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", "createDatabaseColumn");
        this.invalidParameterHandler.validateObject((Object)databaseColumnProperties, "databaseColumnProperties", "createDatabaseColumn");
        if (databaseColumnProperties.getExternalTypeGUID() == null) {
            this.invalidParameterHandler.validateName(databaseColumnProperties.getDataType(), "databaseColumnProperties.dataType", "createDatabaseColumn");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/tables/{4}/columns";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseColumn", urlTemplate, databaseColumnProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseTableGUID});
        return restResult.getGUID();
    }

    public String createDatabaseColumnFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseTableGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseColumnFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "databaseTableGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseColumnFromTemplate");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "createDatabaseColumnFromTemplate");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "createDatabaseColumnFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createDatabaseColumnFromTemplate");
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", "createDatabaseColumnFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createDatabaseColumnFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/tables/{4}/columns/from-template/{5}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseColumnFromTemplate", urlTemplate, templateProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, templateGUID});
        return restResult.getGUID();
    }

    public void updateDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, DatabaseColumnProperties databaseColumnProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDatabaseColumn";
        String elementGUIDParameterName = "databaseColumnGUID";
        String propertiesParameterName = "databaseColumnProperties";
        this.invalidParameterHandler.validateUserId(userId, "updateDatabaseColumn");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "updateDatabaseColumn");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "updateDatabaseColumn");
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", "updateDatabaseColumn");
        this.invalidParameterHandler.validateObject((Object)databaseColumnProperties, "databaseColumnProperties", "updateDatabaseColumn");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/tables/columns/{4}";
        this.restClient.callVoidPostRESTCall("updateDatabaseColumn", urlTemplate, databaseColumnProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID});
    }

    public void removeDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDatabaseColumn";
        String elementGUIDParameterName = "databaseColumnGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeDatabaseColumn");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "removeDatabaseColumn");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "removeDatabaseColumn");
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", "removeDatabaseColumn");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeDatabaseColumn");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/tables/columns/{4}/{5}/delete";
        this.restClient.callVoidPostRESTCall("removeDatabaseColumn", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, qualifiedName});
    }

    public List<DatabaseColumnElement> findDatabaseColumns(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDatabaseColumns";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDatabaseColumns");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDatabaseColumns");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDatabaseColumns");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/tables/columns/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        DatabaseColumnsResponse restResult = this.restClient.callDatabaseColumnsPostRESTCall("findDatabaseColumns", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DatabaseColumnElement> getColumnsForDatabaseTable(String userId, String databaseTableGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getColumnsForDatabaseTable";
        String parentElementGUIDParameterName = "databaseTableGUID";
        this.invalidParameterHandler.validateUserId(userId, "getColumnsForDatabaseTable");
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", "getColumnsForDatabaseTable");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getColumnsForDatabaseTable");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/tables/{2}/columns?startFrom={3}&pageSize={4}";
        DatabaseColumnsResponse restResult = this.restClient.callDatabaseColumnsGetRESTCall("getColumnsForDatabaseTable", urlTemplate, this.serverName, userId, databaseTableGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DatabaseColumnElement> getDatabaseColumnsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseColumnsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseColumnsByName");
        this.invalidParameterHandler.validateName(name, "name", "getDatabaseColumnsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDatabaseColumnsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/tables/columns/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        DatabaseColumnsResponse restResult = this.restClient.callDatabaseColumnsPostRESTCall("getDatabaseColumnsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public DatabaseColumnElement getDatabaseColumnByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDatabaseColumnByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getDatabaseColumnByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDatabaseColumnByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/databases/schemas/tables/columns/{2}";
        DatabaseColumnResponse restResult = this.restClient.callDatabaseColumnGetRESTCall("getDatabaseColumnByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public void setPrimaryKeyOnColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, DatabasePrimaryKeyProperties databasePrimaryKeyProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setPrimaryKeyOnColumn";
        String parentElementGUIDParameterName = "databaseColumnGUID";
        String propertiesParameterName = "databasePrimaryKeyProperties";
        this.invalidParameterHandler.validateUserId(userId, "setPrimaryKeyOnColumn");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "setPrimaryKeyOnColumn");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "setPrimaryKeyOnColumn");
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", "setPrimaryKeyOnColumn");
        this.invalidParameterHandler.validateObject((Object)databasePrimaryKeyProperties, "databasePrimaryKeyProperties", "setPrimaryKeyOnColumn");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/tables/columns/{4}/primary-key";
        this.restClient.callVoidPostRESTCall("setPrimaryKeyOnColumn", urlTemplate, databasePrimaryKeyProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID});
    }

    public void removePrimaryKeyFromColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removePrimaryKeyFromColumn";
        String parentElementGUIDParameterName = "databaseColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, "removePrimaryKeyFromColumn");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "removePrimaryKeyFromColumn");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "removePrimaryKeyFromColumn");
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", "removePrimaryKeyFromColumn");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/tables/columns/{4}/primary-key/delete";
        this.restClient.callVoidPostRESTCall("removePrimaryKeyFromColumn", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID});
    }

    public void addForeignKeyRelationship(String userId, String databaseManagerGUID, String databaseManagerName, String primaryKeyColumnGUID, String foreignKeyColumnGUID, DatabaseForeignKeyProperties databaseForeignKeyProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addForeignKeyRelationship";
        String primaryElementGUIDParameterName = "primaryKeyColumnGUID";
        String foreignElementGUIDParameterName = "foreignKeyColumnGUID";
        String propertiesParameterName = "databaseForeignKeyProperties";
        this.invalidParameterHandler.validateUserId(userId, "addForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "addForeignKeyRelationship");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "addForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(primaryKeyColumnGUID, "primaryKeyColumnGUID", "addForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(foreignKeyColumnGUID, "foreignKeyColumnGUID", "addForeignKeyRelationship");
        this.invalidParameterHandler.validateObject((Object)databaseForeignKeyProperties, "databaseForeignKeyProperties", "addForeignKeyRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/tables/columns/{4}/foreign-key/{5}";
        this.restClient.callVoidPostRESTCall("addForeignKeyRelationship", urlTemplate, databaseForeignKeyProperties, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, foreignKeyColumnGUID, primaryKeyColumnGUID});
    }

    public void removeForeignKeyRelationship(String userId, String databaseManagerGUID, String databaseManagerName, String primaryKeyColumnGUID, String foreignKeyColumnGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeForeignKeyRelationship";
        String primaryElementGUIDParameterName = "primaryKeyColumnGUID";
        String foreignElementGUIDParameterName = "foreignKeyColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(databaseManagerGUID, "databaseManagerGUID", "removeForeignKeyRelationship");
        this.invalidParameterHandler.validateName(databaseManagerName, "databaseManagerName", "removeForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(primaryKeyColumnGUID, "primaryKeyColumnGUID", "removeForeignKeyRelationship");
        this.invalidParameterHandler.validateGUID(foreignKeyColumnGUID, "foreignKeyColumnGUID", "removeForeignKeyRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/database-managers/{2}/{3}/databases/schemas/tables/columns/{4}/foreign-key/{5}/delete";
        this.restClient.callVoidPostRESTCall("removeForeignKeyRelationship", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, databaseManagerGUID, databaseManagerName, foreignKeyColumnGUID, primaryKeyColumnGUID});
    }
}

