/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.SchemaManagerInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementStub;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ValidValueSetElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DerivedSchemaTypeQueryTargetProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EnumSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.StructSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.DerivedSchemaTypeQueryTargetRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ElementStubResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.EnumSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FormulaRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.LiteralSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.MapSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.PrimitiveSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaAttributeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaAttributeResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaAttributesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaTypeChoiceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaTypeResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaTypesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.StructSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ValidValueSetsResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public abstract class SchemaManagerClient
implements SchemaManagerInterface {
    private static final String schemaTypeURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types";
    private static final String validValueSetsURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/valid-value-sets";
    private static final String schemaAttributeURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-attributes";
    private static final String schemaElementURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-elements";
    String serverName;
    String serverPlatformURLRoot;
    AuditLog auditLog = null;
    InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    DataManagerRESTClient restClient;
    static final NullRequestBody nullRequestBody = new NullRequestBody();
    private String schemaAttributeTypeName;

    SchemaManagerClient(String schemaAttributeTypeName, String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
        this.schemaAttributeTypeName = schemaAttributeTypeName;
    }

    SchemaManagerClient(String schemaAttributeTypeName, String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot);
        this.schemaAttributeTypeName = schemaAttributeTypeName;
    }

    SchemaManagerClient(String schemaAttributeTypeName, String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
        this.schemaAttributeTypeName = schemaAttributeTypeName;
    }

    SchemaManagerClient(String schemaAttributeTypeName, String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
        this.schemaAttributeTypeName = schemaAttributeTypeName;
    }

    SchemaManagerClient(String schemaAttributeTypeName, String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
        this.schemaAttributeTypeName = schemaAttributeTypeName;
    }

    public String createPrimitiveSchemaType(String userId, String externalSourceGUID, String externalSourceName, PrimitiveSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createPrimitiveSchemaType";
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createPrimitiveSchemaType");
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", "createPrimitiveSchemaType");
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "qualifiedName", "createPrimitiveSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/primitives";
        PrimitiveSchemaTypeRequestBody requestBody = new PrimitiveSchemaTypeRequestBody(schemaTypeProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createPrimitiveSchemaType", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createLiteralSchemaType(String userId, String externalSourceGUID, String externalSourceName, LiteralSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLiteralSchemaType";
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createLiteralSchemaType");
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", "createLiteralSchemaType");
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "qualifiedName", "createLiteralSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/literals";
        LiteralSchemaTypeRequestBody requestBody = new LiteralSchemaTypeRequestBody(schemaTypeProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createLiteralSchemaType", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createEnumSchemaType(String userId, String externalSourceGUID, String externalSourceName, EnumSchemaTypeProperties schemaTypeProperties, String validValuesSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEnumSchemaType";
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "qualifiedName";
        String validValueSetGUIDParameterName = "validValuesSetGUID";
        this.invalidParameterHandler.validateUserId(userId, "createEnumSchemaType");
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", "createEnumSchemaType");
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "qualifiedName", "createEnumSchemaType");
        this.invalidParameterHandler.validateGUID(validValuesSetGUID, "validValuesSetGUID", "createEnumSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/enums/valid-values/{2}";
        EnumSchemaTypeRequestBody requestBody = new EnumSchemaTypeRequestBody(schemaTypeProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEnumSchemaType", urlTemplate, requestBody, new Object[]{this.serverName, userId, validValuesSetGUID});
        return restResult.getGUID();
    }

    public List<ValidValueSetElement> getValidValueSetByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueSetByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueSetByName");
        this.invalidParameterHandler.validateName(name, "name", "getValidValueSetByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValueSetByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/valid-value-sets/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        ValidValueSetsResponse restResult = this.restClient.callValidValueSetsPostRESTCall("getValidValueSetByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ValidValueSetElement> findValidValueSet(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findValidValueSet";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findValidValueSet");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findValidValueSet");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findValidValueSet");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/valid-value-sets/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ValidValueSetsResponse restResult = this.restClient.callValidValueSetsPostRESTCall("findValidValueSet", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public String createStructSchemaType(String userId, String externalSourceGUID, String externalSourceName, StructSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createStructSchemaType";
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createStructSchemaType");
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", "createStructSchemaType");
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "qualifiedName", "createStructSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/structs";
        StructSchemaTypeRequestBody requestBody = new StructSchemaTypeRequestBody(schemaTypeProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createStructSchemaType", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createSchemaTypeChoice(String userId, String externalSourceGUID, String externalSourceName, SchemaTypeChoiceProperties schemaTypeProperties, List<String> schemaTypeOptionGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaTypeChoice";
        String propertiesParameterName = "schemaTypeProperties";
        String optionGUIDsParameterName = "schemaTypeOptionGUIDs";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaTypeChoice");
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", "createSchemaTypeChoice");
        this.invalidParameterHandler.validateObject(schemaTypeOptionGUIDs, "schemaTypeOptionGUIDs", "createSchemaTypeChoice");
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "qualifiedName", "createSchemaTypeChoice");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/choices";
        SchemaTypeChoiceRequestBody requestBody = new SchemaTypeChoiceRequestBody(schemaTypeProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setSchemaTypeOptionGUIDs(schemaTypeOptionGUIDs);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaTypeChoice", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createMapSchemaType(String userId, String externalSourceGUID, String externalSourceName, MapSchemaTypeProperties schemaTypeProperties, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createMapSchemaType";
        String propertiesParameterName = "schemaTypeProperties";
        String fromGUIDParameterName = "mapFromSchemaTypeGUID";
        String toGUIDParameterName = "mapToSchemaTypeGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createMapSchemaType");
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", "createMapSchemaType");
        this.invalidParameterHandler.validateGUID(mapFromSchemaTypeGUID, "mapFromSchemaTypeGUID", "createMapSchemaType");
        this.invalidParameterHandler.validateGUID(mapToSchemaTypeGUID, "mapToSchemaTypeGUID", "createMapSchemaType");
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "qualifiedName", "createMapSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/maps/from/{2}/to/{3}";
        MapSchemaTypeRequestBody requestBody = new MapSchemaTypeRequestBody(schemaTypeProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createMapSchemaType", urlTemplate, requestBody, new Object[]{this.serverName, userId, mapFromSchemaTypeGUID, mapToSchemaTypeGUID});
        return restResult.getGUID();
    }

    public String createSchemaTypeFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaTypeFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaTypeFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createSchemaTypeFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createSchemaTypeFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createSchemaTypeFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/from-template/{2}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaTypeFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public void updateSchemaType(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSchemaType";
        String elementGUIDParameterName = "schemaTypeGUID";
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "updateSchemaType");
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", "updateSchemaType");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "qualifiedName", "updateSchemaType");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/{2}?isMergeUpdate={3}";
        SchemaTypeRequestBody requestBody = new SchemaTypeRequestBody(schemaTypeProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("updateSchemaType", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaTypeGUID, isMergeUpdate});
    }

    public void removeSchemaType(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSchemaType";
        String elementGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "removeSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("removeSchemaType", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaTypeGUID});
    }

    public List<SchemaTypeElement> findSchemaType(String userId, String typeName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSchemaType";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findSchemaType");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findSchemaType");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/types/{2}/by-search-string?startFrom={3}&pageSize={4}";
        String requestTypeName = "SchemaType";
        if (typeName != null) {
            requestTypeName = typeName;
        }
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        SchemaTypesResponse restResult = this.restClient.callSchemaTypesPostRESTCall("findSchemaType", urlTemplate, requestBody, this.serverName, userId, requestTypeName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public SchemaTypeElement getSchemaTypeForElement(String userId, String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSchemaType";
        String parentElementGUIDParameterName = "parentElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "findSchemaType");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "findSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/types/{2}/by-parent-element/{3}";
        String requestTypeName = "Referenceable";
        if (parentElementTypeName != null) {
            requestTypeName = parentElementTypeName;
        }
        SchemaTypeResponse restResult = this.restClient.callSchemaTypeGetRESTCall("findSchemaType", urlTemplate, this.serverName, userId, requestTypeName, parentElementGUID);
        return restResult.getElement();
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String userId, String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeByName");
        this.invalidParameterHandler.validateName(name, "name", "getSchemaTypeByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSchemaTypeByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/types/{2}/by-name?startFrom={3}&pageSize={4}";
        String requestTypeName = "SchemaType";
        if (typeName != null) {
            requestTypeName = typeName;
        }
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        SchemaTypesResponse restResult = this.restClient.callSchemaTypesPostRESTCall("getSchemaTypeByName", urlTemplate, requestBody, this.serverName, userId, requestTypeName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public SchemaTypeElement getSchemaTypeByGUID(String userId, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeByGUID";
        String guidParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeByGUID");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "getSchemaTypeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/{2}";
        SchemaTypeResponse restResult = this.restClient.callSchemaTypeGetRESTCall("getSchemaTypeByGUID", urlTemplate, this.serverName, userId, schemaTypeGUID);
        return restResult.getElement();
    }

    public ElementStub getSchemaTypeParent(String userId, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeByGUID";
        String guidParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeByGUID");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "getSchemaTypeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-types/{2}/parent";
        ElementStubResponse restResult = this.restClient.callElementStubGetRESTCall("getSchemaTypeByGUID", urlTemplate, this.serverName, userId, schemaTypeGUID);
        return restResult.getElement();
    }

    public String createSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String schemaElementGUID, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttribute";
        String propertiesParameterName = "schemaAttributeProperties";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaAttribute");
        this.invalidParameterHandler.validateObject((Object)schemaAttributeProperties, "schemaAttributeProperties", "createSchemaAttribute");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "createSchemaAttribute");
        this.invalidParameterHandler.validateName(schemaAttributeProperties.getQualifiedName(), "qualifiedName", "createSchemaAttribute");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-attributes/attached-to/{2}";
        if (schemaAttributeProperties.getTypeName() == null) {
            schemaAttributeProperties.setTypeName(this.schemaAttributeTypeName);
        }
        SchemaAttributeRequestBody requestBody = new SchemaAttributeRequestBody(schemaAttributeProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaAttribute", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaElementGUID});
        return restResult.getGUID();
    }

    public String createSchemaAttributeFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String schemaElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttributeFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createSchemaAttributeFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-attributes/from-template/{2}/attached-to/{3}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaAttributeFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, schemaElementGUID});
        return restResult.getGUID();
    }

    public void setupSchemaType(String userId, String externalSourceGUID, String externalSourceName, String relationshipTypeName, String schemaAttributeGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupSchemaType";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "setupSchemaType");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "setupSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "setupSchemaType");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "setupSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-attributes/{2}/schema-types/{3}/relationship-type-name/{4}";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("setupSchemaType", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaAttributeGUID, schemaTypeGUID, relationshipTypeName});
    }

    public void clearSchemaTypes(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSchemaTypes";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearSchemaTypes");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "clearSchemaTypes");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-attributes/{2}/schema-types/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("clearSchemaTypes", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaAttributeGUID});
    }

    public void updateSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSchemaAttribute";
        String elementGUIDParameterName = "schemaAttributeGUID";
        String propertiesParameterName = "schemaAttributeProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateSchemaAttribute");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "updateSchemaAttribute");
        this.invalidParameterHandler.validateObject((Object)schemaAttributeProperties, "schemaAttributeProperties", "updateSchemaAttribute");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(schemaAttributeProperties.getQualifiedName(), "qualifiedName", "updateSchemaAttribute");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-attributes/{2}?isMergeUpdate={3}";
        SchemaAttributeRequestBody requestBody = new SchemaAttributeRequestBody(schemaAttributeProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("updateSchemaAttribute", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaAttributeGUID, isMergeUpdate});
    }

    public void removeSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSchemaAttribute";
        String elementGUIDParameterName = "schemaAttributeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeSchemaAttribute");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "removeSchemaAttribute");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-attributes/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("removeSchemaAttribute", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaAttributeGUID});
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String userId, String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSchemaAttributes";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findSchemaAttributes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findSchemaAttributes");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSchemaAttributes");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-attributes/types/{2}/by-search-string?startFrom={3}&pageSize={4}";
        String requestTypeName = this.schemaAttributeTypeName;
        if (typeName != null) {
            requestTypeName = typeName;
        }
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        SchemaAttributesResponse restResult = this.restClient.callSchemaAttributesPostRESTCall("findSchemaAttributes", urlTemplate, requestBody, this.serverName, userId, requestTypeName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<SchemaAttributeElement> getNestedAttributes(String userId, String parentSchemaElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNestedAttributes";
        String elementGUIDParameterName = "schemaAttributeGUID";
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getNestedAttributes");
        this.invalidParameterHandler.validateUserId(userId, "getNestedAttributes");
        this.invalidParameterHandler.validateGUID(parentSchemaElementGUID, "schemaAttributeGUID", "getNestedAttributes");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-elements/{2}/nested-attributes?startFrom={3}&pageSize={4}";
        SchemaAttributesResponse restResult = this.restClient.callSchemaAttributesGetRESTCall("getNestedAttributes", urlTemplate, this.serverName, userId, parentSchemaElementGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String userId, String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaAttributesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaAttributesByName");
        this.invalidParameterHandler.validateName(name, "name", "getSchemaAttributesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSchemaAttributesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-attributes/types/{2}/by-name?startFrom={3}&pageSize={4}";
        String requestTypeName = this.schemaAttributeTypeName;
        if (typeName != null) {
            requestTypeName = typeName;
        }
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        SchemaAttributesResponse restResult = this.restClient.callSchemaAttributesPostRESTCall("getSchemaAttributesByName", urlTemplate, requestBody, this.serverName, userId, requestTypeName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String userId, String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaAttributeByGUID";
        String guidParameterName = "schemaAttributeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaAttributeByGUID");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "getSchemaAttributeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-attributes/{2}";
        SchemaAttributeResponse restResult = this.restClient.callSchemaAttributeGetRESTCall("getSchemaAttributeByGUID", urlTemplate, this.serverName, userId, schemaAttributeGUID);
        return restResult.getElement();
    }

    public void setupCalculatedValue(String userId, String externalSourceGUID, String externalSourceName, String schemaElementGUID, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        String formulaParameterName = "formula";
        this.invalidParameterHandler.validateUserId(userId, "setupCalculatedValue");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "setupCalculatedValue");
        this.invalidParameterHandler.validateName(formula, "formula", "setupCalculatedValue");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-elements/{2}/calculated-value";
        FormulaRequestBody requestBody = new FormulaRequestBody();
        requestBody.setFormula(formula);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("setupCalculatedValue", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaElementGUID});
    }

    public void clearCalculatedValue(String userId, String externalSourceGUID, String externalSourceName, String schemaElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearCalculatedValue");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "clearCalculatedValue");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-elements/{2}/calculated-value/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("clearCalculatedValue", urlTemplate, requestBody, new Object[]{this.serverName, userId, schemaElementGUID});
    }

    public void setupQueryTargetRelationship(String userId, String externalSourceGUID, String externalSourceName, String derivedElementGUID, String queryTargetGUID, DerivedSchemaTypeQueryTargetProperties queryTargetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupQueryTargetRelationship";
        String schemaElementGUIDParameterName = "derivedElementGUID";
        String queryTargetGUIDParameterName = "queryTargetGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupQueryTargetRelationship");
        this.invalidParameterHandler.validateGUID(derivedElementGUID, "derivedElementGUID", "setupQueryTargetRelationship");
        this.invalidParameterHandler.validateGUID(queryTargetGUID, "queryTargetGUID", "setupQueryTargetRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-elements/{2}/query-targets/{3}";
        DerivedSchemaTypeQueryTargetRequestBody requestBody = new DerivedSchemaTypeQueryTargetRequestBody(queryTargetProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("setupQueryTargetRelationship", urlTemplate, requestBody, new Object[]{this.serverName, userId, derivedElementGUID, queryTargetGUID});
    }

    public void updateQueryTargetRelationship(String userId, String externalSourceGUID, String externalSourceName, String derivedElementGUID, String queryTargetGUID, DerivedSchemaTypeQueryTargetProperties queryTargetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateQueryTargetRelationship";
        String schemaElementGUIDParameterName = "derivedElementGUID";
        String queryTargetGUIDParameterName = "queryTargetGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateQueryTargetRelationship");
        this.invalidParameterHandler.validateGUID(derivedElementGUID, "derivedElementGUID", "updateQueryTargetRelationship");
        this.invalidParameterHandler.validateGUID(queryTargetGUID, "queryTargetGUID", "updateQueryTargetRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-elements/{2}/query-targets/{3}/update";
        DerivedSchemaTypeQueryTargetRequestBody requestBody = new DerivedSchemaTypeQueryTargetRequestBody(queryTargetProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("updateQueryTargetRelationship", urlTemplate, requestBody, new Object[]{this.serverName, userId, derivedElementGUID, queryTargetGUID});
    }

    public void clearQueryTargetRelationship(String userId, String externalSourceGUID, String externalSourceName, String derivedElementGUID, String queryTargetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearQueryTargetRelationship";
        String schemaElementGUIDParameterName = "derivedElementGUID";
        String queryTargetGUIDParameterName = "queryTargetGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearQueryTargetRelationship");
        this.invalidParameterHandler.validateGUID(derivedElementGUID, "derivedElementGUID", "clearQueryTargetRelationship");
        this.invalidParameterHandler.validateGUID(queryTargetGUID, "queryTargetGUID", "clearQueryTargetRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schema-elements/{2}/query-targets/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("clearQueryTargetRelationship", urlTemplate, requestBody, new Object[]{this.serverName, userId, derivedElementGUID, queryTargetGUID});
    }
}

