/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.APIManagerInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.SchemaManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.APIOperationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.APIOperationResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.APIOperationsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.APIParameterListRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.APIParameterListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.APIParameterListsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.APIRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.APIResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.APIsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.enums.APIParameterListType;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.APIElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.APIOperationElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.APIParameterElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.APIParameterListElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.apis.APIProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaAttributeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.apis.APIOperationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.apis.APIParameterListProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.apis.APIParameterProperties;

public class APIManagerClient
extends SchemaManagerClient
implements APIManagerInterface {
    private static final String apiURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis";
    private static final String defaultSchemaAttributeName = "APIParameter";

    public APIManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, auditLog);
    }

    public APIManagerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot);
    }

    public APIManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public APIManagerClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public APIManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, userId, password);
    }

    public String createAPI(String userId, String apiManagerGUID, String apiManagerName, boolean apiManagerIsHome, String endpointGUID, APIProperties apiProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAPI";
        String propertiesParameterName = "apiProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createAPI");
        this.invalidParameterHandler.validateObject((Object)apiProperties, "apiProperties", "createAPI");
        this.invalidParameterHandler.validateName(apiProperties.getQualifiedName(), "qualifiedName", "createAPI");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis?apiManagerIsHome={2}";
        String urlTemplateWithEndpoint = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/for-endpoint/{2}?apiManagerIsHome={3}";
        APIRequestBody requestBody = new APIRequestBody(apiProperties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        GUIDResponse restResult = endpointGUID == null ? this.restClient.callGUIDPostRESTCall("createAPI", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiManagerIsHome}) : this.restClient.callGUIDPostRESTCall("createAPI", urlTemplateWithEndpoint, requestBody, new Object[]{this.serverName, userId, endpointGUID, apiManagerIsHome});
        return restResult.getGUID();
    }

    public String createAPIFromTemplate(String userId, String apiManagerGUID, String apiManagerName, boolean apiManagerIsHome, String endpointGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAPIFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createAPIFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createAPIFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createAPIFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createAPIFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/from-template/{2}?apiManagerIsHome={3}";
        String urlTemplateWithEndpoint = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/for-endpoint/{2}/from-template/{3}?apiManagerIsHome={4}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        GUIDResponse restResult = endpointGUID == null ? this.restClient.callGUIDPostRESTCall("createAPIFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, apiManagerIsHome}) : this.restClient.callGUIDPostRESTCall("createAPIFromTemplate", urlTemplateWithEndpoint, requestBody, new Object[]{this.serverName, userId, endpointGUID, templateGUID, apiManagerIsHome});
        return restResult.getGUID();
    }

    public void updateAPI(String userId, String apiManagerGUID, String apiManagerName, String apiGUID, boolean isMergeUpdate, APIProperties apiProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAPI";
        String elementGUIDParameterName = "apiGUID";
        String propertiesParameterName = "apiProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateAPI");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "updateAPI");
        this.invalidParameterHandler.validateObject((Object)apiProperties, "apiProperties", "updateAPI");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(apiProperties.getQualifiedName(), "qualifiedName", "updateAPI");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/{2}?isMergeUpdate={3}";
        APIRequestBody requestBody = new APIRequestBody(apiProperties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        this.restClient.callVoidPostRESTCall("updateAPI", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiGUID, isMergeUpdate});
    }

    public void publishAPI(String userId, String apiGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishAPI";
        String elementGUIDParameterName = "apiGUID";
        this.invalidParameterHandler.validateUserId(userId, "publishAPI");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "publishAPI");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/{2}/publish";
        this.restClient.callVoidPostRESTCall("publishAPI", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, apiGUID});
    }

    public void withdrawAPI(String userId, String apiGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawAPI";
        String elementGUIDParameterName = "apiGUID";
        this.invalidParameterHandler.validateUserId(userId, "withdrawAPI");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "withdrawAPI");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/{2}/withdraw";
        this.restClient.callVoidPostRESTCall("withdrawAPI", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, apiGUID});
    }

    public void removeAPI(String userId, String apiManagerGUID, String apiManagerName, String apiGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeAPI";
        String elementGUIDParameterName = "apiGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeAPI");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "removeAPI");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeAPI");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/{2}/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        this.restClient.callVoidPostRESTCall("removeAPI", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiManagerGUID, apiManagerName, apiGUID, qualifiedName});
    }

    public List<APIElement> findAPIs(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findAPIs";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findAPIs");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findAPIs");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findAPIs");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        APIsResponse restResult = this.restClient.callAPIsPostRESTCall("findAPIs", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<APIElement> getAPIsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAPIsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getAPIsByName");
        this.invalidParameterHandler.validateName(name, "name", "getAPIsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAPIsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        APIsResponse restResult = this.restClient.callAPIsPostRESTCall("getAPIsByName", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<APIElement> getAPIsForAPIManager(String userId, String apiManagerGUID, String apiManagerName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAPIsForAPIManager";
        String apiManagerGUIDParameterName = "apiManagerGUID";
        String apiManagerNameParameterName = "apiManagerName";
        this.invalidParameterHandler.validateUserId(userId, "getAPIsForAPIManager");
        this.invalidParameterHandler.validateGUID(apiManagerGUID, "apiManagerGUID", "getAPIsForAPIManager");
        this.invalidParameterHandler.validateName(apiManagerName, "apiManagerName", "getAPIsForAPIManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAPIsForAPIManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/api-managers/{2}/{3}?startFrom={4}&pageSize={5}";
        APIsResponse restResult = this.restClient.callAPIsGetRESTCall("getAPIsForAPIManager", urlTemplate, new Object[]{this.serverName, userId, apiManagerGUID, apiManagerName, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<APIElement> getAPIsForEndpoint(String userId, String endpointGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAPIsForEndpoint";
        String endpointGUIDParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAPIsForEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "getAPIsForEndpoint");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAPIsForEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/by-endpoint/{2}?startFrom={3}&pageSize={4}";
        APIsResponse restResult = this.restClient.callAPIsGetRESTCall("getAPIsForEndpoint", urlTemplate, new Object[]{this.serverName, userId, endpointGUID, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public APIElement getAPIByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAPIByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getAPIByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getAPIByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/{2}";
        APIResponse restResult = this.restClient.callAPIGetRESTCall("getAPIByGUID", urlTemplate, new Object[]{this.serverName, userId, guid});
        return restResult.getElement();
    }

    public String createAPIOperation(String userId, String apiManagerGUID, String apiManagerName, String apiGUID, APIOperationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAPIOperation";
        String parentElementGUIDParameterName = "apiGUID";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "createAPIOperation");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "createAPIOperation");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createAPIOperation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/{2}/api-operations";
        APIOperationRequestBody requestBody = new APIOperationRequestBody(properties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createAPIOperation", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiGUID});
        return restResult.getGUID();
    }

    public String createAPIOperationFromTemplate(String userId, String apiManagerGUID, String apiManagerName, String templateGUID, String apiGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAPIOperationFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "apiGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createAPIOperationFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createAPIOperationFromTemplate");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "createAPIOperationFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createAPIOperationFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createAPIOperationFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/{2}/api-operations/from-template/{3}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createAPIOperationFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiGUID, templateGUID});
        return restResult.getGUID();
    }

    public void updateAPIOperation(String userId, String apiManagerGUID, String apiManagerName, String apiOperationGUID, boolean isMergeUpdate, APIOperationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAPIOperation";
        String elementGUIDParameterName = "apiOperationGUID";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "updateAPIOperation");
        this.invalidParameterHandler.validateGUID(apiOperationGUID, "apiOperationGUID", "updateAPIOperation");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateAPIOperation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/api-operations/{2}?isMergeUpdate={3}";
        APIOperationRequestBody requestBody = new APIOperationRequestBody(properties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        this.restClient.callVoidPostRESTCall("updateAPIOperation", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiOperationGUID, isMergeUpdate});
    }

    public void removeAPIOperation(String userId, String apiManagerGUID, String apiManagerName, String apiOperationGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeAPIOperation";
        String elementGUIDParameterName = "apiOperationGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeAPIOperation");
        this.invalidParameterHandler.validateGUID(apiOperationGUID, "apiOperationGUID", "removeAPIOperation");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeAPIOperation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/api-operations/{2}/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        this.restClient.callVoidPostRESTCall("removeAPIOperation", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiOperationGUID, qualifiedName});
    }

    public List<APIOperationElement> findAPIOperations(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findAPIOperations";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findAPIOperations");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findAPIOperations");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findAPIOperations");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/api-operations/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        APIOperationsResponse restResult = this.restClient.callAPIOperationsPostRESTCall("findAPIOperations", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<APIOperationElement> getOperationsForAPI(String userId, String apiGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getOperationsForAPI";
        String parentElementGUIDParameterName = "apiGUID";
        this.invalidParameterHandler.validateUserId(userId, "getOperationsForAPI");
        this.invalidParameterHandler.validateGUID(apiGUID, "apiGUID", "getOperationsForAPI");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getOperationsForAPI");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/{2}/api-operations?startFrom={3}&pageSize={4}";
        APIOperationsResponse restResult = this.restClient.callAPIOperationsGetRESTCall("getOperationsForAPI", urlTemplate, new Object[]{this.serverName, userId, apiGUID, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<APIOperationElement> getAPIOperationsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAPIOperationsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getAPIOperationsByName");
        this.invalidParameterHandler.validateName(name, "name", "getAPIOperationsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAPIOperationsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/api-operations/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        APIOperationsResponse restResult = this.restClient.callAPIOperationsPostRESTCall("getAPIOperationsByName", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public APIOperationElement getAPIOperationByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAPIOperationByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getAPIOperationByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getAPIOperationByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/api-operations/{2}";
        APIOperationResponse restResult = this.restClient.callAPIOperationGetRESTCall("getAPIOperationByGUID", urlTemplate, new Object[]{this.serverName, userId, guid});
        return restResult.getElement();
    }

    public String createAPIParameterList(String userId, String apiManagerGUID, String apiManagerName, String apiOperationGUID, APIParameterListType parameterListType, APIParameterListProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAPIParameterList";
        String parentElementGUIDParameterName = "apiOperationGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        String listTypeParameterName = "parameterListType";
        this.invalidParameterHandler.validateUserId(userId, "createAPIParameterList");
        this.invalidParameterHandler.validateGUID(apiOperationGUID, "apiOperationGUID", "createAPIParameterList");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createAPIParameterList");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createAPIParameterList");
        this.invalidParameterHandler.validateEnum((Object)parameterListType, "parameterListType", "createAPIParameterList");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/api-operations/{2}/api-parameter-lists/{3}";
        APIParameterListRequestBody requestBody = new APIParameterListRequestBody(properties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createAPIParameterList", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiOperationGUID, parameterListType});
        return restResult.getGUID();
    }

    public String createAPIParameterListFromTemplate(String userId, String apiManagerGUID, String apiManagerName, String templateGUID, String apiOperationGUID, APIParameterListType parameterListType, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAPIParameterListFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "apiOperationGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        String listTypeParameterName = "parameterListType";
        this.invalidParameterHandler.validateUserId(userId, "createAPIParameterListFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createAPIParameterListFromTemplate");
        this.invalidParameterHandler.validateGUID(apiOperationGUID, "apiOperationGUID", "createAPIParameterListFromTemplate");
        this.invalidParameterHandler.validateEnum((Object)parameterListType, "parameterListType", "createAPIParameterListFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createAPIParameterListFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createAPIParameterListFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/api-operations/{2}/api-parameter-lists/{3}/from-template/{4}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createAPIParameterListFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiOperationGUID, parameterListType, templateGUID});
        return restResult.getGUID();
    }

    public void updateAPIParameterList(String userId, String apiManagerGUID, String apiManagerName, String apiParameterListGUID, boolean isMergeUpdate, APIParameterListProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAPIParameterList";
        String elementGUIDParameterName = "apiParameterListGUID";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "updateAPIParameterList");
        this.invalidParameterHandler.validateGUID(apiParameterListGUID, "apiParameterListGUID", "updateAPIParameterList");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateAPIParameterList");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/api-operations/api-parameter-lists/{2}?isMergeUpdate={3}";
        APIParameterListRequestBody requestBody = new APIParameterListRequestBody(properties);
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        this.restClient.callVoidPostRESTCall("updateAPIParameterList", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiParameterListGUID, isMergeUpdate});
    }

    public void removeAPIParameterList(String userId, String apiManagerGUID, String apiManagerName, String apiParameterListGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeAPIParameterList";
        String elementGUIDParameterName = "apiParameterListGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeAPIParameterList");
        this.invalidParameterHandler.validateGUID(apiParameterListGUID, "apiParameterListGUID", "removeAPIParameterList");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeAPIParameterList");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/api-operations/api-parameter-lists/{2}/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(apiManagerGUID);
        requestBody.setExternalSourceName(apiManagerName);
        this.restClient.callVoidPostRESTCall("removeAPIParameterList", urlTemplate, requestBody, new Object[]{this.serverName, userId, apiParameterListGUID, qualifiedName});
    }

    public List<APIParameterListElement> findAPIParameterLists(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findAPIParameterLists";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findAPIParameterLists");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findAPIParameterLists");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findAPIParameterLists");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/api-operations/api-parameter-lists/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        APIParameterListsResponse restResult = this.restClient.callAPIParameterListsPostRESTCall("findAPIParameterLists", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<APIParameterListElement> getParameterListsForAPIOperation(String userId, String apiOperationGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getParameterListsForAPIOperation";
        String parentElementGUIDParameterName = "apiOperationGUID";
        this.invalidParameterHandler.validateUserId(userId, "getParameterListsForAPIOperation");
        this.invalidParameterHandler.validateGUID(apiOperationGUID, "apiOperationGUID", "getParameterListsForAPIOperation");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getParameterListsForAPIOperation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/{2}/api-operations/api-parameter-lists?startFrom={3}&pageSize={4}";
        APIParameterListsResponse restResult = this.restClient.callAPIParameterListsGetRESTCall("getParameterListsForAPIOperation", urlTemplate, new Object[]{this.serverName, userId, apiOperationGUID, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<APIParameterListElement> getAPIParameterListsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAPIParameterListsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getAPIParameterListsByName");
        this.invalidParameterHandler.validateName(name, "name", "getAPIParameterListsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAPIParameterListsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/api-operations/api-parameter-lists/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        APIParameterListsResponse restResult = this.restClient.callAPIParameterListsPostRESTCall("getAPIParameterListsByName", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public APIParameterListElement getAPIParameterListByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAPIOperationByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getAPIOperationByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getAPIOperationByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/apis/api-operations/api-parameter-lists/{2}";
        APIParameterListResponse restResult = this.restClient.callAPIParameterListGetRESTCall("getAPIOperationByGUID", urlTemplate, new Object[]{this.serverName, userId, guid});
        return restResult.getElement();
    }

    public String createAPIParameter(String userId, String apiManagerGUID, String apiManagerName, String schemaElementGUID, APIParameterProperties apiParameterProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAPIParameter";
        String parentElementGUIDParameterName = "schemaElementGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createAPIParameter");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "createAPIParameter");
        this.invalidParameterHandler.validateObject((Object)apiParameterProperties, "properties", "createAPIParameter");
        this.invalidParameterHandler.validateName(apiParameterProperties.getQualifiedName(), "properties.qualifiedName", "createAPIParameter");
        return super.createSchemaAttribute(userId, apiManagerGUID, apiManagerName, schemaElementGUID, this.getSchemaAttributeProperties(apiParameterProperties));
    }

    public String createAPIParameterFromTemplate(String userId, String apiManagerGUID, String apiManagerName, String schemaElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return super.createSchemaAttributeFromTemplate(userId, apiManagerGUID, apiManagerName, schemaElementGUID, templateGUID, templateProperties);
    }

    @Override
    public void setupSchemaType(String userId, String apiManagerGUID, String apiManagerName, String relationshipTypeName, String apiParameterGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.setupSchemaType(userId, apiManagerGUID, apiManagerName, relationshipTypeName, apiParameterGUID, schemaTypeGUID);
    }

    private SchemaAttributeProperties getSchemaAttributeProperties(APIParameterProperties apiParameterProperties) {
        SchemaAttributeProperties properties = new SchemaAttributeProperties((SchemaAttributeProperties)apiParameterProperties);
        if (apiParameterProperties.getParameterType() != null) {
            HashMap<String, String> extendedProperties = new HashMap<String, String>();
            extendedProperties.put("parameterType", apiParameterProperties.getParameterType());
            properties.setExtendedProperties(extendedProperties);
        }
        return properties;
    }

    public void updateAPIParameter(String userId, String apiManagerGUID, String apiManagerName, String apiParameterGUID, boolean isMergeUpdate, APIParameterProperties apiParameterProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAPIParameter";
        String elementGUIDParameterName = "apiParameterGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateAPIParameter");
        this.invalidParameterHandler.validateGUID(apiParameterGUID, "apiParameterGUID", "updateAPIParameter");
        this.invalidParameterHandler.validateObject((Object)apiParameterProperties, "properties", "updateAPIParameter");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(apiParameterProperties.getQualifiedName(), "properties.qualifiedName", "updateAPIParameter");
        }
        super.updateSchemaAttribute(userId, apiManagerGUID, apiManagerName, apiParameterGUID, isMergeUpdate, this.getSchemaAttributeProperties(apiParameterProperties));
    }

    public void removeAPIParameter(String userId, String apiManagerGUID, String apiManagerName, String apiParameterGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.removeSchemaAttribute(userId, apiManagerGUID, apiManagerName, apiParameterGUID);
    }

    private List<APIParameterElement> getAPIParametersFromSchemaAttributes(List<SchemaAttributeElement> schemaAttributeElements) {
        if (schemaAttributeElements != null) {
            ArrayList<APIParameterElement> apiParameterElements = new ArrayList<APIParameterElement>();
            for (SchemaAttributeElement schemaAttributeElement : schemaAttributeElements) {
                if (schemaAttributeElement == null) continue;
                APIParameterElement apiParameterElement = new APIParameterElement(schemaAttributeElement);
                apiParameterElements.add(apiParameterElement);
            }
            if (!apiParameterElements.isEmpty()) {
                return apiParameterElements;
            }
        }
        return null;
    }

    public List<APIParameterElement> findAPIParameters(String userId, String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<SchemaAttributeElement> schemaAttributeElements = super.findSchemaAttributes(userId, searchString, typeName, startFrom, pageSize);
        return this.getAPIParametersFromSchemaAttributes(schemaAttributeElements);
    }

    public List<APIParameterElement> getNestedAPIParameters(String userId, String parentElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<SchemaAttributeElement> schemaAttributeElements = super.getNestedAttributes(userId, parentElementGUID, startFrom, pageSize);
        return this.getAPIParametersFromSchemaAttributes(schemaAttributeElements);
    }

    public List<APIParameterElement> getAPIParametersByName(String userId, String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<SchemaAttributeElement> schemaAttributeElements = super.getSchemaAttributesByName(userId, name, typeName, startFrom, pageSize);
        return this.getAPIParametersFromSchemaAttributes(schemaAttributeElements);
    }

    public APIParameterElement getAPIParameterByGUID(String userId, String apiParameterGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SchemaAttributeElement schemaAttributeElement = super.getSchemaAttributeByGUID(userId, apiParameterGUID);
        if (schemaAttributeElement != null) {
            return new APIParameterElement(schemaAttributeElement);
        }
        return null;
    }
}

