/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.fvt.databases;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.client.DatabaseManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseTableElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseManagerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseSchemaProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseTableProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.OwnerCategory;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateDatabaseTest {
    private static final String testCaseName = "CreateDatabaseTest";
    private static final int maxPageSize = 100;
    private static final String databaseManagerName = "TestDatabaseManager";
    private static final String databaseManagerDisplayName = "DatabaseManager displayName";
    private static final String databaseManagerDescription = "DatabaseManager description";
    private static final String databaseManagerTypeDescription = "DatabaseManager type";
    private static final String databaseManagerVersion = "DatabaseManager version";
    private static final String databaseName = "TestDatabase";
    private static final String databaseDisplayName = "Database displayName";
    private static final String databaseDescription = "Database description";
    private static final String databaseType = "Database type";
    private static final String databaseVersion = "Database version";
    private static final String databaseSchemaName = "TestDatabaseSchema";
    private static final String databaseSchemaDisplayName = "DatabaseSchema displayName";
    private static final String databaseSchemaDescription = "DatabaseSchema description";
    private static final String databaseSchemaZone = "DatabaseSchema Zone";
    private static final String databaseSchemaOwner = "DatabaseSchema Owner";
    private static final String databaseTableName = "TestDatabaseTable";
    private static final String databaseTableDisplayName = "DatabaseTable displayName";
    private static final String databaseTableDescription = "DatabaseTable description";
    private static final String databaseColumnName = "TestDatabaseColumn";
    private static final String databaseColumnDisplayName = "DatabaseColumn displayName";
    private static final String databaseColumnDescription = "DatabaseColumn description";
    private static final String databaseColumnType = "string";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateDatabaseTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateDatabaseTest thisTest = new CreateDatabaseTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceWiki());
        DatabaseManagerClient client = thisTest.getDatabaseManagerClient(serverName, serverPlatformRootURL, auditLog);
        String databaseManagerGUID = thisTest.getDatabaseManager(serverName, serverPlatformRootURL, userId, auditLog);
        String databaseGUID = thisTest.getDatabase(client, databaseManagerGUID, userId);
        String databaseSchemaGUID = thisTest.getDatabaseSchema(client, databaseManagerGUID, databaseGUID, userId);
        String databaseTableGUID = thisTest.getDatabaseTable(client, databaseManagerGUID, databaseSchemaGUID, userId);
        String databaseColumnGUID = thisTest.getDatabaseColumn(client, databaseManagerGUID, databaseTableGUID, userId);
    }

    private DatabaseManagerClient getDatabaseManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getDatabaseManagerClient";
        try {
            DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL);
            return new DatabaseManagerClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManagerClient", unexpectedError);
        }
    }

    private String getDatabaseManager(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getDatabaseManager";
        try {
            DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL);
            MetadataSourceClient client = new MetadataSourceClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
            DatabaseManagerProperties properties = new DatabaseManagerProperties();
            properties.setQualifiedName(databaseManagerName);
            properties.setDisplayName(databaseManagerDisplayName);
            properties.setDescription(databaseManagerDescription);
            properties.setTypeDescription(databaseManagerTypeDescription);
            properties.setVersion(databaseManagerVersion);
            String databaseManagerGUID = client.createDatabaseManager(userId, null, null, properties);
            if (databaseManagerGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManager(no GUID for Create)");
            }
            String retrievedDatabaseManagerGUID = client.getMetadataSourceGUID(userId, databaseManagerName);
            if (retrievedDatabaseManagerGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManager(no GUID for Retrieve)");
            }
            if (!retrievedDatabaseManagerGUID.equals(databaseManagerGUID)) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManager(Inconsistent GUIDs)");
            }
            return databaseManagerGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManager", unexpectedError);
        }
    }

    private String getDatabase(DatabaseManagerClient client, String databaseManagerGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getDatabase";
        try {
            DatabaseProperties properties = new DatabaseProperties();
            properties.setQualifiedName(databaseName);
            properties.setDisplayName(databaseDisplayName);
            properties.setDescription(databaseDescription);
            properties.setDatabaseType(databaseType);
            properties.setDatabaseVersion(databaseVersion);
            String databaseGUID = client.createDatabase(userId, databaseManagerGUID, databaseManagerName, properties);
            if (databaseGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(no GUID for Create)");
            }
            DatabaseElement retrievedElement = client.getDatabaseByGUID(userId, databaseGUID);
            DatabaseProperties retrievedDatabase = retrievedElement.getDatabaseProperties();
            if (retrievedDatabase == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(no Database from Retrieve)");
            }
            if (!databaseName.equals(retrievedDatabase.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(Bad qualifiedName from Retrieve)");
            }
            if (!databaseDisplayName.equals(retrievedDatabase.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(Bad displayName from Retrieve)");
            }
            if (!databaseDescription.equals(retrievedDatabase.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(Bad description from Retrieve)");
            }
            if (!databaseType.equals(retrievedDatabase.getDatabaseType())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(Bad databaseType from Retrieve " + retrievedDatabase.getDatabaseType() + ")");
            }
            if (!databaseVersion.equals(retrievedDatabase.getDatabaseVersion())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(Bad databaseVersion from Retrieve)");
            }
            List databaseList = client.getDatabasesByName(userId, databaseName, 0, 100);
            if (databaseList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(no Database for RetrieveByName)");
            }
            if (databaseList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(Empty Database list for RetrieveByName)");
            }
            if (databaseList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(Database list for RetrieveByName contains" + databaseList.size() + " elements)");
            }
            retrievedElement = (DatabaseElement)databaseList.get(0);
            retrievedDatabase = retrievedElement.getDatabaseProperties();
            if (!databaseName.equals(retrievedDatabase.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(Bad qualifiedName from RetrieveByName)");
            }
            if (!databaseDisplayName.equals(retrievedDatabase.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(Bad displayName from RetrieveByName)");
            }
            if (!databaseDescription.equals(retrievedDatabase.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(Bad description from RetrieveByName)");
            }
            if (!databaseType.equals(retrievedDatabase.getDatabaseType())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(Bad databaseType from RetrieveByName)");
            }
            if (!databaseVersion.equals(retrievedDatabase.getDatabaseVersion())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(Bad databaseVersion from RetrieveByName)");
            }
            databaseList = client.getDatabasesByName(userId, databaseName, 1, 100);
            if (databaseList != null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(no Database for RetrieveByName)");
            }
            return databaseGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDatabase", unexpectedError);
        }
    }

    private String getDatabaseSchema(DatabaseManagerClient client, String databaseManagerGUID, String databaseGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getDatabaseSchema";
        try {
            DatabaseSchemaProperties properties = new DatabaseSchemaProperties();
            properties.setQualifiedName(databaseSchemaName);
            properties.setDisplayName(databaseSchemaDisplayName);
            properties.setDescription(databaseSchemaDescription);
            ArrayList<String> zones = new ArrayList<String>();
            zones.add(databaseSchemaZone);
            properties.setZoneMembership(zones);
            properties.setOwner(databaseSchemaOwner);
            properties.setOwnerCategory(OwnerCategory.USER_ID);
            String databaseSchemaGUID = client.createDatabaseSchema(userId, databaseManagerGUID, databaseManagerName, databaseGUID, properties);
            if (databaseSchemaGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(no GUID for schemaCreate)");
            }
            DatabaseSchemaElement retrievedElement = client.getDatabaseSchemaByGUID(userId, databaseSchemaGUID);
            DatabaseSchemaProperties retrievedSchema = retrievedElement.getDatabaseSchemaProperties();
            if (retrievedSchema == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(no DatabaseSchema from Retrieve)");
            }
            if (!databaseSchemaName.equals(retrievedSchema.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Bad qualifiedName from Retrieve)");
            }
            if (!databaseSchemaDisplayName.equals(retrievedSchema.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Bad displayName from Retrieve)");
            }
            if (!databaseSchemaDescription.equals(retrievedSchema.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Bad description from Retrieve)");
            }
            if (retrievedSchema.getZoneMembership() == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Null database schema Zone Membership from Retrieve)");
            }
            if (retrievedSchema.getZoneMembership().size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Database schema Zone Membership size is " + retrievedSchema.getZoneMembership().size() + " from Retrieve)");
            }
            if (!databaseSchemaZone.equals(retrievedSchema.getZoneMembership().get(0))) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Bad database schema Zone Membership from Retrieve)");
            }
            if (!databaseSchemaOwner.equals(retrievedSchema.getOwner())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Bad database owner from Retrieve)");
            }
            if (OwnerCategory.USER_ID != retrievedSchema.getOwnerCategory()) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Bad database owner type from Retrieve)");
            }
            List databaseSchemaList = client.getDatabaseSchemasByName(userId, databaseSchemaName, 0, 100);
            if (databaseSchemaList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(no DatabaseSchema for RetrieveByName)");
            }
            if (databaseSchemaList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Empty DatabaseSchema list for RetrieveByName)");
            }
            if (databaseSchemaList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(DatabaseSchema list for RetrieveByName contains" + databaseSchemaList.size() + " elements)");
            }
            retrievedElement = (DatabaseSchemaElement)databaseSchemaList.get(0);
            retrievedSchema = retrievedElement.getDatabaseSchemaProperties();
            if (!databaseSchemaName.equals(retrievedSchema.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Bad qualifiedName from RetrieveByName)");
            }
            if (!databaseSchemaDisplayName.equals(retrievedSchema.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Bad displayName from RetrieveByName)");
            }
            if (!databaseSchemaDescription.equals(retrievedSchema.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Bad description from RetrieveByName)");
            }
            if (!databaseSchemaZone.equals(retrievedSchema.getZoneMembership().get(0))) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Bad zone membership from RetrieveByName)");
            }
            if (!databaseSchemaOwner.equals(retrievedSchema.getOwner())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(Bad database owner from RetrieveByName)");
            }
            return databaseSchemaGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema", unexpectedError);
        }
    }

    private String getDatabaseTable(DatabaseManagerClient client, String databaseManagerGUID, String databaseSchemaGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getDatabaseTable";
        try {
            DatabaseTableProperties properties = new DatabaseTableProperties();
            properties.setQualifiedName(databaseTableName);
            properties.setDisplayName(databaseTableDisplayName);
            properties.setDescription(databaseTableDescription);
            String databaseTableGUID = client.createDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, properties);
            if (databaseTableGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseTable(no GUID for tableCreate)");
            }
            DatabaseTableElement retrievedElement = client.getDatabaseTableByGUID(userId, databaseTableGUID);
            DatabaseTableProperties retrievedTable = retrievedElement.getDatabaseTableProperties();
            if (retrievedTable == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseTable(no DatabaseTable from Retrieve)");
            }
            if (!databaseTableName.equals(retrievedTable.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseTable(Bad qualifiedName from Retrieve)");
            }
            if (!databaseTableDisplayName.equals(retrievedTable.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseTable(Bad displayName from Retrieve)");
            }
            if (!databaseTableDescription.equals(retrievedTable.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseTable(Bad description from Retrieve)");
            }
            List databaseTableList = client.getDatabaseTablesByName(userId, databaseTableName, 0, 100);
            if (databaseTableList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseTable(no DatabaseTable for RetrieveByName)");
            }
            if (databaseTableList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseTable(Empty DatabaseTable list for RetrieveByName)");
            }
            if (databaseTableList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseTable(DatabaseTable list for RetrieveByName contains" + databaseTableList.size() + " elements)");
            }
            retrievedElement = (DatabaseTableElement)databaseTableList.get(0);
            retrievedTable = retrievedElement.getDatabaseTableProperties();
            if (!databaseTableName.equals(retrievedTable.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseTable(Bad qualifiedName from RetrieveByName)");
            }
            if (!databaseTableDisplayName.equals(retrievedTable.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseTable(Bad displayName from RetrieveByName)");
            }
            if (!databaseTableDescription.equals(retrievedTable.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseTable(Bad description from RetrieveByName)");
            }
            List databaseColumnList = client.getColumnsForDatabaseTable(userId, databaseTableGUID, 0, 100);
            if (databaseColumnList != null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseTable(no DatabaseColumn for getColumnsForDatabaseTable)");
            }
            return databaseTableGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDatabaseTable", unexpectedError);
        }
    }

    private String getDatabaseColumn(DatabaseManagerClient client, String databaseManagerGUID, String databaseTableGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getDatabaseColumn";
        try {
            DatabaseColumnProperties properties = new DatabaseColumnProperties();
            properties.setQualifiedName(databaseColumnName);
            properties.setDisplayName(databaseColumnDisplayName);
            properties.setDescription(databaseColumnDescription);
            properties.setDataType(databaseColumnType);
            String databaseColumnGUID = client.createDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, properties);
            if (databaseColumnGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(no GUID for columnCreate)");
            }
            DatabaseColumnElement retrievedElement = client.getDatabaseColumnByGUID(userId, databaseColumnGUID);
            DatabaseColumnProperties retrievedColumn = retrievedElement.getDatabaseColumnProperties();
            if (retrievedColumn == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(no DatabaseColumn from Retrieve)");
            }
            if (!databaseColumnName.equals(retrievedColumn.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(Bad qualifiedName from Retrieve)");
            }
            if (!databaseColumnDisplayName.equals(retrievedColumn.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(Bad displayName from Retrieve)");
            }
            if (!databaseColumnDescription.equals(retrievedColumn.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(Bad description from Retrieve)");
            }
            List databaseColumnList = client.getDatabaseColumnsByName(userId, databaseColumnName, 0, 100);
            if (databaseColumnList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(no DatabaseColumn for RetrieveByName)");
            }
            if (databaseColumnList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(Empty DatabaseColumn list for RetrieveByName)");
            }
            if (databaseColumnList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(DatabaseColumn list for RetrieveByName contains" + databaseColumnList.size() + " elements)");
            }
            retrievedElement = (DatabaseColumnElement)databaseColumnList.get(0);
            retrievedColumn = retrievedElement.getDatabaseColumnProperties();
            if (!databaseColumnName.equals(retrievedColumn.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(Bad qualifiedName from RetrieveByName)");
            }
            if (!databaseColumnDisplayName.equals(retrievedColumn.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(Bad displayName from RetrieveByName)");
            }
            if (!databaseColumnDescription.equals(retrievedColumn.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(Bad description from RetrieveByName)");
            }
            databaseColumnList = client.getColumnsForDatabaseTable(userId, databaseTableGUID, 0, 100);
            if (databaseColumnList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(no DatabaseColumn for getColumnsForDatabaseTable)");
            }
            if (databaseColumnList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(Empty DatabaseColumn list for getColumnsForDatabaseTable)");
            }
            if (databaseColumnList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(DatabaseColumn list for getColumnsForDatabaseTable contains" + databaseColumnList.size() + " elements)");
            }
            retrievedElement = (DatabaseColumnElement)databaseColumnList.get(0);
            retrievedColumn = retrievedElement.getDatabaseColumnProperties();
            if (!databaseColumnName.equals(retrievedColumn.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(Bad qualifiedName from getColumnsForDatabaseTable)");
            }
            if (!databaseColumnDisplayName.equals(retrievedColumn.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(Bad displayName from getColumnsForDatabaseTable)");
            }
            if (!databaseColumnDescription.equals(retrievedColumn.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn(Bad description from getColumnsForDatabaseTable)");
            }
            return databaseColumnGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDatabaseColumn", unexpectedError);
        }
    }
}

