/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.fvt.clientconstructors;

import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DatabaseManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.FilesAndFoldersClient;
import org.odpi.openmetadata.accessservices.datamanager.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;

public class ClientConstructorTest {
    private static final String testCaseName = "ClientConstructorTest";
    private static final String callerId = "TestCallerId";
    private static final String serverUserId = "TestNPA";
    private static final String serverPassword = "TestNPAPassword";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            ClientConstructorTest.runIt(serverPlatformRootURL, serverName, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, FVTAuditLogDestination auditLogDestination) throws InvalidParameterException {
        ClientConstructorTest thisTest = new ClientConstructorTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceWiki());
        thisTest.testMetadataSourceClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testDatabaseManagerClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testFilesAndFoldersClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testDataManagerEventClient(serverName, serverPlatformRootURL, auditLog);
    }

    private void testMetadataSourceClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new MetadataSourceClient(serverName, serverPlatformRootURL, auditLog);
        new MetadataSourceClient(serverName, serverPlatformRootURL);
        new MetadataSourceClient(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new MetadataSourceClient(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL);
        new MetadataSourceClient(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testDatabaseManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new DatabaseManagerClient(serverName, serverPlatformRootURL, auditLog);
        new DatabaseManagerClient(serverName, serverPlatformRootURL);
        new DatabaseManagerClient(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new DatabaseManagerClient(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL);
        new DatabaseManagerClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
    }

    private void testFilesAndFoldersClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new FilesAndFoldersClient(serverName, serverPlatformRootURL, auditLog);
        new FilesAndFoldersClient(serverName, serverPlatformRootURL);
        new FilesAndFoldersClient(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new FilesAndFoldersClient(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL);
        new FilesAndFoldersClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
    }

    private void testDataManagerEventClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new DataManagerEventClient(serverName, serverPlatformRootURL, callerId);
        new DataManagerEventClient(serverName, serverPlatformRootURL, serverUserId, serverPassword, callerId);
        DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL);
        new DataManagerEventClient(serverName, serverPlatformRootURL, (OCFRESTClient)restClient, 100, auditLog, callerId);
    }
}

