/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.fvt.databases;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.client.DatabaseManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseTableElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseManagerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseSchemaProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseTableProperties;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateDatabaseTest {
    private static final String testCaseName = "CreateDatabaseTest";
    private static final int maxPageSize = 100;
    private static final String databaseManagerName = "TestDatabaseManager";
    private static final String databaseManagerDisplayName = "DatabaseManager displayName";
    private static final String databaseManagerDescription = "DatabaseManager description";
    private static final String databaseManagerTypeDescription = "DatabaseManager type";
    private static final String databaseManagerVersion = "DatabaseManager version";
    private static final String databaseName = "TestDatabase";
    private static final String databaseDisplayName = "Database displayName";
    private static final String databaseDescription = "Database description";
    private static final String databaseType = "Database type";
    private static final String databaseVersion = "Database version";
    private static final String databaseSchemaName = "TestDatabaseSchema";
    private static final String databaseSchemaDisplayName = "DatabaseSchema displayName";
    private static final String databaseSchemaDescription = "DatabaseSchema description";
    private static final String databaseTableName = "TestDatabaseTable";
    private static final String databaseTableDisplayName = "DatabaseTable displayName";
    private static final String databaseTableDescription = "DatabaseTable description";
    private static final String databaseColumnName = "TestDatabaseColumn";
    private static final String databaseColumnDisplayName = "DatabaseColumn displayName";
    private static final String databaseColumnDescription = "DatabaseColumn description";
    private static final String databaseColumnType = "string";
    private static final String databaseColumnTwoName = "TestDatabaseColumn2";
    private static final String databaseColumnTwoDisplayName = "DatabaseColumn2 displayName";
    private static final String databaseColumnTwoDescription = "DatabaseColumn2 description";
    private static final String databaseColumnTwoType = "date";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateDatabaseTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateDatabaseTest thisTest = new CreateDatabaseTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceWiki());
        DatabaseManagerClient client = thisTest.getDatabaseManagerClient(serverName, serverPlatformRootURL, auditLog);
        String databaseManagerGUID = thisTest.getDatabaseManager(serverName, serverPlatformRootURL, userId, auditLog);
        String databaseGUID = thisTest.getDatabase(client, databaseManagerGUID, userId);
        String databaseSchemaGUID = thisTest.getDatabaseSchema(client, databaseManagerGUID, databaseGUID, userId);
        String databaseTableGUID = thisTest.createDatabaseTable(client, databaseManagerGUID, databaseSchemaGUID, userId);
        String databaseColumnGUID = thisTest.createDatabaseColumn(client, databaseManagerGUID, databaseTableGUID, userId);
        String activityName = "cascadedDelete";
        try {
            client.removeDatabase(userId, databaseManagerGUID, databaseManagerName, databaseGUID);
            thisTest.checkDatabaseGone(client, databaseGUID, activityName, userId);
            thisTest.checkDatabaseSchemaGone(client, databaseSchemaGUID, null, activityName, userId);
            thisTest.checkDatabaseTableGone(client, databaseTableGUID, null, activityName, userId);
            thisTest.checkDatabaseColumnGone(client, databaseColumnGUID, null, activityName, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        activityName = "deleteOneByOne";
        databaseGUID = thisTest.getDatabase(client, databaseManagerGUID, userId);
        databaseSchemaGUID = thisTest.getDatabaseSchema(client, databaseManagerGUID, databaseGUID, userId);
        databaseTableGUID = thisTest.createDatabaseTable(client, databaseManagerGUID, databaseSchemaGUID, userId);
        databaseColumnGUID = thisTest.createDatabaseColumn(client, databaseManagerGUID, databaseTableGUID, userId);
        try {
            activityName = "deleteOneByOne - pre-validate";
            thisTest.checkDatabaseColumnOK(client, databaseColumnGUID, databaseTableGUID, activityName, userId);
            thisTest.checkDatabaseTableOK(client, databaseTableGUID, databaseSchemaGUID, activityName, userId);
            thisTest.checkDatabaseSchemaOK(client, databaseSchemaGUID, databaseGUID, activityName, userId);
            thisTest.checkDatabaseOK(client, databaseGUID, activityName, userId);
            client.removeDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID);
            activityName = "deleteOneByOne - column gone";
            thisTest.checkDatabaseColumnGone(client, databaseColumnGUID, databaseTableGUID, activityName, userId);
            thisTest.checkDatabaseTableOK(client, databaseTableGUID, databaseSchemaGUID, activityName, userId);
            thisTest.checkDatabaseSchemaOK(client, databaseSchemaGUID, databaseGUID, activityName, userId);
            thisTest.checkDatabaseOK(client, databaseGUID, activityName, userId);
            client.removeDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID);
            activityName = "deleteOneByOne - table gone";
            thisTest.checkDatabaseColumnGone(client, databaseColumnGUID, null, activityName, userId);
            thisTest.checkDatabaseTableGone(client, databaseTableGUID, databaseSchemaGUID, activityName, userId);
            thisTest.checkDatabaseSchemaOK(client, databaseSchemaGUID, databaseGUID, activityName, userId);
            thisTest.checkDatabaseOK(client, databaseGUID, activityName, userId);
            client.removeDatabaseSchema(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID);
            activityName = "deleteOneByOne - schema gone";
            thisTest.checkDatabaseColumnGone(client, databaseColumnGUID, null, activityName, userId);
            thisTest.checkDatabaseTableGone(client, databaseTableGUID, null, activityName, userId);
            thisTest.checkDatabaseSchemaGone(client, databaseSchemaGUID, databaseGUID, activityName, userId);
            thisTest.checkDatabaseOK(client, databaseGUID, activityName, userId);
            client.removeDatabase(userId, databaseManagerGUID, databaseManagerName, databaseGUID);
            activityName = "deleteOneByOne - database gone";
            thisTest.checkDatabaseColumnGone(client, databaseColumnGUID, null, activityName, userId);
            thisTest.checkDatabaseTableGone(client, databaseTableGUID, null, activityName, userId);
            thisTest.checkDatabaseSchemaGone(client, databaseSchemaGUID, null, activityName, userId);
            thisTest.checkDatabaseGone(client, databaseGUID, activityName, userId);
            databaseGUID = thisTest.getDatabase(client, databaseManagerGUID, userId);
            databaseSchemaGUID = thisTest.getDatabaseSchema(client, databaseManagerGUID, databaseGUID, userId);
            databaseTableGUID = thisTest.createDatabaseTable(client, databaseManagerGUID, databaseSchemaGUID, userId);
            databaseColumnGUID = thisTest.createDatabaseColumn(client, databaseManagerGUID, databaseTableGUID, userId);
            activityName = "updateNonExistentColumn";
            String databaseColumnTwoGUID = "Blah Blah";
            DatabaseColumnProperties databaseColumnTwoProperties = new DatabaseColumnProperties();
            databaseColumnTwoProperties.setQualifiedName(databaseColumnTwoName);
            databaseColumnTwoProperties.setDisplayName(databaseColumnDisplayName);
            databaseColumnTwoProperties.setDescription(databaseColumnTwoDescription);
            databaseColumnTwoProperties.setDataType(databaseColumnType);
            try {
                client.updateDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnTwoGUID, true, databaseColumnTwoProperties);
                throw new FVTUnexpectedCondition(testCaseName, activityName);
            }
            catch (InvalidParameterException invalidParameterException) {
                activityName = "updateColumnWithSameProperties";
                databaseColumnTwoGUID = client.createDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, databaseColumnTwoProperties);
                DatabaseColumnElement beforeElement = client.getDatabaseColumnByGUID(userId, databaseColumnTwoGUID);
                client.updateDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnTwoGUID, false, databaseColumnTwoProperties);
                DatabaseColumnElement afterElement = client.getDatabaseColumnByGUID(userId, databaseColumnTwoGUID);
                if (!beforeElement.getElementHeader().getVersions().equals((Object)afterElement.getElementHeader().getVersions())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(version changed from " + beforeElement.getElementHeader().getVersions() + " to " + afterElement.getElementHeader().getVersions() + ")");
                }
                activityName = "updateColumnClassificationProperties";
                databaseColumnTwoProperties.setDataType(databaseColumnTwoType);
                client.updateDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnTwoGUID, false, databaseColumnTwoProperties);
                afterElement = client.getDatabaseColumnByGUID(userId, databaseColumnTwoGUID);
                if (!beforeElement.getElementHeader().getVersions().equals((Object)afterElement.getElementHeader().getVersions())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(version changed from " + beforeElement.getElementHeader().getVersions() + " to " + afterElement.getElementHeader().getVersions() + ")");
                }
                if (!databaseColumnTwoType.equals(afterElement.getDatabaseColumnProperties().getDataType())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(data type should be date rather than " + afterElement.getDatabaseColumnProperties().getDataType() + ")");
                }
                activityName = "updateColumnProperties";
                databaseColumnTwoProperties.setDisplayName(databaseColumnTwoDisplayName);
                client.updateDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnTwoGUID, false, databaseColumnTwoProperties);
                afterElement = client.getDatabaseColumnByGUID(userId, databaseColumnTwoGUID);
                if (beforeElement.getElementHeader().getVersions().equals((Object)afterElement.getElementHeader().getVersions())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(version did not change from " + beforeElement.getElementHeader().getVersions() + ")");
                }
                if (!databaseColumnTwoDisplayName.equals(afterElement.getDatabaseColumnProperties().getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(display name should be DatabaseColumn2 displayName rather than " + afterElement.getDatabaseColumnProperties().getDisplayName() + ")");
                }
                activityName = "cascadedDelete";
                try {
                    client.removeDatabase(userId, databaseManagerGUID, databaseManagerName, databaseGUID);
                    thisTest.checkDatabaseGone(client, databaseGUID, activityName, userId);
                    thisTest.checkDatabaseSchemaGone(client, databaseSchemaGUID, null, activityName, userId);
                    thisTest.checkDatabaseTableGone(client, databaseTableGUID, null, activityName, userId);
                    thisTest.checkDatabaseColumnGone(client, databaseColumnGUID, null, activityName, userId);
                    thisTest.checkDatabaseColumnGone(client, databaseColumnTwoGUID, null, activityName, userId);
                }
                catch (Exception unexpectedError) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
                }
                activityName = "schemaType test";
                databaseGUID = thisTest.getDatabase(client, databaseManagerGUID, userId);
                databaseSchemaGUID = thisTest.getDatabaseSchema(client, databaseManagerGUID, databaseGUID, userId);
                String databaseSchemaTypeGUID = client.createDatabaseSchemaType(userId, databaseManagerGUID, databaseManagerName, "SchemaOf:TestDatabaseSchema");
                databaseTableGUID = thisTest.createDatabaseTableForSchemaType(client, databaseManagerGUID, databaseSchemaTypeGUID, userId);
                databaseColumnGUID = thisTest.createDatabaseColumn(client, databaseManagerGUID, databaseTableGUID, userId);
                client.attachSchemaTypeToDatabaseAsset(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, databaseSchemaTypeGUID);
                activityName = "cascadedDelete for SchemaType";
                try {
                    client.removeDatabase(userId, databaseManagerGUID, databaseManagerName, databaseGUID);
                    thisTest.checkDatabaseGone(client, databaseGUID, activityName, userId);
                    thisTest.checkDatabaseSchemaGone(client, databaseSchemaGUID, null, activityName, userId);
                    thisTest.checkDatabaseTableGone(client, databaseTableGUID, null, activityName, userId);
                    thisTest.checkDatabaseColumnGone(client, databaseColumnGUID, null, activityName, userId);
                }
                catch (Exception unexpectedError) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
                }
            }
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private DatabaseManagerClient getDatabaseManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getDatabaseManagerClient";
        try {
            DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL, auditLog);
            return new DatabaseManagerClient(serverName, serverPlatformRootURL, restClient, 100);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManagerClient", (Throwable)unexpectedError);
        }
    }

    private String getDatabaseManager(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getDatabaseManager";
        try {
            DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL);
            MetadataSourceClient client = new MetadataSourceClient(serverName, serverPlatformRootURL, restClient, 100);
            DatabaseManagerProperties properties = new DatabaseManagerProperties();
            properties.setQualifiedName(databaseManagerName);
            properties.setDisplayName(databaseManagerDisplayName);
            properties.setDescription(databaseManagerDescription);
            properties.setTypeDescription(databaseManagerTypeDescription);
            properties.setVersion(databaseManagerVersion);
            String databaseManagerGUID = client.createDatabaseManager(userId, null, null, properties);
            if (databaseManagerGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManager(no GUID for Create)");
            }
            String retrievedDatabaseManagerGUID = client.getMetadataSourceGUID(userId, databaseManagerName);
            if (retrievedDatabaseManagerGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManager(no GUID for Retrieve)");
            }
            if (!retrievedDatabaseManagerGUID.equals(databaseManagerGUID)) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManager(Inconsistent GUIDs)");
            }
            return databaseManagerGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManager", (Throwable)unexpectedError);
        }
    }

    private void checkDatabaseGone(DatabaseManagerClient client, String databaseGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            DatabaseElement retrievedElement = client.getDatabaseByGUID(userId, databaseGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Database returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Retrieve returned)");
        }
        catch (InvalidParameterException retrievedElement) {
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void checkDatabaseOK(DatabaseManagerClient client, String databaseGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            DatabaseElement retrievedElement = client.getDatabaseByGUID(userId, databaseGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseElement from Retrieve)");
            }
            DatabaseProperties retrievedDatabase = retrievedElement.getDatabaseProperties();
            if (retrievedDatabase == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseProperties from Retrieve)");
            }
            if (!databaseName.equals(retrievedDatabase.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve)");
            }
            if (!databaseDisplayName.equals(retrievedDatabase.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve)");
            }
            if (!databaseDescription.equals(retrievedDatabase.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve)");
            }
            if (!databaseType.equals(retrievedDatabase.getDatabaseType())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad databaseType from Retrieve " + retrievedDatabase.getDatabaseType() + ")");
            }
            if (!databaseVersion.equals(retrievedDatabase.getDatabaseVersion())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad databaseVersion from Retrieve)");
            }
            List databaseList = client.getDatabasesByName(userId, databaseName, 0, 100);
            if (databaseList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Database for RetrieveByName)");
            }
            if (databaseList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Database list for RetrieveByName)");
            }
            if (databaseList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Database list for RetrieveByName contains" + databaseList.size() + " elements)");
            }
            retrievedElement = (DatabaseElement)databaseList.get(0);
            retrievedDatabase = retrievedElement.getDatabaseProperties();
            if (!databaseName.equals(retrievedDatabase.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!databaseDisplayName.equals(retrievedDatabase.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName)");
            }
            if (!databaseDescription.equals(retrievedDatabase.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            if (!databaseType.equals(retrievedDatabase.getDatabaseType())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad databaseType from RetrieveByName)");
            }
            if (!databaseVersion.equals(retrievedDatabase.getDatabaseVersion())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad databaseVersion from RetrieveByName)");
            }
            databaseList = client.getDatabasesByName(userId, databaseName, 1, 100);
            if (databaseList != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Database for RetrieveByName)");
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getDatabase(DatabaseManagerClient client, String databaseManagerGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getDatabase";
        try {
            DatabaseProperties properties = new DatabaseProperties();
            properties.setQualifiedName(databaseName);
            properties.setDisplayName(databaseDisplayName);
            properties.setDescription(databaseDescription);
            properties.setDatabaseType(databaseType);
            properties.setDatabaseVersion(databaseVersion);
            String databaseGUID = client.createDatabase(userId, databaseManagerGUID, databaseManagerName, properties);
            if (databaseGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabase(no GUID for Create)");
            }
            this.checkDatabaseOK(client, databaseGUID, "getDatabase", userId);
            return databaseGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDatabase", (Throwable)unexpectedError);
        }
    }

    private void checkDatabaseSchemaGone(DatabaseManagerClient client, String databaseSchemaGUID, String databaseGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            DatabaseSchemaElement retrievedElement = client.getDatabaseSchemaByGUID(userId, databaseSchemaGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseSchema returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getDatabaseSchemaByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (databaseGUID != null) {
            try {
                List databaseSchemaList = client.getSchemasForDatabase(userId, databaseGUID, 0, 100);
                if (databaseSchemaList != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseSchema returned for getSchemasForDatabase)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void checkDatabaseSchemaOK(DatabaseManagerClient client, String databaseSchemaGUID, String databaseGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            DatabaseSchemaElement retrievedElement = client.getDatabaseSchemaByGUID(userId, databaseSchemaGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseSchemaElement from Retrieve)");
            }
            DatabaseSchemaProperties retrievedSchema = retrievedElement.getDatabaseSchemaProperties();
            if (retrievedSchema == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseSchemaProperties from Retrieve)");
            }
            if (!databaseSchemaName.equals(retrievedSchema.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve)");
            }
            if (!databaseSchemaDisplayName.equals(retrievedSchema.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve)");
            }
            if (!databaseSchemaDescription.equals(retrievedSchema.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve)");
            }
            List databaseSchemaList = client.getDatabaseSchemasByName(userId, databaseSchemaName, 0, 100);
            if (databaseSchemaList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseSchema for RetrieveByName)");
            }
            if (databaseSchemaList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty DatabaseSchema list for RetrieveByName)");
            }
            if (databaseSchemaList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseSchema list for RetrieveByName contains" + databaseSchemaList.size() + " elements)");
            }
            retrievedElement = (DatabaseSchemaElement)databaseSchemaList.get(0);
            retrievedSchema = retrievedElement.getDatabaseSchemaProperties();
            if (!databaseSchemaName.equals(retrievedSchema.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!databaseSchemaDisplayName.equals(retrievedSchema.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName)");
            }
            if (!databaseSchemaDescription.equals(retrievedSchema.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            databaseSchemaList = client.getSchemasForDatabase(userId, databaseGUID, 0, 100);
            if (databaseSchemaList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseSchema for getSchemasForDatabase)");
            }
            if (databaseSchemaList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty DatabaseSchema list for getSchemasForDatabase)");
            }
            if (databaseSchemaList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseSchema list for getSchemasForDatabase contains" + databaseSchemaList.size() + " elements)");
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getDatabaseSchema(DatabaseManagerClient client, String databaseManagerGUID, String databaseGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getDatabaseSchema";
        try {
            DatabaseSchemaProperties properties = new DatabaseSchemaProperties();
            properties.setQualifiedName(databaseSchemaName);
            properties.setDisplayName(databaseSchemaDisplayName);
            properties.setDescription(databaseSchemaDescription);
            String databaseSchemaGUID = client.createDatabaseSchema(userId, databaseManagerGUID, databaseManagerName, databaseGUID, properties);
            if (databaseSchemaGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema(no GUID for schemaCreate)");
            }
            this.checkDatabaseSchemaOK(client, databaseSchemaGUID, databaseGUID, "getDatabaseSchema", userId);
            return databaseSchemaGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDatabaseSchema", (Throwable)unexpectedError);
        }
    }

    private void checkDatabaseTableGone(DatabaseManagerClient client, String databaseTableGUID, String databaseSchemaGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            DatabaseTableElement retrievedElement = client.getDatabaseTableByGUID(userId, databaseTableGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseTable returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getDatabaseTableByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (databaseSchemaGUID != null) {
            try {
                List databaseTableList = client.getTablesForDatabaseSchema(userId, databaseSchemaGUID, 0, 100);
                if (databaseTableList != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseTable returned for getTablesForDatabaseAsset)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void checkDatabaseTableOK(DatabaseManagerClient client, String databaseTableGUID, String databaseSchemaGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            DatabaseTableElement retrievedElement = client.getDatabaseTableByGUID(userId, databaseTableGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseTableElement from Retrieve)");
            }
            DatabaseTableProperties retrievedTable = retrievedElement.getDatabaseTableProperties();
            if (retrievedTable == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseTableProperties from Retrieve)");
            }
            if (!databaseTableName.equals(retrievedTable.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve)");
            }
            if (!databaseTableDisplayName.equals(retrievedTable.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve)");
            }
            if (!databaseTableDescription.equals(retrievedTable.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve)");
            }
            List databaseTableList = client.getDatabaseTablesByName(userId, databaseTableName, 0, 100);
            if (databaseTableList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseTable for RetrieveByName)");
            }
            if (databaseTableList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty DatabaseTable list for RetrieveByName)");
            }
            if (databaseTableList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseTable list for RetrieveByName contains" + databaseTableList.size() + " elements)");
            }
            retrievedElement = (DatabaseTableElement)databaseTableList.get(0);
            retrievedTable = retrievedElement.getDatabaseTableProperties();
            if (!databaseTableName.equals(retrievedTable.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!databaseTableDisplayName.equals(retrievedTable.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName)");
            }
            if (!databaseTableDescription.equals(retrievedTable.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            if (databaseSchemaGUID != null) {
                databaseTableList = client.getTablesForDatabaseAsset(userId, databaseSchemaGUID, 0, 100);
                if (databaseTableList == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseTable for getTablesForDatabaseAsset)");
                }
                if (databaseTableList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty DatabaseTable list for getTablesForDatabaseAsset)");
                }
                if (databaseTableList.size() != 1) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseColumn list for getTablesForDatabaseAsset contains" + databaseTableList.size() + " elements)");
                }
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String createDatabaseTable(DatabaseManagerClient client, String databaseManagerGUID, String databaseSchemaGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createDatabaseTable";
        try {
            DatabaseTableProperties properties = new DatabaseTableProperties();
            properties.setQualifiedName(databaseTableName);
            properties.setDisplayName(databaseTableDisplayName);
            properties.setDescription(databaseTableDescription);
            String databaseTableGUID = client.createDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, properties);
            if (databaseTableGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createDatabaseTable(no GUID for tableCreate)");
            }
            this.checkDatabaseTableOK(client, databaseTableGUID, databaseSchemaGUID, "createDatabaseTable", userId);
            return databaseTableGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createDatabaseTable", (Throwable)unexpectedError);
        }
    }

    private String createDatabaseTableForSchemaType(DatabaseManagerClient client, String databaseManagerGUID, String databaseSchemaTypeGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createDatabaseTableForSchemaType";
        try {
            DatabaseTableProperties properties = new DatabaseTableProperties();
            properties.setQualifiedName(databaseTableName);
            properties.setDisplayName(databaseTableDisplayName);
            properties.setDescription(databaseTableDescription);
            String databaseTableGUID = client.createDatabaseTableForSchemaType(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, properties);
            if (databaseTableGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createDatabaseTableForSchemaType(no GUID for tableCreate)");
            }
            this.checkDatabaseTableOK(client, databaseTableGUID, null, "createDatabaseTableForSchemaType", userId);
            return databaseTableGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createDatabaseTableForSchemaType", (Throwable)unexpectedError);
        }
    }

    private void checkDatabaseColumnGone(DatabaseManagerClient client, String databaseColumnGUID, String databaseTableGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            DatabaseColumnElement retrievedElement = client.getDatabaseColumnByGUID(userId, databaseColumnGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseColumn returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getDatabaseColumnByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (databaseTableGUID != null) {
            try {
                List databaseColumnList = client.getColumnsForDatabaseTable(userId, databaseTableGUID, 0, 100);
                if (databaseColumnList != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseColumn returned for getColumnsForDatabaseTable)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void checkDatabaseColumnOK(DatabaseManagerClient client, String databaseColumnGUID, String databaseTableGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            DatabaseColumnElement retrievedElement = client.getDatabaseColumnByGUID(userId, databaseColumnGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseColumnElement from Retrieve)");
            }
            DatabaseColumnProperties retrievedColumn = retrievedElement.getDatabaseColumnProperties();
            if (retrievedColumn == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseColumnProperties from Retrieve)");
            }
            if (!databaseColumnName.equals(retrievedColumn.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve)");
            }
            if (!databaseColumnDisplayName.equals(retrievedColumn.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve)");
            }
            if (!databaseColumnDescription.equals(retrievedColumn.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve)");
            }
            List databaseColumnList = client.getDatabaseColumnsByName(userId, databaseColumnName, 0, 100);
            if (databaseColumnList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseColumn for RetrieveByName)");
            }
            if (databaseColumnList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty DatabaseColumn list for RetrieveByName)");
            }
            if (databaseColumnList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseColumn list for RetrieveByName contains" + databaseColumnList.size() + " elements)");
            }
            retrievedElement = (DatabaseColumnElement)databaseColumnList.get(0);
            retrievedColumn = retrievedElement.getDatabaseColumnProperties();
            if (!databaseColumnName.equals(retrievedColumn.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!databaseColumnDisplayName.equals(retrievedColumn.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName)");
            }
            if (!databaseColumnDescription.equals(retrievedColumn.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            databaseColumnList = client.getColumnsForDatabaseTable(userId, databaseTableGUID, 0, 100);
            if (databaseColumnList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no DatabaseColumn for getColumnsForDatabaseTable)");
            }
            if (databaseColumnList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty DatabaseColumn list for getColumnsForDatabaseTable)");
            }
            if (databaseColumnList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(DatabaseColumn list for getColumnsForDatabaseTable contains" + databaseColumnList.size() + " elements)");
            }
            retrievedElement = (DatabaseColumnElement)databaseColumnList.get(0);
            retrievedColumn = retrievedElement.getDatabaseColumnProperties();
            if (!databaseColumnName.equals(retrievedColumn.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from getColumnsForDatabaseTable)");
            }
            if (!databaseColumnDisplayName.equals(retrievedColumn.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from getColumnsForDatabaseTable)");
            }
            if (!databaseColumnDescription.equals(retrievedColumn.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from getColumnsForDatabaseTable)");
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String createDatabaseColumn(DatabaseManagerClient client, String databaseManagerGUID, String databaseTableGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createDatabaseColumn";
        try {
            DatabaseColumnProperties properties = new DatabaseColumnProperties();
            properties.setQualifiedName(databaseColumnName);
            properties.setDisplayName(databaseColumnDisplayName);
            properties.setDescription(databaseColumnDescription);
            properties.setDataType(databaseColumnType);
            String databaseColumnGUID = client.createDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, properties);
            if (databaseColumnGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createDatabaseColumn(no GUID for columnCreate)");
            }
            this.checkDatabaseColumnOK(client, databaseColumnGUID, databaseTableGUID, "createDatabaseColumn", userId);
            return databaseColumnGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createDatabaseColumn", (Throwable)unexpectedError);
        }
    }
}

