/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DatabaseManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.FilesAndFoldersClient;
import org.odpi.openmetadata.accessservices.datamanager.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseManagerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileManagerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileSystemProperties;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class InvalidParameterTest {
    private static final String testCaseName = "InvalidParameterTest";
    private static final int maxPageSize = 100;
    private static final String externalSourceGUID = "TestExternalSourceGUID";
    private static final String externalSourceName = "TestExternalSourceName";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            InvalidParameterTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        InvalidParameterTest thisTest = new InvalidParameterTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceWiki());
        thisTest.testMetadataSourceClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testDatabaseManagerClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testFilesAndFoldersClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testDataManagerEventClient(serverName, serverPlatformRootURL, userId, auditLog);
    }

    private void testMetadataSourceClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testMetadataSourceClient";
        try {
            DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL, auditLog);
            MetadataSourceClient client = new MetadataSourceClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
            this.testCreateFileSystem(userId, client);
            this.testCreateFileManager(userId, client);
            this.testCreateDatabaseManager(userId, client);
            this.testGetMetadataSourceGUID(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testMetadataSourceClient", (Throwable)unexpectedError);
        }
    }

    private void testCreateFileSystem(String userId, MetadataSourceClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateFileSystem";
        try {
            this.testCreateFileSystemNoUserId(client);
            this.testCreateFileSystemNoProperties(client, userId);
            this.testCreateFileSystemNoQualifiedName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileSystem", (Throwable)unexpectedError);
        }
    }

    private void testCreateFileSystemNoUserId(MetadataSourceClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateFileSystemNoUserId";
        FileSystemProperties fileSystemProperties = new FileSystemProperties();
        try {
            client.createFileSystem(null, externalSourceGUID, externalSourceName, fileSystemProperties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileSystemNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileSystemNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testCreateFileSystemNoProperties(MetadataSourceClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateFileSystemNoProperties";
        try {
            client.createFileSystem(userId, externalSourceGUID, externalSourceName, null);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileSystemNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileSystemNoProperties", (Throwable)unexpectedError);
        }
    }

    private void testCreateFileSystemNoQualifiedName(MetadataSourceClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateFileSystemNoQualifiedName";
        try {
            FileSystemProperties fileSystemProperties = new FileSystemProperties();
            client.createFileSystem(userId, externalSourceGUID, externalSourceName, fileSystemProperties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileSystemNoQualifiedName");
        }
        catch (InvalidParameterException fileSystemProperties) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileSystemNoQualifiedName", (Throwable)unexpectedError);
        }
    }

    private void testCreateFileManager(String userId, MetadataSourceClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateFileSystem";
        try {
            this.testCreateFileManagerNoUserId(client);
            this.testCreateFileManagerNoProperties(client, userId);
            this.testCreateFileManagerNoQualifiedName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileSystem", (Throwable)unexpectedError);
        }
    }

    private void testCreateFileManagerNoUserId(MetadataSourceClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateFileManagerNoUserId";
        FileManagerProperties fileManagerProperties = new FileManagerProperties();
        try {
            client.createFileManager(null, externalSourceGUID, externalSourceName, fileManagerProperties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileManagerNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileManagerNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testCreateFileManagerNoProperties(MetadataSourceClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateFileManagerNoProperties";
        try {
            client.createFileManager(userId, externalSourceGUID, externalSourceName, null);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileManagerNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileManagerNoProperties", (Throwable)unexpectedError);
        }
    }

    private void testCreateFileManagerNoQualifiedName(MetadataSourceClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateFileManagerNoQualifiedName";
        try {
            FileManagerProperties fileManagerProperties = new FileManagerProperties();
            client.createFileManager(userId, externalSourceGUID, externalSourceName, fileManagerProperties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileManagerNoQualifiedName");
        }
        catch (InvalidParameterException fileManagerProperties) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileManagerNoQualifiedName", (Throwable)unexpectedError);
        }
    }

    private void testCreateDatabaseManager(String userId, MetadataSourceClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateDatabaseManager";
        try {
            this.testCreateDatabaseManagerNoUserId(client);
            this.testCreateDatabaseManagerNoProperties(client, userId);
            this.testCreateDatabaseManagerNoQualifiedName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseManager", (Throwable)unexpectedError);
        }
    }

    private void testCreateDatabaseManagerNoUserId(MetadataSourceClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateDatabaseManagerNoUserId";
        DatabaseManagerProperties databaseManagerProperties = new DatabaseManagerProperties();
        try {
            client.createDatabaseManager(null, externalSourceGUID, externalSourceName, databaseManagerProperties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseManagerNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseManagerNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testCreateDatabaseManagerNoProperties(MetadataSourceClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateDatabaseManagerNoProperties";
        try {
            client.createDatabaseManager(userId, externalSourceGUID, externalSourceName, null);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseManagerNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseManagerNoProperties", (Throwable)unexpectedError);
        }
    }

    private void testCreateDatabaseManagerNoQualifiedName(MetadataSourceClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateDatabaseManagerNoQualifiedName";
        try {
            DatabaseManagerProperties databaseManagerProperties = new DatabaseManagerProperties();
            client.createDatabaseManager(userId, externalSourceGUID, externalSourceName, databaseManagerProperties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseManagerNoQualifiedName");
        }
        catch (InvalidParameterException databaseManagerProperties) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseManagerNoQualifiedName", (Throwable)unexpectedError);
        }
    }

    private void testGetMetadataSourceGUID(String userId, MetadataSourceClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateDatabaseManager";
        try {
            this.testGetMetadataSourceGUIDNoUserId(client);
            this.testGetMetadataSourceGUIDNoQualifiedName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseManager", (Throwable)unexpectedError);
        }
    }

    private void testGetMetadataSourceGUIDNoUserId(MetadataSourceClient client) throws FVTUnexpectedCondition {
        String activityName = "testGetMetadataSourceGUIDNoUserId";
        try {
            client.getMetadataSourceGUID(null, "TestQualifiedName");
            throw new FVTUnexpectedCondition(testCaseName, "testGetMetadataSourceGUIDNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetMetadataSourceGUIDNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testGetMetadataSourceGUIDNoQualifiedName(MetadataSourceClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testGetMetadataSourceGUIDNoQualifiedName";
        try {
            client.getMetadataSourceGUID(userId, null);
            throw new FVTUnexpectedCondition(testCaseName, "testGetMetadataSourceGUIDNoQualifiedName");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetMetadataSourceGUIDNoQualifiedName", (Throwable)unexpectedError);
        }
    }

    private void testDatabaseManagerClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testDatabaseManagerClient";
        try {
            DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL, auditLog);
            DatabaseManagerClient client = new DatabaseManagerClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
            this.testCreateDatabase(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testDatabaseManagerClient", (Throwable)unexpectedError);
        }
    }

    private void testCreateDatabase(String userId, DatabaseManagerClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateDatabase";
        try {
            this.testCreateDatabaseNoUserId(client);
            this.testCreateDatabaseNoProperties(client, userId);
            this.testCreateDatabaseNoQualifiedName(client, userId);
            this.testCreateDatabaseNoExternalSourceGUID(client, userId);
            this.testCreateDatabaseNoExternalSourceName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabase", (Throwable)unexpectedError);
        }
    }

    private void testCreateDatabaseNoUserId(DatabaseManagerClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateDatabaseNoUserId";
        DatabaseProperties properties = new DatabaseProperties();
        try {
            client.createDatabase(null, externalSourceGUID, externalSourceName, properties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testCreateDatabaseNoProperties(DatabaseManagerClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateDatabaseNoQualifiedName";
        try {
            client.createDatabase(userId, externalSourceGUID, externalSourceName, null);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseNoQualifiedName");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseNoQualifiedName", (Throwable)unexpectedError);
        }
    }

    private void testCreateDatabaseNoQualifiedName(DatabaseManagerClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateDatabaseNoQualifiedName";
        DatabaseProperties properties = new DatabaseProperties();
        try {
            client.createDatabase(userId, externalSourceGUID, externalSourceName, properties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseNoQualifiedName");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseNoQualifiedName", (Throwable)unexpectedError);
        }
    }

    private void testCreateDatabaseNoExternalSourceGUID(DatabaseManagerClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateDatabaseNoExternalSourceGUID";
        DatabaseProperties properties = new DatabaseProperties();
        try {
            client.createDatabase(userId, null, externalSourceName, properties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseNoExternalSourceGUID");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseNoExternalSourceGUID", (Throwable)unexpectedError);
        }
    }

    private void testCreateDatabaseNoExternalSourceName(DatabaseManagerClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateDatabaseNoExternalSourceName";
        DatabaseProperties properties = new DatabaseProperties();
        try {
            client.createDatabase(userId, externalSourceGUID, null, properties);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseNoExternalSourceName");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateDatabaseNoExternalSourceName", (Throwable)unexpectedError);
        }
    }

    private void testFilesAndFoldersClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testFilesAndFoldersClient";
        try {
            DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL, auditLog);
            FilesAndFoldersClient client = new FilesAndFoldersClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
            this.testCreateNestedFolders(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testFilesAndFoldersClient", (Throwable)unexpectedError);
        }
    }

    private void testCreateNestedFolders(String userId, FilesAndFoldersClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateNestedFolders";
        try {
            this.testCreateNestedFoldersNoUserId(client);
            this.testCreateNestedFoldersNoParentGUID(client, userId);
            this.testCreateNestedFoldersNoPathName(client, userId);
            this.testCreateNestedFoldersNoExternalSourceGUID(client, userId);
            this.testCreateNestedFoldersNoExternalSourceName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateNestedFolders", (Throwable)unexpectedError);
        }
    }

    private void testCreateNestedFoldersNoUserId(FilesAndFoldersClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateNestedFoldersNoUserId";
        String parentGUID = "xxxx";
        String pathName = "top-folder/folder2";
        try {
            client.createNestedFolders(null, externalSourceGUID, externalSourceName, parentGUID, pathName);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateNestedFoldersNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateNestedFoldersNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testCreateNestedFoldersNoParentGUID(FilesAndFoldersClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateNestedFoldersNoPathName";
        String pathName = "top-folder/folder2";
        try {
            client.createNestedFolders(userId, externalSourceGUID, externalSourceName, null, pathName);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateNestedFoldersNoPathName");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateNestedFoldersNoPathName", (Throwable)unexpectedError);
        }
    }

    private void testCreateNestedFoldersNoPathName(FilesAndFoldersClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateNestedFoldersNoPathName";
        String parentGUID = "xxxx";
        try {
            client.createNestedFolders(userId, externalSourceGUID, externalSourceName, parentGUID, null);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateNestedFoldersNoPathName");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateNestedFoldersNoPathName", (Throwable)unexpectedError);
        }
    }

    private void testCreateNestedFoldersNoExternalSourceGUID(FilesAndFoldersClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateNestedFoldersNoExternalSourceGUID";
        String pathName = "top-folder/folder2";
        String parentGUID = "xxxx";
        try {
            client.createNestedFolders(userId, null, externalSourceName, parentGUID, pathName);
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateNestedFoldersNoExternalSourceGUID", (Throwable)unexpectedError);
        }
    }

    private void testCreateNestedFoldersNoExternalSourceName(FilesAndFoldersClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateNestedFoldersNoExternalSourceGUID";
        String pathName = "top-folder/folder2";
        String parentGUID = "xxxx";
        try {
            client.createNestedFolders(userId, externalSourceGUID, null, parentGUID, pathName);
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateNestedFoldersNoExternalSourceGUID", (Throwable)unexpectedError);
        }
    }

    private void testDataManagerEventClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testDataManagerEventClient";
        try {
            DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL, auditLog);
            DataManagerEventClient client = new DataManagerEventClient(serverName, serverPlatformRootURL, (OCFRESTClient)restClient, 100, auditLog, "");
            this.testRegisterListener(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testDataManagerEventClient", (Throwable)unexpectedError);
        }
    }

    private void testRegisterListener(String userId, DataManagerEventClient client) throws FVTUnexpectedCondition {
        String activityName = "testCreateNestedFolders";
        try {
            this.testRegisterListenerNoUserId(client);
            this.testRegisterListenerNoListener(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateNestedFolders", (Throwable)unexpectedError);
        }
    }

    private void testRegisterListenerNoUserId(DataManagerEventClient client) throws FVTUnexpectedCondition {
        String activityName = "testRegisterListenerNoUserId";
        try {
            client.registerListener(null, null);
            throw new FVTUnexpectedCondition(testCaseName, "testRegisterListenerNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testRegisterListenerNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testRegisterListenerNoListener(DataManagerEventClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testRegisterListenerNoListener";
        try {
            client.registerListener(userId, null);
            throw new FVTUnexpectedCondition(testCaseName, "testRegisterListenerNoListener");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testRegisterListenerNoListener", (Throwable)unexpectedError);
        }
    }
}

