/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.fvt.connections;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.client.ConnectionManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseManagerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EndpointProperties;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateConnectionTest {
    private static final String testCaseName = "CreateConnectionTest";
    private static final int maxPageSize = 100;
    private static final String databaseManagerName = "TestConnectionManager";
    private static final String databaseManagerDisplayName = "ConnectionManager displayName";
    private static final String databaseManagerDescription = "ConnectionManager description";
    private static final String databaseManagerTypeDescription = "ConnectionManager type";
    private static final String databaseManagerVersion = "ConnectionManager version";
    private static final String connectionName = "TestConnection";
    private static final String connectionDisplayName = "Connection displayName";
    private static final String connectionDescription = "Connection description";
    private static final String endpointName = "TestEndpoint";
    private static final String endpointDisplayName = "Endpoint displayName";
    private static final String endpointDescription = "Endpoint description";
    private static final String connectorTypeName = "Basic File Store Connector";
    private static final String connectorTypeGUID = "ba213761-f5f5-4cf5-a95f-6150aef09e0b";
    private static final String connectorTypeDescription = "Connector supports reading of Files.";
    private static final String connectorProviderClassName = "org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStoreProvider";
    private static final String assetTypeName = "DataFile";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateConnectionTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateConnectionTest thisTest = new CreateConnectionTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceWiki());
        ConnectionManagerClient client = thisTest.getConnectionClient(serverName, serverPlatformRootURL, auditLog);
        String databaseManagerGUID = thisTest.getDatabaseManager(serverName, serverPlatformRootURL, userId);
        String connectionGUID = thisTest.getConnection(client, databaseManagerGUID, userId);
        String endpointGUID = thisTest.createEndpoint(client, databaseManagerGUID, connectionGUID, userId);
        thisTest.addConnectorType(client, databaseManagerGUID, connectionGUID, userId);
        String activityName = "deleteOneByOne";
        try {
            client.removeConnection(userId, databaseManagerGUID, databaseManagerName, connectionGUID);
            activityName = "deleteOneByOne - connection gone";
            thisTest.checkConnectionGone(client, connectionGUID, activityName, userId);
            thisTest.checkConnectorTypeOK(client, null, activityName, userId);
            thisTest.checkEndpointOK(client, endpointGUID, null, activityName, userId);
            client.removeEndpoint(userId, databaseManagerGUID, databaseManagerName, endpointGUID);
            activityName = "deleteOneByOne - endpoint gone";
            thisTest.checkConnectorTypeOK(client, null, activityName, userId);
            thisTest.checkEndpointGone(client, endpointGUID, null, activityName, userId);
            thisTest.checkConnectionGone(client, connectionGUID, activityName, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private ConnectionManagerClient getConnectionClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getConnectionManagerClient";
        try {
            DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL);
            return new ConnectionManagerClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getConnectionManagerClient", (Throwable)unexpectedError);
        }
    }

    private String getDatabaseManager(String serverName, String serverPlatformRootURL, String userId) throws FVTUnexpectedCondition {
        String activityName = "getDatabaseManager";
        try {
            DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL);
            MetadataSourceClient client = new MetadataSourceClient(serverName, serverPlatformRootURL, restClient, 100);
            DatabaseManagerProperties properties = new DatabaseManagerProperties();
            properties.setQualifiedName(databaseManagerName);
            properties.setDisplayName(databaseManagerDisplayName);
            properties.setDescription(databaseManagerDescription);
            properties.setTypeDescription(databaseManagerTypeDescription);
            properties.setVersion(databaseManagerVersion);
            String databaseManagerGUID = client.createDatabaseManager(userId, null, null, properties);
            if (databaseManagerGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManager(no GUID for Create)");
            }
            String retrievedDatabaseManagerGUID = client.getMetadataSourceGUID(userId, databaseManagerName);
            if (retrievedDatabaseManagerGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManager(no GUID for Retrieve)");
            }
            if (!retrievedDatabaseManagerGUID.equals(databaseManagerGUID)) {
                throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManager(Inconsistent GUIDs)");
            }
            return databaseManagerGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDatabaseManager", (Throwable)unexpectedError);
        }
    }

    private void checkConnectionGone(ConnectionManagerClient client, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            ConnectionElement retrievedElement = client.getConnectionByGUID(userId, connectionGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Connection returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Retrieve returned)");
        }
        catch (InvalidParameterException retrievedElement) {
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void checkConnectionOK(ConnectionManagerClient client, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            ConnectionElement retrievedElement = client.getConnectionByGUID(userId, connectionGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectionElement from Retrieve)");
            }
            ConnectionProperties retrievedConnection = retrievedElement.getConnectionProperties();
            if (retrievedConnection == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectionProperties from Retrieve)");
            }
            if (!connectionName.equals(retrievedConnection.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve) =>>" + retrievedConnection);
            }
            if (!connectionDisplayName.equals(retrievedConnection.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve) =>>" + retrievedConnection);
            }
            if (!connectionDescription.equals(retrievedConnection.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve) =>>" + retrievedConnection);
            }
            List connectionList = client.getConnectionsByName(userId, connectionName, 0, 100);
            if (connectionList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Connection for RetrieveByName)");
            }
            if (connectionList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Connection list for RetrieveByName)");
            }
            if (connectionList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Connection list for RetrieveByName contains" + connectionList.size() + " elements) =>>" + connectionList);
            }
            retrievedElement = (ConnectionElement)connectionList.get(0);
            retrievedConnection = retrievedElement.getConnectionProperties();
            if (!connectionName.equals(retrievedConnection.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName) =>>" + retrievedConnection);
            }
            if (!connectionDisplayName.equals(retrievedConnection.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName) =>>" + retrievedConnection);
            }
            if (!connectionDescription.equals(retrievedConnection.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName) =>>" + retrievedConnection);
            }
            connectionList = client.getConnectionsByName(userId, connectionName, 1, 100);
            if (connectionList != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "Connection for RetrieveByName (from 1) =>>" + retrievedConnection);
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getConnection(ConnectionManagerClient client, String databaseManagerGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getConnection";
        try {
            ConnectionProperties properties = new ConnectionProperties();
            properties.setQualifiedName(connectionName);
            properties.setDisplayName(connectionDisplayName);
            properties.setDescription(connectionDescription);
            String connectionGUID = client.createConnection(userId, databaseManagerGUID, databaseManagerName, properties);
            if (connectionGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getConnection(no GUID for Create)");
            }
            this.checkConnectionOK(client, connectionGUID, "getConnection", userId);
            return connectionGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getConnection", (Throwable)unexpectedError);
        }
    }

    private void checkEndpointGone(ConnectionManagerClient client, String endpointGUID, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            EndpointElement retrievedElement = client.getEndpointByGUID(userId, endpointGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Endpoint returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getEndpointByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (connectionGUID != null) {
            try {
                ConnectionElement connection = client.getConnectionByGUID(userId, connectionGUID);
                ElementStub endpoint = connection.getEndpoint();
                if (endpoint != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Endpoint " + endpoint + " returned for connection)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void checkEndpointOK(ConnectionManagerClient client, String endpointGUID, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        block20: {
            try {
                EndpointElement retrievedElement = client.getEndpointByGUID(userId, endpointGUID);
                if (retrievedElement == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no EndpointElement from Retrieve)");
                }
                EndpointProperties retrievedEndpoint = retrievedElement.getEndpointProperties();
                if (retrievedEndpoint == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no EndpointProperties from Retrieve)");
                }
                if (!endpointName.equals(retrievedEndpoint.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve) =>>" + retrievedEndpoint);
                }
                if (!endpointDisplayName.equals(retrievedEndpoint.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve) =>>" + retrievedEndpoint);
                }
                if (!endpointDescription.equals(retrievedEndpoint.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve) =>>" + retrievedEndpoint);
                }
                List endpointList = client.getEndpointsByName(userId, endpointName, 0, 100);
                if (endpointList == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Endpoint for RetrieveByName)");
                }
                if (endpointList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Endpoint list for RetrieveByName)");
                }
                if (endpointList.size() != 1) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Endpoint list for RetrieveByName contains" + endpointList.size() + " elements)");
                }
                retrievedElement = (EndpointElement)endpointList.get(0);
                retrievedEndpoint = retrievedElement.getEndpointProperties();
                if (!endpointName.equals(retrievedEndpoint.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName) =>>" + retrievedEndpoint);
                }
                if (!endpointDisplayName.equals(retrievedEndpoint.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName) =>>" + retrievedEndpoint);
                }
                if (!endpointDescription.equals(retrievedEndpoint.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName) =>>" + retrievedEndpoint);
                }
                if (connectionGUID == null) break block20;
                try {
                    ConnectionElement connection = client.getConnectionByGUID(userId, connectionGUID);
                    ElementStub endpoint = connection.getEndpoint();
                    if (endpoint == null) {
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(No Endpoint returned for connection)");
                    }
                    if (!endpointGUID.equals(endpoint.getGUID())) {
                        System.out.println("ConnectionGUID: " + connectionGUID);
                        System.out.println("EndpointGUID: " + endpointGUID);
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong Endpoint returned for connection: " + endpoint.getGUID() + "rather than " + endpointGUID + ")");
                    }
                    if (!endpointName.equals(endpoint.getUniqueName())) {
                        System.out.println("ConnectionGUID: " + connectionGUID);
                        System.out.println("Endpoint: " + endpoint);
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong Endpoint Qualified Name returned for connection: " + endpoint.getUniqueName() + "rather than TestEndpoint)");
                    }
                }
                catch (FVTUnexpectedCondition testCaseError) {
                    throw testCaseError;
                }
                catch (Exception unexpectedError) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private String createEndpoint(ConnectionManagerClient client, String databaseManagerGUID, String connectionGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createEndpoint";
        try {
            EndpointProperties properties = new EndpointProperties();
            properties.setQualifiedName(endpointName);
            properties.setDisplayName(endpointDisplayName);
            properties.setDescription(endpointDescription);
            String endpointGUID = client.createEndpoint(userId, databaseManagerGUID, databaseManagerName, properties);
            if (endpointGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createEndpoint(no GUID for endpointCreate)");
            }
            client.setupEndpoint(userId, databaseManagerGUID, databaseManagerName, connectionGUID, endpointGUID);
            this.checkEndpointOK(client, endpointGUID, connectionGUID, "createEndpoint", userId);
            return endpointGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createEndpoint", (Throwable)unexpectedError);
        }
    }

    private void checkConnectorTypeOK(ConnectionManagerClient client, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        block22: {
            try {
                ConnectorTypeElement retrievedElement = client.getConnectorTypeByGUID(userId, connectorTypeGUID);
                if (retrievedElement == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectorTypeElement from Retrieve)");
                }
                ConnectorTypeProperties retrievedConnectorType = retrievedElement.getConnectorTypeProperties();
                if (retrievedConnectorType == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectorTypeProperties from Retrieve)");
                }
                if (!connectorTypeName.equals(retrievedConnectorType.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve) =>>" + retrievedConnectorType);
                }
                if (!connectorTypeName.equals(retrievedConnectorType.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve) =>>" + retrievedConnectorType);
                }
                if (!connectorTypeDescription.equals(retrievedConnectorType.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve) =>>" + retrievedConnectorType);
                }
                if (!assetTypeName.equals(retrievedConnectorType.getSupportedAssetTypeName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad assetTypeName from Retrieve) =>>" + retrievedConnectorType);
                }
                if (!connectorProviderClassName.equals(retrievedConnectorType.getConnectorProviderClassName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad connectorProviderClassName from Retrieve) =>>" + retrievedConnectorType);
                }
                List connectorTypeList = client.getConnectorTypesByName(userId, connectorTypeName, 0, 100);
                if (connectorTypeList == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectorType for RetrieveByName)");
                }
                if (connectorTypeList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty ConnectorType list for RetrieveByName)");
                }
                if (connectorTypeList.size() != 1) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(ConnectorType list for RetrieveByName contains" + connectorTypeList.size() + " elements)");
                }
                retrievedElement = (ConnectorTypeElement)connectorTypeList.get(0);
                retrievedConnectorType = retrievedElement.getConnectorTypeProperties();
                if (!connectorTypeName.equals(retrievedConnectorType.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName) =>>" + retrievedConnectorType);
                }
                if (!connectorTypeName.equals(retrievedConnectorType.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName) =>>" + retrievedConnectorType);
                }
                if (!connectorTypeDescription.equals(retrievedConnectorType.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName) =>>" + retrievedConnectorType);
                }
                if (connectionGUID == null) break block22;
                try {
                    ConnectionElement connection = client.getConnectionByGUID(userId, connectionGUID);
                    ElementStub connectorType = connection.getConnectorType();
                    if (connectorType == null) {
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(No connectorType returned for connection: " + connection + ")");
                    }
                    if (!connectorTypeGUID.equals(connectorType.getGUID())) {
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong connector type returned for connection: " + connectorType.getGUID() + "rather than ba213761-f5f5-4cf5-a95f-6150aef09e0b)");
                    }
                    if (!connectorTypeName.equals(connectorType.getUniqueName())) {
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong connector type Qualified Name returned for connection: " + connectorType.getUniqueName() + "rather than TestEndpoint)");
                    }
                }
                catch (FVTUnexpectedCondition testCaseError) {
                    throw testCaseError;
                }
                catch (Exception unexpectedError) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void addConnectorType(ConnectionManagerClient client, String databaseManagerGUID, String connectionGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createConnectorType";
        try {
            if (connectionGUID != null) {
                client.setupConnectorType(userId, databaseManagerGUID, databaseManagerName, connectionGUID, connectorTypeGUID);
            }
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createConnectorType", (Throwable)unexpectedError);
        }
    }
}

