/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.fvt.validvalues;

import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.client.ValidValueManagement;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ValidValueMembershipProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ValidValueProperties;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateValidValuesSetTest {
    private static final String testCaseName = "CreateValidValuesSetTest";
    private static final int maxPageSize = 100;
    private static final String validValuesSetName = "TestValidValuesSet";
    private static final String validValuesSetDisplayName = "TestValidValuesSet displayName";
    private static final String validValuesSetDescription = "TestValidValuesSet description";
    private static final String validValuesSetUsage = "TestValidValuesSet usage";
    private static final String validValuesSetScope = "TestValidValuesSet scope";
    private static final String validValue1Name = "TestValidValue1";
    private static final String validValue1DisplayName = "TestValidValue1 displayName";
    private static final String validValue1Description = "TestValidValue1 description";
    private static final String validValue1Usage = "TestValidValue1 usage";
    private static final String validValue1Scope = "TestValidValue1 scope";
    private static final String validValue1PreferredValue = "TestValidValue1 preferredValue";
    private static final String validValue1AdditionalPropertyName = "TestValidValue1 additionalPropertyName";
    private static final String validValue1AdditionalPropertyValue = "TestValidValue1 additionalPropertyValue";
    private static final String validValue2Name = "TestValidValue2";
    private static final String validValue2DisplayName = "TestValidValue2 displayName";
    private static final String validValue2Description = "TestValidValue2 description";
    private static final String validValue2Usage = "TestValidValue2 usage";
    private static final String validValue2Scope = "TestValidValue2 scope";
    private static final String validValue2PreferredValue = "TestValidValue2 preferredValue";
    private static final String validValue2NameUpdate = "TestValidValue2 - updated";
    private static final String searchString = ".*Test.*";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateValidValuesSetTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateValidValuesSetTest thisTest = new CreateValidValuesSetTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceCode(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceName(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceDescription(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceWiki());
        ValidValueManagement client = thisTest.getValidValuesManagerClient(serverName, serverPlatformRootURL, auditLog);
        String validValuesSet = thisTest.createValidValueSet(client, userId);
        thisTest.createValidValueDefinitions(client, validValuesSet, userId);
        thisTest.deleteValidValuesSet(client, validValuesSet, userId);
    }

    private ValidValueManagement getValidValuesManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getValidValuesManagerClient";
        try {
            DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL, auditLog);
            return new ValidValueManagement(serverName, serverPlatformRootURL, restClient, 100);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getValidValuesManagerClient", (Throwable)unexpectedError);
        }
    }

    private String createValidValueSet(ValidValueManagement client, String userId) throws FVTUnexpectedCondition {
        String activityName = "createValidValueSet";
        try {
            ValidValueProperties validValueProperties = new ValidValueProperties();
            validValueProperties.setTypeName("ValidValuesSet");
            validValueProperties.setQualifiedName(validValuesSetName);
            validValueProperties.setDisplayName(validValuesSetDisplayName);
            validValueProperties.setDescription(validValuesSetDescription);
            validValueProperties.setUsage(validValuesSetUsage);
            validValueProperties.setScope(validValuesSetScope);
            String validValuesSetGUID = client.createValidValue(userId, null, null, validValueProperties);
            if (validValuesSetGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(no GUID for Create)");
            }
            ValidValueElement retrievedElement = client.getValidValueByGUID(userId, validValuesSetGUID);
            ValidValueProperties retrievedSet = retrievedElement.getValidValueProperties();
            if (retrievedSet == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(no Valid Values Set from Retrieve)");
            }
            if (!validValuesSetName.equals(retrievedSet.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Bad qualifiedName from Retrieve)");
            }
            if (!validValuesSetDisplayName.equals(retrievedSet.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Bad displayName from Retrieve)");
            }
            if (!validValuesSetDescription.equals(retrievedSet.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Bad description from Retrieve)");
            }
            if (!validValuesSetUsage.equals(retrievedSet.getUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Bad usage from Retrieve)");
            }
            if (!validValuesSetScope.equals(retrievedSet.getScope())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Bad scope from Retrieve)");
            }
            if (retrievedSet.getPreferredValue() != null) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Bad preferredValue from Retrieve)");
            }
            List validValueList = client.getValidValuesByName(userId, validValuesSetName, 0, 100);
            if (validValueList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(no valid value for RetrieveByName)");
            }
            if (validValueList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Empty valid value list for RetrieveByName)");
            }
            if (validValueList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Valid value list for RetrieveByName contains" + validValueList.size() + " elements)");
            }
            retrievedElement = (ValidValueElement)validValueList.get(0);
            retrievedSet = retrievedElement.getValidValueProperties();
            if (!validValuesSetName.equals(retrievedSet.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Bad qualifiedName from RetrieveByName)");
            }
            if (!validValuesSetDisplayName.equals(retrievedSet.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Bad displayName from RetrieveByName)");
            }
            if (!validValuesSetDescription.equals(retrievedSet.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Bad description from RetrieveByName)");
            }
            if (!validValuesSetUsage.equals(retrievedSet.getUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Bad usage from RetrieveByName)");
            }
            if (!validValuesSetScope.equals(retrievedSet.getScope())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Bad scope from RetrieveByName)");
            }
            if (retrievedSet.getPreferredValue() != null) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet(Bad preferredValue from RetrieveByName)");
            }
            return validValuesSetGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createValidValueSet", (Throwable)unexpectedError);
        }
    }

    private void createValidValueDefinitions(ValidValueManagement client, String validValueSetGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createValidValueDefinitions";
        try {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            additionalProperties.put(validValue1AdditionalPropertyName, validValue1AdditionalPropertyValue);
            ValidValueProperties validValueProperties = new ValidValueProperties();
            validValueProperties.setTypeName("ValidValuesSet");
            validValueProperties.setQualifiedName(validValue1Name);
            validValueProperties.setDisplayName(validValue1DisplayName);
            validValueProperties.setDescription(validValue1Description);
            validValueProperties.setUsage(validValue1Usage);
            validValueProperties.setScope(validValue1Scope);
            validValueProperties.setPreferredValue(validValue1PreferredValue);
            validValueProperties.setAdditionalProperties(additionalProperties);
            String validValue1GUID = client.createValidValue(userId, null, null, validValueProperties);
            if (validValue1GUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no GUID for Create of definition 1)");
            }
            client.setupValidValueMember(userId, null, null, validValueSetGUID, null, validValue1GUID);
            ValidValueElement retrievedElement = client.getValidValueByGUID(userId, validValue1GUID);
            ValidValueProperties retrievedDefinition = retrievedElement.getValidValueProperties();
            if (retrievedDefinition == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no Valid Values definition 1 from Retrieve)");
            }
            if (!validValue1Name.equals(retrievedDefinition.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad qualifiedName from Retrieve of 1)");
            }
            if (!validValue1DisplayName.equals(retrievedDefinition.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad displayName from Retrieve of 1)");
            }
            if (!validValue1Description.equals(retrievedDefinition.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad description from Retrieve of 1)");
            }
            if (!validValue1Usage.equals(retrievedDefinition.getUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad usage from Retrieve of 1)");
            }
            if (!validValue1Scope.equals(retrievedDefinition.getScope())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad scope from Retrieve of 1)");
            }
            if (!validValue1PreferredValue.equals(retrievedDefinition.getPreferredValue())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad preferredValue from Retrieve of 1)");
            }
            if (retrievedDefinition.getAdditionalProperties() == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(null additionalProperties from Retrieve of 1)");
            }
            if (!validValue1AdditionalPropertyValue.equals(retrievedDefinition.getAdditionalProperties().get(validValue1AdditionalPropertyName))) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(bad additionalProperties from Retrieve of 1)");
            }
            List validValueList = client.getValidValuesByName(userId, validValue1Name, 0, 100);
            if (validValueList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no valid value for RetrieveByName of 1)");
            }
            if (validValueList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Empty valid value list for RetrieveByName of 1)");
            }
            if (validValueList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Valid value list for RetrieveByName of 1 contains" + validValueList.size() + " elements)");
            }
            retrievedElement = (ValidValueElement)validValueList.get(0);
            retrievedDefinition = retrievedElement.getValidValueProperties();
            if (retrievedDefinition == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no Valid Values definition 1 from Retrieve)");
            }
            if (!validValue1Name.equals(retrievedDefinition.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad qualifiedName from RetrieveByName of 1)");
            }
            if (!validValue1DisplayName.equals(retrievedDefinition.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad displayName from RetrieveByName of 1)");
            }
            if (!validValue1Description.equals(retrievedDefinition.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad description from RetrieveByName of 1)");
            }
            if (!validValue1Usage.equals(retrievedDefinition.getUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad usage from RetrieveByName of 1)");
            }
            if (!validValue1Scope.equals(retrievedDefinition.getScope())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad scope from RetrieveByName of 1)");
            }
            if (!validValue1PreferredValue.equals(retrievedDefinition.getPreferredValue())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad preferredValue from RetrieveByName of 1)");
            }
            validValueList = client.findValidValues(userId, searchString, 0, 100);
            if (validValueList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no valid value for findValidValues of 1)");
            }
            if (validValueList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Empty valid value list for findValidValues of 1)");
            }
            if (validValueList.size() != 2) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Valid value list for findValidValues of 1 contains" + validValueList.size() + " elements)");
            }
            validValueList = client.getValidValueSetMembers(userId, validValueSetGUID, 0, 100);
            if (validValueList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no valid value for RetrieveSetMembers of 1)");
            }
            if (validValueList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Empty valid value list for RetrieveSetMembers of 1)");
            }
            if (validValueList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Valid value list for RetrieveSetMembers of 1 contains" + validValueList.size() + " elements)");
            }
            retrievedElement = (ValidValueElement)validValueList.get(0);
            retrievedDefinition = retrievedElement.getValidValueProperties();
            if (retrievedDefinition == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no Valid Values definition 1 from RetrieveOfMembers)");
            }
            if (!validValue1Name.equals(retrievedDefinition.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad qualifiedName from RetrieveOfMembers of 1)");
            }
            if (!validValue1DisplayName.equals(retrievedDefinition.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad displayName from RetrieveOfMembers of 1)");
            }
            if (!validValue1Description.equals(retrievedDefinition.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad description from RetrieveOfMembers of 1)");
            }
            if (!validValue1Usage.equals(retrievedDefinition.getUsage())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad usage from RetrieveOfMembers of 1)");
            }
            if (!validValue1Scope.equals(retrievedDefinition.getScope())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad scope from RetrieveOfMembers of 1)");
            }
            if (!validValue1PreferredValue.equals(retrievedDefinition.getPreferredValue())) {
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad preferredValue from RetrieveOfMembers of 1)");
            }
            try {
                client.createValidValue(userId, null, null, validValueProperties);
                throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(duplicate create of valid value definition allowed)");
            }
            catch (InvalidParameterException invalidParameterException) {
                ValidValueProperties validValueProperties2 = new ValidValueProperties();
                validValueProperties2.setTypeName("ValidValuesSet");
                validValueProperties2.setQualifiedName(validValue2Name);
                validValueProperties2.setDisplayName(validValue2DisplayName);
                validValueProperties2.setDescription(validValue2Description);
                validValueProperties2.setUsage(validValue2Usage);
                validValueProperties2.setScope(validValue2Scope);
                validValueProperties2.setAdditionalProperties(additionalProperties);
                String validValue2GUID = client.createValidValue(userId, null, null, validValueProperties2);
                if (validValue2GUID == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no GUID for Create of definition 2)");
                }
                client.setupValidValueMember(userId, null, null, validValueSetGUID, null, validValue2GUID);
                retrievedElement = client.getValidValueByGUID(userId, validValue2GUID);
                retrievedDefinition = retrievedElement.getValidValueProperties();
                if (retrievedDefinition == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no Valid Values definition 2 from Retrieve)");
                }
                if (!validValue2Name.equals(retrievedDefinition.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad qualifiedName from Retrieve of 2)");
                }
                if (!validValue2DisplayName.equals(retrievedDefinition.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad displayName from Retrieve of 2)");
                }
                if (!validValue2Description.equals(retrievedDefinition.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad description from Retrieve of 2)");
                }
                if (!validValue2Usage.equals(retrievedDefinition.getUsage())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad usage from Retrieve of 2)");
                }
                if (!validValue2Scope.equals(retrievedDefinition.getScope())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad scope from Retrieve of 2)");
                }
                if (retrievedDefinition.getPreferredValue() != null) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad preferredValue from Retrieve of 2)");
                }
                if (retrievedDefinition.getIsDeprecated()) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad isDeprecated from Retrieve of 2)");
                }
                validValueList = client.getValidValuesByName(userId, validValue2Name, 0, 100);
                if (validValueList == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no valid value for RetrieveByName of 2)");
                }
                if (validValueList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Empty valid value list for RetrieveByName of 2)");
                }
                if (validValueList.size() != 1) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Valid value list for RetrieveByName of 2 contains" + validValueList.size() + " elements)");
                }
                retrievedElement = (ValidValueElement)validValueList.get(0);
                retrievedDefinition = retrievedElement.getValidValueProperties();
                if (!validValue2Name.equals(retrievedDefinition.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad qualifiedName from RetrieveByName of 2)");
                }
                if (!validValue2DisplayName.equals(retrievedDefinition.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad displayName from RetrieveByName of 2)");
                }
                if (!validValue2Description.equals(retrievedDefinition.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad description from RetrieveByName of 2)");
                }
                if (!validValue2Usage.equals(retrievedDefinition.getUsage())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad usage from RetrieveByName of 2)");
                }
                if (!validValue2Scope.equals(retrievedDefinition.getScope())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad scope from RetrieveByName of 2)");
                }
                if (retrievedDefinition.getPreferredValue() != null) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad preferredValue from RetrieveByName of 2)");
                }
                if (retrievedDefinition.getIsDeprecated()) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad isDeprecated from RetrieveByName of 2)");
                }
                validValueList = client.findValidValues(userId, searchString, 0, 100);
                if (validValueList == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no valid value for findValidValues of all)");
                }
                if (validValueList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Empty valid value list for findValidValues of all)");
                }
                if (validValueList.size() != 3) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Valid value list for findValidValues of all contains" + validValueList.size() + " elements)");
                }
                validValueList = client.getValidValueSetMembers(userId, validValueSetGUID, 0, 100);
                if (validValueList == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no valid value for RetrieveSetMembers of both)");
                }
                if (validValueList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Empty valid value list for RetrieveSetMembers of both)");
                }
                if (validValueList.size() != 2) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Valid value list for RetrieveSetMembers of both contains" + validValueList.size() + " elements)");
                }
                ValidValueProperties validValueProperties3 = new ValidValueProperties();
                validValueProperties3.setPreferredValue(validValue2PreferredValue);
                validValueProperties3.setIsDeprecated(true);
                client.updateValidValue(userId, null, null, validValue2GUID, true, validValueProperties3);
                retrievedElement = client.getValidValueByGUID(userId, validValue2GUID);
                retrievedDefinition = retrievedElement.getValidValueProperties();
                if (!validValue2Name.equals(retrievedDefinition.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad qualifiedName from RetrieveUpdate of 2)");
                }
                if (!validValue2DisplayName.equals(retrievedDefinition.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad displayName from RetrieveUpdate of 2)");
                }
                if (!validValue2Description.equals(retrievedDefinition.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad description from RetrieveUpdate of 2)");
                }
                if (!validValue2Usage.equals(retrievedDefinition.getUsage())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad usage from RetrieveUpdate of 2)");
                }
                if (!validValue2Scope.equals(retrievedDefinition.getScope())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad scope from RetrieveUpdate of 2)");
                }
                if (!validValue2PreferredValue.equals(retrievedDefinition.getPreferredValue())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad preferredValue from RetrieveUpdate of 2)");
                }
                if (!retrievedDefinition.getIsDeprecated()) {
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad isDeprecated from RetrieveUpdate of 2)");
                }
                try {
                    ValidValueProperties validValueProperties4 = new ValidValueProperties();
                    validValueProperties4.setQualifiedName(validValue1Name);
                    client.updateValidValue(userId, null, null, validValue2GUID, true, validValueProperties4);
                    throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Duplicate update allowed)");
                }
                catch (InvalidParameterException validValueProperties4) {
                    retrievedElement = client.getValidValueByGUID(userId, validValue2GUID);
                    retrievedDefinition = retrievedElement.getValidValueProperties();
                    if (!validValue2Name.equals(retrievedDefinition.getQualifiedName())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad qualifiedName from RetrieveUpdate of 2 after qualified name failed change)");
                    }
                    if (!validValue2DisplayName.equals(retrievedDefinition.getDisplayName())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad displayName from RetrieveUpdate of 2 after qualified name failed change)");
                    }
                    if (!validValue2Description.equals(retrievedDefinition.getDescription())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad description from RetrieveUpdate of 2 after qualified name failed change)");
                    }
                    if (!validValue2Usage.equals(retrievedDefinition.getUsage())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad usage from RetrieveUpdate of 2 after qualified name failed change)");
                    }
                    if (!validValue2Scope.equals(retrievedDefinition.getScope())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad scope from RetrieveUpdate of 2 after qualified name failed change)");
                    }
                    if (!validValue2PreferredValue.equals(retrievedDefinition.getPreferredValue())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad preferredValue from RetrieveUpdate of 2)");
                    }
                    if (!retrievedDefinition.getIsDeprecated()) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad isDeprecated from RetrieveUpdate of 2)");
                    }
                    validValueProperties2.setQualifiedName(validValue2NameUpdate);
                    validValueProperties2.setPreferredValue(validValue2PreferredValue);
                    validValueProperties2.setIsDeprecated(true);
                    client.updateValidValue(userId, null, null, validValue2GUID, false, validValueProperties2);
                    retrievedElement = client.getValidValueByGUID(userId, validValue2GUID);
                    retrievedDefinition = retrievedElement.getValidValueProperties();
                    if (!validValue2NameUpdate.equals(retrievedDefinition.getQualifiedName())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad qualifiedName from RetrieveUpdate of 2 after qualified name change)");
                    }
                    if (!validValue2DisplayName.equals(retrievedDefinition.getDisplayName())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad displayName from RetrieveUpdate of 2 after qualified name change)");
                    }
                    if (!validValue2Description.equals(retrievedDefinition.getDescription())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad description from RetrieveUpdate of 2 after qualified name change)");
                    }
                    if (!validValue2Usage.equals(retrievedDefinition.getUsage())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad usage from RetrieveUpdate of 2 after qualified name change)");
                    }
                    if (!validValue2Scope.equals(retrievedDefinition.getScope())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad scope from RetrieveUpdate of 2 after qualified name change)");
                    }
                    if (!validValue2PreferredValue.equals(retrievedDefinition.getPreferredValue())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad preferredValue from RetrieveUpdate of 2 after qualified name change)");
                    }
                    if (!retrievedDefinition.getIsDeprecated()) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad isDeprecated from RetrieveUpdate of 2 after qualified name change)");
                    }
                    client.clearValidValueMember(userId, null, null, validValueSetGUID, validValue2GUID);
                    validValueList = client.getValidValueSetMembers(userId, validValueSetGUID, 0, 100);
                    if (validValueList == null) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no valid value for RetrieveSetMembers of 1 after detach)");
                    }
                    if (validValueList.isEmpty()) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Empty valid value list for RetrieveSetMembers of 1 after detach)");
                    }
                    if (validValueList.size() != 1) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Valid value list for RetrieveSetMembers after detach of 1 contains" + validValueList.size() + " elements)");
                    }
                    retrievedElement = (ValidValueElement)validValueList.get(0);
                    retrievedDefinition = retrievedElement.getValidValueProperties();
                    if (retrievedDefinition == null) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no Valid Values definition 1 from RetrieveOfMembers of 1 after detach)");
                    }
                    if (!validValue1Name.equals(retrievedDefinition.getQualifiedName())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad qualifiedName from RetrieveOfMembers of 1 after detach)");
                    }
                    if (!validValue1DisplayName.equals(retrievedDefinition.getDisplayName())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad displayName from RetrieveOfMembers of 1 after detach)");
                    }
                    if (!validValue1Description.equals(retrievedDefinition.getDescription())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad description from RetrieveOfMembers of 1 after detach)");
                    }
                    if (!validValue1Usage.equals(retrievedDefinition.getUsage())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad usage from RetrieveOfMembers of 1 after detach)");
                    }
                    if (!validValue1Scope.equals(retrievedDefinition.getScope())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad scope from RetrieveOfMembers of 1 after detach)");
                    }
                    if (!validValue1PreferredValue.equals(retrievedDefinition.getPreferredValue())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Bad preferredValue from RetrieveOfMembers of 1 after detach)");
                    }
                    ValidValueMembershipProperties membershipProperties = new ValidValueMembershipProperties();
                    membershipProperties.setDefaultValue(false);
                    client.setupValidValueMember(userId, null, null, validValueSetGUID, null, validValue2GUID);
                    validValueList = client.getValidValueSetMembers(userId, validValueSetGUID, 0, 100);
                    if (validValueList == null) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(no valid value for RetrieveSetMembers of both after reattach)");
                    }
                    if (validValueList.isEmpty()) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Empty valid value list for RetrieveSetMembers of of both after reattach)");
                    }
                    if (validValueList.size() != 2) {
                        throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions(Valid value list for RetrieveSetMembers of both after reattach contains" + validValueList.size() + " elements)");
                    }
                }
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createValidValueDefinitions", (Throwable)unexpectedError);
        }
    }

    private void deleteValidValuesSet(ValidValueManagement client, String validValueSetGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "deleteValidValuesSet";
        try {
            client.removeValidValue(userId, null, null, validValueSetGUID);
            try {
                client.getValidValueByGUID(userId, validValueSetGUID);
                throw new FVTUnexpectedCondition(testCaseName, "deleteValidValuesSet(Deleted value value set returned)");
            }
            catch (InvalidParameterException invalidParameterException) {
                List searchResults = client.findValidValues(userId, searchString, 0, 100);
                if (searchResults == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "deleteValidValuesSet(cascaded delete occurred)");
                }
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "deleteValidValuesSet", (Throwable)unexpectedError);
        }
    }
}

