/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.fvt;

import java.io.IOException;
import org.odpi.openmetadata.accessservices.datamanager.fvt.clientconstructors.ClientConstructorTest;
import org.odpi.openmetadata.accessservices.datamanager.fvt.connections.CreateConnectionTest;
import org.odpi.openmetadata.accessservices.datamanager.fvt.databases.CreateDatabaseTest;
import org.odpi.openmetadata.accessservices.datamanager.fvt.errorhandling.InvalidParameterTest;
import org.odpi.openmetadata.accessservices.datamanager.fvt.events.CreateEventsTest;
import org.odpi.openmetadata.accessservices.datamanager.fvt.validvalues.CreateValidValuesSetTest;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.FVTSuiteBase;
import org.odpi.openmetadata.http.HttpHelper;

public class DataManagerOMASFVTSuite
extends FVTSuiteBase {
    public static void main(String[] args) {
        int exitCode;
        try {
            String url = DataManagerOMASFVTSuite.getUrl((String[])args);
            String serverName = DataManagerOMASFVTSuite.getServerName((String[])args);
            String userId = DataManagerOMASFVTSuite.getUserId((String[])args);
            DataManagerOMASFVTSuite fvtSuite = new DataManagerOMASFVTSuite();
            exitCode = fvtSuite.performFVT(serverName, url, userId);
        }
        catch (IOException error) {
            System.out.println("Error getting user input");
            error.printStackTrace();
            exitCode = -99;
        }
        System.exit(exitCode);
    }

    public int performFVT(String serverName, String serverPlatformRootURL, String userId) {
        HttpHelper.noStrictSSL();
        int returnCode = 0;
        FVTResults results = CreateValidValuesSetTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = ClientConstructorTest.performFVT(serverName, serverPlatformRootURL);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = InvalidParameterTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = CreateDatabaseTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = CreateEventsTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = CreateConnectionTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        return returnCode;
    }
}

