/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.fvt.events;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.client.EventBrokerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.EventTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.TopicElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.topics.TopicProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaAttributeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.events.EventTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.EventBrokerProperties;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateEventsTest {
    private static final String testCaseName = "CreateEventsTest";
    private static final int maxPageSize = 100;
    private static final String eventBrokerName = "TestEventBroker";
    private static final String eventBrokerDisplayName = "eventBroker displayName";
    private static final String eventBrokerDescription = "eventBroker description";
    private static final String eventBrokerTypeDescription = "eventBroker type";
    private static final String eventBrokerVersion = "eventBroker version";
    private static final String topicName = "TestTopic";
    private static final String topicDisplayName = "Topic displayName";
    private static final String topicDescription = "Topic description";
    private static final String topicType = "Topic type";
    private static final String topicVersion = "Topic version";
    private static final String eventTypeName = "TestEventType";
    private static final String eventTypeDisplayName = "EventType displayName";
    private static final String eventTypeDescription = "EventType description";
    private static final String schemaAttributeName = "TestSchemaAttribute";
    private static final String schemaAttributeDisplayName = "SchemaAttribute displayName";
    private static final String schemaAttributeDescription = "SchemaAttribute description";
    private static final String nestedSchemaAttributeName = "TestNestedSchemaAttribute";
    private static final String nestedSchemaAttributeDisplayName = "Nested SchemaAttribute displayName";
    private static final String nestedSchemaAttributeDescription = "Nested SchemaAttribute description";
    private static final String nestedSchemaAttributeType = "string";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateEventsTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateEventsTest thisTest = new CreateEventsTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceWiki());
        EventBrokerClient client = thisTest.getEventBrokerClient(serverName, serverPlatformRootURL);
        String eventBrokerGUID = thisTest.getEventBroker(serverName, serverPlatformRootURL, userId, auditLog);
        String topicGUID = thisTest.getTopic(client, eventBrokerGUID, userId);
        String eventTypeGUID = thisTest.getEventType(client, eventBrokerGUID, topicGUID, userId);
        String schemaAttributeGUID = thisTest.createSchemaAttribute(client, eventBrokerGUID, eventTypeGUID, userId);
        String nestedSchemaAttributeGUID = thisTest.createNestedSchemaAttribute(client, eventBrokerGUID, schemaAttributeGUID, userId);
        String activityName = "cascadedDelete";
        try {
            client.removeTopic(userId, eventBrokerGUID, eventBrokerName, topicGUID, topicName);
            thisTest.checkTopicGone(client, topicGUID, activityName, userId);
            thisTest.checkEventTypeGone(client, eventTypeGUID, null, activityName, userId);
            thisTest.checkSchemaAttributeGone(client, schemaAttributeGUID, null, activityName, userId);
            thisTest.checkNestedSchemaAttributeGone(client, null, nestedSchemaAttributeGUID, activityName, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        activityName = "deleteOneByOne";
        topicGUID = thisTest.getTopic(client, eventBrokerGUID, userId);
        System.out.println("Topic GUID = " + topicGUID);
        eventTypeGUID = thisTest.getEventType(client, eventBrokerGUID, topicGUID, userId);
        System.out.println("EventType GUID = " + eventTypeGUID);
        schemaAttributeGUID = thisTest.createSchemaAttribute(client, eventBrokerGUID, eventTypeGUID, userId);
        System.out.println("SchemaAttribute GUID = " + schemaAttributeGUID);
        nestedSchemaAttributeGUID = thisTest.createNestedSchemaAttribute(client, eventBrokerGUID, schemaAttributeGUID, userId);
        System.out.println("NestedSchemaAttribute GUID = " + nestedSchemaAttributeGUID);
        try {
            activityName = "deleteOneByOne - prevalidate";
            thisTest.checkSchemaAttributeOK(client, schemaAttributeGUID, eventTypeGUID, activityName, userId);
            thisTest.checkEventTypeOK(client, eventTypeGUID, topicGUID, activityName, userId);
            thisTest.checkTopicOK(client, topicGUID, activityName, userId);
            client.removeSchemaAttribute(userId, eventBrokerGUID, eventBrokerName, nestedSchemaAttributeGUID);
            activityName = "deleteOneByOne - nested attribute gone";
            thisTest.checkNestedSchemaAttributeGone(client, schemaAttributeGUID, nestedSchemaAttributeGUID, activityName, userId);
            thisTest.checkSchemaAttributeOK(client, schemaAttributeGUID, eventTypeGUID, activityName, userId);
            thisTest.checkEventTypeOK(client, eventTypeGUID, topicGUID, activityName, userId);
            thisTest.checkTopicOK(client, topicGUID, activityName, userId);
            client.removeSchemaAttribute(userId, eventBrokerGUID, eventBrokerName, schemaAttributeGUID);
            activityName = "deleteOneByOne - top-level schema gone";
            thisTest.checkNestedSchemaAttributeGone(client, null, nestedSchemaAttributeGUID, activityName, userId);
            thisTest.checkSchemaAttributeGone(client, schemaAttributeGUID, eventTypeGUID, activityName, userId);
            thisTest.checkEventTypeOK(client, eventTypeGUID, topicGUID, activityName, userId);
            thisTest.checkTopicOK(client, topicGUID, activityName, userId);
            client.removeEventType(userId, eventBrokerGUID, eventBrokerName, eventTypeGUID, eventTypeName);
            activityName = "deleteOneByOne - event Type gone";
            thisTest.checkNestedSchemaAttributeGone(client, null, nestedSchemaAttributeGUID, activityName, userId);
            thisTest.checkSchemaAttributeGone(client, schemaAttributeGUID, null, activityName, userId);
            thisTest.checkEventTypeGone(client, eventTypeGUID, topicGUID, activityName, userId);
            thisTest.checkTopicOK(client, topicGUID, activityName, userId);
            client.removeTopic(userId, eventBrokerGUID, eventBrokerName, topicGUID, topicName);
            activityName = "deleteOneByOne - topic gone";
            thisTest.checkNestedSchemaAttributeGone(client, null, nestedSchemaAttributeGUID, activityName, userId);
            thisTest.checkSchemaAttributeGone(client, schemaAttributeGUID, null, activityName, userId);
            thisTest.checkEventTypeGone(client, eventTypeGUID, null, activityName, userId);
            thisTest.checkTopicGone(client, topicGUID, activityName, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private EventBrokerClient getEventBrokerClient(String serverName, String serverPlatformRootURL) throws FVTUnexpectedCondition {
        String activityName = "getEventBrokerClient";
        try {
            DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL);
            return new EventBrokerClient(serverName, serverPlatformRootURL, restClient, 100);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getEventBrokerClient", (Throwable)unexpectedError);
        }
    }

    private String getEventBroker(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getEventBroker";
        try {
            DataManagerRESTClient restClient = new DataManagerRESTClient(serverName, serverPlatformRootURL);
            MetadataSourceClient client = new MetadataSourceClient(serverName, serverPlatformRootURL, restClient, 100);
            EventBrokerProperties properties = new EventBrokerProperties();
            properties.setQualifiedName(eventBrokerName);
            properties.setResourceName(eventBrokerDisplayName);
            properties.setResourceDescription(eventBrokerDescription);
            properties.setDeployedImplementationType(eventBrokerTypeDescription);
            properties.setVersion(eventBrokerVersion);
            String eventBrokerGUID = client.createEventBroker(userId, null, null, properties);
            if (eventBrokerGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getEventBroker(no GUID for Create)");
            }
            String retrievedeventBrokerGUID = client.getMetadataSourceGUID(userId, eventBrokerName);
            if (retrievedeventBrokerGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getEventBroker(no GUID for Retrieve)");
            }
            if (!retrievedeventBrokerGUID.equals(eventBrokerGUID)) {
                throw new FVTUnexpectedCondition(testCaseName, "getEventBroker(Inconsistent GUIDs)");
            }
            return eventBrokerGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getEventBroker", (Throwable)unexpectedError);
        }
    }

    private void checkTopicGone(EventBrokerClient client, String topicGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            TopicElement retrievedElement = client.getTopicByGUID(userId, topicGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Topic returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Retrieve returned)");
        }
        catch (InvalidParameterException retrievedElement) {
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void checkTopicOK(EventBrokerClient client, String topicGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            TopicElement retrievedElement = client.getTopicByGUID(userId, topicGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no TopicElement from Retrieve)");
            }
            TopicProperties retrievedTopic = retrievedElement.getProperties();
            if (retrievedTopic == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no TopicProperties from Retrieve)");
            }
            if (!topicName.equals(retrievedTopic.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve)");
            }
            if (!topicDisplayName.equals(retrievedTopic.getName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve)");
            }
            if (!topicDescription.equals(retrievedTopic.getResourceDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve)");
            }
            if (!topicType.equals(retrievedTopic.getTopicType())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad topicType from Retrieve " + retrievedTopic.getTopicType() + ")");
            }
            List topicList = client.getTopicsByName(userId, topicName, 0, 100);
            if (topicList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Topic for RetrieveByName)");
            }
            if (topicList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Topic list for RetrieveByName)");
            }
            if (topicList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Topic list for RetrieveByName contains" + topicList.size() + " elements)");
            }
            retrievedElement = (TopicElement)topicList.get(0);
            retrievedTopic = retrievedElement.getProperties();
            if (!topicName.equals(retrievedTopic.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!topicDisplayName.equals(retrievedTopic.getName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName)");
            }
            if (!topicDescription.equals(retrievedTopic.getResourceDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            if (!topicType.equals(retrievedTopic.getTopicType())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad topicType from RetrieveByName)");
            }
            topicList = client.getTopicsByName(userId, topicName, 1, 100);
            if (topicList != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Topic for RetrieveByName)");
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getTopic(EventBrokerClient client, String eventBrokerGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getTopic";
        try {
            TopicProperties properties = new TopicProperties();
            properties.setQualifiedName(topicName);
            properties.setName(topicDisplayName);
            properties.setResourceDescription(topicDescription);
            properties.setTopicType(topicType);
            String topicGUID = client.createTopic(userId, eventBrokerGUID, eventBrokerName, true, properties);
            if (topicGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getTopic(no GUID for Create)");
            }
            this.checkTopicOK(client, topicGUID, "getTopic", userId);
            return topicGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getTopic", (Throwable)unexpectedError);
        }
    }

    private void checkEventTypeGone(EventBrokerClient client, String eventTypeGUID, String topicGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            EventTypeElement retrievedElement = client.getEventTypeByGUID(userId, eventTypeGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(EventType returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getEventTypeByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (topicGUID != null) {
            try {
                List eventTypeList = client.getEventTypesForTopic(userId, topicGUID, 0, 100);
                if (eventTypeList != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(EventType returned for getEventTypesForTopic)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void checkEventTypeOK(EventBrokerClient client, String eventTypeGUID, String topicGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            EventTypeElement retrievedElement = client.getEventTypeByGUID(userId, eventTypeGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no EventTypeElement from Retrieve)");
            }
            EventTypeProperties retrievedSchema = retrievedElement.getProperties();
            if (retrievedSchema == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no EventTypeProperties from Retrieve)");
            }
            if (!eventTypeName.equals(retrievedSchema.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve: " + retrievedSchema.getQualifiedName() + ")");
            }
            if (!eventTypeDisplayName.equals(retrievedSchema.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve: " + retrievedSchema.getDisplayName() + ")");
            }
            if (!eventTypeDescription.equals(retrievedSchema.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve: " + retrievedSchema.getDescription() + ")");
            }
            List eventTypeList = client.getEventTypesByName(userId, eventTypeName, 0, 100);
            if (eventTypeList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no EventType for RetrieveByName)");
            }
            if (eventTypeList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty EventType list for RetrieveByName)");
            }
            if (eventTypeList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(EventType list for RetrieveByName contains" + eventTypeList.size() + " elements)");
            }
            retrievedElement = (EventTypeElement)eventTypeList.get(0);
            retrievedSchema = retrievedElement.getProperties();
            if (!eventTypeName.equals(retrievedSchema.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!eventTypeDisplayName.equals(retrievedSchema.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName)");
            }
            if (!eventTypeDescription.equals(retrievedSchema.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            eventTypeList = client.getEventTypesForTopic(userId, topicGUID, 0, 100);
            if (eventTypeList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no EventType for getSchemasForTopic)");
            }
            if (eventTypeList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty EventType list for getSchemasForTopic)");
            }
            if (eventTypeList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(EventType list for getSchemasForTopic contains" + eventTypeList.size() + " elements)");
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getEventType(EventBrokerClient client, String eventBrokerGUID, String topicGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getEventType";
        try {
            EventTypeProperties properties = new EventTypeProperties();
            properties.setQualifiedName(eventTypeName);
            properties.setDisplayName(eventTypeDisplayName);
            properties.setDescription(eventTypeDescription);
            String eventTypeGUID = client.createEventType(userId, eventBrokerGUID, eventBrokerName, topicGUID, properties);
            if (eventTypeGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getEventType(no GUID for schemaCreate)");
            }
            this.checkEventTypeOK(client, eventTypeGUID, topicGUID, "getEventType", userId);
            return eventTypeGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getEventType", (Throwable)unexpectedError);
        }
    }

    private void checkSchemaAttributeGone(EventBrokerClient client, String schemaAttributeGUID, String eventTypeGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            SchemaAttributeElement retrievedElement = client.getSchemaAttributeByGUID(userId, schemaAttributeGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(SchemaAttribute returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getSchemaAttributeByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (eventTypeGUID != null) {
            try {
                List schemaAttributeList = client.getNestedAttributes(userId, eventTypeGUID, 0, 100);
                if (schemaAttributeList != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(SchemaAttribute returned for getNestedAttributes)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void checkSchemaAttributeOK(EventBrokerClient client, String schemaAttributeGUID, String eventTypeGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            SchemaAttributeElement retrievedElement = client.getSchemaAttributeByGUID(userId, schemaAttributeGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no SchemaAttributeElement from Retrieve)");
            }
            SchemaAttributeProperties retrievedTable = retrievedElement.getSchemaAttributeProperties();
            if (retrievedTable == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no SchemaAttributeProperties from Retrieve)");
            }
            if (!schemaAttributeName.equals(retrievedTable.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve)");
            }
            if (!schemaAttributeDisplayName.equals(retrievedTable.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve)");
            }
            if (!schemaAttributeDescription.equals(retrievedTable.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve)");
            }
            List schemaAttributeList = client.getSchemaAttributesByName(userId, schemaAttributeName, "EventSchemaAttribute", 0, 100);
            if (schemaAttributeList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no SchemaAttribute for RetrieveByName)");
            }
            if (schemaAttributeList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty SchemaAttribute list for RetrieveByName)");
            }
            if (schemaAttributeList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(SchemaAttribute list for RetrieveByName contains" + schemaAttributeList.size() + " elements)");
            }
            retrievedElement = (SchemaAttributeElement)schemaAttributeList.get(0);
            retrievedTable = retrievedElement.getSchemaAttributeProperties();
            if (!schemaAttributeName.equals(retrievedTable.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!schemaAttributeDisplayName.equals(retrievedTable.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName)");
            }
            if (!schemaAttributeDescription.equals(retrievedTable.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            schemaAttributeList = client.getNestedAttributes(userId, eventTypeGUID, 0, 100);
            if (schemaAttributeList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no SchemaAttribute for getTablesForEventType)");
            }
            if (schemaAttributeList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty SchemaAttribute list for getTablesForEventType)");
            }
            if (schemaAttributeList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(SchemaAttribute list for getTablesForEventType contains" + schemaAttributeList.size() + " elements)");
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String createSchemaAttribute(EventBrokerClient client, String eventBrokerGUID, String eventTypeGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createSchemaAttribute";
        try {
            SchemaAttributeProperties properties = new SchemaAttributeProperties();
            properties.setQualifiedName(schemaAttributeName);
            properties.setDisplayName(schemaAttributeDisplayName);
            properties.setDescription(schemaAttributeDescription);
            String schemaAttributeGUID = client.createSchemaAttribute(userId, eventBrokerGUID, eventBrokerName, eventTypeGUID, properties);
            if (schemaAttributeGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createSchemaAttribute(no GUID for tableCreate)");
            }
            this.checkSchemaAttributeOK(client, schemaAttributeGUID, eventTypeGUID, "createSchemaAttribute", userId);
            return schemaAttributeGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createSchemaAttribute", (Throwable)unexpectedError);
        }
    }

    private void checkNestedSchemaAttributeGone(EventBrokerClient client, String schemaAttributeGUID, String nestedSchemaAttributeGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            SchemaAttributeElement retrievedElement = client.getSchemaAttributeByGUID(userId, nestedSchemaAttributeGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(SchemaAttribute returned from Retrieve - " + retrievedElement.toString() + ")");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getSchemaAttributeByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (schemaAttributeGUID != null) {
            try {
                List schemaAttributeList = client.getNestedAttributes(userId, schemaAttributeGUID, 0, 100);
                if (schemaAttributeList != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + " (SchemaAttribute returned for getNestedAttributes)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + " - exception from getNestedAttributes(" + schemaAttributeGUID + ")", (Throwable)unexpectedError);
            }
        }
    }

    private void checkNestedSchemaAttributeOK(EventBrokerClient client, String schemaAttributeGUID, String nestedSchemaAttributeGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            SchemaAttributeElement retrievedElement = client.getSchemaAttributeByGUID(userId, nestedSchemaAttributeGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no SchemaAttributeElement from Retrieve)");
            }
            SchemaAttributeProperties retrievedAttribute = retrievedElement.getSchemaAttributeProperties();
            if (retrievedAttribute == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no SchemaAttributeProperties from Retrieve)");
            }
            if (!nestedSchemaAttributeName.equals(retrievedAttribute.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve: " + retrievedAttribute.getQualifiedName() + ")");
            }
            if (!nestedSchemaAttributeDisplayName.equals(retrievedAttribute.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve: " + retrievedAttribute.getDisplayName() + ")");
            }
            if (!nestedSchemaAttributeDescription.equals(retrievedAttribute.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve: " + retrievedAttribute.getDescription() + ")");
            }
            List schemaAttributeList = client.getSchemaAttributesByName(userId, nestedSchemaAttributeName, "EventSchemaAttribute", 0, 100);
            if (schemaAttributeList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no SchemaAttribute for RetrieveByName)");
            }
            if (schemaAttributeList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty SchemaAttribute list for RetrieveByName)");
            }
            if (schemaAttributeList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(SchemaAttribute list for RetrieveByName contains" + schemaAttributeList.size() + " elements)");
            }
            retrievedElement = (SchemaAttributeElement)schemaAttributeList.get(0);
            retrievedAttribute = retrievedElement.getSchemaAttributeProperties();
            if (!nestedSchemaAttributeName.equals(retrievedAttribute.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName)");
            }
            if (!nestedSchemaAttributeDisplayName.equals(retrievedAttribute.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName)");
            }
            if (!nestedSchemaAttributeDescription.equals(retrievedAttribute.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName)");
            }
            schemaAttributeList = client.getNestedAttributes(userId, schemaAttributeGUID, 0, 100);
            if (schemaAttributeList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no SchemaAttribute for getColumnsForSchemaAttribute)");
            }
            if (schemaAttributeList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty SchemaAttribute list for getColumnsForSchemaAttribute)");
            }
            if (schemaAttributeList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(SchemaAttribute list for getColumnsForSchemaAttribute contains" + schemaAttributeList.size() + " elements)");
            }
            retrievedElement = (SchemaAttributeElement)schemaAttributeList.get(0);
            retrievedAttribute = retrievedElement.getSchemaAttributeProperties();
            if (!nestedSchemaAttributeName.equals(retrievedAttribute.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from getColumnsForSchemaAttribute)");
            }
            if (!nestedSchemaAttributeDisplayName.equals(retrievedAttribute.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from getColumnsForSchemaAttribute)");
            }
            if (!nestedSchemaAttributeDescription.equals(retrievedAttribute.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from getColumnsForSchemaAttribute)");
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String createNestedSchemaAttribute(EventBrokerClient client, String eventBrokerGUID, String schemaAttributeGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createNestedSchemaAttribute";
        try {
            SchemaAttributeProperties properties = new SchemaAttributeProperties();
            properties.setQualifiedName(nestedSchemaAttributeName);
            properties.setDisplayName(nestedSchemaAttributeDisplayName);
            properties.setDescription(nestedSchemaAttributeDescription);
            properties.setDataType(nestedSchemaAttributeType);
            String nestedSchemaAttributeGUID = client.createSchemaAttribute(userId, eventBrokerGUID, eventBrokerName, schemaAttributeGUID, properties);
            if (nestedSchemaAttributeGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createNestedSchemaAttribute(no GUID for nested attribute create)");
            }
            this.checkNestedSchemaAttributeOK(client, schemaAttributeGUID, nestedSchemaAttributeGUID, "createNestedSchemaAttribute", userId);
            return nestedSchemaAttributeGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createNestedSchemaAttribute", (Throwable)unexpectedError);
        }
    }
}

