/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFileElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileSystemElement;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFileResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileFolderResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileSystemResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.NewDataFileRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.NewDataFolderRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.NewFileSystemRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.PathNameRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerOCFBeanCloner;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.FilesAndFoldersHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRESTServices {
    private static DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(FileSystemRESTServices.class);
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private DataManagerOCFBeanCloner cloner = new DataManagerOCFBeanCloner(instanceHandler);

    public GUIDResponse createFileSystemInCatalog(String serverName, String userId, NewFileSystemRequestBody requestBody) {
        String methodName = "createFileSystemInCatalog";
        log.debug("Calling method: createFileSystemInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFileSystemInCatalog");
            if (requestBody != null) {
                SoftwareServerCapabilityHandler handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createFileSystemInCatalog");
                response.setGUID(handler.createFileSystem(userId, requestBody.getUniqueName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getFileSystemType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getFormat(), requestBody.getEncryption(), requestBody.getAdditionalProperties(), null, "createFileSystemInCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "createFileSystemInCatalog", auditLog);
        }
        log.debug("Returning from method: createFileSystemInCatalog with response: " + response.toString());
        return response;
    }

    public GUIDListResponse createFolderStructureInCatalog(String serverName, String userId, String anchorGUID, PathNameRequestBody requestBody) {
        String methodName = "createFolderStructureInCatalog";
        log.debug("Calling method: createFolderStructureInCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFolderStructureInCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "createFolderStructureInCatalog");
                response.setGUIDs(handler.createFolderStructureInCatalog(userId, anchorGUID, requestBody.getFullPath(), "createFolderStructureInCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "createFolderStructureInCatalog", auditLog);
        }
        log.debug("Returning from method: createFolderStructureInCatalog with response: " + response.toString());
        return response;
    }

    public GUIDListResponse createFolderStructureInCatalog(String serverName, String userId, PathNameRequestBody requestBody) {
        String methodName = "createFolderStructureInCatalog";
        log.debug("Calling method: createFolderStructureInCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFolderStructureInCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "createFolderStructureInCatalog");
                response.setGUIDs(handler.createFolderStructureInCatalog(userId, requestBody.getFullPath(), "createFolderStructureInCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "createFolderStructureInCatalog", auditLog);
        }
        log.debug("Returning from method: createFolderStructureInCatalog with response: " + response.toString());
        return response;
    }

    public VoidResponse attachFolderToFileSystem(String serverName, String userId, String fileSystemGUID, String folderGUID, NullRequestBody requestBody) {
        String methodName = "attachFolderToFileSystem";
        log.debug("Calling method: attachFolderToFileSystem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachFolderToFileSystem");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "attachFolderToFileSystem");
            handler.attachFolderToFileSystem(userId, fileSystemGUID, folderGUID, "attachFolderToFileSystem");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "attachFolderToFileSystem", auditLog);
        }
        log.debug("Returning from method: attachFolderToFileSystem with response: " + response.toString());
        return response;
    }

    public VoidResponse detachFolderFromFileSystem(String serverName, String userId, String fileSystemGUID, String folderGUID, NullRequestBody requestBody) {
        String methodName = "detachFolderFromFileSystem";
        log.debug("Calling method: detachFolderFromFileSystem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachFolderFromFileSystem");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "detachFolderFromFileSystem");
            handler.detachFolderFromFileSystem(userId, fileSystemGUID, folderGUID, "detachFolderFromFileSystem");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "detachFolderFromFileSystem", auditLog);
        }
        log.debug("Returning from method: detachFolderFromFileSystem with response: " + response.toString());
        return response;
    }

    public GUIDListResponse addDataFileToCatalog(String serverName, String userId, NewDataFileRequestBody requestBody) {
        String methodName = "addFileToCatalog";
        log.debug("Calling method: addFileToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addFileToCatalog");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addFileToCatalog");
            response.setGUIDs(handler.addFileToCatalog(userId, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getConnectorClassName(), requestBody.getTypeName(), requestBody.getExtendedProperties(), "addFileToCatalog"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addFileToCatalog", auditLog);
        }
        log.debug("Returning from method: addFileToCatalog with response: " + response.toString());
        return response;
    }

    public GUIDListResponse addDataFolderAssetToCatalog(String serverName, String userId, NewDataFolderRequestBody requestBody) {
        String methodName = "addDataFileAssetToCatalog";
        log.debug("Calling method: addDataFileAssetToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addDataFileAssetToCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addDataFileAssetToCatalog");
                response.setGUIDs(handler.addDataFolderAssetToCatalog(userId, requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getQualifiedName(), "addDataFileAssetToCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addDataFileAssetToCatalog", auditLog);
        }
        log.debug("Returning from method: addDataFileAssetToCatalog with response: " + response.toString());
        return response;
    }

    public VoidResponse attachDataFileAssetToFolder(String serverName, String userId, String folderGUID, String fileGUID, NullRequestBody requestBody) {
        String methodName = "attachDataFileAssetToFolder";
        log.debug("Calling method: attachDataFileAssetToFolder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachDataFileAssetToFolder");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "attachDataFileAssetToFolder");
            handler.attachDataFileAssetToFolder(userId, folderGUID, fileGUID, "attachDataFileAssetToFolder");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "attachDataFileAssetToFolder", auditLog);
        }
        log.debug("Returning from method: attachDataFileAssetToFolder with response: " + response.toString());
        return response;
    }

    public VoidResponse detachDataFileAssetFromFolder(String serverName, String userId, String folderGUID, String fileGUID, NullRequestBody requestBody) {
        String methodName = "detachDataFileAssetFromFolder";
        log.debug("Calling method: detachDataFileAssetFromFolder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachDataFileAssetFromFolder");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "detachDataFileAssetFromFolder");
            handler.detachDataFileAssetFromFolder(userId, folderGUID, fileGUID, "detachDataFileAssetFromFolder");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "detachDataFileAssetFromFolder", auditLog);
        }
        log.debug("Returning from method: detachDataFileAssetFromFolder with response: " + response.toString());
        return response;
    }

    public VoidResponse moveDataFileInCatalog(String serverName, String userId, String folderGUID, String fileGUID, NullRequestBody requestBody) {
        String methodName = "moveDataFileInCatalog";
        log.debug("Calling method: moveDataFileInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "moveDataFileInCatalog");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "moveDataFileInCatalog");
            handler.moveDataFileInCatalog(userId, folderGUID, fileGUID, "moveDataFileInCatalog");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "moveDataFileInCatalog", auditLog);
        }
        log.debug("Returning from method: moveDataFileInCatalog with response: " + response.toString());
        return response;
    }

    public VoidResponse moveDataFolderInCatalog(String serverName, String userId, String folderGUID, String fileGUID, NullRequestBody requestBody) {
        String methodName = "moveDataFileInCatalog";
        log.debug("Calling method: moveDataFileInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "moveDataFileInCatalog");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "moveDataFileInCatalog");
            handler.moveDataFolderInCatalog(userId, folderGUID, fileGUID, "moveDataFileInCatalog");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "moveDataFileInCatalog", auditLog);
        }
        log.debug("Returning from method: moveDataFileInCatalog with response: " + response.toString());
        return response;
    }

    public FileSystemResponse getFileSystemByGUID(String serverName, String userId, String fileSystemGUID) {
        String methodName = "getFileSystemByGUID";
        log.debug("Calling method: getFileSystemByGUID");
        FileSystemResponse response = new FileSystemResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystemByGUID");
            SoftwareServerCapabilityHandler handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "getFileSystemByGUID");
            FileSystemElement element = this.cloner.getFileSystemFromCapability(handler.getSoftwareServerCapabilityByGUID(userId, fileSystemGUID, "getFileSystemByGUID"), userId, serverName, "getFileSystemByGUID");
            response.setFileSystem(element);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getFileSystemByGUID", auditLog);
        }
        log.debug("Returning from method: getFileSystemByGUID with response: " + response.toString());
        return response;
    }

    public FileSystemResponse getFileSystemByUniqueName(String serverName, String userId, String uniqueName) {
        String methodName = "getFileSystemByUniqueName";
        log.debug("Calling method: getFileSystemByUniqueName");
        FileSystemResponse response = new FileSystemResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystemByUniqueName");
            SoftwareServerCapabilityHandler handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "getFileSystemByUniqueName");
            FileSystemElement element = this.cloner.getFileSystemFromCapability(handler.getSoftwareServerCapabilityByUniqueName(userId, uniqueName, "getFileSystemByUniqueName"), userId, serverName, "getFileSystemByUniqueName");
            response.setFileSystem(element);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getFileSystemByUniqueName", auditLog);
        }
        log.debug("Returning from method: getFileSystemByUniqueName with response: " + response.toString());
        return response;
    }

    public GUIDListResponse getFileSystems(String serverName, String userId, int startingFrom, int maxPageSize) {
        String methodName = "getFileSystems";
        log.debug("Calling method: getFileSystems");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystems");
            SoftwareServerCapabilityHandler handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "getFileSystems");
            response.setGUIDs(handler.getSoftwareServerCapabilityGUIDsByClassification(userId, "FileSystem", startingFrom, maxPageSize, "getFileSystems"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getFileSystems", auditLog);
        }
        log.debug("Returning from method: getFileSystems with response: " + response.toString());
        return response;
    }

    public FileFolderResponse getFolderByGUID(String serverName, String userId, String folderGUID) {
        String methodName = "getFolderByGUID";
        log.debug("Calling method: getFolderByGUID");
        FileFolderResponse response = new FileFolderResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderByGUID");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderByGUID");
            FileFolderElement fileFolder = this.cloner.getFileFolderFromAsset(handler.getFolderByGUID(userId, folderGUID, "getFolderByGUID"), userId, serverName, "getFolderByGUID");
            response.setFolder(fileFolder);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getFolderByGUID", auditLog);
        }
        log.debug("Returning from method: getFolderByGUID with response: " + response.toString());
        return response;
    }

    public FileFolderResponse getFolderByPathName(String serverName, String userId, PathNameRequestBody requestBody) {
        String methodName = "getFolderByPathName";
        log.debug("Calling method: getFolderByPathName");
        FileFolderResponse response = new FileFolderResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderByPathName");
            if (requestBody != null) {
                FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderByPathName");
                FileFolderElement fileFolder = this.cloner.getFileFolderFromAsset(handler.getFolderByPathName(userId, requestBody.getFullPath(), "getFolderByPathName"), userId, serverName, "getFolderByPathName");
                response.setFolder(fileFolder);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getFolderByPathName", auditLog);
        }
        log.debug("Returning from method: getFolderByPathName with response: " + response.toString());
        return response;
    }

    public GUIDListResponse getNestedFolders(String serverName, String userId, String anchorGUID, int startingFrom, int maxPageSize) {
        String methodName = "getNestedFolders";
        log.debug("Calling method: getNestedFolders");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNestedFolders");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getNestedFolders");
            response.setGUIDs(handler.getNestedFolders(userId, anchorGUID, startingFrom, maxPageSize, "getNestedFolders"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getNestedFolders", auditLog);
        }
        log.debug("Returning from method: getNestedFolders with response: " + response.toString());
        return response;
    }

    public GUIDListResponse getFolderFiles(String serverName, String userId, String folderGUID, int startingFrom, int maxPageSize) {
        String methodName = "getFolderFiles";
        log.debug("Calling method: getFolderFiles");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderFiles");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderFiles");
            response.setGUIDs(handler.getFolderFiles(userId, folderGUID, startingFrom, maxPageSize, "getFolderFiles"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getFolderFiles", auditLog);
        }
        log.debug("Returning from method: getFolderFiles with response: " + response.toString());
        return response;
    }

    public DataFileResponse getDataFileByGUID(String serverName, String userId, String fileGUID) {
        String methodName = "getDataFileByGUID";
        log.debug("Calling method: getDataFileByGUID");
        DataFileResponse response = new DataFileResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFileByGUID");
            FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getDataFileByGUID");
            DataFileElement dataFile = this.cloner.getDataFileFromAsset(handler.getDataFileByGUID(userId, fileGUID, "getDataFileByGUID"), userId, serverName, "getDataFileByGUID");
            response.setDataFile(dataFile);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDataFileByGUID", auditLog);
        }
        log.debug("Returning from method: getDataFileByGUID with response: " + response.toString());
        return response;
    }

    public DataFileResponse getDataFileByPathName(String serverName, String userId, PathNameRequestBody requestBody) {
        String methodName = "getDataFileByPathName";
        log.debug("Calling method: getDataFileByPathName");
        DataFileResponse response = new DataFileResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFileByPathName");
            if (requestBody != null) {
                FilesAndFoldersHandler handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getDataFileByPathName");
                DataFileElement dataFile = this.cloner.getDataFileFromAsset(handler.getDataFileByPathName(userId, requestBody.getFullPath(), "getDataFileByPathName"), userId, serverName, "getDataFileByPathName");
                response.setDataFile(dataFile);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDataFileByPathName", auditLog);
        }
        log.debug("Returning from method: getDataFileByPathName with response: " + response.toString());
        return response;
    }
}

