/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFileElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseTableElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseViewElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementOriginCategory;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementType;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileSystemElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataItemSortOrder;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseForeignKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabasePrimaryKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseQueryProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.datamanager.properties.OwnerCategory;
import org.odpi.openmetadata.accessservices.datamanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaElementProperties;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DerivedSchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Meaning;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PrimitiveSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttributeRelationship;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaElement;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaImplementationQuery;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SoftwareServerCapability;

public class DataManagerOCFBeanCloner {
    private DataManagerInstanceHandler instanceHandler;

    public DataManagerOCFBeanCloner(DataManagerInstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    OwnerType getOwnerType(OwnerCategory ownerCategory) {
        OwnerType ownerType = OwnerType.OTHER;
        if (ownerCategory == OwnerCategory.USER_ID) {
            ownerType = OwnerType.USER_ID;
        } else if (ownerCategory == OwnerCategory.PROFILE_ID) {
            ownerType = OwnerType.PROFILE_ID;
        }
        return ownerType;
    }

    private OwnerCategory getOwnerCategory(OwnerType ownerType) {
        OwnerCategory ownerCategory = OwnerCategory.OTHER;
        if (ownerType == OwnerType.USER_ID) {
            ownerCategory = OwnerCategory.USER_ID;
        } else if (ownerType == OwnerType.PROFILE_ID) {
            ownerCategory = OwnerCategory.PROFILE_ID;
        }
        return ownerCategory;
    }

    private List<org.odpi.openmetadata.accessservices.datamanager.properties.Classification> getDataManagerClassifications(List<Classification> ocfClassifications) {
        ArrayList<org.odpi.openmetadata.accessservices.datamanager.properties.Classification> dataManagerClassifications = null;
        if (ocfClassifications != null) {
            dataManagerClassifications = new ArrayList<org.odpi.openmetadata.accessservices.datamanager.properties.Classification>();
            for (Classification ocfClassification : ocfClassifications) {
                org.odpi.openmetadata.accessservices.datamanager.properties.Classification dataManagerClassification;
                if (ocfClassification == null || (dataManagerClassification = this.getDataManagerClassification(ocfClassification)) == null) continue;
                dataManagerClassifications.add(dataManagerClassification);
            }
            if (dataManagerClassifications.isEmpty()) {
                dataManagerClassifications = null;
            }
        }
        return dataManagerClassifications;
    }

    private org.odpi.openmetadata.accessservices.datamanager.properties.Classification getDataManagerClassification(Classification ocfClassification) {
        if (ocfClassification != null) {
            org.odpi.openmetadata.accessservices.datamanager.properties.Classification dataManagerClassification = new org.odpi.openmetadata.accessservices.datamanager.properties.Classification();
            dataManagerClassification.setClassificationName(ocfClassification.getClassificationName());
            dataManagerClassification.setClassificationProperties(ocfClassification.getClassificationProperties());
            return dataManagerClassification;
        }
        return null;
    }

    private org.odpi.openmetadata.accessservices.datamanager.properties.Classification extractClassification(String requestedClassificationName, List<org.odpi.openmetadata.accessservices.datamanager.properties.Classification> retrievedClassifications) {
        org.odpi.openmetadata.accessservices.datamanager.properties.Classification requestedClassification = null;
        if (retrievedClassifications != null) {
            for (org.odpi.openmetadata.accessservices.datamanager.properties.Classification retrievedClassification : retrievedClassifications) {
                if (retrievedClassification == null || !requestedClassificationName.equals(retrievedClassification.getClassificationName())) continue;
                requestedClassification = retrievedClassification;
            }
        }
        return requestedClassification;
    }

    private List<org.odpi.openmetadata.accessservices.datamanager.properties.Classification> removeClassification(String requestedClassificationName, List<org.odpi.openmetadata.accessservices.datamanager.properties.Classification> retrievedClassifications) {
        ArrayList<org.odpi.openmetadata.accessservices.datamanager.properties.Classification> newClassifications = null;
        if (retrievedClassifications != null) {
            newClassifications = new ArrayList<org.odpi.openmetadata.accessservices.datamanager.properties.Classification>();
            for (org.odpi.openmetadata.accessservices.datamanager.properties.Classification retrievedClassification : retrievedClassifications) {
                if (retrievedClassification == null || requestedClassificationName.equals(retrievedClassification.getClassificationName())) continue;
                newClassifications.add(retrievedClassification);
            }
            if (newClassifications.isEmpty()) {
                newClassifications = null;
            }
        }
        return newClassifications;
    }

    FileSystemElement getFileSystemFromCapability(SoftwareServerCapability capability, String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        FileSystemElement fileSystem = null;
        if (capability != null) {
            fileSystem = new FileSystemElement();
            this.setReferenceableProperties((ReferenceableProperties)fileSystem, (Referenceable)capability);
            fileSystem.setDisplayName(capability.getDisplayName());
        }
        return fileSystem;
    }

    FileFolderElement getFileFolderFromAsset(Asset asset, String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        FileFolderElement fileFolder = null;
        if (asset != null) {
            fileFolder = new FileFolderElement();
            this.setReferenceableProperties((ReferenceableProperties)fileFolder, (Referenceable)asset);
            fileFolder.setDisplayName(asset.getDisplayName());
        }
        return fileFolder;
    }

    DataFileElement getDataFileFromAsset(Asset asset, String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        DataFileElement element = null;
        if (asset != null) {
            element = new DataFileElement();
            this.setReferenceableProperties((ReferenceableProperties)element, (Referenceable)asset);
            element.setDisplayName(asset.getDisplayName());
            Map extendedProperties = asset.getExtendedProperties();
            if (extendedProperties != null && extendedProperties.get("fileType") != null) {
                element.setFileType(extendedProperties.get("fileType").toString());
            }
        }
        return element;
    }

    List<DatabaseElement> getDatabasesFromAssets(List<Asset> assets, String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<DatabaseElement> databaseElements = null;
        if (assets != null) {
            databaseElements = new ArrayList<DatabaseElement>();
            for (Asset asset : assets) {
                databaseElements.add(this.getDatabaseFromAsset(asset, userId, serverName, methodName));
            }
        }
        return databaseElements;
    }

    DatabaseElement getDatabaseFromAsset(Asset asset, String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        DatabaseElement element = null;
        if (asset != null) {
            element = new DatabaseElement();
            element.setElementHeader(this.getElementHeaderFromBean((Referenceable)asset, serverName));
            this.setAssetProperties((AssetProperties)element, asset);
            Map extendedProperties = asset.getExtendedProperties();
            if (extendedProperties != null) {
                if (extendedProperties.get("createTime") != null) {
                    element.setCreateTime((Date)extendedProperties.get("createTime"));
                }
                if (extendedProperties.get("modifiedTime") != null) {
                    element.setModifiedTime((Date)extendedProperties.get("modifiedTime"));
                }
                if (extendedProperties.get("encoding") != null) {
                    element.setEncodingType(extendedProperties.get("encoding").toString());
                }
                if (extendedProperties.get("language") != null) {
                    element.setEncodingLanguage(extendedProperties.get("language").toString());
                }
                if (extendedProperties.get("description") != null) {
                    element.setEncodingDescription(extendedProperties.get("description").toString());
                }
                if (extendedProperties.get("type") != null) {
                    element.setDatabaseType(extendedProperties.get("type").toString());
                }
                if (extendedProperties.get("version") != null) {
                    element.setDatabaseVersion(extendedProperties.get("version").toString());
                }
                if (extendedProperties.get("instance") != null) {
                    element.setDatabaseInstance(extendedProperties.get("instance").toString());
                }
                if (extendedProperties.get("importedFrom") != null) {
                    element.setDatabaseImportedFrom(extendedProperties.get("importedFrom").toString());
                }
            }
            ReferenceableHandler handler = this.instanceHandler.getReferenceableHandler(userId, serverName, methodName);
            element.setVendorProperties(handler.getVendorProperties(userId, asset.getGUID(), asset.getQualifiedName(), methodName));
        }
        return element;
    }

    List<DatabaseSchemaElement> getDatabaseSchemasFromAssets(List<Asset> assets, String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<DatabaseSchemaElement> databaseSchemaElements = null;
        if (assets != null) {
            databaseSchemaElements = new ArrayList<DatabaseSchemaElement>();
            for (Asset asset : assets) {
                databaseSchemaElements.add(this.getDatabaseSchemaFromAsset(asset, userId, serverName, methodName));
            }
        }
        return databaseSchemaElements;
    }

    DatabaseSchemaElement getDatabaseSchemaFromAsset(Asset asset, String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        DatabaseSchemaElement element = null;
        if (asset != null) {
            element = new DatabaseSchemaElement();
            element.setElementHeader(this.getElementHeaderFromBean((Referenceable)asset, serverName));
            this.setAssetProperties((AssetProperties)element, asset);
            element.setExtendedProperties(asset.getExtendedProperties());
            ReferenceableHandler handler = this.instanceHandler.getReferenceableHandler(userId, serverName, methodName);
            element.setVendorProperties(handler.getVendorProperties(userId, asset.getGUID(), asset.getQualifiedName(), methodName));
        }
        return element;
    }

    private void setAssetProperties(AssetProperties assetPropertiesBean, Asset assetBean) {
        if (assetPropertiesBean != null) {
            this.setReferenceableProperties((ReferenceableProperties)assetPropertiesBean, (Referenceable)assetBean);
            assetPropertiesBean.setDisplayName(assetBean.getDisplayName());
            assetPropertiesBean.setDescription(assetBean.getDescription());
            assetPropertiesBean.setOwner(assetBean.getOwner());
            assetPropertiesBean.setOwnerCategory(this.getOwnerCategory(assetBean.getOwnerType()));
            assetPropertiesBean.setZoneMembership(assetBean.getZoneMembership());
            assetPropertiesBean.setOrigin(assetBean.getOrigin());
            assetPropertiesBean.setLatestChange(assetBean.getLatestChange());
        }
    }

    List<DatabaseTableElement> getDatabaseTablesFromAttributes(List<SchemaAttribute> schemaAttributes, String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<DatabaseTableElement> databaseTableElements = null;
        if (schemaAttributes != null) {
            databaseTableElements = new ArrayList<DatabaseTableElement>();
            for (SchemaAttribute schemaAttribute : schemaAttributes) {
                databaseTableElements.add(this.getDatabaseTableFromAttribute(schemaAttribute, userId, serverName, methodName));
            }
        }
        return databaseTableElements;
    }

    DatabaseTableElement getDatabaseTableFromAttribute(SchemaAttribute schemaAttribute, String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        DatabaseTableElement element = null;
        if (schemaAttribute != null) {
            element = new DatabaseTableElement();
            element.setElementHeader(this.getElementHeaderFromBean((Referenceable)schemaAttribute, serverName));
            this.setSchemaAttributeProperties((SchemaAttributeProperties)element, schemaAttribute);
            element.setExtendedProperties(schemaAttribute.getExtendedProperties());
            ReferenceableHandler handler = this.instanceHandler.getReferenceableHandler(userId, serverName, methodName);
            element.setVendorProperties(handler.getVendorProperties(userId, schemaAttribute.getGUID(), schemaAttribute.getQualifiedName(), methodName));
        }
        return element;
    }

    List<DatabaseViewElement> getDatabaseViewsFromAttributes(List<SchemaAttribute> schemaAttributes, String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<DatabaseViewElement> databaseViewElements = null;
        if (schemaAttributes != null) {
            databaseViewElements = new ArrayList<DatabaseViewElement>();
            for (SchemaAttribute schemaAttribute : schemaAttributes) {
                databaseViewElements.add(this.getDatabaseViewFromAttribute(schemaAttribute, userId, serverName, methodName));
            }
        }
        return databaseViewElements;
    }

    DatabaseViewElement getDatabaseViewFromAttribute(SchemaAttribute schemaAttribute, String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        DatabaseViewElement element = null;
        if (schemaAttribute != null) {
            element = new DatabaseViewElement();
            ElementHeader elementHeader = this.getElementHeaderFromBean((Referenceable)schemaAttribute, serverName);
            org.odpi.openmetadata.accessservices.datamanager.properties.Classification relationalViewClassification = this.extractClassification("RelationalView", elementHeader.getClassifications());
            if (relationalViewClassification != null) {
                Object expressionObject;
                elementHeader.setClassifications(this.removeClassification("RelationalView", elementHeader.getClassifications()));
                Map properties = relationalViewClassification.getClassificationProperties();
                if (properties != null && (expressionObject = properties.get("expression")) != null) {
                    element.setExpression(expressionObject.toString());
                }
            }
            element.setElementHeader(elementHeader);
            this.setSchemaAttributeProperties((SchemaAttributeProperties)element, schemaAttribute);
            element.setExtendedProperties(schemaAttribute.getExtendedProperties());
            ReferenceableHandler handler = this.instanceHandler.getReferenceableHandler(userId, serverName, methodName);
            element.setVendorProperties(handler.getVendorProperties(userId, schemaAttribute.getGUID(), schemaAttribute.getQualifiedName(), methodName));
        }
        return element;
    }

    List<DatabaseColumnElement> getDatabaseColumnsFromAttributes(List<SchemaAttribute> schemaAttributes, String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<DatabaseColumnElement> databaseColumnElements = null;
        if (schemaAttributes != null) {
            databaseColumnElements = new ArrayList<DatabaseColumnElement>();
            for (SchemaAttribute schemaAttribute : schemaAttributes) {
                databaseColumnElements.add(this.getDatabaseColumnFromAttribute(schemaAttribute, userId, serverName, methodName));
            }
        }
        return databaseColumnElements;
    }

    DatabaseColumnElement getDatabaseColumnFromAttribute(SchemaAttribute schemaAttribute, String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        DatabaseColumnElement element = null;
        if (schemaAttribute != null) {
            element = new DatabaseColumnElement();
            if (schemaAttribute instanceof DerivedSchemaAttribute) {
                element.setFormula(((DerivedSchemaAttribute)schemaAttribute).getFormula());
                element.setQueries(this.getDatabaseSchemaQueries(((DerivedSchemaAttribute)schemaAttribute).getQueries()));
            } else {
                SchemaType attributeType = schemaAttribute.getAttributeType();
                if (attributeType != null && attributeType instanceof PrimitiveSchemaType) {
                    PrimitiveSchemaType primitiveSchemaType = (PrimitiveSchemaType)attributeType;
                    element.setDataType(primitiveSchemaType.getDataType());
                    element.setDefaultValue(primitiveSchemaType.getDefaultValue());
                }
            }
            ElementHeader elementHeader = this.getElementHeaderFromBean((Referenceable)schemaAttribute, serverName);
            this.setSchemaAttributeProperties((SchemaAttributeProperties)element, schemaAttribute);
            element.setExtendedProperties(schemaAttribute.getExtendedProperties());
            org.odpi.openmetadata.accessservices.datamanager.properties.Classification primaryKeyClassification = this.extractClassification("PrimaryKey", elementHeader.getClassifications());
            if (primaryKeyClassification != null) {
                elementHeader.setClassifications(this.removeClassification("PrimaryKey", elementHeader.getClassifications()));
                DatabasePrimaryKeyProperties primaryKeyProperties = new DatabasePrimaryKeyProperties();
                Map classificationProperties = primaryKeyClassification.getClassificationProperties();
                if (classificationProperties != null) {
                    Object primaryKeyPattern;
                    Object primaryKeyName = classificationProperties.get("name");
                    if (primaryKeyName != null) {
                        primaryKeyProperties.setName(primaryKeyName.toString());
                    }
                    if ((primaryKeyPattern = classificationProperties.get("keyPattern")) != null) {
                        primaryKeyProperties.setKeyPattern(this.getKeyPattern((org.odpi.openmetadata.frameworks.connectors.properties.beans.KeyPattern)primaryKeyPattern));
                    }
                }
                element.setPrimaryKeyProperties(primaryKeyProperties);
            }
            element.setElementHeader(elementHeader);
            List relationships = schemaAttribute.getAttributeRelationships();
            if (relationships != null) {
                for (SchemaAttributeRelationship relationship : relationships) {
                    if (relationship == null || !"ForeignKey".equals(relationship.getLinkType())) continue;
                    element.setReferencedColumnGUID(relationship.getLinkedAttributeGUID());
                    element.setReferencedColumnQualifiedName(relationship.getLinkedAttributeName());
                    DatabaseForeignKeyProperties foreignKeyProperties = new DatabaseForeignKeyProperties();
                    Map linkProperties = relationship.getLinkProperties();
                    if (linkProperties != null) {
                        Object propertyValue = linkProperties.get("name");
                        if (propertyValue != null) {
                            foreignKeyProperties.setName(propertyValue.toString());
                        }
                        if ((propertyValue = linkProperties.get("description")) != null) {
                            foreignKeyProperties.setDescription(propertyValue.toString());
                        }
                        if ((propertyValue = linkProperties.get("confidence")) != null) {
                            foreignKeyProperties.setConfidence(Integer.getInteger(propertyValue.toString()).intValue());
                        }
                        if ((propertyValue = linkProperties.get("steward")) != null) {
                            foreignKeyProperties.setSteward(propertyValue.toString());
                        }
                        if ((propertyValue = linkProperties.get("source")) != null) {
                            foreignKeyProperties.setSource(propertyValue.toString());
                        }
                    }
                    element.setForeignKeyProperties(foreignKeyProperties);
                }
            }
            ReferenceableHandler handler = this.instanceHandler.getReferenceableHandler(userId, serverName, methodName);
            element.setVendorProperties(handler.getVendorProperties(userId, schemaAttribute.getGUID(), schemaAttribute.getQualifiedName(), methodName));
        }
        return element;
    }

    private void setSchemaAttributeProperties(SchemaAttributeProperties schemaAttributePropertiesBean, SchemaAttribute schemaAttributeBean) {
        if (schemaAttributePropertiesBean != null) {
            this.setSchemaElementProperties((SchemaElementProperties)schemaAttributePropertiesBean, (SchemaElement)schemaAttributeBean);
            schemaAttributePropertiesBean.setElementPosition(schemaAttributeBean.getElementPosition());
            schemaAttributePropertiesBean.setMinCardinality(schemaAttributeBean.getMinCardinality());
            schemaAttributePropertiesBean.setMaxCardinality(schemaAttributeBean.getMaxCardinality());
            schemaAttributePropertiesBean.setAllowsDuplicateValues(schemaAttributeBean.isAllowsDuplicateValues());
            schemaAttributePropertiesBean.setOrderedValues(schemaAttributeBean.isOrderedValues());
            schemaAttributePropertiesBean.setDefaultValueOverride(schemaAttributeBean.getDefaultValueOverride());
            schemaAttributePropertiesBean.setMinimumLength(schemaAttributeBean.getMinimumLength());
            schemaAttributePropertiesBean.setLength(schemaAttributeBean.getLength());
            schemaAttributePropertiesBean.setSignificantDigits(schemaAttributeBean.getSignificantDigits());
            schemaAttributePropertiesBean.setNullable(schemaAttributeBean.isNullable());
            schemaAttributePropertiesBean.setNativeJavaClass(schemaAttributeBean.getNativeJavaClass());
            schemaAttributePropertiesBean.setAliases(schemaAttributeBean.getAliases());
            schemaAttributePropertiesBean.setSortOrder(this.getDataItemSortOrder(schemaAttributeBean.getSortOrder()));
        }
    }

    private void setSchemaElementProperties(SchemaElementProperties schemaElementPropertiesBean, SchemaElement schemaElementBean) {
        if (schemaElementPropertiesBean != null) {
            this.setReferenceableProperties((ReferenceableProperties)schemaElementPropertiesBean, (Referenceable)schemaElementBean);
            schemaElementPropertiesBean.setDisplayName(schemaElementBean.getDisplayName());
            schemaElementPropertiesBean.setDescription(schemaElementBean.getDescription());
            schemaElementPropertiesBean.setDeprecated(schemaElementBean.isDeprecated());
        }
    }

    private void setReferenceableProperties(ReferenceableProperties referenceablePropertiesBean, Referenceable referenceableBean) {
        if (referenceableBean != null) {
            referenceablePropertiesBean.setQualifiedName(referenceableBean.getQualifiedName());
            referenceablePropertiesBean.setAdditionalProperties(referenceableBean.getAdditionalProperties());
            if (referenceableBean.getType() != null) {
                referenceablePropertiesBean.setTypeName(referenceableBean.getType().getElementTypeName());
            }
        }
    }

    private List<String> getMeaningGUIDs(List<Meaning> ocfMeanings) {
        ArrayList<String> meaningGUIDs = null;
        if (ocfMeanings != null && !ocfMeanings.isEmpty()) {
            meaningGUIDs = new ArrayList<String>();
            for (Meaning ocfMeaning : ocfMeanings) {
                if (ocfMeaning == null) continue;
                meaningGUIDs.add(ocfMeaning.getGUID());
            }
        }
        return meaningGUIDs;
    }

    private ElementHeader getElementHeaderFromBean(Referenceable bean, String serverName) {
        ElementHeader elementHeader = null;
        if (bean != null) {
            elementHeader = new ElementHeader();
            elementHeader.setGUID(bean.getGUID());
            elementHeader.setOrigin(this.getElementOriginFromBean(bean, serverName));
            elementHeader.setType(this.getElementTypeFromBean(bean));
            elementHeader.setMeanings(this.getMeaningGUIDs(bean.getMeanings()));
            elementHeader.setClassifications(this.getDataManagerClassifications(bean.getClassifications()));
        }
        return elementHeader;
    }

    private org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementOrigin getElementOriginFromBean(Referenceable bean, String serverName) {
        org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementOrigin elementOrigin = null;
        if (bean != null) {
            elementOrigin = new org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementOrigin();
            elementOrigin.setSourceServer(serverName);
            if (bean.getType() != null) {
                elementOrigin.setOriginCategory(this.getElementOriginCategory(bean.getType().getElementOrigin()));
                elementOrigin.setHomeMetadataCollectionId(bean.getType().getElementHomeMetadataCollectionId());
                elementOrigin.setHomeMetadataCollectionName(bean.getType().getElementHomeMetadataCollectionName());
                elementOrigin.setLicense(bean.getType().getElementLicense());
            }
        }
        return elementOrigin;
    }

    private ElementOriginCategory getElementOriginCategory(ElementOrigin ocfElementOrigin) {
        if (ocfElementOrigin != null) {
            switch (ocfElementOrigin) {
                case LOCAL_COHORT: {
                    return ElementOriginCategory.LOCAL_COHORT;
                }
                case EXPORT_ARCHIVE: {
                    return ElementOriginCategory.EXPORT_ARCHIVE;
                }
                case CONTENT_PACK: {
                    return ElementOriginCategory.CONTENT_PACK;
                }
                case DEREGISTERED_REPOSITORY: {
                    return ElementOriginCategory.DEREGISTERED_REPOSITORY;
                }
                case CONFIGURATION: {
                    return ElementOriginCategory.CONFIGURATION;
                }
                case EXTERNAL_SOURCE: {
                    return ElementOriginCategory.EXTERNAL_SOURCE;
                }
            }
        }
        return ElementOriginCategory.UNKNOWN;
    }

    private ElementType getElementTypeFromBean(Referenceable bean) {
        ElementType elementType = null;
        if (bean != null && bean.getType() != null) {
            elementType = new ElementType();
            elementType.setTypeId(bean.getType().getElementTypeId());
            elementType.setTypeName(bean.getType().getElementTypeName());
            elementType.setTypeDescription(bean.getType().getElementTypeDescription());
            elementType.setTypeVersion(bean.getType().getElementTypeVersion());
            elementType.setSuperTypeNames(bean.getType().getElementSuperTypeNames());
        }
        return elementType;
    }

    private DataItemSortOrder getDataItemSortOrder(org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder ocfSortOrder) {
        if (ocfSortOrder != null) {
            switch (ocfSortOrder) {
                case ASCENDING: {
                    return DataItemSortOrder.ASCENDING;
                }
                case DESCENDING: {
                    return DataItemSortOrder.DESCENDING;
                }
                case UNSORTED: {
                    return DataItemSortOrder.UNSORTED;
                }
            }
        }
        return DataItemSortOrder.UNKNOWN;
    }

    org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder getOCFSortOrder(DataItemSortOrder dataItemSortOrder) {
        if (dataItemSortOrder != null) {
            switch (dataItemSortOrder) {
                case ASCENDING: {
                    return org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder.ASCENDING;
                }
                case DESCENDING: {
                    return org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder.DESCENDING;
                }
                case UNSORTED: {
                    return org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder.UNSORTED;
                }
            }
        }
        return org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder.UNKNOWN;
    }

    List<SchemaImplementationQuery> getOCFDerivedSchemaQueries(List<DatabaseQueryProperties> databaseQueries) {
        ArrayList<SchemaImplementationQuery> derivedSchemaQueries = null;
        if (databaseQueries != null) {
            derivedSchemaQueries = new ArrayList<SchemaImplementationQuery>();
            for (DatabaseQueryProperties queryProperties : databaseQueries) {
                if (queryProperties == null) continue;
                SchemaImplementationQuery ocfQueryProperties = new SchemaImplementationQuery();
                ocfQueryProperties.setQueryId(queryProperties.getQueryId());
                ocfQueryProperties.setQuery(queryProperties.getQuery());
                ocfQueryProperties.setQueryTargetGUID(queryProperties.getQueryTargetGUID());
                derivedSchemaQueries.add(ocfQueryProperties);
            }
            if (derivedSchemaQueries.isEmpty()) {
                derivedSchemaQueries = null;
            }
        }
        return derivedSchemaQueries;
    }

    List<DatabaseQueryProperties> getDatabaseSchemaQueries(List<SchemaImplementationQuery> derivedSchemaQueries) {
        ArrayList<DatabaseQueryProperties> databaseQueryPropertiesList = null;
        if (derivedSchemaQueries != null) {
            databaseQueryPropertiesList = new ArrayList<DatabaseQueryProperties>();
            for (SchemaImplementationQuery derivedSchemaQueryProperties : derivedSchemaQueries) {
                if (derivedSchemaQueryProperties == null) continue;
                DatabaseQueryProperties databaseQueryProperties = new DatabaseQueryProperties();
                databaseQueryProperties.setQueryId(derivedSchemaQueryProperties.getQueryId());
                databaseQueryProperties.setQuery(derivedSchemaQueryProperties.getQuery());
                databaseQueryProperties.setQueryTargetGUID(derivedSchemaQueryProperties.getQueryTargetGUID());
                databaseQueryPropertiesList.add(databaseQueryProperties);
            }
            if (databaseQueryPropertiesList.isEmpty()) {
                databaseQueryPropertiesList = null;
            }
        }
        return databaseQueryPropertiesList;
    }

    private KeyPattern getKeyPattern(org.odpi.openmetadata.frameworks.connectors.properties.beans.KeyPattern ocfKeyPattern) {
        if (ocfKeyPattern != null) {
            switch (ocfKeyPattern) {
                case LOCAL_KEY: {
                    return KeyPattern.LOCAL_KEY;
                }
                case RECYCLED_KEY: {
                    return KeyPattern.RECYCLED_KEY;
                }
                case NATURAL_KEY: {
                    return KeyPattern.NATURAL_KEY;
                }
                case MIRROR_KEY: {
                    return KeyPattern.MIRROR_KEY;
                }
                case AGGREGATE_KEY: {
                    return KeyPattern.AGGREGATE_KEY;
                }
                case CALLERS_KEY: {
                    return KeyPattern.CALLERS_KEY;
                }
                case STABLE_KEY: {
                    return KeyPattern.STABLE_KEY;
                }
            }
        }
        return KeyPattern.OTHER;
    }

    org.odpi.openmetadata.frameworks.connectors.properties.beans.KeyPattern getOCFKeyPattern(KeyPattern keyPattern) {
        if (keyPattern != null) {
            switch (keyPattern) {
                case LOCAL_KEY: {
                    return org.odpi.openmetadata.frameworks.connectors.properties.beans.KeyPattern.LOCAL_KEY;
                }
                case RECYCLED_KEY: {
                    return org.odpi.openmetadata.frameworks.connectors.properties.beans.KeyPattern.RECYCLED_KEY;
                }
                case NATURAL_KEY: {
                    return org.odpi.openmetadata.frameworks.connectors.properties.beans.KeyPattern.NATURAL_KEY;
                }
                case MIRROR_KEY: {
                    return org.odpi.openmetadata.frameworks.connectors.properties.beans.KeyPattern.MIRROR_KEY;
                }
                case AGGREGATE_KEY: {
                    return org.odpi.openmetadata.frameworks.connectors.properties.beans.KeyPattern.AGGREGATE_KEY;
                }
                case CALLERS_KEY: {
                    return org.odpi.openmetadata.frameworks.connectors.properties.beans.KeyPattern.CALLERS_KEY;
                }
                case STABLE_KEY: {
                    return org.odpi.openmetadata.frameworks.connectors.properties.beans.KeyPattern.STABLE_KEY;
                }
            }
        }
        return org.odpi.openmetadata.frameworks.connectors.properties.beans.KeyPattern.OTHER;
    }
}

