/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.converters;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.converters.DataManagerOMASConverter;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.TabularColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TabularColumnProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class TabularColumnConverter<B>
extends DataManagerOMASConverter<B> {
    public TabularColumnConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public <T> B getNewSchemaAttributeBean(Class<B> beanClass, EntityDetail schemaAttributeEntity, Class<T> typeClass, T schemaType, List<Relationship> schemaAttributeRelationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof TabularColumnElement) {
                TabularColumnElement bean = (TabularColumnElement)returnBean;
                TabularColumnProperties tabularColumnProperties = new TabularColumnProperties();
                if (schemaAttributeEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, schemaAttributeEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(schemaAttributeEntity.getProperties());
                    tabularColumnProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    tabularColumnProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    tabularColumnProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    tabularColumnProperties.setDescription(this.removeDescription(instanceProperties));
                    tabularColumnProperties.setElementPosition(this.removePosition(instanceProperties));
                    tabularColumnProperties.setMinCardinality(this.removeMinCardinality(instanceProperties));
                    tabularColumnProperties.setMaxCardinality(this.removeMaxCardinality(instanceProperties));
                    tabularColumnProperties.setAllowsDuplicateValues(this.removeAllowsDuplicateValues(instanceProperties));
                    tabularColumnProperties.setOrderedValues(this.removeOrderedValues(instanceProperties));
                    tabularColumnProperties.setDefaultValueOverride(this.removeDefaultValueOverride(instanceProperties));
                    tabularColumnProperties.setSortOrder(this.removeSortOrder(instanceProperties));
                    tabularColumnProperties.setMinimumLength(this.removeMinimumLength(instanceProperties));
                    tabularColumnProperties.setLength(this.removeLength(instanceProperties));
                    tabularColumnProperties.setPrecision(this.removePrecision(instanceProperties));
                    tabularColumnProperties.setIsNullable(this.removeIsNullable(instanceProperties));
                    tabularColumnProperties.setNativeJavaClass(this.removeNativeClass(instanceProperties));
                    tabularColumnProperties.setAliases(this.removeAliases(instanceProperties));
                    tabularColumnProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    tabularColumnProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    if (schemaType instanceof SchemaTypeElement) {
                        SchemaTypeProperties schemaTypeProperties = ((SchemaTypeElement)schemaType).getSchemaTypeProperties();
                        super.addSchemaTypeToColumn(schemaTypeProperties, tabularColumnProperties);
                    }
                    bean.setTabularColumnProperties(tabularColumnProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

