/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.converters;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.converters.DataManagerOMASConverter;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ComplexSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EnumSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ExternalSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeConverter<B>
extends DataManagerOMASConverter<B> {
    public SchemaTypeConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewSchemaTypeBean(Class<B> beanClass, InstanceHeader schemaRootHeader, String schemaTypeTypeName, InstanceProperties instanceProperties, List<Classification> schemaRootClassifications, int attributeCount, String validValueSetGUID, B externalSchemaType, B mapFromSchemaType, B mapToSchemaType, List<B> schemaTypeOptions, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof SchemaTypeElement) {
                if (schemaRootHeader != null && instanceProperties != null) {
                    SchemaTypeElement bean = (SchemaTypeElement)returnBean;
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, schemaRootHeader, schemaRootClassifications, methodName));
                    bean.setSchemaTypeProperties(this.getSchemaTypeProperties(beanClass, schemaTypeTypeName, instanceProperties, schemaRootClassifications, attributeCount, validValueSetGUID, externalSchemaType, mapFromSchemaType, mapToSchemaType, schemaTypeOptions, methodName));
                    return returnBean;
                }
                this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
            }
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
        }
        return null;
    }

    private SchemaTypeProperties getSchemaTypeProperties(Class<B> beanClass, String schemaTypeTypeName, InstanceProperties instanceProperties, List<Classification> schemaRootClassifications, int attributeCount, String validValueSetGUID, B externalSchemaType, B mapFromSchemaType, B mapToSchemaType, List<B> schemaTypeOptions, String methodName) throws PropertyServerException {
        SchemaTypeProperties returnBean = null;
        if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "PrimitiveSchemaType")) {
            returnBean = this.getPrimitiveSchemaType(instanceProperties);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "LiteralSchemaType")) {
            returnBean = this.getLiteralSchemaType(instanceProperties);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "ComplexSchemaType")) {
            returnBean = this.getComplexSchemaType(instanceProperties, attributeCount);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "LiteralSchemaType")) {
            returnBean = this.getEnumSchemaType(instanceProperties, validValueSetGUID);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "MapSchemaType")) {
            returnBean = this.getMapSchemaType(instanceProperties, mapFromSchemaType, mapToSchemaType);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "SchemaTypeChoice")) {
            returnBean = this.getSchemaTypeChoice(instanceProperties, schemaTypeOptions);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "ExternalSchemaType")) {
            returnBean = this.getExternalSchemaType(instanceProperties, externalSchemaType);
        } else {
            super.validateInstanceType("SchemaType", beanClass.getName(), schemaTypeTypeName, methodName);
        }
        if (returnBean != null) {
            InstanceProperties classificationProperties = super.getClassificationProperties("CalculatedValue", schemaRootClassifications);
            returnBean.setFormula(this.getFormula(classificationProperties));
        }
        return returnBean;
    }

    private SchemaTypeProperties getLiteralSchemaType(InstanceProperties instanceProperties) {
        LiteralSchemaTypeProperties schemaType = new LiteralSchemaTypeProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        schemaType.setDataType(this.removeDataType(propertiesCopy));
        schemaType.setFixedValue(this.removeFixedValue(propertiesCopy));
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private SchemaTypeProperties getPrimitiveSchemaType(InstanceProperties instanceProperties) {
        PrimitiveSchemaTypeProperties schemaType = new PrimitiveSchemaTypeProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        schemaType.setDataType(this.removeDataType(propertiesCopy));
        schemaType.setDefaultValue(this.removeDefaultValue(propertiesCopy));
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private SchemaTypeProperties getComplexSchemaType(InstanceProperties instanceProperties, int attributeCount) {
        ComplexSchemaTypeProperties schemaType = new ComplexSchemaTypeProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        schemaType.setAttributeCount(attributeCount);
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private SchemaTypeProperties getEnumSchemaType(InstanceProperties instanceProperties, String validValueSetGUID) {
        EnumSchemaTypeProperties schemaType = new EnumSchemaTypeProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        schemaType.setDataType(this.removeDataType(propertiesCopy));
        schemaType.setDefaultValue(this.removeDefaultValue(propertiesCopy));
        schemaType.setValidValueSetGUID(validValueSetGUID);
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private SchemaTypeProperties getSchemaTypeChoice(InstanceProperties instanceProperties, List<B> schemaTypeOptions) {
        SchemaTypeChoiceProperties schemaType = new SchemaTypeChoiceProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        if (schemaTypeOptions != null && !schemaTypeOptions.isEmpty()) {
            ArrayList<SchemaTypeProperties> schemaTypeOptionBeans = new ArrayList<SchemaTypeProperties>();
            for (B optionBean : schemaTypeOptions) {
                if (optionBean == null) continue;
                schemaTypeOptionBeans.add((SchemaTypeProperties)optionBean);
            }
            if (!schemaTypeOptionBeans.isEmpty()) {
                schemaType.setSchemaOptions(schemaTypeOptionBeans);
            }
        }
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private SchemaTypeProperties getExternalSchemaType(InstanceProperties instanceProperties, B externalSchemaType) {
        ExternalSchemaTypeProperties schemaType = new ExternalSchemaTypeProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        if (externalSchemaType != null) {
            schemaType.setExternalSchemaType((SchemaTypeProperties)externalSchemaType);
        }
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private SchemaTypeProperties getMapSchemaType(InstanceProperties instanceProperties, B mapFromSchemaType, B mapToSchemaType) {
        MapSchemaTypeProperties schemaType = new MapSchemaTypeProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        if (mapFromSchemaType != null) {
            schemaType.setMapFromElement((SchemaTypeProperties)mapFromSchemaType);
        }
        if (mapToSchemaType != null) {
            schemaType.setMapFromElement((SchemaTypeProperties)mapFromSchemaType);
        }
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private void updateBasicSchemaTypeProperties(SchemaTypeProperties bean, InstanceProperties instanceProperties) {
        bean.setDisplayName(this.removeDisplayName(instanceProperties));
        bean.setDescription(this.removeDescription(instanceProperties));
        bean.setIsDeprecated(this.removeIsDeprecated(instanceProperties));
        bean.setVersionNumber(this.removeVersionNumber(instanceProperties));
        bean.setAuthor(this.removeAuthor(instanceProperties));
        bean.setUsage(this.removeUsage(instanceProperties));
        bean.setEncodingStandard(this.removeEncodingStandard(instanceProperties));
        bean.setNamespace(this.removeNamespace(instanceProperties));
        bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
    }
}

