/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SoftwareServerCapabilityElement;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseManagerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileManagerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileSystemRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.LoggerFactory;

public class DataManagerRESTServices {
    private static DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DataManagerRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public ConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createFileSystemInCatalog(String serverName, String userId, FileSystemRequestBody requestBody) {
        String methodName = "createFileSystemInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFileSystemInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFileSystemInCatalog");
            if (requestBody != null) {
                SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createFileSystemInCatalog");
                response.setGUID(handler.createFileSystem(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getFormat(), requestBody.getEncryption(), requestBody.getAdditionalProperties(), requestBody.getVendorProperties(), "createFileSystemInCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createFileSystemInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createFileManagerInCatalog(String serverName, String userId, FileManagerRequestBody requestBody) {
        String methodName = "createFileSystemInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFileSystemInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFileSystemInCatalog");
            if (requestBody != null) {
                SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createFileSystemInCatalog");
                response.setGUID(handler.createSoftwareServerCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", "FileManager", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getVendorProperties(), "createFileSystemInCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createFileSystemInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseManagerInCatalog(String serverName, String userId, DatabaseManagerRequestBody requestBody) {
        String methodName = "createDataManagerIntegrator";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDataManagerIntegrator");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataManagerIntegrator");
            SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createDataManagerIntegrator");
            response.setGUID(handler.createSoftwareServerCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", "DatabaseManager", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getVendorProperties(), "createDataManagerIntegrator"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDataManagerIntegrator", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getMetadataSourceGUID(String serverName, String userId, String qualifiedName) {
        String methodName = "getMetadataSourceGUID";
        String parameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataSourceGUID");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataSourceGUID");
            SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "getMetadataSourceGUID");
            response.setGUID(handler.getBeanGUIDByQualifiedName(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", qualifiedName, "qualifiedName", "getMetadataSourceGUID"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getMetadataSourceGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

