/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFileElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileSystemElement;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFileRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFileResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFolderRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileFolderResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileSystemResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.PathNameRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.FilesAndFoldersHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.LoggerFactory;

public class FilesRESTServices {
    private static DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(FilesRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public GUIDListResponse createFolderStructureInCatalog(String serverName, String userId, String parentGUID, PathNameRequestBody requestBody) {
        String requestBodyParameterName = "requestBody";
        String methodName = "createFolderStructureInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFolderStructureInCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFolderStructureInCatalog");
            this.invalidParameterHandler.validateObject((Object)requestBody, "requestBody", "createFolderStructureInCatalog");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "createFolderStructureInCatalog");
            response.setGUIDs(handler.createFolderStructureInCatalog(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentGUID, requestBody.getFullPath(), "createFolderStructureInCatalog"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createFolderStructureInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse createFolderStructureInCatalog(String serverName, String userId, String fileSystemGUID, String fileSystemName, PathNameRequestBody requestBody) {
        String requestBodyParameterName = "requestBody";
        String methodName = "createFolderStructureInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFolderStructureInCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFolderStructureInCatalog");
            this.invalidParameterHandler.validateObject((Object)requestBody, "requestBody", "createFolderStructureInCatalog");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "createFolderStructureInCatalog");
            response.setGUIDs(handler.createFolderStructureInCatalog(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), fileSystemGUID, fileSystemName, requestBody.getFullPath(), "createFolderStructureInCatalog"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createFolderStructureInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachFolderToFileSystem(String serverName, String userId, String fileSystemGUID, String folderGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "attachFolderToFileSystem";
        String fileSystemGUIDParameterName = "fileSystemGUID";
        String folderGUIDParameterName = "folderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachFolderToFileSystem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachFolderToFileSystem");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "attachFolderToFileSystem");
            String externalSourceGUID = null;
            String externalSourceName = null;
            if (requestBody != null) {
                externalSourceGUID = requestBody.getExternalSourceGUID();
                externalSourceName = requestBody.getExternalSourceName();
            }
            handler.attachFolderToFileSystem(userId, externalSourceGUID, externalSourceName, fileSystemGUID, "fileSystemGUID", folderGUID, "folderGUID", "attachFolderToFileSystem");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "attachFolderToFileSystem", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachFolderFromFileSystem(String serverName, String userId, String fileSystemGUID, String folderGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "detachFolderFromFileSystem";
        String fileSystemGUIDParameterName = "fileSystemGUID";
        String folderGUIDParameterName = "folderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachFolderFromFileSystem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachFolderFromFileSystem");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "detachFolderFromFileSystem");
            String externalSourceGUID = null;
            String externalSourceName = null;
            if (requestBody != null) {
                externalSourceGUID = requestBody.getExternalSourceGUID();
                externalSourceName = requestBody.getExternalSourceName();
            }
            handler.detachFolderFromFileSystem(userId, externalSourceGUID, externalSourceName, fileSystemGUID, "fileSystemGUID", folderGUID, "folderGUID", "detachFolderFromFileSystem");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "detachFolderFromFileSystem", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse addDataFileToCatalog(String serverName, String userId, String fileSystemGUID, String fileSystemName, DataFileRequestBody requestBody) {
        String requestBodyParameterName = "requestBody";
        String methodName = "addFileToCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addFileToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addFileToCatalog");
            this.invalidParameterHandler.validateObject((Object)requestBody, "requestBody", "addFileToCatalog");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addFileToCatalog");
            response.setGUIDs(handler.addFileToCatalog(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), fileSystemGUID, fileSystemName, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getConnectorProviderClassName(), requestBody.getTypeName(), requestBody.getExtendedProperties(), "addFileToCatalog"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addFileToCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse addDataFolderAssetToCatalog(String serverName, String userId, String fileSystemGUID, String fileSystemName, DataFolderRequestBody requestBody) {
        String requestBodyParameterName = "requestBody";
        String methodName = "addDataFileAssetToCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addDataFileAssetToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addDataFileAssetToCatalog");
            this.invalidParameterHandler.validateObject((Object)requestBody, "requestBody", "addDataFileAssetToCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addDataFileAssetToCatalog");
                response.setGUIDs(handler.addDataFolderAssetToCatalog(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), fileSystemGUID, fileSystemName, requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getQualifiedName(), "addDataFileAssetToCatalog"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addDataFileAssetToCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachDataFileAssetToFolder(String serverName, String userId, String folderGUID, String fileGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "attachDataFileAssetToFolder";
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachDataFileAssetToFolder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachDataFileAssetToFolder");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "attachDataFileAssetToFolder");
            String externalSourceGUID = null;
            String externalSourceName = null;
            if (requestBody != null) {
                externalSourceGUID = requestBody.getExternalSourceGUID();
                externalSourceName = requestBody.getExternalSourceName();
            }
            handler.attachDataFileAssetToFolder(userId, externalSourceGUID, externalSourceName, folderGUID, "folderGUID", fileGUID, "fileGUID", "attachDataFileAssetToFolder");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "attachDataFileAssetToFolder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachDataFileAssetFromFolder(String serverName, String userId, String folderGUID, String fileGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "detachDataFileAssetFromFolder";
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachDataFileAssetFromFolder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachDataFileAssetFromFolder");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "detachDataFileAssetFromFolder");
            String externalSourceGUID = null;
            String externalSourceName = null;
            if (requestBody != null) {
                externalSourceGUID = requestBody.getExternalSourceGUID();
                externalSourceName = requestBody.getExternalSourceName();
            }
            handler.detachDataFileAssetFromFolder(userId, externalSourceGUID, externalSourceName, folderGUID, "folderGUID", fileGUID, "fileGUID", "detachDataFileAssetFromFolder");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "detachDataFileAssetFromFolder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse moveDataFileInCatalog(String serverName, String userId, String folderGUID, String fileGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "moveDataFileInCatalog";
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "moveDataFileInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "moveDataFileInCatalog");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "moveDataFileInCatalog");
            String externalSourceGUID = null;
            String externalSourceName = null;
            if (requestBody != null) {
                externalSourceGUID = requestBody.getExternalSourceGUID();
                externalSourceName = requestBody.getExternalSourceName();
            }
            handler.moveDataFileInCatalog(userId, externalSourceGUID, externalSourceName, folderGUID, "folderGUID", fileGUID, "fileGUID", "moveDataFileInCatalog");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "moveDataFileInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse moveDataFolderInCatalog(String serverName, String userId, String newParentFolderGUID, String movingFolderGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "moveDataFileInCatalog";
        String newParentFolderGUIDParameterName = "newParentFolderGUID";
        String movingFolderGUIDParameterName = "movingFolderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "moveDataFileInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "moveDataFileInCatalog");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "moveDataFileInCatalog");
            String externalSourceGUID = null;
            String externalSourceName = null;
            if (requestBody != null) {
                externalSourceGUID = requestBody.getExternalSourceGUID();
                externalSourceName = requestBody.getExternalSourceName();
            }
            handler.moveDataFolderInCatalog(userId, externalSourceGUID, externalSourceName, newParentFolderGUID, "newParentFolderGUID", movingFolderGUID, "movingFolderGUID", "moveDataFileInCatalog");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "moveDataFileInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FileSystemResponse getFileSystemByGUID(String serverName, String userId, String fileSystemGUID) {
        String methodName = "getFileSystemByGUID";
        String guidParameterName = "fileSystemGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFileSystemByGUID");
        FileSystemResponse response = new FileSystemResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystemByGUID");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFileSystemByGUID");
            FileSystemElement element = (FileSystemElement)handler.getFileSystemByGUID(userId, fileSystemGUID, "fileSystemGUID", "getFileSystemByGUID");
            response.setFileSystem(element);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFileSystemByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FileSystemResponse getFileSystemByUniqueName(String serverName, String userId, String uniqueName) {
        String methodName = "getFileSystemByUniqueName";
        String parameterName = "uniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFileSystemByUniqueName");
        FileSystemResponse response = new FileSystemResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystemByUniqueName");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFileSystemByUniqueName");
            FileSystemElement element = (FileSystemElement)handler.getFileSystemByUniqueName(userId, uniqueName, "uniqueName", "getFileSystemByUniqueName");
            response.setFileSystem(element);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFileSystemByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getFileSystems(String serverName, String userId, int startingFrom, int maxPageSize) {
        String methodName = "getFileSystems";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFileSystems");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystems");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFileSystems");
            response.setGUIDs(handler.getFileSystems(userId, startingFrom, maxPageSize, "getFileSystems"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFileSystems", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FileFolderResponse getFolderByGUID(String serverName, String userId, String folderGUID) {
        String methodName = "getFolderByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFolderByGUID");
        FileFolderResponse response = new FileFolderResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderByGUID");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderByGUID");
            FileFolderElement fileFolder = (FileFolderElement)handler.getFolderByGUID(userId, folderGUID, "getFolderByGUID");
            response.setFolder(fileFolder);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFolderByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FileFolderResponse getFolderByPathName(String serverName, String userId, PathNameRequestBody requestBody) {
        String methodName = "getFolderByPathName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFolderByPathName");
        FileFolderResponse response = new FileFolderResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderByPathName");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderByPathName");
                FileFolderElement fileFolder = (FileFolderElement)handler.getFolderByPathName(userId, requestBody.getFullPath(), "getFolderByPathName");
                response.setFolder(fileFolder);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFolderByPathName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getNestedFolders(String serverName, String userId, String parentFolderGUID, int startingFrom, int maxPageSize) {
        String methodName = "getNestedFolders";
        String guidParameterName = "parentFolderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNestedFolders");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNestedFolders");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getNestedFolders");
            response.setGUIDs(handler.getNestedFolders(userId, parentFolderGUID, "parentFolderGUID", startingFrom, maxPageSize, "getNestedFolders"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getNestedFolders", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getFolderFiles(String serverName, String userId, String folderGUID, int startingFrom, int maxPageSize) {
        String methodName = "getFolderFiles";
        String guidParameterName = "folderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFolderFiles");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderFiles");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderFiles");
            response.setGUIDs(handler.getFolderFiles(userId, folderGUID, "folderGUID", startingFrom, maxPageSize, "getFolderFiles"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getFolderFiles", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFileResponse getDataFileByGUID(String serverName, String userId, String fileGUID) {
        String methodName = "getDataFileByGUID";
        String guidParameterName = "fileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFileByGUID");
        DataFileResponse response = new DataFileResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFileByGUID");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getDataFileByGUID");
            DataFileElement dataFile = (DataFileElement)handler.getDataFileByGUID(userId, fileGUID, "fileGUID", "getDataFileByGUID");
            response.setDataFile(dataFile);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDataFileByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFileResponse getDataFileByPathName(String serverName, String userId, PathNameRequestBody requestBody) {
        String methodName = "getDataFileByPathName";
        String nameParameterName = "fullPath";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFileByPathName");
        DataFileResponse response = new DataFileResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFileByPathName");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getDataFileByPathName");
                DataFileElement dataFile = (DataFileElement)handler.getDataFileByPathName(userId, requestBody.getFullPath(), "fullPath", "getDataFileByPathName");
                response.setDataFile(dataFile);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDataFileByPathName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

