/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.connectors.outtopic.DataManagerOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.datamanager.connectors.outtopic.DataManagerOutTopicServerProvider;
import org.odpi.openmetadata.accessservices.datamanager.ffdc.DataManagerAuditCode;
import org.odpi.openmetadata.accessservices.datamanager.listener.DataManagerOMRSTopicListener;
import org.odpi.openmetadata.accessservices.datamanager.outtopic.DataManagerOutTopicPublisher;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DataManagerAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private DataManagerServicesInstance instance = null;
    private OpenMetadataTopicConnector inTopicConnector = null;
    private String serverName = null;
    private DataManagerOutTopicPublisher eventPublisher = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "Initialize Data Manager OMAS service.";
        auditLog.logMessage("Initialize Data Manager OMAS service.", DataManagerAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List defaultZones = this.extractDefaultZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List publishZones = this.extractPublishZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new DataManagerServicesInstance(repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize(), accessServiceConfig.getAccessServiceOutTopic());
            this.serverName = this.instance.getServerName();
            if (accessServiceConfig.getAccessServiceOutTopic() != null) {
                Connection outTopicEventBusConnection = accessServiceConfig.getAccessServiceOutTopic();
                Endpoint endpoint = outTopicEventBusConnection.getEndpoint();
                AuditLog outTopicAuditLog = auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_OUT_TOPIC);
                Connection serverSideOutTopicConnection = this.getOutTopicConnection(accessServiceConfig.getAccessServiceOutTopic(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceFullName(), DataManagerOutTopicServerProvider.class.getName(), auditLog);
                DataManagerOutTopicServerConnector outTopicServerConnector = (DataManagerOutTopicServerConnector)super.getTopicConnector(serverSideOutTopicConnection, DataManagerOutTopicServerConnector.class, outTopicAuditLog, AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceFullName(), "Initialize Data Manager OMAS service.");
                this.eventPublisher = new DataManagerOutTopicPublisher(outTopicServerConnector, endpoint.getAddress(), outTopicAuditLog);
                this.registerWithEnterpriseTopic(AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceFullName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)new DataManagerOMRSTopicListener(AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceFullName(), this.eventPublisher, supportedZones, repositoryConnector.getRepositoryHelper(), outTopicAuditLog), auditLog);
            }
            if (accessServiceConfig.getAccessServiceInTopic() != null) {
                this.inTopicConnector = super.getInTopicEventBusConnector(accessServiceConfig.getAccessServiceInTopic(), AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceFullName(), auditLog);
            }
            auditLog.logMessage("Initialize Data Manager OMAS service.", DataManagerAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}), accessServiceConfig.toString());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            auditLog.logException("Initialize Data Manager OMAS service.", DataManagerAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), accessServiceConfig.toString(), error);
            super.throwUnexpectedInitializationException("Initialize Data Manager OMAS service.", AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceFullName(), error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        try {
            if (this.inTopicConnector != null) {
                this.inTopicConnector.disconnect();
            }
        }
        catch (ConnectorCheckedException error) {
            this.auditLog.logException("shutdown", DataManagerAuditCode.SERVICE_INSTANCE_TERMINATION_FAILURE.getMessageDefinition(new String[]{this.serverName}), (Throwable)error);
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.disconnect();
        }
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", DataManagerAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

