/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseTableElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseViewElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataItemSortOrder;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseForeignKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabasePrimaryKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseQueryProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseSchemaProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseTableProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseViewProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.datamanager.properties.OwnerCategory;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseColumnResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseColumnsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseSchemaResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseSchemasResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseTableResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseTablesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseViewResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseViewsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabasesResponse;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.RelationalDataHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.LoggerFactory;

public class DatabaseManagerRESTServices {
    private static DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DatabaseManagerRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createDatabase(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, DatabaseProperties databaseProperties) {
        String methodName = "createDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabase");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabase");
            int ownerCategory = OwnerCategory.USER_ID.getOpenTypeOrdinal();
            if (databaseProperties.getOwnerCategory() != null) {
                ownerCategory = databaseProperties.getOwnerCategory().getOpenTypeOrdinal();
            }
            String databaseGUID = handler.createDatabase(userId, databaseManagerGUID, databaseManagerName, databaseProperties.getQualifiedName(), databaseProperties.getDisplayName(), databaseProperties.getDescription(), databaseProperties.getOwner(), ownerCategory, databaseProperties.getZoneMembership(), databaseProperties.getOriginOrganizationGUID(), databaseProperties.getOriginBusinessCapabilityGUID(), databaseProperties.getOtherOriginValues(), databaseProperties.getCreateTime(), databaseProperties.getModifiedTime(), databaseProperties.getEncodingType(), databaseProperties.getEncodingLanguage(), databaseProperties.getEncodingDescription(), databaseProperties.getEncodingProperties(), databaseProperties.getDatabaseType(), databaseProperties.getDatabaseVersion(), databaseProperties.getDatabaseInstance(), databaseProperties.getDatabaseImportedFrom(), databaseProperties.getAdditionalProperties(), databaseProperties.getTypeName(), databaseProperties.getExtendedProperties(), databaseProperties.getVendorProperties(), "createDatabase");
            response.setGUID(databaseGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseFromTemplate(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, TemplateProperties templateProperties) {
        String methodName = "createDatabaseFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseFromTemplate");
            response.setGUID(handler.createDatabaseFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), "createDatabaseFromTemplate"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDatabaseFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabase(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, DatabaseProperties databaseProperties) {
        String methodName = "updateDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabase");
            int ownerCategory = OwnerCategory.USER_ID.getOpenTypeOrdinal();
            if (databaseProperties.getOwnerCategory() != null) {
                ownerCategory = databaseProperties.getOwnerCategory().getOpenTypeOrdinal();
            }
            handler.updateDatabase(userId, databaseManagerGUID, databaseManagerName, databaseGUID, databaseProperties.getQualifiedName(), databaseProperties.getDisplayName(), databaseProperties.getDescription(), databaseProperties.getOwner(), ownerCategory, databaseProperties.getZoneMembership(), databaseProperties.getOriginOrganizationGUID(), databaseProperties.getOriginBusinessCapabilityGUID(), databaseProperties.getOtherOriginValues(), databaseProperties.getCreateTime(), databaseProperties.getModifiedTime(), databaseProperties.getEncodingType(), databaseProperties.getEncodingLanguage(), databaseProperties.getEncodingDescription(), databaseProperties.getEncodingProperties(), databaseProperties.getDatabaseType(), databaseProperties.getDatabaseVersion(), databaseProperties.getDatabaseInstance(), databaseProperties.getDatabaseImportedFrom(), databaseProperties.getAdditionalProperties(), databaseProperties.getTypeName(), databaseProperties.getExtendedProperties(), databaseProperties.getVendorProperties(), "updateDatabase");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishDatabase(String serverName, String userId, String databaseGUID, NullRequestBody nullRequestBody) {
        String methodName = "publishDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "publishDatabase");
            handler.publishDatabase(userId, databaseGUID, "publishDatabase");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "publishDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawDatabase(String serverName, String userId, String databaseGUID, NullRequestBody nullRequestBody) {
        String methodName = "withdrawDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "withdrawDatabase");
            handler.withdrawDatabase(userId, databaseGUID, "withdrawDatabase");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "withdrawDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabase(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, String qualifiedName, NullRequestBody nullRequestBody) {
        String methodName = "removeDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabase");
            handler.removeDatabase(userId, databaseManagerGUID, databaseManagerName, databaseGUID, qualifiedName, "removeDatabase");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removeDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabasesResponse findDatabases(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findDatabases";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabases");
        DatabasesResponse response = new DatabasesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabases");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabases");
            List databaseAssets = handler.findDatabases(userId, searchString, startFrom, pageSize, "findDatabases");
            response.setElementList(databaseAssets);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findDatabases", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabasesResponse getDatabasesByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getDatabasesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabasesByName");
        DatabasesResponse response = new DatabasesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabasesByName");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabasesByName");
            List databaseAssets = handler.getDatabasesByName(userId, name, startFrom, pageSize, "getDatabasesByName");
            response.setElementList(databaseAssets);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDatabasesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabasesResponse getDatabasesForDatabaseManager(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, int startFrom, int pageSize) {
        String methodName = "getDatabasesForDatabaseManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabasesForDatabaseManager");
        DatabasesResponse response = new DatabasesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabasesForDatabaseManager");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabasesForDatabaseManager");
            List databaseAssets = handler.getDatabasesForDatabaseManager(userId, databaseManagerGUID, databaseManagerName, startFrom, pageSize, "getDatabasesForDatabaseManager");
            response.setElementList(databaseAssets);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDatabasesForDatabaseManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseResponse getDatabaseByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseByGUID");
        DatabaseResponse response = new DatabaseResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseByGUID");
            DatabaseElement databaseAsset = (DatabaseElement)handler.getDatabaseByGUID(userId, guid, "getDatabaseByGUID");
            response.setElement(databaseAsset);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDatabaseByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseSchema(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, DatabaseSchemaProperties databaseSchemaProperties) {
        String methodName = "createDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseSchema");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseSchema");
            int ownerCategory = OwnerCategory.USER_ID.getOpenTypeOrdinal();
            if (databaseSchemaProperties.getOwnerCategory() != null) {
                ownerCategory = databaseSchemaProperties.getOwnerCategory().getOpenTypeOrdinal();
            }
            String databaseSchemaGUID = handler.createDatabaseSchema(userId, databaseManagerGUID, databaseManagerName, databaseGUID, databaseSchemaProperties.getQualifiedName(), databaseSchemaProperties.getDisplayName(), databaseSchemaProperties.getDescription(), databaseSchemaProperties.getOwner(), ownerCategory, databaseSchemaProperties.getZoneMembership(), databaseSchemaProperties.getOriginOrganizationGUID(), databaseSchemaProperties.getOriginBusinessCapabilityGUID(), databaseSchemaProperties.getOtherOriginValues(), databaseSchemaProperties.getAdditionalProperties(), databaseSchemaProperties.getTypeName(), databaseSchemaProperties.getExtendedProperties(), databaseSchemaProperties.getVendorProperties(), "createDatabaseSchema");
            response.setGUID(databaseSchemaGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseSchemaFromTemplate(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseGUID, TemplateProperties templateProperties) {
        String methodName = "createDatabaseSchemaFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseSchemaFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseSchemaFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseSchemaFromTemplate");
            response.setGUID(handler.createDatabaseSchemaFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, databaseGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), "createDatabaseSchemaFromTemplate"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDatabaseSchemaFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabaseSchema(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, DatabaseSchemaProperties databaseSchemaProperties) {
        String methodName = "updateDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabaseSchema");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabaseSchema");
            int ownerCategory = OwnerCategory.USER_ID.getOpenTypeOrdinal();
            if (databaseSchemaProperties.getOwnerCategory() != null) {
                ownerCategory = databaseSchemaProperties.getOwnerCategory().getOpenTypeOrdinal();
            }
            handler.updateDatabaseSchema(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, databaseSchemaProperties.getQualifiedName(), databaseSchemaProperties.getDisplayName(), databaseSchemaProperties.getDescription(), databaseSchemaProperties.getOwner(), ownerCategory, databaseSchemaProperties.getZoneMembership(), databaseSchemaProperties.getOriginOrganizationGUID(), databaseSchemaProperties.getOriginBusinessCapabilityGUID(), databaseSchemaProperties.getOtherOriginValues(), databaseSchemaProperties.getAdditionalProperties(), databaseSchemaProperties.getTypeName(), databaseSchemaProperties.getExtendedProperties(), databaseSchemaProperties.getVendorProperties(), "updateDatabaseSchema");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishDatabaseSchema(String serverName, String userId, String databaseSchemaGUID, NullRequestBody nullRequestBody) {
        String methodName = "publishDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishDatabaseSchema");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "publishDatabaseSchema");
            handler.publishDatabaseSchema(userId, databaseSchemaGUID, "publishDatabaseSchema");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "publishDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawDatabaseSchema(String serverName, String userId, String databaseSchemaGUID, NullRequestBody nullRequestBody) {
        String methodName = "withdrawDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "withdrawDatabase");
            handler.withdrawDatabaseSchema(userId, databaseSchemaGUID, "withdrawDatabase");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "withdrawDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabaseSchema(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, String qualifiedName, NullRequestBody nullRequestBody) {
        String methodName = "removeDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabaseSchema");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabaseSchema");
            handler.removeDatabaseSchema(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, qualifiedName, "removeDatabaseSchema");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removeDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseSchemasResponse findDatabaseSchemas(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findDatabaseSchemas";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabaseSchemas");
        DatabaseSchemasResponse response = new DatabaseSchemasResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabaseSchemas");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabaseSchemas");
            List databaseSchemaAssets = handler.findDatabaseSchemas(userId, searchString, startFrom, pageSize, "findDatabaseSchemas");
            response.setElementList(databaseSchemaAssets);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findDatabaseSchemas", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseSchemasResponse getSchemasForDatabase(String serverName, String userId, String databaseGUID, int startFrom, int pageSize) {
        String methodName = "getSchemasForDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemasForDatabase");
        DatabaseSchemasResponse response = new DatabaseSchemasResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemasForDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getSchemasForDatabase");
            List databaseSchemaAssets = handler.getSchemasForDatabase(userId, databaseGUID, startFrom, pageSize, "getSchemasForDatabase");
            response.setElementList(databaseSchemaAssets);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getSchemasForDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseSchemasResponse getDatabaseSchemasByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getDatabaseSchemasByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseSchemasByName");
        DatabaseSchemasResponse response = new DatabaseSchemasResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseSchemasByName");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseSchemasByName");
            List databaseSchemaAssets = handler.getDatabaseSchemasByName(userId, name, startFrom, pageSize, "getDatabaseSchemasByName");
            response.setElementList(databaseSchemaAssets);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDatabaseSchemasByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseSchemaResponse getDatabaseSchemaByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseSchemaByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseSchemaByGUID");
        DatabaseSchemaResponse response = new DatabaseSchemaResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseSchemaByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseSchemaByGUID");
            DatabaseSchemaElement databaseSchemaAsset = (DatabaseSchemaElement)handler.getDatabaseSchemaByGUID(userId, guid, "getDatabaseSchemaByGUID");
            response.setElement(databaseSchemaAsset);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDatabaseSchemaByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseTable(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, DatabaseTableProperties databaseTableProperties) {
        String methodName = "createDatabaseTable";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseTable");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseTable");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseTable");
            String databaseTableGUID = handler.createDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, databaseTableProperties.getQualifiedName(), databaseTableProperties.getDisplayName(), databaseTableProperties.getDescription(), databaseTableProperties.getIsDeprecated(), databaseTableProperties.getAliases(), databaseTableProperties.getAdditionalProperties(), databaseTableProperties.getTypeName(), databaseTableProperties.getExtendedProperties(), databaseTableProperties.getVendorProperties(), "createDatabaseTable");
            response.setGUID(databaseTableGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDatabaseTable", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseTableFromTemplate(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseSchemaGUID, TemplateProperties templateProperties) {
        String methodName = "createDatabaseTableFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseTableFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseTableFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseTableFromTemplate");
            response.setGUID(handler.createDatabaseTableFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, databaseSchemaGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), "createDatabaseTableFromTemplate"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDatabaseTableFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabaseTable(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, DatabaseTableProperties databaseTableProperties) {
        String methodName = "updateDatabaseTable";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabaseTable");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabaseTable");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabaseTable");
            handler.updateDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, databaseTableProperties.getQualifiedName(), databaseTableProperties.getDisplayName(), databaseTableProperties.getDescription(), databaseTableProperties.getIsDeprecated(), databaseTableProperties.getAliases(), databaseTableProperties.getAdditionalProperties(), databaseTableProperties.getTypeName(), databaseTableProperties.getExtendedProperties(), databaseTableProperties.getVendorProperties(), "updateDatabaseTable");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateDatabaseTable", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabaseTable(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, String qualifiedName, NullRequestBody nullRequestBody) {
        String methodName = "removeDatabaseTable";
        String elementGUIDParameterName = "databaseTableGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabaseTable");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabaseTable");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabaseTable");
            handler.removeDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, "databaseTableGUID", qualifiedName, "removeDatabaseTable");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removeDatabaseTable", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseTablesResponse findDatabaseTables(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findDatabaseTables";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabaseTables");
        DatabaseTablesResponse response = new DatabaseTablesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabaseTables");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabaseTables");
            List databaseTableAttributes = handler.findDatabaseTables(userId, searchString, startFrom, pageSize, "findDatabaseTables");
            response.setElementList(databaseTableAttributes);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findDatabaseTables", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseTablesResponse getTablesForDatabaseSchema(String serverName, String userId, String databaseSchemaGUID, int startFrom, int pageSize) {
        String methodName = "getTablesForDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTablesForDatabaseSchema");
        DatabaseTablesResponse response = new DatabaseTablesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTablesForDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getTablesForDatabaseSchema");
            List databaseTableAttributes = handler.getTablesForDatabaseSchema(userId, databaseSchemaGUID, startFrom, pageSize, "getTablesForDatabaseSchema");
            response.setElementList(databaseTableAttributes);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getTablesForDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseTablesResponse getDatabaseTablesByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getDatabaseTablesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseTablesByName");
        DatabaseTablesResponse response = new DatabaseTablesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseTablesByName");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseTablesByName");
            List databaseTableAttributes = handler.getDatabaseTablesByName(userId, name, startFrom, pageSize, "getDatabaseTablesByName");
            response.setElementList(databaseTableAttributes);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDatabaseTablesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseTableResponse getDatabaseTableByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseTableByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseTableByGUID");
        DatabaseTableResponse response = new DatabaseTableResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseTableByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseTableByGUID");
            DatabaseTableElement databaseTableAttribute = (DatabaseTableElement)handler.getDatabaseTableByGUID(userId, guid, "getDatabaseTableByGUID");
            response.setElement(databaseTableAttribute);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDatabaseTableByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseView(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, DatabaseViewProperties databaseViewProperties) {
        String methodName = "createDatabaseView";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseView");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseView");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseView");
            String databaseViewGUID = handler.createDatabaseView(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, databaseViewProperties.getQualifiedName(), databaseViewProperties.getDisplayName(), databaseViewProperties.getDescription(), databaseViewProperties.getIsDeprecated(), databaseViewProperties.getAliases(), databaseViewProperties.getFormula(), databaseViewProperties.getAdditionalProperties(), databaseViewProperties.getTypeName(), databaseViewProperties.getExtendedProperties(), databaseViewProperties.getVendorProperties(), "createDatabaseView");
            response.setGUID(databaseViewGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDatabaseView", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseViewFromTemplate(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseSchemaGUID, TemplateProperties templateProperties) {
        String methodName = "createDatabaseViewFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseViewFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseViewFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseViewFromTemplate");
            response.setGUID(handler.createDatabaseViewFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, databaseSchemaGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), "createDatabaseViewFromTemplate"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDatabaseViewFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabaseView(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseViewGUID, DatabaseViewProperties databaseViewProperties) {
        String methodName = "updateDatabaseView";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabaseView");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabaseView");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabaseView");
            handler.updateDatabaseView(userId, databaseManagerGUID, databaseManagerName, databaseViewGUID, databaseViewProperties.getQualifiedName(), databaseViewProperties.getDisplayName(), databaseViewProperties.getDescription(), databaseViewProperties.getIsDeprecated(), databaseViewProperties.getAliases(), databaseViewProperties.getFormula(), databaseViewProperties.getAdditionalProperties(), databaseViewProperties.getTypeName(), databaseViewProperties.getExtendedProperties(), databaseViewProperties.getVendorProperties(), "updateDatabaseView");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateDatabaseView", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabaseView(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseViewGUID, String qualifiedName, NullRequestBody nullRequestBody) {
        String methodName = "removeDatabaseView";
        String elementGUIDParameterName = "databaseViewGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabaseView");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabaseView");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabaseView");
            handler.removeDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseViewGUID, "databaseViewGUID", qualifiedName, "removeDatabaseView");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removeDatabaseView", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseViewsResponse findDatabaseViews(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findDatabaseViews";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabaseViews");
        DatabaseViewsResponse response = new DatabaseViewsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabaseViews");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabaseViews");
            List databaseViewAttributes = handler.findDatabaseViews(userId, searchString, startFrom, pageSize, "findDatabaseViews");
            response.setElementList(databaseViewAttributes);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findDatabaseViews", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseViewsResponse getViewsForDatabaseSchema(String serverName, String userId, String databaseSchemaGUID, int startFrom, int pageSize) {
        String methodName = "getViewsForDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getViewsForDatabaseSchema");
        DatabaseViewsResponse response = new DatabaseViewsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getViewsForDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getViewsForDatabaseSchema");
            List databaseViewAttributes = handler.getViewsForDatabaseSchema(userId, databaseSchemaGUID, startFrom, pageSize, "getViewsForDatabaseSchema");
            response.setElementList(databaseViewAttributes);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getViewsForDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseViewsResponse getDatabaseViewsByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getDatabaseViewsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseViewsByName");
        DatabaseViewsResponse response = new DatabaseViewsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseViewsByName");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseViewsByName");
            List databaseViewAttributes = handler.getDatabaseViewsByName(userId, name, startFrom, pageSize, "getDatabaseViewsByName");
            response.setElementList(databaseViewAttributes);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDatabaseViewsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseViewResponse getDatabaseViewByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseViewByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseViewByGUID");
        DatabaseViewResponse response = new DatabaseViewResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseViewByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseViewByGUID");
            DatabaseViewElement databaseViewAttribute = (DatabaseViewElement)handler.getDatabaseViewByGUID(userId, guid, "getDatabaseViewByGUID");
            response.setElement(databaseViewAttribute);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDatabaseViewByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseColumn(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, DatabaseColumnProperties databaseColumnProperties) {
        String methodName = "createDatabaseColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseColumn");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String databaseColumnGUID;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseColumn");
            int sortOrder = DataItemSortOrder.UNKNOWN.getOpenTypeOrdinal();
            if (databaseColumnProperties.getSortOrder() != null) {
                sortOrder = databaseColumnProperties.getSortOrder().getOpenTypeOrdinal();
            }
            if ((databaseColumnGUID = handler.createDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, databaseColumnProperties.getQualifiedName(), databaseColumnProperties.getDisplayName(), databaseColumnProperties.getDescription(), databaseColumnProperties.getExternalTypeGUID(), databaseColumnProperties.getDataType(), databaseColumnProperties.getDefaultValue(), databaseColumnProperties.getFixedValue(), databaseColumnProperties.getValidValuesSetGUID(), databaseColumnProperties.getFormula(), databaseColumnProperties.getIsDeprecated(), databaseColumnProperties.getElementPosition(), databaseColumnProperties.getMinCardinality(), databaseColumnProperties.getMaxCardinality(), databaseColumnProperties.getAllowsDuplicateValues(), databaseColumnProperties.getOrderedValues(), databaseColumnProperties.getDefaultValueOverride(), sortOrder, databaseColumnProperties.getMinimumLength(), databaseColumnProperties.getLength(), databaseColumnProperties.getPrecision(), databaseColumnProperties.getIsNullable(), databaseColumnProperties.getNativeJavaClass(), databaseColumnProperties.getAliases(), databaseColumnProperties.getAdditionalProperties(), databaseColumnProperties.getTypeName(), databaseColumnProperties.getExtendedProperties(), databaseColumnProperties.getVendorProperties(), "createDatabaseColumn")) != null && databaseColumnProperties.getQueries() != null) {
                for (DatabaseQueryProperties queryProperties : databaseColumnProperties.getQueries()) {
                    if (queryProperties == null) continue;
                    handler.createDatabaseColumnQuery(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, queryProperties.getQueryId(), queryProperties.getQuery(), queryProperties.getQueryTargetGUID(), "createDatabaseColumn");
                }
            }
            response.setGUID(databaseColumnGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDatabaseColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseColumnFromTemplate(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseTableGUID, TemplateProperties templateProperties) {
        String methodName = "createDatabaseColumnFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseColumnFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseColumnFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseColumnFromTemplate");
            response.setGUID(handler.createDatabaseColumnFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, databaseTableGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), "createDatabaseColumnFromTemplate"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDatabaseColumnFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabaseColumn(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, DatabaseColumnProperties databaseColumnProperties) {
        String methodName = "updateDatabaseColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabaseColumn");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabaseColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabaseColumn");
            int sortOrder = DataItemSortOrder.UNKNOWN.getOpenTypeOrdinal();
            if (databaseColumnProperties.getSortOrder() != null) {
                sortOrder = databaseColumnProperties.getSortOrder().getOpenTypeOrdinal();
            }
            handler.updateDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, databaseColumnProperties.getQualifiedName(), databaseColumnProperties.getDisplayName(), databaseColumnProperties.getDescription(), databaseColumnProperties.getDataType(), databaseColumnProperties.getDefaultValue(), databaseColumnProperties.getFixedValue(), databaseColumnProperties.getFormula(), databaseColumnProperties.getIsDeprecated(), databaseColumnProperties.getElementPosition(), databaseColumnProperties.getMinCardinality(), databaseColumnProperties.getMaxCardinality(), databaseColumnProperties.getAllowsDuplicateValues(), databaseColumnProperties.getOrderedValues(), databaseColumnProperties.getDefaultValueOverride(), sortOrder, databaseColumnProperties.getMinimumLength(), databaseColumnProperties.getLength(), databaseColumnProperties.getPrecision(), databaseColumnProperties.getIsNullable(), databaseColumnProperties.getNativeJavaClass(), databaseColumnProperties.getAliases(), databaseColumnProperties.getAdditionalProperties(), databaseColumnProperties.getTypeName(), databaseColumnProperties.getExtendedProperties(), databaseColumnProperties.getVendorProperties(), "updateDatabaseColumn");
            if (databaseColumnProperties.getQueries() != null) {
                for (DatabaseQueryProperties queryProperties : databaseColumnProperties.getQueries()) {
                    if (queryProperties == null) continue;
                    handler.createDatabaseColumnQuery(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, queryProperties.getQueryId(), queryProperties.getQuery(), queryProperties.getQueryTargetGUID(), "updateDatabaseColumn");
                }
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateDatabaseColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabaseColumn(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, String qualifiedName, NullRequestBody nullRequestBody) {
        String methodName = "removeDatabaseColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabaseColumn");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabaseColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabaseColumn");
            handler.removeDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, qualifiedName, "removeDatabaseColumn");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removeDatabaseColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseColumnsResponse findDatabaseColumns(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findDatabaseColumns";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabaseColumns");
        DatabaseColumnsResponse response = new DatabaseColumnsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabaseColumns");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabaseColumns");
            List databaseColumnAttributes = handler.findDatabaseColumns(userId, searchString, startFrom, pageSize, "findDatabaseColumns");
            response.setElementList(databaseColumnAttributes);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findDatabaseColumns", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseColumnsResponse getColumnsForDatabaseTable(String serverName, String userId, String databaseTableGUID, int startFrom, int pageSize) {
        String methodName = "getColumnsForDatabaseTable";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getColumnsForDatabaseTable");
        DatabaseColumnsResponse response = new DatabaseColumnsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getColumnsForDatabaseTable");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getColumnsForDatabaseTable");
            List databaseColumnAttributes = handler.getColumnsForDatabaseTable(userId, databaseTableGUID, startFrom, pageSize, "getColumnsForDatabaseTable");
            response.setElementList(databaseColumnAttributes);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getColumnsForDatabaseTable", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseColumnsResponse getDatabaseColumnsByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getDatabaseColumnsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseColumnsByName");
        DatabaseColumnsResponse response = new DatabaseColumnsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseColumnsByName");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseColumnsByName");
            List databaseColumnAttributes = handler.getDatabaseColumnsByName(userId, name, startFrom, pageSize, "getDatabaseColumnsByName");
            response.setElementList(databaseColumnAttributes);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDatabaseColumnsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseColumnResponse getDatabaseColumnByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseColumnByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseColumnByGUID");
        DatabaseColumnResponse response = new DatabaseColumnResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseColumnByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseColumnByGUID");
            DatabaseColumnElement schemaAttribute = (DatabaseColumnElement)handler.getDatabaseColumnByGUID(userId, guid, "getDatabaseColumnByGUID");
            response.setElement(schemaAttribute);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDatabaseColumnByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setPrimaryKeyOnColumn(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, DatabasePrimaryKeyProperties databasePrimaryKeyProperties) {
        String methodName = "setPrimaryKeyOnColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setPrimaryKeyOnColumn");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setPrimaryKeyOnColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "setPrimaryKeyOnColumn");
            int keyPattern = KeyPattern.LOCAL_KEY.getOpenTypeOrdinal();
            if (databasePrimaryKeyProperties.getKeyPattern() != null) {
                keyPattern = databasePrimaryKeyProperties.getKeyPattern().getOpenTypeOrdinal();
            }
            handler.setPrimaryKeyOnColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, databasePrimaryKeyProperties.getName(), keyPattern, "setPrimaryKeyOnColumn");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "setPrimaryKeyOnColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removePrimaryKeyFromColumn(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, NullRequestBody nullRequestBody) {
        String methodName = "removePrimaryKeyFromColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removePrimaryKeyFromColumn");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removePrimaryKeyFromColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removePrimaryKeyFromColumn");
            handler.removePrimaryKeyFromColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "removePrimaryKeyFromColumn");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removePrimaryKeyFromColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addForeignKeyRelationship(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String primaryKeyColumnGUID, String foreignKeyColumnGUID, DatabaseForeignKeyProperties databaseForeignKeyProperties) {
        String methodName = "addForeignKeyRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addForeignKeyRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addForeignKeyRelationship");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "addForeignKeyRelationship");
            handler.addForeignKeyRelationship(userId, databaseManagerGUID, databaseManagerName, primaryKeyColumnGUID, foreignKeyColumnGUID, databaseForeignKeyProperties.getName(), databaseForeignKeyProperties.getDescription(), databaseForeignKeyProperties.getConfidence(), databaseForeignKeyProperties.getSteward(), databaseForeignKeyProperties.getSource(), "addForeignKeyRelationship");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addForeignKeyRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeForeignKeyRelationship(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String primaryKeyColumnGUID, String foreignKeyColumnGUID, NullRequestBody nullRequestBody) {
        String methodName = "removeForeignKeyRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeForeignKeyRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeForeignKeyRelationship");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeForeignKeyRelationship");
            handler.removeForeignKeyRelationship(userId, databaseManagerGUID, databaseManagerName, primaryKeyColumnGUID, foreignKeyColumnGUID, "removeForeignKeyRelationship");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removeForeignKeyRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

