/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.converters;

import org.odpi.openmetadata.accessservices.datamanager.converters.DataManagerOMASConverter;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileFolderProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class FileFolderConverter<B>
extends DataManagerOMASConverter<B> {
    public FileFolderConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof FileFolderElement) {
                FileFolderElement bean = (FileFolderElement)returnBean;
                FileFolderProperties fileFolderProperties = new FileFolderProperties();
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    fileFolderProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    fileFolderProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    fileFolderProperties.setDisplayName(this.removeName(instanceProperties));
                    fileFolderProperties.setDescription(this.removeDescription(instanceProperties));
                    fileFolderProperties.setPathName(this.removePathName(instanceProperties));
                    fileFolderProperties.setCreateTime(this.removeStoreCreateTime(instanceProperties));
                    fileFolderProperties.setModifiedTime(this.removeStoreUpdateTime(instanceProperties));
                    fileFolderProperties.setOwner(this.removeOwner(instanceProperties));
                    fileFolderProperties.setOwnerCategory(this.removeOwnerCategoryFromProperties(instanceProperties));
                    fileFolderProperties.setZoneMembership(this.removeZoneMembership(instanceProperties));
                    fileFolderProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    fileFolderProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetZoneMembership", entity);
                    fileFolderProperties.setZoneMembership(this.getZoneMembership(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetOwnership", entity);
                    fileFolderProperties.setOwner(this.getOwner(instanceProperties));
                    fileFolderProperties.setOwnerCategory(this.getOwnerCategoryFromProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetOrigin", entity);
                    fileFolderProperties.setOriginOrganizationGUID(this.getOriginOrganizationGUID(instanceProperties));
                    fileFolderProperties.setOriginBusinessCapabilityGUID(this.getOriginBusinessCapabilityGUID(instanceProperties));
                    fileFolderProperties.setOtherOriginValues(this.getOtherOriginValues(instanceProperties));
                    instanceProperties = super.getClassificationProperties("DataStoreEncoding", entity);
                    fileFolderProperties.setEncodingType(this.getDataStoreEncodingType(instanceProperties));
                    fileFolderProperties.setEncodingLanguage(this.getDataStoreEncodingLanguage(instanceProperties));
                    fileFolderProperties.setEncodingDescription(this.getDataStoreEncodingDescription(instanceProperties));
                    fileFolderProperties.setEncodingProperties(this.getEncodingProperties(instanceProperties));
                    bean.setFileFolderProperties(fileFolderProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

