/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.connectors.outtopic.DataManagerOutTopicClientProvider;
import org.odpi.openmetadata.accessservices.datamanager.converters.DataFileConverter;
import org.odpi.openmetadata.accessservices.datamanager.converters.DatabaseColumnConverter;
import org.odpi.openmetadata.accessservices.datamanager.converters.DatabaseConverter;
import org.odpi.openmetadata.accessservices.datamanager.converters.DatabaseManagerConverter;
import org.odpi.openmetadata.accessservices.datamanager.converters.DatabaseSchemaConverter;
import org.odpi.openmetadata.accessservices.datamanager.converters.DatabaseTableConverter;
import org.odpi.openmetadata.accessservices.datamanager.converters.DatabaseViewConverter;
import org.odpi.openmetadata.accessservices.datamanager.converters.FileFolderConverter;
import org.odpi.openmetadata.accessservices.datamanager.converters.FileSystemConverter;
import org.odpi.openmetadata.accessservices.datamanager.converters.SchemaTypeConverter;
import org.odpi.openmetadata.accessservices.datamanager.ffdc.DataManagerErrorCode;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFileElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseTableElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseViewElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileSystemElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SoftwareServerCapabilityElement;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.FilesAndFoldersHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RelationalDataHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DataManagerServicesInstance
extends OMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.DATA_MANAGER_OMAS;
    private SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> dataManagerIntegratorHandler;
    private RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> relationalDataHandler;
    private FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> filesAndFoldersHandler;

    public DataManagerServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog, String localServerUserId, int maxPageSize, Connection outTopicEventBusConnection) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, localServerUserId, maxPageSize, null, null, DataManagerOutTopicClientProvider.class.getName(), outTopicEventBusConnection);
        if (this.repositoryHandler == null) {
            String methodName = "new ServiceInstance";
            throw new NewInstanceException(DataManagerErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.dataManagerIntegratorHandler = new SoftwareServerCapabilityHandler(new DatabaseManagerConverter(this.repositoryHelper, this.serviceName, this.serverName), SoftwareServerCapabilityElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.relationalDataHandler = new RelationalDataHandler(new DatabaseConverter(this.repositoryHelper, this.serviceName, this.serverName), DatabaseElement.class, new DatabaseSchemaConverter(this.repositoryHelper, this.serviceName, this.serverName), DatabaseSchemaElement.class, new DatabaseTableConverter(this.repositoryHelper, this.serviceName, this.serverName), DatabaseTableElement.class, new DatabaseViewConverter(this.repositoryHelper, this.serviceName, this.serverName), DatabaseViewElement.class, new DatabaseColumnConverter(this.repositoryHelper, this.serviceName, this.serverName), DatabaseColumnElement.class, new SchemaTypeConverter(this.repositoryHelper, this.serviceName, this.serverName), SchemaTypeElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.filesAndFoldersHandler = new FilesAndFoldersHandler(new FileSystemConverter(this.repositoryHelper, this.serviceName, this.serverName), FileSystemElement.class, new FileFolderConverter(this.repositoryHelper, this.serviceName, this.serverName), FileFolderElement.class, new DataFileConverter(this.repositoryHelper, this.serviceName, this.serverName), DataFileElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> getRelationalDataHandler() throws PropertyServerException {
        String methodName = "getRelationalDataHandler";
        this.validateActiveRepository("getRelationalDataHandler");
        return this.relationalDataHandler;
    }

    SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> getDataManagerIntegratorHandler() throws PropertyServerException {
        String methodName = "getDataManagerIntegratorHandler";
        this.validateActiveRepository("getDataManagerIntegratorHandler");
        return this.dataManagerIntegratorHandler;
    }

    FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> getFilesAndFoldersHandler() throws PropertyServerException {
        String methodName = "getFilesAndFoldersHandler";
        this.validateActiveRepository("getFilesAndFoldersHandler");
        return this.filesAndFoldersHandler;
    }
}

