/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.converters;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.converters.DataManagerOMASConverter;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseQueryProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DerivedSchemaTypeQueryTargetProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TabularColumnProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DatabaseColumnConverter<B>
extends DataManagerOMASConverter<B> {
    public DatabaseColumnConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public <T> B getNewSchemaAttributeBean(Class<B> beanClass, EntityDetail schemaAttributeEntity, Class<T> typeClass, T schemaType, List<Relationship> schemaAttributeRelationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof DatabaseColumnElement) {
                DatabaseColumnElement bean = (DatabaseColumnElement)returnBean;
                DatabaseColumnProperties databaseColumnProperties = new DatabaseColumnProperties();
                if (schemaAttributeEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, schemaAttributeEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(schemaAttributeEntity.getProperties());
                    databaseColumnProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    databaseColumnProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    databaseColumnProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    databaseColumnProperties.setDescription(this.removeDescription(instanceProperties));
                    databaseColumnProperties.setElementPosition(this.removePosition(instanceProperties));
                    databaseColumnProperties.setMinCardinality(this.removeMinCardinality(instanceProperties));
                    databaseColumnProperties.setMaxCardinality(this.removeMaxCardinality(instanceProperties));
                    databaseColumnProperties.setAllowsDuplicateValues(this.removeAllowsDuplicateValues(instanceProperties));
                    databaseColumnProperties.setOrderedValues(this.removeOrderedValues(instanceProperties));
                    databaseColumnProperties.setDefaultValueOverride(this.removeDefaultValueOverride(instanceProperties));
                    databaseColumnProperties.setSortOrder(this.removeSortOrder(instanceProperties));
                    databaseColumnProperties.setMinimumLength(this.removeMinimumLength(instanceProperties));
                    databaseColumnProperties.setLength(this.removeLength(instanceProperties));
                    databaseColumnProperties.setPrecision(this.removePrecision(instanceProperties));
                    databaseColumnProperties.setIsNullable(this.removeIsNullable(instanceProperties));
                    databaseColumnProperties.setNativeJavaClass(this.removeNativeClass(instanceProperties));
                    databaseColumnProperties.setAliases(this.removeAliases(instanceProperties));
                    databaseColumnProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    databaseColumnProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    if (schemaType instanceof SchemaTypeElement) {
                        SchemaTypeProperties schemaTypeProperties = ((SchemaTypeElement)schemaType).getSchemaTypeProperties();
                        super.addSchemaTypeToColumn(schemaTypeProperties, (TabularColumnProperties)databaseColumnProperties);
                        databaseColumnProperties.setFormula(schemaTypeProperties.getFormula());
                        if (schemaTypeProperties.getQueries() != null && !schemaTypeProperties.getQueries().isEmpty()) {
                            ArrayList databaseQueryPropertiesList = new ArrayList();
                            for (DerivedSchemaTypeQueryTargetProperties derivedSchemaTypeQueryTargetProperties : schemaTypeProperties.getQueries()) {
                                if (derivedSchemaTypeQueryTargetProperties == null) continue;
                                DatabaseQueryProperties databaseQueryProperties = new DatabaseQueryProperties();
                                databaseQueryProperties.setQuery(derivedSchemaTypeQueryTargetProperties.getQuery());
                                databaseQueryProperties.setQueryId(derivedSchemaTypeQueryTargetProperties.getQueryId());
                                databaseQueryProperties.setQueryTargetGUID(derivedSchemaTypeQueryTargetProperties.getQueryTargetGUID());
                            }
                            databaseColumnProperties.setQueries(databaseQueryPropertiesList);
                        }
                    }
                    bean.setDatabaseColumnProperties(databaseColumnProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

