/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SoftwareServerCapabilityElement;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIManagerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ApplicationRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataProcessingEngineRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseManagerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.EventBrokerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileManagerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileSystemRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class DataManagerRESTServices {
    private static DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DataManagerRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public ConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createFileSystemInCatalog(String serverName, String userId, FileSystemRequestBody requestBody) {
        String methodName = "createFileSystemInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFileSystemInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFileSystemInCatalog");
            if (requestBody != null) {
                SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createFileSystemInCatalog");
                response.setGUID(handler.createFileSystem(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getFormat(), requestBody.getEncryption(), requestBody.getAdditionalProperties(), requestBody.getVendorProperties(), "createFileSystemInCatalog"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createFileSystemInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createFileManagerInCatalog(String serverName, String userId, FileManagerRequestBody requestBody) {
        String methodName = "createFileManagerInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFileManagerInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFileManagerInCatalog");
            if (requestBody != null) {
                SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createFileManagerInCatalog");
                response.setGUID(handler.createSoftwareServerCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", "FileManager", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getVendorProperties(), "createFileManagerInCatalog"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createFileManagerInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseManagerInCatalog(String serverName, String userId, DatabaseManagerRequestBody requestBody) {
        String methodName = "createDatabaseManagerInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseManagerInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseManagerInCatalog");
            SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createDatabaseManagerInCatalog");
            response.setGUID(handler.createSoftwareServerCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), "68b35c1e-6c28-4ac3-94f9-2c3dbcbb79e9", "DatabaseManager", null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getVendorProperties(), "createDatabaseManagerInCatalog"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createDatabaseManagerInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createAPIManagerInCatalog(String serverName, String userId, APIManagerRequestBody requestBody) {
        String methodName = "createAPIManagerInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createAPIManagerInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createAPIManagerInCatalog");
            SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createAPIManagerInCatalog");
            response.setGUID(handler.createSoftwareServerCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), "283a127d-3acd-4d64-b558-1fce9db9a35b", "APIManager", null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getVendorProperties(), "createAPIManagerInCatalog"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createAPIManagerInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEventBrokerInCatalog(String serverName, String userId, EventBrokerRequestBody requestBody) {
        String methodName = "createEventBrokerInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEventBrokerInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEventBrokerInCatalog");
            SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createEventBrokerInCatalog");
            response.setGUID(handler.createSoftwareServerCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), "309dfc3c-663b-4732-957b-e4a084436314", "EventBroker", null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getVendorProperties(), "createEventBrokerInCatalog"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createEventBrokerInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createApplicationInCatalog(String serverName, String userId, ApplicationRequestBody requestBody) {
        String methodName = "createApplicationInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createApplicationInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createApplicationInCatalog");
            SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createApplicationInCatalog");
            response.setGUID(handler.createSoftwareServerCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), "58280f3c-9d63-4eae-9509-3f223872fb25", "Application", null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getVendorProperties(), "createApplicationInCatalog"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createApplicationInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDataProcessingEngineInCatalog(String serverName, String userId, DataProcessingEngineRequestBody requestBody) {
        String methodName = "createDataProcessingEngineInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDataProcessingEngineInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataProcessingEngineInCatalog");
            SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createDataProcessingEngineInCatalog");
            response.setGUID(handler.createSoftwareServerCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), "3566527f-b1bd-4e7a-873e-a3e04d5f2a14", "Engine", null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getVendorProperties(), "createDataProcessingEngineInCatalog"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createDataProcessingEngineInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getMetadataSourceGUID(String serverName, String userId, String qualifiedName) {
        String methodName = "getMetadataSourceGUID";
        String parameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataSourceGUID");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataSourceGUID");
            SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "getMetadataSourceGUID");
            response.setGUID(handler.getBeanGUIDByQualifiedName(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", qualifiedName, "qualifiedName", "getMetadataSourceGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getMetadataSourceGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

