/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.converters.ElementStubConverter;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementStub;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ValidValueSetElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataItemSortOrder;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.DerivedSchemaTypeQueryTargetRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ElementStubResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.EnumSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FormulaRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.LiteralSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.MapSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.PrimitiveSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaAttributeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaAttributeResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaAttributesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaTypeChoiceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaTypeResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.SchemaTypesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.StructSchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ValidValueSetsResponse;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValuesHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.LoggerFactory;

public class SchemaManagerRESTServices {
    private static DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(SchemaManagerRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createPrimitiveSchemaType(String serverName, String userId, PrimitiveSchemaTypeRequestBody requestBody) {
        String methodName = "createPrimitiveSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createPrimitiveSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createPrimitiveSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createPrimitiveSchemaType");
            if (requestBody != null) {
                String schemaTypeGUID = handler.addPrimitiveSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getDataType(), requestBody.getDefaultValue(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), "createPrimitiveSchemaType");
                handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), "createPrimitiveSchemaType");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createPrimitiveSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createPrimitiveSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createLiteralSchemaType(String serverName, String userId, LiteralSchemaTypeRequestBody requestBody) {
        String methodName = "createLiteralSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createLiteralSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createLiteralSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createLiteralSchemaType");
            if (requestBody != null) {
                String schemaTypeGUID = handler.addLiteralSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getDataType(), requestBody.getFixedValue(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), "createLiteralSchemaType");
                handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), "createLiteralSchemaType");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createLiteralSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createLiteralSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEnumSchemaType(String serverName, String userId, String validValuesSetGUID, EnumSchemaTypeRequestBody requestBody) {
        String methodName = "createEnumSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEnumSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEnumSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createEnumSchemaType");
            if (requestBody != null) {
                String schemaTypeGUID = handler.addEnumSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getDataType(), requestBody.getDefaultValue(), validValuesSetGUID, requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), "createEnumSchemaType");
                handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), "createEnumSchemaType");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createEnumSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createEnumSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueSetsResponse getValidValueSetByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getValidValueSetByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueSetByName");
        ValidValueSetsResponse response = new ValidValueSetsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueSetByName");
            ValidValuesHandler<ValidValueSetElement, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueSetByName");
            response.setElementList(handler.getValidValueByName(userId, name, "name", startFrom, pageSize, "getValidValueSetByName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValueSetByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueSetsResponse findValidValueSet(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findValidValueSet";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findValidValueSet");
        ValidValueSetsResponse response = new ValidValueSetsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findValidValueSet");
            ValidValuesHandler<ValidValueSetElement, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> handler = instanceHandler.getValidValuesHandler(userId, serverName, "findValidValueSet");
            response.setElementList(handler.findValidValues(userId, searchString, "searchString", startFrom, pageSize, "findValidValueSet"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findValidValueSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createStructSchemaType(String serverName, String userId, StructSchemaTypeRequestBody requestBody) {
        String methodName = "createStructSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createStructSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createStructSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createStructSchemaType");
            if (requestBody != null) {
                String schemaTypeGUID = handler.addStructSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), "createStructSchemaType");
                handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), "createStructSchemaType");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createStructSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createStructSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaTypeChoice(String serverName, String userId, SchemaTypeChoiceRequestBody requestBody) {
        String methodName = "createSchemaTypeChoice";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaTypeChoice");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaTypeChoice");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createSchemaTypeChoice");
            if (requestBody != null) {
                String schemaTypeGUID = handler.addSchemaTypeChoice(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), "createSchemaTypeChoice");
                handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), "createSchemaTypeChoice");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSchemaTypeChoice", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createSchemaTypeChoice", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createMapSchemaType(String serverName, String userId, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID, MapSchemaTypeRequestBody requestBody) {
        String methodName = "createMapSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createMapSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createMapSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createMapSchemaType");
            if (requestBody != null) {
                String schemaTypeGUID = handler.addMapSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), mapFromSchemaTypeGUID, mapToSchemaTypeGUID, requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), "createMapSchemaType");
                handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), "createMapSchemaType");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createMapSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createMapSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaTypeFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createSchemaTypeFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaTypeFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaTypeFromTemplate");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createSchemaTypeFromTemplate");
            if (requestBody != null) {
                String schemaTypeGUID = handler.createSchemaTypeFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), "createSchemaTypeFromTemplate");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSchemaTypeFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createSchemaTypeFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateSchemaType(String serverName, String userId, String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeRequestBody requestBody) {
        String methodName = "updateSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "updateSchemaType");
            if (requestBody != null) {
                handler.updateSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaTypeGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), isMergeUpdate, "updateSchemaType");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), "updateSchemaType");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSchemaType(String serverName, String userId, String schemaTypeGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "removeSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "removeSchemaType");
            if (requestBody != null) {
                handler.removeSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaTypeGUID, "removeSchemaType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypesResponse findSchemaType(String serverName, String userId, String typeName, String searchString, int startFrom, int pageSize) {
        String methodName = "findSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findSchemaType");
        SchemaTypesResponse response = new SchemaTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "findSchemaType");
            List results = handler.findSchemaTypes(userId, typeName, searchString, startFrom, pageSize, "findSchemaType");
            response.setElementList(this.setUpVendorProperties(userId, results, handler, "findSchemaType"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypeResponse getSchemaTypeForElement(String serverName, String userId, String parentElementGUID, String parentElementTypeName) {
        String methodName = "findSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findSchemaType");
        SchemaTypeResponse response = new SchemaTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "findSchemaType");
            SchemaTypeElement result = (SchemaTypeElement)handler.getSchemaTypeForElement(userId, parentElementGUID, parentElementTypeName, "findSchemaType");
            response.setElement(this.setUpVendorProperties(userId, result, handler, "findSchemaType"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypesResponse getSchemaTypeByName(String serverName, String userId, String typeName, String name, int startFrom, int pageSize) {
        String methodName = "getSchemaTypeByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeByName");
        SchemaTypesResponse response = new SchemaTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeByName");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "getSchemaTypeByName");
            List results = handler.getSchemaTypeByName(userId, typeName, name, startFrom, pageSize, "getSchemaTypeByName");
            response.setElementList(this.setUpVendorProperties(userId, results, handler, "getSchemaTypeByName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getSchemaTypeByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypeResponse getSchemaTypeByGUID(String serverName, String userId, String schemaTypeGUID) {
        String methodName = "getSchemaTypeByGUID";
        String guidParameterName = "schemaTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeByGUID");
        SchemaTypeResponse response = new SchemaTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeByGUID");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "getSchemaTypeByGUID");
            SchemaTypeElement result = (SchemaTypeElement)handler.getSchemaType(userId, schemaTypeGUID, "schemaTypeGUID", "getSchemaTypeByGUID");
            response.setElement(this.setUpVendorProperties(userId, result, handler, "getSchemaTypeByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getSchemaTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubResponse getSchemaTypeParent(String serverName, String userId, String schemaTypeGUID) {
        String methodName = "getSchemaTypeByGUID";
        String guidParameterName = "schemaTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeByGUID");
        ElementStubResponse response = new ElementStubResponse();
        AuditLog auditLog = null;
        try {
            ElementStub parent = null;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeByGUID");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "getSchemaTypeByGUID");
            ElementStubConverter<ElementStub> converter = instanceHandler.getElementStubConverter(userId, serverName, "getSchemaTypeByGUID");
            List relationships = handler.getAttachmentLinks(userId, schemaTypeGUID, "schemaTypeGUID", "SchemaType", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", null, "Asset", 1, 0, 2, "getSchemaTypeByGUID");
            if (relationships != null) {
                parent = converter.getNewBean(ElementStub.class, (Relationship)relationships.get(0), true, "getSchemaTypeByGUID");
            } else {
                relationships = handler.getAttachmentLinks(userId, schemaTypeGUID, "schemaTypeGUID", "SchemaType", "B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", null, "Port", 1, 0, 2, "getSchemaTypeByGUID");
                if (relationships != null) {
                    parent = converter.getNewBean(ElementStub.class, (Relationship)relationships.get(0), true, "getSchemaTypeByGUID");
                }
            }
            response.setElement(parent);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getSchemaTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaAttribute(String serverName, String userId, String schemaElementGUID, SchemaAttributeRequestBody requestBody) {
        String methodName = "createSchemaAttribute";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaAttribute");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaAttribute");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "createSchemaAttribute");
            if (requestBody != null) {
                String schemaAttributeGUID;
                int sortOrder = DataItemSortOrder.UNKNOWN.getOpenTypeOrdinal();
                if (requestBody.getSortOrder() != null) {
                    sortOrder = requestBody.getSortOrder().getOpenTypeOrdinal();
                }
                if ((schemaAttributeGUID = handler.createNestedSchemaAttribute(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaElementGUID, "schemaElementGUID", requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getExternalTypeGUID(), requestBody.getDataType(), requestBody.getDefaultValue(), requestBody.getFixedValue(), requestBody.getValidValuesSetGUID(), null, requestBody.getIsDeprecated(), requestBody.getElementPosition(), requestBody.getMinCardinality(), requestBody.getMaxCardinality(), requestBody.getAllowsDuplicateValues(), requestBody.getOrderedValues(), requestBody.getDefaultValueOverride(), sortOrder, requestBody.getMinimumLength(), requestBody.getLength(), requestBody.getPrecision(), requestBody.getIsNullable(), requestBody.getNativeJavaClass(), requestBody.getAliases(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), "createSchemaAttribute")) != null && requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, schemaAttributeGUID, requestBody.getVendorProperties(), "createSchemaAttribute");
                }
                response.setGUID(schemaAttributeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSchemaAttribute", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createSchemaAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaAttributeFromTemplate(String serverName, String userId, String schemaElementGUID, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createSchemaAttributeFromTemplate";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaAttributeFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaAttributeFromTemplate");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "createSchemaAttributeFromTemplate");
            if (requestBody != null) {
                String schemaTypeGUID = handler.createSchemaAttributeFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaElementGUID, "schemaElementGUID", templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), "createSchemaAttributeFromTemplate");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSchemaAttributeFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createSchemaAttributeFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupSchemaType(String serverName, String userId, String relationshipTypeName, String schemaAttributeGUID, String schemaTypeGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "setupSchemaType";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupSchemaType");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "setupSchemaType");
            if (requestBody != null) {
                if (relationshipTypeName != null) {
                    TypeDef relationshipTypeDef = handler.getRepositoryHelper().getTypeDefByName(instanceHandler.getServiceName(), relationshipTypeName);
                    if (relationshipTypeDef != null) {
                        handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaAttributeGUID, "schemaAttributeGUID", "SchemaAttribute", schemaTypeGUID, "schemaTypeGUID", "SchemaType", relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), null, "setupSchemaType");
                    }
                } else {
                    this.restExceptionHandler.handleMissingValue("relationshipTypeName", "setupSchemaType");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSchemaTypes(String serverName, String userId, String schemaAttributeGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "clearSchemaTypes";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearSchemaTypes");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSchemaTypes");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "clearSchemaTypes");
            if (requestBody != null) {
                handler.removeSchemaTypes(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaAttributeGUID, "schemaAttributeGUID", "clearSchemaTypes");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearSchemaTypes", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearSchemaTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateSchemaAttribute(String serverName, String userId, String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeRequestBody requestBody) {
        String methodName = "updateSchemaAttribute";
        String elementGUIDParameterName = "schemaAttributeGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateSchemaAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateSchemaAttribute");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "updateSchemaAttribute");
            if (requestBody != null) {
                int sortOrder = DataItemSortOrder.UNKNOWN.getOpenTypeOrdinal();
                if (requestBody.getSortOrder() != null) {
                    sortOrder = requestBody.getSortOrder().getOpenTypeOrdinal();
                }
                handler.updateSchemaAttribute(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaAttributeGUID, "schemaAttributeGUID", requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getIsDeprecated(), requestBody.getElementPosition(), requestBody.getMinCardinality(), requestBody.getMaxCardinality(), requestBody.getAllowsDuplicateValues(), requestBody.getOrderedValues(), requestBody.getDefaultValueOverride(), sortOrder, requestBody.getMinimumLength(), requestBody.getLength(), requestBody.getPrecision(), requestBody.getIsNullable(), requestBody.getNativeJavaClass(), requestBody.getAliases(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), isMergeUpdate, "updateSchemaAttribute");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, schemaAttributeGUID, requestBody.getVendorProperties(), "updateSchemaAttribute");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateSchemaAttribute", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateSchemaAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSchemaAttribute(String serverName, String userId, String schemaAttributeGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "removeSchemaAttribute";
        String elementGUIDParameterName = "schemaAttributeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSchemaAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSchemaAttribute");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "removeSchemaAttribute");
            if (requestBody != null) {
                handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaAttributeGUID, "schemaAttributeGUID", "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", null, null, "removeSchemaAttribute");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeSchemaAttribute", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeSchemaAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributesResponse findSchemaAttributes(String serverName, String userId, String typeName, String searchString, int startFrom, int pageSize) {
        String methodName = "findSchemaAttributes";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findSchemaAttributes");
        SchemaAttributesResponse response = new SchemaAttributesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findSchemaAttributes");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "findSchemaAttributes");
            TypeDef typeDef = handler.getTypeDefByName(typeName, "SchemaAttribute");
            if (typeDef != null) {
                List results = handler.findSchemaAttributes(userId, searchString, "searchString", typeDef.getGUID(), typeDef.getName(), null, null, startFrom, pageSize, "findSchemaAttributes");
                response.setElementList(this.setUpVendorProperties(userId, results, handler, "findSchemaAttributes"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findSchemaAttributes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributesResponse getNestedAttributes(String serverName, String userId, String parentSchemaElementGUID, int startFrom, int pageSize) {
        String methodName = "getNestedAttributes";
        String elementGUIDParameterName = "schemaAttributeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNestedAttributes");
        SchemaAttributesResponse response = new SchemaAttributesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNestedAttributes");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "getNestedAttributes");
            List results = handler.getAttachedSchemaAttributes(userId, parentSchemaElementGUID, "schemaAttributeGUID", "SchemaAttribute", startFrom, pageSize, "getNestedAttributes");
            response.setElementList(this.setUpVendorProperties(userId, results, handler, "getNestedAttributes"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getNestedAttributes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributesResponse getSchemaAttributesByName(String serverName, String userId, String typeName, String name, int startFrom, int pageSize) {
        String methodName = "getSchemaAttributesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaAttributesByName");
        SchemaAttributesResponse response = new SchemaAttributesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaAttributesByName");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "getSchemaAttributesByName");
            TypeDef typeDef = handler.getTypeDefByName(typeName, "SchemaAttribute");
            if (typeDef != null) {
                List results = handler.getSchemaAttributesByName(userId, name, "name", typeDef.getGUID(), typeDef.getName(), null, null, startFrom, pageSize, "getSchemaAttributesByName");
                response.setElementList(this.setUpVendorProperties(userId, results, handler, "getSchemaAttributesByName"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getSchemaAttributesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributeResponse getSchemaAttributeByGUID(String serverName, String userId, String schemaAttributeGUID) {
        String methodName = "getSchemaAttributeByGUID";
        String guidParameterName = "schemaAttributeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaAttributeByGUID");
        SchemaAttributeResponse response = new SchemaAttributeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaAttributeByGUID");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "getSchemaAttributeByGUID");
            SchemaAttributeElement result = (SchemaAttributeElement)handler.getSchemaAttribute(userId, schemaAttributeGUID, "schemaAttributeGUID", "SchemaAttribute", null, null, "getSchemaAttributeByGUID");
            response.setElement(this.setUpVendorProperties(userId, result, handler, "getSchemaAttributeByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getSchemaAttributeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupCalculatedValue(String serverName, String userId, String schemaElementGUID, FormulaRequestBody requestBody) {
        String methodName = "setupCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupCalculatedValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupCalculatedValue");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "setupCalculatedValue");
            SchemaAttributeBuilder builder = new SchemaAttributeBuilder(handler.getRepositoryHelper(), instanceHandler.getServiceName(), serverName);
            handler.setClassificationInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaElementGUID, "schemaElementGUID", "SchemaElement", "4814bec8-482d-463d-8376-160b0358e139", "CalculatedValue", builder.getCalculatedValueProperties(requestBody.getFormula(), "setupCalculatedValue"), false, "setupCalculatedValue");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupCalculatedValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearCalculatedValue(String serverName, String userId, String schemaElementGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "clearCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearCalculatedValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearCalculatedValue");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "clearCalculatedValue");
            handler.removeClassificationFromRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaElementGUID, "schemaElementGUID", "SchemaElement", "4814bec8-482d-463d-8376-160b0358e139", "CalculatedValue", "clearCalculatedValue");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearCalculatedValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupQueryTargetRelationship(String serverName, String userId, String derivedElementGUID, String queryTargetGUID, DerivedSchemaTypeQueryTargetRequestBody requestBody) {
        String methodName = "setupQueryTargetRelationship";
        String schemaElementGUIDParameterName = "derivedElementGUID";
        String queryTargetGUIDParameterName = "queryTargetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupQueryTargetRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupQueryTargetRelationship");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "setupQueryTargetRelationship");
            handler.setupQueryTargetRelationship(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), derivedElementGUID, "derivedElementGUID", "SchemaElement", requestBody.getQueryId(), requestBody.getQuery(), queryTargetGUID, "queryTargetGUID", "setupQueryTargetRelationship");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupQueryTargetRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateQueryTargetRelationship(String serverName, String userId, String derivedElementGUID, String queryTargetGUID, DerivedSchemaTypeQueryTargetRequestBody requestBody) {
        String methodName = "updateQueryTargetRelationship";
        String schemaElementGUIDParameterName = "derivedElementGUID";
        String queryTargetGUIDParameterName = "queryTargetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateQueryTargetRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateQueryTargetRelationship");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "updateQueryTargetRelationship");
            handler.updateQueryTargetRelationship(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), derivedElementGUID, "derivedElementGUID", "SchemaElement", requestBody.getQueryId(), requestBody.getQuery(), queryTargetGUID, "queryTargetGUID", "updateQueryTargetRelationship");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateQueryTargetRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearQueryTargetRelationship(String serverName, String userId, String derivedElementGUID, String queryTargetGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "clearQueryTargetRelationship";
        String schemaElementGUIDParameterName = "derivedElementGUID";
        String queryTargetGUIDParameterName = "queryTargetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearQueryTargetRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearQueryTargetRelationship");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "clearQueryTargetRelationship");
            handler.clearQueryTargetRelationship(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), derivedElementGUID, "derivedElementGUID", "SchemaElement", queryTargetGUID, "queryTargetGUID", "clearQueryTargetRelationship");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearQueryTargetRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<SchemaTypeElement> setUpVendorProperties(String userId, List<SchemaTypeElement> retrievedResults, SchemaTypeHandler<SchemaTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (SchemaTypeElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private SchemaTypeElement setUpVendorProperties(String userId, SchemaTypeElement element, SchemaTypeHandler<SchemaTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            SchemaTypeProperties properties = element.getSchemaTypeProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", methodName));
        }
        return element;
    }

    private List<SchemaAttributeElement> setUpVendorProperties(String userId, List<SchemaAttributeElement> retrievedResults, SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (SchemaAttributeElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private SchemaAttributeElement setUpVendorProperties(String userId, SchemaAttributeElement element, SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            SchemaAttributeProperties properties = element.getProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", methodName));
        }
        return element;
    }
}

