/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.outtopic;

import org.odpi.openmetadata.accessservices.datamanager.connectors.outtopic.DataManagerOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.datamanager.events.DataManagerOutboundEvent;
import org.odpi.openmetadata.accessservices.datamanager.events.DataManagerOutboundEventType;
import org.odpi.openmetadata.accessservices.datamanager.ffdc.DataManagerAuditCode;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;

public class DataManagerOutTopicPublisher {
    private DataManagerOutTopicServerConnector outTopicServerConnector;
    private AuditLog outTopicAuditLog;
    private String outTopicName;
    private final String actionDescription = "Out topic configuration refresh event publishing";

    public DataManagerOutTopicPublisher(DataManagerOutTopicServerConnector outTopicServerConnector, String outTopicName, AuditLog outTopicAuditLog) {
        this.outTopicServerConnector = outTopicServerConnector;
        this.outTopicAuditLog = outTopicAuditLog;
        this.outTopicName = outTopicName;
        if (outTopicAuditLog != null) {
            outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", DataManagerAuditCode.SERVICE_PUBLISHING.getMessageDefinition(new String[]{outTopicName}));
        }
    }

    private void sendEvent(DataManagerOutboundEvent event, String principleElementGUID, String principleElementTypeName) {
        block2: {
            try {
                this.outTopicServerConnector.sendEvent(event);
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block2;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", DataManagerAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{event.getEventType().getEventTypeName(), principleElementGUID, principleElementTypeName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void sendEntityEvent(DataManagerOutboundEventType eventType, String elementGUID, String elementTypeName, String classificationName, ElementStub elementStub) {
        DataManagerOutboundEvent event = new DataManagerOutboundEvent();
        event.setEventType(eventType);
        event.setPrincipleElement(elementStub);
        event.setClassificationName(classificationName);
        if (this.outTopicAuditLog != null) {
            if (classificationName == null) {
                this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", DataManagerAuditCode.OUTBOUND_ENTITY_EVENT.getMessageDefinition(new String[]{eventType.getEventTypeName(), elementGUID, elementTypeName}), elementStub.toString());
            } else {
                this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", DataManagerAuditCode.OUTBOUND_CLASSIFICATION_EVENT.getMessageDefinition(new String[]{eventType.getEventTypeName(), elementGUID, elementTypeName, classificationName}), elementStub.toString());
            }
        }
        this.sendEvent(event, elementGUID, elementTypeName);
    }

    public void sendRelationshipEvent(DataManagerOutboundEventType eventType, String relationshipGUID, String relationshipTypeName, ElementStub relationshipElementStub, ElementStub endOneElementStub, ElementStub endTwoElementStub) {
        DataManagerOutboundEvent event = new DataManagerOutboundEvent();
        event.setEventType(eventType);
        event.setPrincipleElement(relationshipElementStub);
        event.setEndOneElement(endOneElementStub);
        event.setEndTwoElement(endTwoElementStub);
        if (this.outTopicAuditLog != null) {
            this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", DataManagerAuditCode.OUTBOUND_RELATIONSHIP_EVENT.getMessageDefinition(new String[]{eventType.getEventTypeName(), relationshipGUID, relationshipTypeName, endOneElementStub.getType().getTypeName(), endOneElementStub.getGUID(), endTwoElementStub.getType().getTypeName(), endTwoElementStub.getGUID()}), relationshipElementStub.toString());
        }
        this.sendEvent(event, relationshipGUID, relationshipTypeName);
    }

    public void disconnect() {
        block3: {
            try {
                this.outTopicServerConnector.disconnect();
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", DataManagerAuditCode.PUBLISHING_SHUTDOWN.getMessageDefinition(new String[]{this.outTopicName}));
                }
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block3;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", DataManagerAuditCode.PUBLISHING_SHUTDOWN_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), this.outTopicName, error.getMessage()}), (Throwable)error);
            }
        }
    }
}

