/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ReferenceValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ValidValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ValidValueMembershipProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ValidValueProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ValidValueListResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.ValidValueResponse;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValuesHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.LoggerFactory;

public class ValidValuesRESTServices {
    private static final DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ValidValuesRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createValidValue(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createValidValue");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createValidValue");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "createValidValue");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof ValidValueProperties) {
                    ValidValueProperties properties = (ValidValueProperties)requestBody.getProperties();
                    String validValueGUID = handler.createValidValue(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), properties.getQualifiedName(), properties.getDisplayName(), properties.getDescription(), properties.getUsage(), properties.getScope(), properties.getIsDeprecated(), properties.getPreferredValue(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), properties.getEffectiveFrom(), properties.getEffectiveTo(), new Date(), "createValidValue");
                    if (validValueGUID != null) {
                        handler.setVendorProperties(userId, validValueGUID, properties.getVendorProperties(), false, false, new Date(), "createValidValue");
                    }
                    response.setGUID(validValueGUID);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ValidValueProperties.class.getName(), "createValidValue");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createValidValue", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateValidValue(String serverName, String userId, String validValueGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateValidValue");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "updateValidValue");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof ValidValueProperties) {
                    ValidValueProperties properties = (ValidValueProperties)requestBody.getProperties();
                    handler.updateValidValue(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, properties.getQualifiedName(), properties.getDisplayName(), properties.getDescription(), properties.getUsage(), properties.getScope(), properties.getIsDeprecated(), properties.getPreferredValue(), properties.getAdditionalProperties(), properties.getExtendedProperties(), properties.getEffectiveFrom(), properties.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateValidValue");
                    if (!isMergeUpdate || properties.getVendorProperties() != null) {
                        handler.setVendorProperties(userId, validValueGUID, properties.getVendorProperties(), false, false, new Date(), "updateValidValue");
                    }
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ValidValueProperties.class.getName(), "updateValidValue");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateValidValue", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupValidValueMember(String serverName, String userId, String validValueSetGUID, String validValueMemberGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupValidValueMember";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupValidValueMember");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupValidValueMember");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "setupValidValueMember");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof ValidValueMembershipProperties) {
                    ValidValueMembershipProperties properties = (ValidValueMembershipProperties)requestBody.getProperties();
                    handler.attachValidValueToSet(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueSetGUID, validValueMemberGUID, properties.getDefaultValue(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupValidValueMember");
                } else if (requestBody.getProperties() == null) {
                    handler.attachValidValueToSet(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueSetGUID, validValueMemberGUID, false, null, null, false, false, new Date(), "setupValidValueMember");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ValidValueMembershipProperties.class.getName(), "setupValidValueMember");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupValidValueMember", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupValidValueMember", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearValidValueMember(String serverName, String userId, String validValueSetGUID, String validValueMemberGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearValidValueMember";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearValidValueMember");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearValidValueMember");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "clearValidValueMember");
            if (requestBody != null) {
                handler.detachValidValueFromSet(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueSetGUID, validValueMemberGUID, false, false, new Date(), "clearValidValueMember");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearValidValueMember", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearValidValueMember", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupValidValues(String serverName, String userId, String elementGUID, String validValueGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupValidValues");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupValidValues");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "setupValidValues");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof ValidValueAssignmentProperties) {
                    ValidValueAssignmentProperties properties = (ValidValueAssignmentProperties)requestBody.getProperties();
                    handler.assignValidValueToConsumer(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, elementGUID, properties.getStrictRequirement(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupValidValues");
                } else if (requestBody.getProperties() == null) {
                    handler.assignValidValueToConsumer(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, elementGUID, false, null, null, false, false, new Date(), "setupValidValues");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ValidValueAssignmentProperties.class.getName(), "setupValidValues");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupValidValues", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearValidValues(String serverName, String userId, String elementGUID, String validValueGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearValidValues");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearValidValues");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "clearValidValues");
            if (requestBody != null) {
                handler.unassignValidValueFromConsumer(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, elementGUID, false, false, new Date(), "clearValidValues");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearValidValues", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupReferenceValueTag(String serverName, String userId, String elementGUID, String validValueGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupReferenceValueTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupReferenceValueTag");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupReferenceValueTag");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "setupReferenceValueTag");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof ReferenceValueAssignmentProperties) {
                    ReferenceValueAssignmentProperties properties = (ReferenceValueAssignmentProperties)requestBody.getProperties();
                    handler.assignReferenceValueToItem(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, elementGUID, properties.getConfidence(), properties.getSteward(), properties.getStewardTypeName(), properties.getStewardPropertyName(), properties.getNotes(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupReferenceValueTag");
                } else if (requestBody.getProperties() == null) {
                    handler.assignReferenceValueToItem(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, elementGUID, 100, null, null, null, null, null, null, false, false, new Date(), "setupReferenceValueTag");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ReferenceValueAssignmentProperties.class.getName(), "setupReferenceValueTag");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupReferenceValueTag", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupReferenceValueTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearReferenceValueTag(String serverName, String userId, String elementGUID, String validValueGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearReferenceValueTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearReferenceValueTag");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearReferenceValueTag");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "clearReferenceValueTag");
            if (requestBody != null) {
                handler.unassignValidValueFromConsumer(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, elementGUID, false, false, new Date(), "clearReferenceValueTag");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearReferenceValueTag", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearReferenceValueTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeValidValue(String serverName, String userId, String validValueGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removeValidValue");
                ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "removeValidValue");
                handler.deleteValidValue(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, null, false, false, new Date(), "removeValidValue");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "removeValidValue", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueListResponse findValidValues(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findValidValues";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findValidValues");
        ValidValueListResponse response = new ValidValueListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findValidValues");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "findValidValues");
                List validValues = handler.findValidValues(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findValidValues");
                response.setElementList(this.setUpVendorProperties(userId, validValues, handler, "findValidValues"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findValidValues", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueListResponse getValidValuesByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getValidValuesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesByName");
        ValidValueListResponse response = new ValidValueListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesByName");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getValidValuesByName");
                List validValues = handler.getValidValueByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getValidValuesByName");
                response.setElementList(this.setUpVendorProperties(userId, validValues, handler, "getValidValuesByName"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getValidValuesByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidValuesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueListResponse getValidValueSetMembers(String serverName, String userId, String validValueSetGUID, int startFrom, int pageSize) {
        String methodName = "getValidValueSetMembers";
        String guidParameterName = "validValueSetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueSetMembers");
        ValidValueListResponse response = new ValidValueListResponse();
        AuditLog auditLog = null;
        try {
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getValidValueSetMembers");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueSetMembers");
            response.setElementList(handler.getValidValueSetMembers(userId, validValueSetGUID, "validValueSetGUID", startFrom, pageSize, false, false, new Date(), "getValidValueSetMembers"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidValueSetMembers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueListResponse getSetsForValidValue(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getSetsForValidValue";
        String guidParameterName = "validValueGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSetsForValidValue");
        ValidValueListResponse response = new ValidValueListResponse();
        AuditLog auditLog = null;
        try {
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getSetsForValidValue");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSetsForValidValue");
            response.setElementList(handler.getSetsForValidValue(userId, validValueGUID, "validValueGUID", startFrom, pageSize, false, false, new Date(), "getSetsForValidValue"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSetsForValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueResponse getValidValuesForConsumer(String serverName, String userId, String elementGUID) {
        String methodName = "getValidValuesForConsumer";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesForConsumer");
        ValidValueResponse response = new ValidValueResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesForConsumer");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getValidValuesForConsumer");
            ValidValueElement validValue = (ValidValueElement)handler.getAssignedValidValues(userId, elementGUID, "elementGUID", false, false, new Date(), "getValidValuesForConsumer");
            response.setElement(this.setUpVendorProperties(userId, validValue, handler, "getValidValuesForConsumer"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidValuesForConsumer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getConsumersOfValidValue(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getConsumersOfValidValue";
        String guidParameterName = "validValueGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConsumersOfValidValue");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getConsumersOfValidValue");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConsumersOfValidValue");
            response.setElementList(handler.getValidValueConsumers(userId, validValueGUID, "validValueGUID", startFrom, pageSize, false, false, new Date(), "getConsumersOfValidValue"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConsumersOfValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueListResponse getReferenceValues(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getReferenceValues";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getReferenceValues");
        ValidValueListResponse response = new ValidValueListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getReferenceValues");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getReferenceValues");
            List validValue = handler.getReferenceValues(userId, elementGUID, "elementGUID", startFrom, pageSize, false, false, new Date(), "getReferenceValues");
            response.setElementList(this.setUpVendorProperties(userId, validValue, handler, "getReferenceValues"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getReferenceValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementListResponse getAssigneesOfReferenceValue(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getAssigneesOfReferenceValue";
        String guidParameterName = "validValueGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssigneesOfReferenceValue");
        RelatedElementListResponse response = new RelatedElementListResponse();
        AuditLog auditLog = null;
        try {
            ReferenceableHandler<RelatedElement> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getAssigneesOfReferenceValue");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssigneesOfReferenceValue");
            response.setElementList(handler.getReferenceValueAssignees(userId, validValueGUID, "validValueGUID", startFrom, pageSize, false, false, new Date(), "getAssigneesOfReferenceValue"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssigneesOfReferenceValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueListResponse getAllValidValues(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getAllValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllValidValues");
        ValidValueListResponse response = new ValidValueListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllValidValues");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getAllValidValues");
            List validValues = handler.getValidValues(userId, startFrom, pageSize, false, false, new Date(), "getAllValidValues");
            response.setElementList(this.setUpVendorProperties(userId, validValues, handler, "getAllValidValues"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueResponse getValidValueByGUID(String serverName, String userId, String guid) {
        String methodName = "getValidValueByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueByGUID");
        ValidValueResponse response = new ValidValueResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueByGUID");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getValidValueByGUID");
            ValidValueElement validValue = (ValidValueElement)handler.getValidValueByGUID(userId, guid, false, false, new Date(), "getValidValueByGUID");
            response.setElement(this.setUpVendorProperties(userId, validValue, handler, "getValidValueByGUID"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidValueByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<ValidValueElement> setUpVendorProperties(String userId, List<ValidValueElement> retrievedResults, ValidValuesHandler<ValidValueElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (ValidValueElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private ValidValueElement setUpVendorProperties(String userId, ValidValueElement element, ValidValuesHandler<ValidValueElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            ValidValueProperties properties = element.getValidValueProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }
}

