/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.datamanager.converters.DataManagerOMASConverter;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIOperationElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIOperationProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class APIOperationConverter<B>
extends DataManagerOMASConverter<B> {
    public APIOperationConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof APIOperationElement) {
                if (entity != null && entity.getProperties() != null) {
                    APIOperationElement bean = (APIOperationElement)returnBean;
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)entity, entity.getClassifications(), methodName));
                    APIOperationProperties apiOperationProperties = new APIOperationProperties();
                    InstanceProperties propertiesCopy = new InstanceProperties(entity.getProperties());
                    apiOperationProperties.setQualifiedName(this.removeQualifiedName(propertiesCopy));
                    apiOperationProperties.setDisplayName(this.removeDisplayName(propertiesCopy));
                    apiOperationProperties.setDescription(this.removeDescription(propertiesCopy));
                    apiOperationProperties.setIsDeprecated(this.removeIsDeprecated(propertiesCopy));
                    apiOperationProperties.setVersionNumber(this.removeVersionNumber(propertiesCopy));
                    apiOperationProperties.setAuthor(this.removeAuthor(propertiesCopy));
                    apiOperationProperties.setUsage(this.removeUsage(propertiesCopy));
                    apiOperationProperties.setEncodingStandard(this.removeEncodingStandard(propertiesCopy));
                    apiOperationProperties.setNamespace(this.removeNamespace(propertiesCopy));
                    apiOperationProperties.setAdditionalProperties(this.removeAdditionalProperties(propertiesCopy));
                    apiOperationProperties.setExtendedProperties(this.getRemainingExtendedProperties(propertiesCopy));
                    bean.setProperties(apiOperationProperties);
                    return returnBean;
                }
                this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
            }
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
        }
        return null;
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

