/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.datamanager.converters.DataManagerOMASConverter;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ValidValueProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ValidValueConverter<B>
extends DataManagerOMASConverter<B> {
    public ValidValueConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ValidValueElement) {
                ValidValueElement bean = (ValidValueElement)returnBean;
                ValidValueProperties validValueProperties = new ValidValueProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    validValueProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    validValueProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    validValueProperties.setDisplayName(this.removeName(instanceProperties));
                    validValueProperties.setDescription(this.removeDescription(instanceProperties));
                    validValueProperties.setUsage(this.removeUsage(instanceProperties));
                    validValueProperties.setScope(this.removeScope(instanceProperties));
                    validValueProperties.setPreferredValue(this.removePreferredValue(instanceProperties));
                    validValueProperties.setIsDeprecated(this.removeIsDeprecated(instanceProperties));
                    validValueProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
                    validValueProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
                    validValueProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    validValueProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                bean.setValidValueProperties(validValueProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        B returnBean = this.getNewBean(beanClass, entity, methodName);
        if (returnBean instanceof ValidValueElement) {
            ValidValueElement bean = (ValidValueElement)returnBean;
            bean.setRelatedElement(super.getRelatedElement(beanClass, entity, relationship, methodName));
        }
        return returnBean;
    }
}

