/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.outtopic;

import org.odpi.openmetadata.accessservices.datamanager.connectors.outtopic.DataManagerOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.datamanager.events.DataManagerOutboundEvent;
import org.odpi.openmetadata.accessservices.datamanager.events.DataManagerOutboundEventType;
import org.odpi.openmetadata.accessservices.datamanager.ffdc.DataManagerAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;

public class DataManagerOutTopicPublisher {
    private final DataManagerOutTopicServerConnector outTopicServerConnector;
    private final AuditLog outTopicAuditLog;
    private final String outTopicName;
    private final String actionDescription = "Out topic configuration refresh event publishing";

    public DataManagerOutTopicPublisher(DataManagerOutTopicServerConnector outTopicServerConnector, String outTopicName, AuditLog outTopicAuditLog) {
        this.outTopicServerConnector = outTopicServerConnector;
        this.outTopicAuditLog = outTopicAuditLog;
        this.outTopicName = outTopicName;
        if (outTopicAuditLog != null) {
            outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", DataManagerAuditCode.SERVICE_PUBLISHING.getMessageDefinition(new String[]{outTopicName}));
        }
    }

    private void sendEvent(DataManagerOutboundEvent event, String principleElementGUID, String principleElementTypeName) {
        block2: {
            try {
                this.outTopicServerConnector.sendEvent(event);
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block2;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", DataManagerAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{event.getEventType().getEventTypeName(), principleElementGUID, principleElementTypeName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void sendEntityEvent(DataManagerOutboundEventType eventType, String elementGUID, String elementTypeName, String classificationName, ElementStub elementStub) {
        DataManagerOutboundEvent event = new DataManagerOutboundEvent();
        event.setEventType(eventType);
        event.setPrincipleElement(elementStub);
        event.setClassificationName(classificationName);
        this.sendEvent(event, elementGUID, elementTypeName);
    }

    public void sendRelationshipEvent(DataManagerOutboundEventType eventType, String relationshipGUID, String relationshipTypeName, ElementStub relationshipElementStub, ElementStub endOneElementStub, ElementStub endTwoElementStub) {
        DataManagerOutboundEvent event = new DataManagerOutboundEvent();
        event.setEventType(eventType);
        event.setPrincipleElement(relationshipElementStub);
        event.setEndOneElement(endOneElementStub);
        event.setEndTwoElement(endTwoElementStub);
        this.sendEvent(event, relationshipGUID, relationshipTypeName);
    }

    public void disconnect() {
        block3: {
            try {
                this.outTopicServerConnector.disconnect();
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", DataManagerAuditCode.PUBLISHING_SHUTDOWN.getMessageDefinition(new String[]{this.outTopicName}));
                }
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block3;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", DataManagerAuditCode.PUBLISHING_SHUTDOWN_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), this.outTopicName, error.getMessage()}), (Throwable)error);
            }
        }
    }
}

