/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseTableElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseViewElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataItemSortOrder;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseForeignKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabasePrimaryKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseQueryProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseSchemaProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseTableProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseViewProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseColumnResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseColumnsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseSchemaResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseSchemasResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseTableResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseTablesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseViewResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseViewsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabasesResponse;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.RelationalDataHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class DatabaseManagerRESTServices {
    private static final DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DatabaseManagerRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createDatabase(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, DatabaseProperties databaseProperties) {
        String methodName = "createDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabase");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabase");
            String databaseGUID = handler.createDatabase(userId, databaseManagerGUID, databaseManagerName, databaseProperties.getQualifiedName(), databaseProperties.getDisplayName(), databaseProperties.getDescription(), databaseProperties.getPathName(), databaseProperties.getCreateTime(), databaseProperties.getModifiedTime(), databaseProperties.getEncodingType(), databaseProperties.getEncodingLanguage(), databaseProperties.getEncodingDescription(), databaseProperties.getEncodingProperties(), databaseProperties.getDatabaseType(), databaseProperties.getDatabaseVersion(), databaseProperties.getDatabaseInstance(), databaseProperties.getDatabaseImportedFrom(), databaseProperties.getAdditionalProperties(), databaseProperties.getTypeName(), databaseProperties.getExtendedProperties(), databaseProperties.getVendorProperties(), null, null, false, false, new Date(), "createDatabase");
            response.setGUID(databaseGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseFromTemplate(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, TemplateProperties templateProperties) {
        String methodName = "createDatabaseFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseFromTemplate");
            response.setGUID(handler.createDatabaseFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), templateProperties.getNetworkAddress(), false, false, new Date(), "createDatabaseFromTemplate"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabase(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, DatabaseProperties databaseProperties) {
        String methodName = "updateDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabase");
            handler.updateDatabase(userId, databaseManagerGUID, databaseManagerName, databaseGUID, databaseProperties.getQualifiedName(), databaseProperties.getDisplayName(), databaseProperties.getDescription(), databaseProperties.getCreateTime(), databaseProperties.getModifiedTime(), databaseProperties.getEncodingType(), databaseProperties.getEncodingLanguage(), databaseProperties.getEncodingDescription(), databaseProperties.getEncodingProperties(), databaseProperties.getDatabaseType(), databaseProperties.getDatabaseVersion(), databaseProperties.getDatabaseInstance(), databaseProperties.getDatabaseImportedFrom(), databaseProperties.getAdditionalProperties(), databaseProperties.getTypeName(), databaseProperties.getExtendedProperties(), databaseProperties.getVendorProperties(), null, null, true, false, false, new Date(), "updateDatabase");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishDatabase(String serverName, String userId, String databaseGUID, NullRequestBody nullRequestBody) {
        String methodName = "publishDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "publishDatabase");
            handler.publishDatabase(userId, databaseGUID, false, false, new Date(), "publishDatabase");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawDatabase(String serverName, String userId, String databaseGUID, NullRequestBody nullRequestBody) {
        String methodName = "withdrawDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "withdrawDatabase");
            handler.withdrawDatabase(userId, databaseGUID, false, false, new Date(), "withdrawDatabase");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabase(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, String qualifiedName, NullRequestBody nullRequestBody) {
        String methodName = "removeDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabase");
            handler.removeDatabase(userId, databaseManagerGUID, databaseManagerName, databaseGUID, qualifiedName, false, false, new Date(), "removeDatabase");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabasesResponse findDatabases(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findDatabases";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabases");
        DatabasesResponse response = new DatabasesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabases");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabases");
                List databaseAssets = handler.findDatabases(userId, requestBody.getSearchString(), startFrom, pageSize, false, false, new Date(), "findDatabases");
                response.setElementList(databaseAssets);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findDatabases", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findDatabases", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabasesResponse getDatabasesByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getDatabasesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabasesByName");
        DatabasesResponse response = new DatabasesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabasesByName");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabasesByName");
                List databaseAssets = handler.getDatabasesByName(userId, requestBody.getName(), startFrom, pageSize, false, false, new Date(), "getDatabasesByName");
                response.setElementList(databaseAssets);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDatabasesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabasesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabasesResponse getDatabasesForDatabaseManager(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, int startFrom, int pageSize) {
        String methodName = "getDatabasesForDatabaseManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabasesForDatabaseManager");
        DatabasesResponse response = new DatabasesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabasesForDatabaseManager");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabasesForDatabaseManager");
            List databaseAssets = handler.getDatabasesForDatabaseManager(userId, databaseManagerGUID, databaseManagerName, startFrom, pageSize, false, false, new Date(), "getDatabasesForDatabaseManager");
            response.setElementList(databaseAssets);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabasesForDatabaseManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseResponse getDatabaseByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseByGUID");
        DatabaseResponse response = new DatabaseResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseByGUID");
            DatabaseElement databaseAsset = (DatabaseElement)handler.getDatabaseByGUID(userId, guid, false, false, new Date(), "getDatabaseByGUID");
            response.setElement(databaseAsset);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseSchema(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, DatabaseSchemaProperties databaseSchemaProperties) {
        String methodName = "createDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseSchema");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseSchema");
            String databaseSchemaGUID = handler.createDatabaseSchema(userId, databaseManagerGUID, databaseManagerName, databaseGUID, databaseSchemaProperties.getQualifiedName(), databaseSchemaProperties.getDisplayName(), databaseSchemaProperties.getDescription(), databaseSchemaProperties.getAdditionalProperties(), databaseSchemaProperties.getTypeName(), databaseSchemaProperties.getExtendedProperties(), databaseSchemaProperties.getVendorProperties(), null, null, false, false, new Date(), "createDatabaseSchema");
            response.setGUID(databaseSchemaGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseSchemaFromTemplate(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseGUID, TemplateProperties templateProperties) {
        String methodName = "createDatabaseSchemaFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseSchemaFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseSchemaFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseSchemaFromTemplate");
            response.setGUID(handler.createDatabaseSchemaFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, databaseGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), null, null, false, false, new Date(), "createDatabaseSchemaFromTemplate"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseSchemaFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabaseSchema(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, DatabaseSchemaProperties databaseSchemaProperties) {
        String methodName = "updateDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabaseSchema");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabaseSchema");
            handler.updateDatabaseSchema(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, databaseSchemaProperties.getQualifiedName(), databaseSchemaProperties.getDisplayName(), databaseSchemaProperties.getDescription(), null, 0, null, null, null, null, databaseSchemaProperties.getAdditionalProperties(), databaseSchemaProperties.getTypeName(), databaseSchemaProperties.getExtendedProperties(), databaseSchemaProperties.getVendorProperties(), null, null, true, false, false, new Date(), "updateDatabaseSchema");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishDatabaseSchema(String serverName, String userId, String databaseSchemaGUID, NullRequestBody nullRequestBody) {
        String methodName = "publishDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishDatabaseSchema");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "publishDatabaseSchema");
            handler.publishDatabaseSchema(userId, databaseSchemaGUID, false, false, new Date(), "publishDatabaseSchema");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawDatabaseSchema(String serverName, String userId, String databaseSchemaGUID, NullRequestBody nullRequestBody) {
        String methodName = "withdrawDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "withdrawDatabase");
            handler.withdrawDatabaseSchema(userId, databaseSchemaGUID, false, false, new Date(), "withdrawDatabase");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabaseSchema(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, String qualifiedName, NullRequestBody nullRequestBody) {
        String methodName = "removeDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabaseSchema");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabaseSchema");
            handler.removeDatabaseSchema(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, qualifiedName, false, false, new Date(), "removeDatabaseSchema");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseSchemasResponse findDatabaseSchemas(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findDatabaseSchemas";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabaseSchemas");
        DatabaseSchemasResponse response = new DatabaseSchemasResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabaseSchemas");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabaseSchemas");
                List databaseSchemaAssets = handler.findDatabaseSchemas(userId, requestBody.getSearchString(), startFrom, pageSize, false, false, new Date(), "findDatabaseSchemas");
                response.setElementList(databaseSchemaAssets);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findDatabaseSchemas", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findDatabaseSchemas", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseSchemasResponse getSchemasForDatabase(String serverName, String userId, String databaseGUID, int startFrom, int pageSize) {
        String methodName = "getSchemasForDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemasForDatabase");
        DatabaseSchemasResponse response = new DatabaseSchemasResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemasForDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getSchemasForDatabase");
            List databaseSchemaAssets = handler.getSchemasForDatabase(userId, databaseGUID, startFrom, pageSize, false, false, new Date(), "getSchemasForDatabase");
            response.setElementList(databaseSchemaAssets);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSchemasForDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseSchemasResponse getDatabaseSchemasByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getDatabaseSchemasByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseSchemasByName");
        DatabaseSchemasResponse response = new DatabaseSchemasResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseSchemasByName");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseSchemasByName");
                List databaseSchemaAssets = handler.getDatabaseSchemasByName(userId, requestBody.getName(), startFrom, pageSize, false, false, new Date(), "getDatabaseSchemasByName");
                response.setElementList(databaseSchemaAssets);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDatabaseSchemasByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseSchemasByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseSchemaResponse getDatabaseSchemaByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseSchemaByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseSchemaByGUID");
        DatabaseSchemaResponse response = new DatabaseSchemaResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseSchemaByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseSchemaByGUID");
            DatabaseSchemaElement databaseSchemaAsset = (DatabaseSchemaElement)handler.getDatabaseSchemaByGUID(userId, guid, false, false, new Date(), "getDatabaseSchemaByGUID");
            response.setElement(databaseSchemaAsset);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseSchemaByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseSchemaType(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, NameRequestBody requestBody) {
        String methodName = "createDatabaseSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseSchemaType");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseSchemaType");
                String databaseTableGUID = handler.createDatabaseSchemaType(userId, databaseManagerGUID, databaseManagerName, requestBody.getName(), null, null, new Date(), "createDatabaseSchemaType");
                response.setGUID(databaseTableGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabaseSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachSchemaTypeToDatabaseAsset(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseAssetGUID, String schemaTypeGUID, NullRequestBody requestBody) {
        String methodName = "attachSchemaTypeToDatabaseAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachSchemaTypeToDatabaseAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachSchemaTypeToDatabaseAsset");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "attachSchemaTypeToDatabaseAsset");
            handler.attachSchemaTypeToDatabaseAsset(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, schemaTypeGUID, null, null, false, false, new Date(), "attachSchemaTypeToDatabaseAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "attachSchemaTypeToDatabaseAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseTable(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseAssetGUID, DatabaseTableProperties databaseTableProperties) {
        String methodName = "createDatabaseTable";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseTable");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseTable");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseTable");
            String databaseTableGUID = handler.createDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, databaseTableProperties.getQualifiedName(), databaseTableProperties.getDisplayName(), databaseTableProperties.getDescription(), databaseTableProperties.getIsDeprecated(), databaseTableProperties.getAliases(), databaseTableProperties.getAdditionalProperties(), databaseTableProperties.getTypeName(), databaseTableProperties.getExtendedProperties(), databaseTableProperties.getVendorProperties(), null, null, false, false, new Date(), "createDatabaseTable");
            response.setGUID(databaseTableGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseTable", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseTableFromTemplate(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseAssetGUID, TemplateProperties templateProperties) {
        String methodName = "createDatabaseTableFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseTableFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseTableFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseTableFromTemplate");
            response.setGUID(handler.createDatabaseTableFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, databaseAssetGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), null, null, false, false, new Date(), "createDatabaseTableFromTemplate"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseTableFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseTableForSchemaType(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaTypeGUID, DatabaseTableProperties databaseTableProperties) {
        String methodName = "createDatabaseTableForSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseTableForSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseTableForSchemaType");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseTableForSchemaType");
            String databaseTableGUID = handler.createDatabaseTableForSchemaType(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, databaseTableProperties.getQualifiedName(), databaseTableProperties.getDisplayName(), databaseTableProperties.getDescription(), databaseTableProperties.getIsDeprecated(), databaseTableProperties.getAliases(), databaseTableProperties.getAdditionalProperties(), databaseTableProperties.getTypeName(), databaseTableProperties.getExtendedProperties(), databaseTableProperties.getVendorProperties(), null, null, false, false, new Date(), "createDatabaseTableForSchemaType");
            response.setGUID(databaseTableGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseTableForSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabaseTable(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, DatabaseTableProperties databaseTableProperties) {
        String methodName = "updateDatabaseTable";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabaseTable");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabaseTable");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabaseTable");
            handler.updateDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, databaseTableProperties.getQualifiedName(), databaseTableProperties.getDisplayName(), databaseTableProperties.getDescription(), databaseTableProperties.getIsDeprecated(), databaseTableProperties.getAliases(), databaseTableProperties.getAdditionalProperties(), databaseTableProperties.getTypeName(), databaseTableProperties.getExtendedProperties(), databaseTableProperties.getVendorProperties(), null, null, true, false, false, new Date(), "updateDatabaseTable");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDatabaseTable", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabaseTable(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, String qualifiedName, NullRequestBody nullRequestBody) {
        String methodName = "removeDatabaseTable";
        String elementGUIDParameterName = "databaseTableGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabaseTable");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabaseTable");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabaseTable");
            handler.removeDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, "databaseTableGUID", qualifiedName, false, false, new Date(), "removeDatabaseTable");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeDatabaseTable", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseTablesResponse findDatabaseTables(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findDatabaseTables";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabaseTables");
        DatabaseTablesResponse response = new DatabaseTablesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabaseTables");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabaseTables");
                List databaseTableAttributes = handler.findDatabaseTables(userId, requestBody.getSearchString(), startFrom, pageSize, false, false, new Date(), "findDatabaseTables");
                response.setElementList(databaseTableAttributes);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findDatabaseTables", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findDatabaseTables", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseTablesResponse getTablesForDatabaseAsset(String serverName, String userId, String databaseAssetGUID, int startFrom, int pageSize) {
        String methodName = "getTablesForDatabaseAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTablesForDatabaseAsset");
        DatabaseTablesResponse response = new DatabaseTablesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTablesForDatabaseAsset");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getTablesForDatabaseAsset");
            List databaseTableAttributes = handler.getTablesForDatabaseAsset(userId, databaseAssetGUID, startFrom, pageSize, null, null, false, false, new Date(), "getTablesForDatabaseAsset");
            response.setElementList(databaseTableAttributes);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTablesForDatabaseAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseTablesResponse getDatabaseTablesByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getDatabaseTablesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseTablesByName");
        DatabaseTablesResponse response = new DatabaseTablesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseTablesByName");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseTablesByName");
                List databaseTableAttributes = handler.getDatabaseTablesByName(userId, requestBody.getName(), startFrom, pageSize, false, false, new Date(), "getDatabaseTablesByName");
                response.setElementList(databaseTableAttributes);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDatabaseTablesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseTablesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseTableResponse getDatabaseTableByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseTableByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseTableByGUID");
        DatabaseTableResponse response = new DatabaseTableResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseTableByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseTableByGUID");
            DatabaseTableElement databaseTableAttribute = (DatabaseTableElement)handler.getDatabaseTableByGUID(userId, guid, false, false, new Date(), "getDatabaseTableByGUID");
            response.setElement(databaseTableAttribute);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseTableByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseView(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, DatabaseViewProperties databaseViewProperties) {
        String methodName = "createDatabaseView";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseView");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseView");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseView");
            String databaseViewGUID = handler.createDatabaseView(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, databaseViewProperties.getQualifiedName(), databaseViewProperties.getDisplayName(), databaseViewProperties.getDescription(), databaseViewProperties.getIsDeprecated(), databaseViewProperties.getAliases(), databaseViewProperties.getFormula(), databaseViewProperties.getAdditionalProperties(), databaseViewProperties.getTypeName(), databaseViewProperties.getExtendedProperties(), databaseViewProperties.getVendorProperties(), null, null, false, false, new Date(), "createDatabaseView");
            response.setGUID(databaseViewGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseView", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseViewFromTemplate(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseSchemaGUID, TemplateProperties templateProperties) {
        String methodName = "createDatabaseViewFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseViewFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseViewFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseViewFromTemplate");
            response.setGUID(handler.createDatabaseViewFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, databaseSchemaGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), null, null, false, false, new Date(), "createDatabaseViewFromTemplate"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseViewFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseViewForSchemaType(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaTypeGUID, DatabaseViewProperties databaseViewProperties) {
        String methodName = "createDatabaseViewForSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseViewForSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseViewForSchemaType");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseViewForSchemaType");
            String databaseViewGUID = handler.createDatabaseViewForSchemaType(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, databaseViewProperties.getQualifiedName(), databaseViewProperties.getDisplayName(), databaseViewProperties.getDescription(), databaseViewProperties.getIsDeprecated(), databaseViewProperties.getAliases(), databaseViewProperties.getFormula(), databaseViewProperties.getAdditionalProperties(), databaseViewProperties.getTypeName(), databaseViewProperties.getExtendedProperties(), databaseViewProperties.getVendorProperties(), null, null, false, false, new Date(), "createDatabaseViewForSchemaType");
            response.setGUID(databaseViewGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseViewForSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabaseView(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseViewGUID, DatabaseViewProperties databaseViewProperties) {
        String methodName = "updateDatabaseView";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabaseView");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabaseView");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabaseView");
            handler.updateDatabaseView(userId, databaseManagerGUID, databaseManagerName, databaseViewGUID, databaseViewProperties.getQualifiedName(), databaseViewProperties.getDisplayName(), databaseViewProperties.getDescription(), databaseViewProperties.getIsDeprecated(), databaseViewProperties.getAliases(), databaseViewProperties.getFormula(), databaseViewProperties.getAdditionalProperties(), databaseViewProperties.getTypeName(), databaseViewProperties.getExtendedProperties(), databaseViewProperties.getVendorProperties(), null, null, true, false, false, new Date(), "updateDatabaseView");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDatabaseView", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabaseView(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseViewGUID, String qualifiedName, NullRequestBody nullRequestBody) {
        String methodName = "removeDatabaseView";
        String elementGUIDParameterName = "databaseViewGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabaseView");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabaseView");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabaseView");
            handler.removeDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseViewGUID, "databaseViewGUID", qualifiedName, false, false, new Date(), "removeDatabaseView");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeDatabaseView", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseViewsResponse findDatabaseViews(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findDatabaseViews";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabaseViews");
        DatabaseViewsResponse response = new DatabaseViewsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabaseViews");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabaseViews");
                List databaseViewAttributes = handler.findDatabaseViews(userId, requestBody.getSearchString(), startFrom, pageSize, false, false, new Date(), "findDatabaseViews");
                response.setElementList(databaseViewAttributes);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findDatabaseViews", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findDatabaseViews", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseViewsResponse getViewsForDatabaseAsset(String serverName, String userId, String databaseAssetGUID, int startFrom, int pageSize) {
        String methodName = "getViewsForDatabaseAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getViewsForDatabaseAsset");
        DatabaseViewsResponse response = new DatabaseViewsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getViewsForDatabaseAsset");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getViewsForDatabaseAsset");
            List databaseViewAttributes = handler.getViewsForDatabaseAsset(userId, databaseAssetGUID, startFrom, pageSize, null, null, false, false, new Date(), "getViewsForDatabaseAsset");
            response.setElementList(databaseViewAttributes);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getViewsForDatabaseAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseViewsResponse getDatabaseViewsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getDatabaseViewsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseViewsByName");
        DatabaseViewsResponse response = new DatabaseViewsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseViewsByName");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseViewsByName");
                List databaseViewAttributes = handler.getDatabaseViewsByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getDatabaseViewsByName");
                response.setElementList(databaseViewAttributes);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDatabaseViewsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseViewsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseViewResponse getDatabaseViewByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseViewByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseViewByGUID");
        DatabaseViewResponse response = new DatabaseViewResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseViewByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseViewByGUID");
            DatabaseViewElement databaseViewAttribute = (DatabaseViewElement)handler.getDatabaseViewByGUID(userId, guid, false, false, new Date(), "getDatabaseViewByGUID");
            response.setElement(databaseViewAttribute);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseViewByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseColumn(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, DatabaseColumnProperties databaseColumnProperties) {
        String methodName = "createDatabaseColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseColumn");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String databaseColumnGUID;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseColumn");
            int sortOrder = DataItemSortOrder.UNKNOWN.getOpenTypeOrdinal();
            if (databaseColumnProperties.getSortOrder() != null) {
                sortOrder = databaseColumnProperties.getSortOrder().getOpenTypeOrdinal();
            }
            if ((databaseColumnGUID = handler.createDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, databaseColumnProperties.getQualifiedName(), databaseColumnProperties.getDisplayName(), databaseColumnProperties.getDescription(), databaseColumnProperties.getExternalTypeGUID(), databaseColumnProperties.getDataType(), databaseColumnProperties.getDefaultValue(), databaseColumnProperties.getFixedValue(), databaseColumnProperties.getValidValuesSetGUID(), databaseColumnProperties.getFormula(), databaseColumnProperties.getIsDeprecated(), databaseColumnProperties.getElementPosition(), databaseColumnProperties.getMinCardinality(), databaseColumnProperties.getMaxCardinality(), databaseColumnProperties.getAllowsDuplicateValues(), databaseColumnProperties.getOrderedValues(), databaseColumnProperties.getDefaultValueOverride(), sortOrder, databaseColumnProperties.getMinimumLength(), databaseColumnProperties.getLength(), databaseColumnProperties.getPrecision(), databaseColumnProperties.getIsNullable(), databaseColumnProperties.getNativeJavaClass(), databaseColumnProperties.getAliases(), databaseColumnProperties.getAdditionalProperties(), databaseColumnProperties.getTypeName(), databaseColumnProperties.getExtendedProperties(), databaseColumnProperties.getVendorProperties(), null, null, false, false, new Date(), "createDatabaseColumn")) != null && databaseColumnProperties.getQueries() != null) {
                for (DatabaseQueryProperties queryProperties : databaseColumnProperties.getQueries()) {
                    if (queryProperties == null) continue;
                    handler.createDatabaseColumnQuery(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, queryProperties.getQueryId(), queryProperties.getQuery(), queryProperties.getQueryTargetGUID(), null, null, false, false, new Date(), "createDatabaseColumn");
                }
            }
            response.setGUID(databaseColumnGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseColumnFromTemplate(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseTableGUID, TemplateProperties templateProperties) {
        String methodName = "createDatabaseColumnFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseColumnFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseColumnFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseColumnFromTemplate");
            response.setGUID(handler.createDatabaseColumnFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, databaseTableGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), null, null, false, false, new Date(), "createDatabaseColumnFromTemplate"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseColumnFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabaseColumn(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, DatabaseColumnProperties databaseColumnProperties) {
        String methodName = "updateDatabaseColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabaseColumn");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabaseColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabaseColumn");
            int sortOrder = DataItemSortOrder.UNKNOWN.getOpenTypeOrdinal();
            if (databaseColumnProperties.getSortOrder() != null) {
                sortOrder = databaseColumnProperties.getSortOrder().getOpenTypeOrdinal();
            }
            handler.updateDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, databaseColumnProperties.getQualifiedName(), databaseColumnProperties.getDisplayName(), databaseColumnProperties.getDescription(), databaseColumnProperties.getExternalTypeGUID(), databaseColumnProperties.getDataType(), databaseColumnProperties.getDefaultValue(), databaseColumnProperties.getFixedValue(), databaseColumnProperties.getValidValuesSetGUID(), databaseColumnProperties.getFormula(), databaseColumnProperties.getIsDeprecated(), databaseColumnProperties.getElementPosition(), databaseColumnProperties.getMinCardinality(), databaseColumnProperties.getMaxCardinality(), databaseColumnProperties.getAllowsDuplicateValues(), databaseColumnProperties.getOrderedValues(), databaseColumnProperties.getDefaultValueOverride(), sortOrder, databaseColumnProperties.getMinimumLength(), databaseColumnProperties.getLength(), databaseColumnProperties.getPrecision(), databaseColumnProperties.getIsNullable(), databaseColumnProperties.getNativeJavaClass(), databaseColumnProperties.getAliases(), databaseColumnProperties.getAdditionalProperties(), databaseColumnProperties.getTypeName(), databaseColumnProperties.getExtendedProperties(), databaseColumnProperties.getVendorProperties(), null, null, true, false, false, new Date(), "updateDatabaseColumn");
            if (databaseColumnProperties.getQueries() != null) {
                for (DatabaseQueryProperties queryProperties : databaseColumnProperties.getQueries()) {
                    if (queryProperties == null) continue;
                    handler.createDatabaseColumnQuery(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, queryProperties.getQueryId(), queryProperties.getQuery(), queryProperties.getQueryTargetGUID(), null, null, false, false, new Date(), "updateDatabaseColumn");
                }
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDatabaseColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabaseColumn(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, String qualifiedName, NullRequestBody nullRequestBody) {
        String methodName = "removeDatabaseColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabaseColumn");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabaseColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabaseColumn");
            handler.removeDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, qualifiedName, false, false, new Date(), "removeDatabaseColumn");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeDatabaseColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseColumnsResponse findDatabaseColumns(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findDatabaseColumns";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabaseColumns");
        DatabaseColumnsResponse response = new DatabaseColumnsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabaseColumns");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabaseColumns");
                List databaseColumnAttributes = handler.findDatabaseColumns(userId, requestBody.getSearchString(), startFrom, pageSize, false, false, new Date(), "findDatabaseColumns");
                response.setElementList(databaseColumnAttributes);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findDatabaseColumns", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findDatabaseColumns", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseColumnsResponse getColumnsForDatabaseTable(String serverName, String userId, String databaseTableGUID, int startFrom, int pageSize) {
        String methodName = "getColumnsForDatabaseTable";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getColumnsForDatabaseTable");
        DatabaseColumnsResponse response = new DatabaseColumnsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getColumnsForDatabaseTable");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getColumnsForDatabaseTable");
            List databaseColumnAttributes = handler.getColumnsForDatabaseTable(userId, databaseTableGUID, startFrom, pageSize, false, false, new Date(), "getColumnsForDatabaseTable");
            response.setElementList(databaseColumnAttributes);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getColumnsForDatabaseTable", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseColumnsResponse getDatabaseColumnsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getDatabaseColumnsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseColumnsByName");
        DatabaseColumnsResponse response = new DatabaseColumnsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseColumnsByName");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseColumnsByName");
                List databaseColumnAttributes = handler.getDatabaseColumnsByName(userId, requestBody.getName(), startFrom, pageSize, false, false, new Date(), "getDatabaseColumnsByName");
                response.setElementList(databaseColumnAttributes);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDatabaseColumnsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseColumnsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseColumnResponse getDatabaseColumnByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseColumnByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseColumnByGUID");
        DatabaseColumnResponse response = new DatabaseColumnResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseColumnByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseColumnByGUID");
            DatabaseColumnElement schemaAttribute = (DatabaseColumnElement)handler.getDatabaseColumnByGUID(userId, guid, false, false, new Date(), "getDatabaseColumnByGUID");
            response.setElement(schemaAttribute);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseColumnByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setPrimaryKeyOnColumn(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, DatabasePrimaryKeyProperties databasePrimaryKeyProperties) {
        String methodName = "setPrimaryKeyOnColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setPrimaryKeyOnColumn");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setPrimaryKeyOnColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "setPrimaryKeyOnColumn");
            int keyPattern = KeyPattern.LOCAL_KEY.getOpenTypeOrdinal();
            if (databasePrimaryKeyProperties.getKeyPattern() != null) {
                keyPattern = databasePrimaryKeyProperties.getKeyPattern().getOpenTypeOrdinal();
            }
            handler.setPrimaryKeyOnColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, databasePrimaryKeyProperties.getName(), keyPattern, null, null, true, false, false, new Date(), "setPrimaryKeyOnColumn");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setPrimaryKeyOnColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removePrimaryKeyFromColumn(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, NullRequestBody nullRequestBody) {
        String methodName = "removePrimaryKeyFromColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removePrimaryKeyFromColumn");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removePrimaryKeyFromColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removePrimaryKeyFromColumn");
            handler.removePrimaryKeyFromColumn(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, false, false, new Date(), "removePrimaryKeyFromColumn");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removePrimaryKeyFromColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addForeignKeyRelationship(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String primaryKeyColumnGUID, String foreignKeyColumnGUID, DatabaseForeignKeyProperties databaseForeignKeyProperties) {
        String methodName = "addForeignKeyRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addForeignKeyRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addForeignKeyRelationship");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "addForeignKeyRelationship");
            if (databaseForeignKeyProperties != null) {
                handler.addForeignKeyRelationship(userId, databaseManagerGUID, databaseManagerName, primaryKeyColumnGUID, foreignKeyColumnGUID, databaseForeignKeyProperties.getName(), databaseForeignKeyProperties.getDescription(), databaseForeignKeyProperties.getConfidence(), databaseForeignKeyProperties.getSteward(), databaseForeignKeyProperties.getSource(), null, null, false, false, new Date(), "addForeignKeyRelationship");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addForeignKeyRelationship", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addForeignKeyRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeForeignKeyRelationship(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, String primaryKeyColumnGUID, String foreignKeyColumnGUID, NullRequestBody nullRequestBody) {
        String methodName = "removeForeignKeyRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeForeignKeyRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeForeignKeyRelationship");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeForeignKeyRelationship");
            handler.removeForeignKeyRelationship(userId, databaseManagerGUID, databaseManagerName, primaryKeyColumnGUID, foreignKeyColumnGUID, false, false, new Date(), "removeForeignKeyRelationship");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeForeignKeyRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

