/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.converters.DataManagerOMASConverter;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseForeignKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabasePrimaryKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseQueryProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DerivedSchemaTypeQueryTargetProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DatabaseColumnConverter<B>
extends DataManagerOMASConverter<B> {
    public DatabaseColumnConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public <T> B getNewSchemaAttributeBean(Class<B> beanClass, EntityDetail schemaAttributeEntity, Class<T> typeClass, T schemaType, List<Relationship> schemaAttributeRelationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DatabaseColumnElement) {
                DatabaseColumnElement bean = (DatabaseColumnElement)returnBean;
                DatabaseColumnProperties properties = new DatabaseColumnProperties();
                if (schemaAttributeEntity != null) {
                    InstanceProperties classificationProperties;
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, schemaAttributeEntity, methodName));
                    super.setUpSchemaAttribute(schemaAttributeEntity, null, (SchemaAttributeProperties)properties);
                    properties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    if (schemaType instanceof SchemaTypeElement) {
                        SchemaTypeElement schemaTypeElement = (SchemaTypeElement)schemaType;
                        super.addSchemaTypeToAttribute(schemaTypeElement, (SchemaAttributeProperties)properties);
                        properties.setFormula(schemaTypeElement.getFormula());
                        if (schemaTypeElement.getQueries() != null && !schemaTypeElement.getQueries().isEmpty()) {
                            ArrayList<DatabaseQueryProperties> databaseQueryPropertiesList = new ArrayList<DatabaseQueryProperties>();
                            for (DerivedSchemaTypeQueryTargetProperties derivedSchemaTypeQueryTargetProperties : schemaTypeElement.getQueries()) {
                                if (derivedSchemaTypeQueryTargetProperties == null) continue;
                                DatabaseQueryProperties databaseQueryProperties = new DatabaseQueryProperties();
                                databaseQueryProperties.setQuery(derivedSchemaTypeQueryTargetProperties.getQuery());
                                databaseQueryProperties.setQueryId(derivedSchemaTypeQueryTargetProperties.getQueryId());
                                databaseQueryProperties.setQueryTargetGUID(derivedSchemaTypeQueryTargetProperties.getQueryTargetGUID());
                                databaseQueryPropertiesList.add(databaseQueryProperties);
                            }
                            properties.setQueries(databaseQueryPropertiesList);
                        }
                    }
                    if ((classificationProperties = super.getClassificationProperties("PrimaryKey", schemaAttributeEntity)) != null) {
                        DatabasePrimaryKeyProperties primaryKeyProperties = new DatabasePrimaryKeyProperties();
                        primaryKeyProperties.setName(this.removeName(classificationProperties));
                        primaryKeyProperties.setKeyPattern(this.removeKeyPattern(classificationProperties));
                        primaryKeyProperties.setExtendedProperties(this.getRemainingExtendedProperties(classificationProperties));
                        bean.setPrimaryKeyProperties(primaryKeyProperties);
                    }
                    if (schemaAttributeRelationships != null) {
                        for (Relationship relationship : schemaAttributeRelationships) {
                            if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ForeignKey") || !schemaAttributeEntity.getGUID().equals(relationship.getEntityTwoProxy().getGUID())) continue;
                            DatabaseForeignKeyProperties databaseForeignKeyProperties = new DatabaseForeignKeyProperties();
                            InstanceProperties relationshipProperties = relationship.getProperties();
                            databaseForeignKeyProperties.setEffectiveFrom(relationshipProperties.getEffectiveFromTime());
                            databaseForeignKeyProperties.setEffectiveTo(relationshipProperties.getEffectiveToTime());
                            databaseForeignKeyProperties.setName(this.removeName(relationshipProperties));
                            databaseForeignKeyProperties.setDescription(this.removeDataFieldDescription(relationshipProperties));
                            databaseForeignKeyProperties.setConfidence(this.removeConfidence(relationshipProperties));
                            databaseForeignKeyProperties.setSteward(this.removeSteward(relationshipProperties));
                            databaseForeignKeyProperties.setSource(this.removeSource(relationshipProperties));
                            databaseForeignKeyProperties.setExtendedProperties(this.getRemainingExtendedProperties(relationshipProperties));
                            bean.setForeignKeyProperties(databaseForeignKeyProperties);
                            bean.setReferencedColumnGUID(relationship.getEntityTwoProxy().getGUID());
                            bean.setReferencedColumnQualifiedName(this.getQualifiedName(relationship.getEntityTwoProxy().getUniqueProperties()));
                        }
                    }
                    bean.setDatabaseColumnProperties(properties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

