/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.datamanager.converters.DataManagerOMASConverter;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseSchemaProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DatabaseSchemaConverter<B>
extends DataManagerOMASConverter<B> {
    public DatabaseSchemaConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DatabaseSchemaElement) {
                DatabaseSchemaElement bean = (DatabaseSchemaElement)returnBean;
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    DatabaseSchemaProperties databaseSchemaProperties = new DatabaseSchemaProperties();
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    databaseSchemaProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    databaseSchemaProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    databaseSchemaProperties.setName(this.removeName(instanceProperties));
                    databaseSchemaProperties.setDisplayName(databaseSchemaProperties.getName());
                    databaseSchemaProperties.setVersionIdentifier(this.removeVersionIdentifier(instanceProperties));
                    databaseSchemaProperties.setDescription(this.removeDescription(instanceProperties));
                    databaseSchemaProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    databaseSchemaProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setDatabaseSchemaProperties(databaseSchemaProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

