/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.converters.DataManagerOMASConverter;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ComplexSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DerivedSchemaTypeQueryTargetProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EnumSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ExternalSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeConverter<B>
extends DataManagerOMASConverter<B> {
    public SchemaTypeConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewSchemaTypeBean(Class<B> beanClass, InstanceHeader schemaRootHeader, String schemaTypeTypeName, InstanceProperties instanceProperties, List<Classification> schemaRootClassifications, int attributeCount, String validValueSetGUID, String externalSchemaTypeGUID, B externalSchemaType, String mapFromSchemaTypeGUID, B mapFromSchemaType, String mapToSchemaTypeGUID, B mapToSchemaType, List<String> schemaTypeOptionGUIDs, List<B> schemaTypeOptions, List<Relationship> queryTargetRelationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof SchemaTypeElement) {
                if (schemaRootHeader != null && instanceProperties != null) {
                    SchemaTypeElement bean = (SchemaTypeElement)returnBean;
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, schemaRootHeader, schemaRootClassifications, methodName));
                    if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "PrimitiveSchemaType")) {
                        bean.setSchemaTypeProperties(this.getPrimitiveSchemaType(instanceProperties));
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "LiteralSchemaType")) {
                        bean.setSchemaTypeProperties(this.getLiteralSchemaType(instanceProperties));
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "ComplexSchemaType")) {
                        bean.setSchemaTypeProperties(this.getComplexSchemaType(instanceProperties));
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "LiteralSchemaType")) {
                        bean.setSchemaTypeProperties(this.getEnumSchemaType(instanceProperties, validValueSetGUID));
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "MapSchemaType")) {
                        bean.setSchemaTypeProperties(this.getMapSchemaType(instanceProperties));
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "SchemaTypeChoice")) {
                        bean.setSchemaTypeProperties(this.getSchemaTypeChoice(instanceProperties));
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "ExternalSchemaType")) {
                        bean.setSchemaTypeProperties(this.getExternalSchemaType(instanceProperties));
                    } else {
                        super.validateInstanceType("SchemaType", beanClass.getName(), schemaTypeTypeName, methodName);
                    }
                    bean.setAttributeCount(attributeCount);
                    bean.setMapFromElement((SchemaTypeElement)mapFromSchemaType);
                    bean.setMapToElement((SchemaTypeElement)mapToSchemaType);
                    bean.setExternalSchemaType((SchemaTypeElement)externalSchemaType);
                    if (schemaTypeOptions != null && !schemaTypeOptions.isEmpty()) {
                        ArrayList<SchemaTypeElement> schemaTypeOptionBeans = new ArrayList<SchemaTypeElement>();
                        for (B optionBean : schemaTypeOptions) {
                            if (optionBean == null) continue;
                            schemaTypeOptionBeans.add((SchemaTypeElement)optionBean);
                        }
                        if (!schemaTypeOptionBeans.isEmpty()) {
                            bean.setSchemaOptions(schemaTypeOptionBeans);
                        }
                    }
                    InstanceProperties classificationProperties = super.getClassificationProperties("CalculatedValue", schemaRootClassifications);
                    bean.setFormula(this.getFormula(classificationProperties));
                    if (queryTargetRelationships != null) {
                        ArrayList<DerivedSchemaTypeQueryTargetProperties> queryTargets = new ArrayList<DerivedSchemaTypeQueryTargetProperties>();
                        for (Relationship relationship : queryTargetRelationships) {
                            if (relationship != null && relationship.getEntityTwoProxy() != null) {
                                DerivedSchemaTypeQueryTargetProperties queryTargetProperties = new DerivedSchemaTypeQueryTargetProperties();
                                queryTargetProperties.setQueryId(this.getQueryId(relationship.getProperties()));
                                queryTargetProperties.setQuery(this.getQuery(relationship.getProperties()));
                                queryTargetProperties.setQueryTargetGUID(relationship.getEntityTwoProxy().getGUID());
                                queryTargets.add(queryTargetProperties);
                                continue;
                            }
                            this.handleBadRelationship(beanClass.getName(), relationship, methodName);
                        }
                        if (!queryTargets.isEmpty()) {
                            bean.setQueries(queryTargets);
                        }
                    }
                    return returnBean;
                }
                this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
            }
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
        }
        return null;
    }

    private SchemaTypeProperties getLiteralSchemaType(InstanceProperties instanceProperties) {
        LiteralSchemaTypeProperties schemaType = new LiteralSchemaTypeProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        schemaType.setDataType(this.removeDataType(propertiesCopy));
        schemaType.setFixedValue(this.removeFixedValue(propertiesCopy));
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(propertiesCopy));
        return schemaType;
    }

    private SchemaTypeProperties getPrimitiveSchemaType(InstanceProperties instanceProperties) {
        PrimitiveSchemaTypeProperties schemaType = new PrimitiveSchemaTypeProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        schemaType.setDataType(this.removeDataType(propertiesCopy));
        schemaType.setDefaultValue(this.removeDefaultValue(propertiesCopy));
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(propertiesCopy));
        return schemaType;
    }

    private SchemaTypeProperties getComplexSchemaType(InstanceProperties instanceProperties) {
        ComplexSchemaTypeProperties schemaType = new ComplexSchemaTypeProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(propertiesCopy));
        return schemaType;
    }

    private SchemaTypeProperties getEnumSchemaType(InstanceProperties instanceProperties, String validValueSetGUID) {
        EnumSchemaTypeProperties schemaType = new EnumSchemaTypeProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        schemaType.setDataType(this.removeDataType(propertiesCopy));
        schemaType.setDefaultValue(this.removeDefaultValue(propertiesCopy));
        schemaType.setValidValueSetGUID(validValueSetGUID);
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(propertiesCopy));
        return schemaType;
    }

    private SchemaTypeProperties getSchemaTypeChoice(InstanceProperties instanceProperties) {
        SchemaTypeChoiceProperties schemaType = new SchemaTypeChoiceProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(propertiesCopy));
        return schemaType;
    }

    private SchemaTypeProperties getExternalSchemaType(InstanceProperties instanceProperties) {
        ExternalSchemaTypeProperties schemaType = new ExternalSchemaTypeProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(propertiesCopy));
        return schemaType;
    }

    private SchemaTypeProperties getMapSchemaType(InstanceProperties instanceProperties) {
        MapSchemaTypeProperties schemaType = new MapSchemaTypeProperties();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaTypeProperties)schemaType, propertiesCopy);
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(propertiesCopy));
        return schemaType;
    }

    private void updateBasicSchemaTypeProperties(SchemaTypeProperties bean, InstanceProperties instanceProperties) {
        bean.setQualifiedName(this.removeQualifiedName(instanceProperties));
        bean.setDisplayName(this.removeDisplayName(instanceProperties));
        bean.setDescription(this.removeDescription(instanceProperties));
        bean.setIsDeprecated(this.removeIsDeprecated(instanceProperties));
        bean.setVersionNumber(this.removeVersionNumber(instanceProperties));
        bean.setAuthor(this.removeAuthor(instanceProperties));
        bean.setUsage(this.removeUsage(instanceProperties));
        bean.setEncodingStandard(this.removeEncodingStandard(instanceProperties));
        bean.setNamespace(this.removeNamespace(instanceProperties));
        bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
    }
}

