/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIOperationElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIParameterListElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIOperationProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIParameterListProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIParameterListType;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIOperationRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIOperationResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIOperationsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIParameterListRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIParameterListResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIParameterListsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.APIOperationHandler;
import org.odpi.openmetadata.commonservices.generichandlers.APIParameterListHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.slf4j.LoggerFactory;

public class APIManagerRESTServices {
    private static final DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(APIManagerRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createAPI(String serverName, String userId, boolean apiManagerIsHome, String endpointGUID, APIRequestBody requestBody) {
        String methodName = "createAPI";
        String apiManagerGUIDParameterName = "apiManagerGUID";
        String apiGUIDParameterName = "apiGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createAPI");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createAPI");
            AssetHandler<APIElement> handler = instanceHandler.getAPIHandler(userId, serverName, "createAPI");
            if (requestBody != null) {
                String apiGUID;
                String typeName = "DeployedAPI";
                if (requestBody.getTypeName() != null) {
                    typeName = requestBody.getTypeName();
                }
                if ((apiGUID = handler.createAssetInRepository(userId, handler.getExternalSourceID(apiManagerIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(apiManagerIsHome, requestBody.getExternalSourceName()), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getAdditionalProperties(), typeName, requestBody.getExtendedProperties(), InstanceStatus.ACTIVE, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), new Date(), "createAPI")) != null) {
                    handler.attachAssetToSoftwareServerCapability(userId, handler.getExternalSourceID(apiManagerIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(apiManagerIsHome, requestBody.getExternalSourceName()), apiGUID, "apiGUID", requestBody.getExternalSourceGUID(), "apiManagerGUID", null, null, false, false, new Date(), "createAPI");
                    handler.setVendorProperties(userId, apiGUID, requestBody.getVendorProperties(), false, false, new Date(), "createAPI");
                    if (endpointGUID != null) {
                        handler.linkElementToElement(userId, handler.getExternalSourceID(apiManagerIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(apiManagerIsHome, requestBody.getExternalSourceName()), apiGUID, "apiGUID", "DeployedAPI", endpointGUID, "endpointGUID", "Endpoint", false, false, "de5b9501-3ad4-4803-a8b2-e311c72a4336", "APIEndpoint", (InstanceProperties)null, null, null, new Date(), "createAPI");
                    }
                }
                response.setGUID(apiGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createAPI", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createAPI", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createAPIFromTemplate(String serverName, String userId, String endpointGUID, String templateGUID, boolean apiManagerIsHome, TemplateRequestBody requestBody) {
        String methodName = "createAPIFromTemplate";
        String apiManagerGUIDParameterName = "apiManagerGUID";
        String apiGUIDParameterName = "apiGUID";
        String endpointGUIDParameterName = "endpointGUID";
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createAPIFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createAPIFromTemplate");
            AssetHandler<APIElement> handler = instanceHandler.getAPIHandler(userId, serverName, "createAPIFromTemplate");
            if (requestBody != null) {
                String apiGUID = handler.addAssetFromTemplate(userId, handler.getExternalSourceID(apiManagerIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(apiManagerIsHome, requestBody.getExternalSourceName()), templateGUID, "templateGUID", "7dbb3e63-138f-49f1-97b4-66313871fc14", "DeployedAPI", requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), null, requestBody.getNetworkAddress(), false, false, new Date(), "createAPIFromTemplate");
                handler.attachAssetToSoftwareServerCapability(userId, handler.getExternalSourceID(apiManagerIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(apiManagerIsHome, requestBody.getExternalSourceName()), apiGUID, "apiGUID", requestBody.getExternalSourceGUID(), "apiManagerGUID", null, null, false, false, new Date(), "createAPIFromTemplate");
                if (endpointGUID != null) {
                    handler.linkElementToElement(userId, handler.getExternalSourceID(apiManagerIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(apiManagerIsHome, requestBody.getExternalSourceName()), apiGUID, "apiGUID", "DeployedAPI", endpointGUID, "endpointGUID", "Endpoint", false, false, "de5b9501-3ad4-4803-a8b2-e311c72a4336", "APIEndpoint", (InstanceProperties)null, null, null, new Date(), "createAPIFromTemplate");
                }
                response.setGUID(apiGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createAPIFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createAPIFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAPI(String serverName, String userId, String apiGUID, boolean isMergeUpdate, APIRequestBody requestBody) {
        String methodName = "updateAPI";
        String apiGUIDParameterName = "apiGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAPI");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAPI");
            AssetHandler<APIElement> handler = instanceHandler.getAPIHandler(userId, serverName, "updateAPI");
            if (requestBody != null) {
                String typeName = "DeployedAPI";
                if (requestBody.getTypeName() != null) {
                    typeName = requestBody.getTypeName();
                }
                handler.updateAsset(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), apiGUID, "apiGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getAdditionalProperties(), typeName, requestBody.getExtendedProperties(), null, null, isMergeUpdate, false, false, new Date(), "updateAPI");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, apiGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateAPI");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateAPI", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateAPI", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishAPI(String serverName, String userId, String apiGUID, NullRequestBody nullRequestBody) {
        String methodName = "publishAPI";
        String apiGUIDParameterName = "apiGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishAPI");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishAPI");
            AssetHandler<APIElement> handler = instanceHandler.getAPIHandler(userId, serverName, "publishAPI");
            handler.publishAsset(userId, apiGUID, "apiGUID", false, false, new Date(), "publishAPI");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishAPI", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawAPI(String serverName, String userId, String apiGUID, NullRequestBody nullRequestBody) {
        String methodName = "withdrawAPI";
        String apiGUIDParameterName = "apiGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawAPI");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawAPI");
            AssetHandler<APIElement> handler = instanceHandler.getAPIHandler(userId, serverName, "withdrawAPI");
            handler.withdrawAsset(userId, apiGUID, "apiGUID", false, false, new Date(), "withdrawAPI");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawAPI", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeAPI(String serverName, String userId, String apiGUID, String qualifiedName, MetadataSourceRequestBody requestBody) {
        String methodName = "removeAPI";
        String apiGUIDParameterName = "apiGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeAPI");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeAPI");
            AssetHandler<APIElement> handler = instanceHandler.getAPIHandler(userId, serverName, "removeAPI");
            if (requestBody != null) {
                handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), apiGUID, "apiGUID", "7dbb3e63-138f-49f1-97b4-66313871fc14", "DeployedAPI", "qualifiedName", qualifiedName, false, false, new Date(), "removeAPI");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeAPI", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeAPI", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public APIsResponse findAPIs(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findAPIs";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAPIs");
        APIsResponse response = new APIsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAPIs");
            if (requestBody != null) {
                AssetHandler<APIElement> handler = instanceHandler.getAPIHandler(userId, serverName, "findAPIs");
                List apiElements = handler.findAssets(userId, "7dbb3e63-138f-49f1-97b4-66313871fc14", "DeployedAPI", requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findAPIs");
                response.setElementList(this.setUpVendorProperties(userId, apiElements, handler, "findAPIs"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findAPIs", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findAPIs", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public APIsResponse getAPIsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getAPIsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAPIsByName");
        APIsResponse response = new APIsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAPIsByName");
            if (requestBody != null) {
                AssetHandler<APIElement> handler = instanceHandler.getAPIHandler(userId, serverName, "getAPIsByName");
                List apiElements = handler.getAssetsByName(userId, "7dbb3e63-138f-49f1-97b4-66313871fc14", "DeployedAPI", requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getAPIsByName");
                response.setElementList(this.setUpVendorProperties(userId, apiElements, handler, "getAPIsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAPIsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAPIsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public APIsResponse getAPIsForAPIManager(String serverName, String userId, String apiManagerGUID, String apiManagerName, int startFrom, int pageSize) {
        String methodName = "getAPIsForAPIManager";
        String apiManagerGUIDParameterName = "apiManagerGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAPIsForAPIManager");
        APIsResponse response = new APIsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAPIsForAPIManager");
            AssetHandler<APIElement> handler = instanceHandler.getAPIHandler(userId, serverName, "getAPIsForAPIManager");
            List apiElements = handler.getAttachedElements(userId, apiManagerGUID, "apiManagerGUID", "SoftwareCapability", "56315447-88a6-4235-ba91-fead86524ebf", "ServerAssetUse", "DeployedAPI", null, null, 0, false, false, startFrom, pageSize, new Date(), "getAPIsForAPIManager");
            response.setElementList(this.setUpVendorProperties(userId, apiElements, handler, "getAPIsForAPIManager"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAPIsForAPIManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public APIsResponse getAPIsByEndpoint(String serverName, String userId, String endpointGUID, int startFrom, int pageSize) {
        String methodName = "getAPIsByEndpoint";
        String guidParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAPIsByEndpoint");
        APIsResponse response = new APIsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAPIsByEndpoint");
            AssetHandler<APIElement> handler = instanceHandler.getAPIHandler(userId, serverName, "getAPIsByEndpoint");
            List apiElements = handler.getAttachedElements(userId, endpointGUID, "endpointGUID", "Endpoint", "de5b9501-3ad4-4803-a8b2-e311c72a4336", "APIEndpoint", "DeployedAPI", null, null, 0, false, false, startFrom, pageSize, new Date(), "getAPIsByEndpoint");
            response.setElementList(this.setUpVendorProperties(userId, apiElements, handler, "getAPIsByEndpoint"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAPIsByEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public APIResponse getAPIByGUID(String serverName, String userId, String guid) {
        String methodName = "getAPIByGUID";
        String guidParameterName = "apiGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAPIByGUID");
        APIResponse response = new APIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAPIByGUID");
            AssetHandler<APIElement> handler = instanceHandler.getAPIHandler(userId, serverName, "getAPIByGUID");
            APIElement apiElement = (APIElement)handler.getBeanFromRepository(userId, guid, "apiGUID", "DeployedAPI", false, false, new Date(), "getAPIByGUID");
            response.setElement(this.setUpVendorProperties(userId, apiElement, handler, "getAPIByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAPIByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createAPIOperation(String serverName, String userId, String apiGUID, APIOperationRequestBody requestBody) {
        String methodName = "createAPIOperation";
        String apiGUIDParameterName = "apiGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createAPIOperation");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createAPIOperation");
            APIOperationHandler<APIOperationElement> handler = instanceHandler.getAPIOperationHandler(userId, serverName, "createAPIOperation");
            if (requestBody != null) {
                String apiOperationGUID = handler.createAPIOperation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), apiGUID, "apiGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, false, false, new Date(), "createAPIOperation");
                if (requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, apiGUID, requestBody.getVendorProperties(), false, false, new Date(), "createAPIOperation");
                }
                response.setGUID(apiOperationGUID);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createAPIOperation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createAPIOperationFromTemplate(String serverName, String userId, String templateGUID, String apiGUID, TemplateRequestBody requestBody) {
        String methodName = "createAPIOperationFromTemplate";
        String apiGUIDParameterName = "apiGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createAPIOperationFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createAPIOperationFromTemplate");
            APIOperationHandler<APIOperationElement> handler = instanceHandler.getAPIOperationHandler(userId, serverName, "createAPIOperationFromTemplate");
            if (requestBody != null) {
                response.setGUID(handler.createAPIOperationFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), apiGUID, "apiGUID", templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), null, null, false, false, new Date(), "createAPIOperationFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createAPIOperationFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createAPIOperationFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAPIOperation(String serverName, String userId, String apiOperationGUID, boolean isMergeUpdate, APIOperationRequestBody requestBody) {
        String methodName = "updateAPIOperation";
        String apiOperationGUIDParameterName = "apiOperationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAPIOperation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAPIOperation");
            APIOperationHandler<APIOperationElement> handler = instanceHandler.getAPIOperationHandler(userId, serverName, "updateAPIOperation");
            if (requestBody != null) {
                handler.updateAPIOperation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), apiOperationGUID, "apiOperationGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, isMergeUpdate, false, false, new Date(), "updateAPIOperation");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, apiOperationGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateAPIOperation");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateAPIOperation", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateAPIOperation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeAPIOperation(String serverName, String userId, String apiOperationGUID, String qualifiedName, MetadataSourceRequestBody requestBody) {
        String methodName = "removeAPIOperation";
        String apiOperationGUIDParameterName = "apiOperationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeAPIOperation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeAPIOperation");
            APIOperationHandler<APIOperationElement> handler = instanceHandler.getAPIOperationHandler(userId, serverName, "removeAPIOperation");
            if (requestBody != null) {
                handler.removeAPIOperation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), apiOperationGUID, "apiOperationGUID", qualifiedName, false, false, new Date(), "removeAPIOperation");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeAPIOperation", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeAPIOperation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public APIOperationsResponse findAPIOperations(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findAPIOperations";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAPIOperations");
        APIOperationsResponse response = new APIOperationsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAPIOperations");
            if (requestBody != null) {
                APIOperationHandler<APIOperationElement> handler = instanceHandler.getAPIOperationHandler(userId, serverName, "findAPIOperations");
                List elements = handler.findAPIOperations(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findAPIOperations");
                response.setElementList(this.setUpVendorProperties(userId, elements, handler, "findAPIOperations"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findAPIOperations", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findAPIOperations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public APIOperationsResponse getAPIOperationsForAPI(String serverName, String userId, String apiGUID, int startFrom, int pageSize) {
        String methodName = "getAPIOperationsForTopic";
        String apiGUIDParameterName = "apiGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAPIOperationsForTopic");
        APIOperationsResponse response = new APIOperationsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAPIOperationsForTopic");
            APIOperationHandler<APIOperationElement> handler = instanceHandler.getAPIOperationHandler(userId, serverName, "getAPIOperationsForTopic");
            List elements = handler.getAPIOperationsForAPI(userId, apiGUID, "apiGUID", startFrom, pageSize, false, false, new Date(), "getAPIOperationsForTopic");
            response.setElementList(this.setUpVendorProperties(userId, elements, handler, "getAPIOperationsForTopic"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAPIOperationsForTopic", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public APIOperationsResponse getAPIOperationsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getAPIOperationsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAPIOperationsByName");
        APIOperationsResponse response = new APIOperationsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAPIOperationsByName");
            if (requestBody != null) {
                APIOperationHandler<APIOperationElement> handler = instanceHandler.getAPIOperationHandler(userId, serverName, "getAPIOperationsByName");
                List elements = handler.getAPIOperationsByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getAPIOperationsByName");
                response.setElementList(this.setUpVendorProperties(userId, elements, handler, "getAPIOperationsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAPIOperationsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAPIOperationsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public APIOperationResponse getAPIOperationByGUID(String serverName, String userId, String guid) {
        String methodName = "getAPIOperationByGUID";
        String apiOperationGUIDParameterName = "apiOperationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAPIOperationByGUID");
        APIOperationResponse response = new APIOperationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAPIOperationByGUID");
            APIOperationHandler<APIOperationElement> handler = instanceHandler.getAPIOperationHandler(userId, serverName, "getAPIOperationByGUID");
            APIOperationElement element = (APIOperationElement)handler.getAPIOperationByGUID(userId, guid, "apiOperationGUID", false, false, new Date(), "getAPIOperationByGUID");
            response.setElement(this.setUpVendorProperties(userId, element, handler, "getAPIOperationByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAPIOperationByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createAPIParameterList(String serverName, String userId, String apiOperationGUID, APIParameterListType parameterListType, APIParameterListRequestBody requestBody) {
        String methodName = "createAPIParameterList";
        String apiOperationGUIDParameterName = "apiOperationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createAPIParameterList");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createAPIParameterList");
            APIParameterListHandler<APIParameterListElement> handler = instanceHandler.getAPIParameterListHandler(userId, serverName, "createAPIParameterList");
            if (requestBody != null) {
                String apiParameterListGUID = handler.createAPIParameterList(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), apiOperationGUID, "apiOperationGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getRequired(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), this.getRelationshipType(parameterListType), false, false, new Date(), "createAPIParameterList");
                if (requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, apiOperationGUID, requestBody.getVendorProperties(), false, false, new Date(), "createAPIParameterList");
                }
                response.setGUID(apiParameterListGUID);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createAPIParameterList", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private String getRelationshipType(APIParameterListType parameterListType) {
        String relationshipTypeName = "APIHeader";
        if (APIParameterListType.REQUEST.equals((Object)parameterListType)) {
            relationshipTypeName = "APIRequest";
        } else if (APIParameterListType.RESPONSE.equals((Object)parameterListType)) {
            relationshipTypeName = "APIResponse";
        }
        return relationshipTypeName;
    }

    public GUIDResponse createAPIParameterListFromTemplate(String serverName, String userId, String templateGUID, String apiOperationGUID, APIParameterListType parameterListType, TemplateRequestBody requestBody) {
        String methodName = "createAPIParameterListFromTemplate";
        String apiOperationGUIDParameterName = "apiOperationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createAPIParameterListFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createAPIParameterListFromTemplate");
            APIParameterListHandler<APIParameterListElement> handler = instanceHandler.getAPIParameterListHandler(userId, serverName, "createAPIParameterListFromTemplate");
            if (requestBody != null) {
                response.setGUID(handler.createAPIParameterListFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), apiOperationGUID, "apiOperationGUID", templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), this.getRelationshipType(parameterListType), false, false, new Date(), "createAPIParameterListFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createAPIParameterListFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createAPIParameterListFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAPIParameterList(String serverName, String userId, String apiParameterListGUID, boolean isMergeUpdate, APIParameterListRequestBody requestBody) {
        String methodName = "updateAPIParameterList";
        String apiParameterListGUIDParameterName = "apiParameterListGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAPIParameterList");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAPIParameterList");
            APIParameterListHandler<APIParameterListElement> handler = instanceHandler.getAPIParameterListHandler(userId, serverName, "updateAPIParameterList");
            if (requestBody != null) {
                handler.updateAPIParameterList(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), apiParameterListGUID, "apiParameterListGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getRequired(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, isMergeUpdate, false, false, new Date(), "updateAPIParameterList");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, apiParameterListGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateAPIParameterList");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateAPIParameterList", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateAPIParameterList", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeAPIParameterList(String serverName, String userId, String apiParameterListGUID, String qualifiedName, MetadataSourceRequestBody requestBody) {
        String methodName = "removeAPIParameterList";
        String apiParameterListGUIDParameterName = "apiParameterListGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeAPIParameterList");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeAPIParameterList");
            APIParameterListHandler<APIParameterListElement> handler = instanceHandler.getAPIParameterListHandler(userId, serverName, "removeAPIParameterList");
            if (requestBody != null) {
                handler.removeAPIParameterList(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), apiParameterListGUID, "apiParameterListGUID", qualifiedName, false, false, new Date(), "removeAPIParameterList");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeAPIParameterList", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeAPIParameterList", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public APIParameterListsResponse findAPIParameterLists(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findAPIParameterLists";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAPIParameterLists");
        APIParameterListsResponse response = new APIParameterListsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAPIParameterLists");
            if (requestBody != null) {
                APIParameterListHandler<APIParameterListElement> handler = instanceHandler.getAPIParameterListHandler(userId, serverName, "findAPIParameterLists");
                List elements = handler.findAPIParameterLists(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findAPIParameterLists");
                response.setElementList(this.setUpVendorProperties(userId, elements, handler, "findAPIParameterLists"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findAPIParameterLists", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findAPIParameterLists", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public APIParameterListsResponse getAPIParameterListsForOperation(String serverName, String userId, String apiOperationGUID, int startFrom, int pageSize) {
        String methodName = "getAPIParameterListsForTopic";
        String apiOperationGUIDParameterName = "apiOperationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAPIParameterListsForTopic");
        APIParameterListsResponse response = new APIParameterListsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAPIParameterListsForTopic");
            APIParameterListHandler<APIParameterListElement> handler = instanceHandler.getAPIParameterListHandler(userId, serverName, "getAPIParameterListsForTopic");
            List elements = handler.getAPIParameterListsForOperation(userId, apiOperationGUID, "apiOperationGUID", startFrom, pageSize, false, false, new Date(), "getAPIParameterListsForTopic");
            response.setElementList(this.setUpVendorProperties(userId, elements, handler, "getAPIParameterListsForTopic"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAPIParameterListsForTopic", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public APIParameterListsResponse getAPIParameterListsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getAPIParameterListsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAPIParameterListsByName");
        APIParameterListsResponse response = new APIParameterListsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAPIParameterListsByName");
            if (requestBody != null) {
                APIParameterListHandler<APIParameterListElement> handler = instanceHandler.getAPIParameterListHandler(userId, serverName, "getAPIParameterListsByName");
                List elements = handler.getAPIParameterListsByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getAPIParameterListsByName");
                response.setElementList(this.setUpVendorProperties(userId, elements, handler, "getAPIParameterListsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAPIParameterListsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAPIParameterListsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public APIParameterListResponse getAPIParameterListByGUID(String serverName, String userId, String guid) {
        String methodName = "getAPIParameterListByGUID";
        String apiParameterListGUIDParameterName = "apiParameterListGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAPIParameterListByGUID");
        APIParameterListResponse response = new APIParameterListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAPIParameterListByGUID");
            APIParameterListHandler<APIParameterListElement> handler = instanceHandler.getAPIParameterListHandler(userId, serverName, "getAPIParameterListByGUID");
            APIParameterListElement element = (APIParameterListElement)handler.getAPIParameterListByGUID(userId, guid, "apiParameterListGUID", false, false, new Date(), "getAPIParameterListByGUID");
            response.setElement(this.setUpVendorProperties(userId, element, handler, "getAPIParameterListByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAPIParameterListByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<APIElement> setUpVendorProperties(String userId, List<APIElement> retrievedResults, AssetHandler<APIElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (APIElement apiElement : retrievedResults) {
                if (apiElement == null) continue;
                this.setUpVendorProperties(userId, apiElement, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private APIElement setUpVendorProperties(String userId, APIElement element, AssetHandler<APIElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            APIProperties apiProperties = element.getAPIProperties();
            apiProperties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    private List<APIOperationElement> setUpVendorProperties(String userId, List<APIOperationElement> retrievedResults, APIOperationHandler<APIOperationElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (APIOperationElement apiElement : retrievedResults) {
                if (apiElement == null) continue;
                this.setUpVendorProperties(userId, apiElement, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private APIOperationElement setUpVendorProperties(String userId, APIOperationElement element, APIOperationHandler<APIOperationElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            APIOperationProperties apiProperties = element.getProperties();
            apiProperties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    private List<APIParameterListElement> setUpVendorProperties(String userId, List<APIParameterListElement> retrievedResults, APIParameterListHandler<APIParameterListElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (APIParameterListElement apiElement : retrievedResults) {
                if (apiElement == null) continue;
                this.setUpVendorProperties(userId, apiElement, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private APIParameterListElement setUpVendorProperties(String userId, APIParameterListElement element, APIParameterListHandler<APIParameterListElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            APIParameterListProperties apiProperties = element.getProperties();
            apiProperties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }
}

