/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.converters.DataManagerOMASConverter;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APISpecificationElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.APISpecificationProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class APISpecificationConverter<B>
extends DataManagerOMASConverter<B> {
    public APISpecificationConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewSchemaTypeBean(Class<B> beanClass, InstanceHeader schemaRootHeader, String schemaTypeTypeName, InstanceProperties instanceProperties, List<Classification> schemaRootClassifications, int attributeCount, String validValueSetGUID, String externalSchemaTypeGUID, B externalSchemaType, String mapFromSchemaTypeGUID, B mapFromSchemaType, String mapToSchemaTypeGUID, B mapToSchemaType, List<String> schemaTypeOptionGUIDs, List<B> schemaTypeOptions, List<Relationship> queryTargetRelationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof APISpecificationElement) {
                if (schemaRootHeader != null && instanceProperties != null) {
                    APISpecificationElement bean = (APISpecificationElement)returnBean;
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, schemaRootHeader, schemaRootClassifications, methodName));
                    APISpecificationProperties apiSpecificationProperties = new APISpecificationProperties();
                    InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
                    apiSpecificationProperties.setDisplayName(this.removeDisplayName(propertiesCopy));
                    apiSpecificationProperties.setDescription(this.removeDescription(propertiesCopy));
                    apiSpecificationProperties.setIsDeprecated(this.removeIsDeprecated(propertiesCopy));
                    apiSpecificationProperties.setVersionNumber(this.removeVersionNumber(propertiesCopy));
                    apiSpecificationProperties.setAuthor(this.removeAuthor(propertiesCopy));
                    apiSpecificationProperties.setUsage(this.removeUsage(propertiesCopy));
                    apiSpecificationProperties.setEncodingStandard(this.removeEncodingStandard(propertiesCopy));
                    apiSpecificationProperties.setNamespace(this.removeNamespace(propertiesCopy));
                    apiSpecificationProperties.setAdditionalProperties(this.removeAdditionalProperties(propertiesCopy));
                    apiSpecificationProperties.setExtendedProperties(this.getRemainingExtendedProperties(propertiesCopy));
                    bean.setProperties(apiSpecificationProperties);
                    bean.setOperationCount(attributeCount);
                    return returnBean;
                }
                this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
            }
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
        }
        return null;
    }
}

