/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.listener;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.converters.DataManagerOMASConverter;
import org.odpi.openmetadata.accessservices.datamanager.events.DataManagerOutboundEventType;
import org.odpi.openmetadata.accessservices.datamanager.ffdc.DataManagerAuditCode;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementStub;
import org.odpi.openmetadata.accessservices.datamanager.outtopic.DataManagerOutTopicPublisher;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerServicesInstance;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataManagerOMRSTopicListener
extends OMRSTopicListenerBase {
    private static final Logger log = LoggerFactory.getLogger(DataManagerOMRSTopicListener.class);
    private List<String> supportedZones;
    private DataManagerOutTopicPublisher publisher;
    private OMRSRepositoryHelper repositoryHelper;
    private String serverUserId;
    private DataManagerOMASConverter<ElementStub> converter;
    private OpenMetadataAPIGenericHandler<ElementStub> genericHandler;

    public DataManagerOMRSTopicListener(List<String> supportedZones, DataManagerOutTopicPublisher publisher, String serverUserId, AuditLog auditLog, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, DataManagerServicesInstance instance) {
        super(serviceName, auditLog);
        this.repositoryHelper = repositoryHelper;
        this.supportedZones = supportedZones;
        this.publisher = publisher;
        this.serverUserId = serverUserId;
        this.converter = new DataManagerOMASConverter(repositoryHelper, serviceName, serverName);
        this.genericHandler = instance.getGenericHandler();
    }

    private void processEntityEvent(DataManagerOutboundEventType eventType, String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, String classificationName, String methodName) {
        String entityGUIDParameterName = "entity.getGUID()";
        Date effectiveTime = new Date();
        String instanceTypeName = this.getInstanceTypeName(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, (InstanceHeader)entity, methodName);
        if (instanceTypeName != null) {
            try {
                ElementStub elementStub = this.converter.getElementStub(ElementStub.class, entity, methodName);
                if (this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "DataSet") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "DataStore") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "SchemaElement")) {
                    this.genericHandler.validateAnchorEntity(this.serverUserId, entity.getGUID(), instanceTypeName, entity, "entity.getGUID()", false, false, false, this.supportedZones, effectiveTime, methodName);
                    this.publisher.sendEntityEvent(eventType, entity.getGUID(), instanceTypeName, classificationName, elementStub);
                }
            }
            catch (UserNotAuthorizedException elementStub) {
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, DataManagerAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{entity.getGUID(), instanceTypeName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    private void processRelationshipEvent(DataManagerOutboundEventType eventType, String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship, String methodName) {
        String entityProxyOneGUIDParameterName = "relationship.getEntityProxyOne().getGUID()";
        String entityProxyTwoGUIDParameterName = "relationship.getEntityProxyTwo().getGUID()";
        Date effectiveTime = new Date();
        String instanceTypeName = this.getInstanceTypeName(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, (InstanceHeader)relationship, methodName);
        if (instanceTypeName != null) {
            try {
                ElementStub relationshipElementStub = this.converter.getElementStub(ElementStub.class, relationship, methodName);
                ElementStub endOneElementStub = this.converter.getElementStub(ElementStub.class, relationship.getEntityOneProxy(), methodName);
                ElementStub endTwoElementStub = this.converter.getElementStub(ElementStub.class, relationship.getEntityTwoProxy(), methodName);
                if (this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "DataContentForDataSet") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "AssetSchemaType") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "SchemaAttributeType") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "AttributeForSchema") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "DerivedSchemaTypeQueryTarget") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "LinkedExternalSchemaType") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "MapFromElementType") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "MapToElementType") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "SchemaTypeOption")) {
                    this.genericHandler.validateAnchorEntity(this.serverUserId, relationship.getEntityOneProxy().getGUID(), "relationship.getEntityProxyOne().getGUID()", "OpenMetadataRoot", false, false, false, this.supportedZones, effectiveTime, methodName);
                    this.genericHandler.validateAnchorEntity(this.serverUserId, relationship.getEntityTwoProxy().getGUID(), "relationship.getEntityProxyTwo().getGUID()", "OpenMetadataRoot", false, false, false, this.supportedZones, effectiveTime, methodName);
                    this.publisher.sendRelationshipEvent(eventType, relationship.getGUID(), instanceTypeName, relationshipElementStub, endOneElementStub, endTwoElementStub);
                }
            }
            catch (UserNotAuthorizedException relationshipElementStub) {
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, DataManagerAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{relationship.getGUID(), instanceTypeName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processNewEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.NEW_ELEMENT_EVENT;
        log.debug("Processing new Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, "processNewEntityEvent");
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        String methodName = "processUpdatedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.UPDATED_ELEMENT_EVENT;
        log.debug("Processing updated Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, newEntity, null, "processUpdatedEntityEvent");
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.CLASSIFIED_ELEMENT_EVENT;
        log.debug("Processing classified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, classification.getName(), "processClassifiedEntityEvent");
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.DECLASSIFIED_ELEMENT_EVENT;
        log.debug("Processing declassified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, originalClassification.getName(), "processDeclassifiedEntityEvent");
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.RECLASSIFIED_ELEMENT_EVENT;
        log.debug("Processing reclassified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, originalClassification.getName(), "processReclassifiedEntityEvent");
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.DELETED_ELEMENT_EVENT;
        log.debug("Processing deleted Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, "processDeletedEntityEvent");
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletePurgedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.DELETED_ELEMENT_EVENT;
        log.debug("Processing delete-purge entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, "processDeletePurgedEntityEvent");
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        String methodName = "processReIdentifiedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.UPDATED_ELEMENT_EVENT;
        log.debug("Processing re-identified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, "processReIdentifiedEntityEvent");
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        String methodName = "processReTypedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.UPDATED_ELEMENT_EVENT;
        log.debug("Processing re-typed Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, "processReTypedEntityEvent");
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        String methodName = "processReHomedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.UPDATED_ELEMENT_EVENT;
        log.debug("Processing re-homed Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, "processReHomedEntityEvent");
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processNewRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.NEW_ELEMENT_EVENT;
        log.debug("Processing new relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processNewRelationshipEvent");
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        String methodName = "processUpdatedRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.UPDATED_ELEMENT_EVENT;
        log.debug("Processing updated relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, newRelationship, "processUpdatedRelationshipEvent");
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletedRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.DELETED_ELEMENT_EVENT;
        log.debug("Processing deleted relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processDeletedRelationshipEvent");
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processUpdatedRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.DELETED_ELEMENT_EVENT;
        log.debug("Processing delete-purge relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processUpdatedRelationshipEvent");
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        String methodName = "processReIdentifiedRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.UPDATED_ELEMENT_EVENT;
        log.debug("Processing re-identified relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processReIdentifiedRelationshipEvent");
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        String methodName = "processReTypedRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.UPDATED_ELEMENT_EVENT;
        log.debug("Processing re-typed relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processReTypedRelationshipEvent");
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        String methodName = "processReHomedRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.UPDATED_ELEMENT_EVENT;
        log.debug("Processing re-homed relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processReHomedRelationshipEvent");
    }
}

