/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.datamanager.converters.DataManagerOMASConverter;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectorTypeConverter<B>
extends DataManagerOMASConverter<B> {
    public ConnectorTypeConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ConnectorTypeElement) {
                ConnectorTypeElement bean = (ConnectorTypeElement)returnBean;
                ConnectorTypeProperties connectorTypeProperties = new ConnectorTypeProperties();
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    connectorTypeProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    connectorTypeProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    connectorTypeProperties.setDisplayName(this.removeName(instanceProperties));
                    connectorTypeProperties.setDescription(this.removeDescription(instanceProperties));
                    connectorTypeProperties.setSupportedAssetTypeName(this.removeSupportedAssetTypeName(instanceProperties));
                    connectorTypeProperties.setExpectedDataFormat(this.removeExpectedDataFormat(instanceProperties));
                    connectorTypeProperties.setConnectorProviderClassName(this.removeConnectorProviderClassName(instanceProperties));
                    connectorTypeProperties.setConnectorFrameworkName(this.removeConnectorFrameworkName(instanceProperties));
                    connectorTypeProperties.setConnectorInterfaceLanguage(this.removeConnectorInterfaceLanguage(instanceProperties));
                    connectorTypeProperties.setConnectorInterfaces(this.removeConnectorInterfaces(instanceProperties));
                    connectorTypeProperties.setTargetTechnologySource(this.removeTargetTechnologySource(instanceProperties));
                    connectorTypeProperties.setTargetTechnologyName(this.removeTargetTechnologyName(instanceProperties));
                    connectorTypeProperties.setTargetTechnologyInterfaces(this.removeTargetTechnologyInterfaces(instanceProperties));
                    connectorTypeProperties.setTargetTechnologyVersions(this.removeTargetTechnologyVersions(instanceProperties));
                    connectorTypeProperties.setRecognizedAdditionalProperties(this.removeRecognizedAdditionalProperties(instanceProperties));
                    connectorTypeProperties.setRecognizedSecuredProperties(this.removeRecognizedSecuredProperties(instanceProperties));
                    connectorTypeProperties.setRecognizedConfigurationProperties(this.removeRecognizedConfigurationProperties(instanceProperties));
                    connectorTypeProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    connectorTypeProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setConnectorTypeProperties(connectorTypeProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

