/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.datamanager.converters.DataManagerOMASConverter;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DatabaseConverter<B>
extends DataManagerOMASConverter<B> {
    public DatabaseConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DatabaseElement) {
                DatabaseElement bean = (DatabaseElement)returnBean;
                DatabaseProperties databaseProperties = new DatabaseProperties();
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    databaseProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    databaseProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    databaseProperties.setName(this.removeName(instanceProperties));
                    databaseProperties.setVersionIdentifier(this.removeVersionIdentifier(instanceProperties));
                    databaseProperties.setDescription(this.removeDescription(instanceProperties));
                    databaseProperties.setPathName(this.removePathName(instanceProperties));
                    databaseProperties.setCreateTime(this.removeStoreCreateTime(instanceProperties));
                    databaseProperties.setModifiedTime(this.removeStoreUpdateTime(instanceProperties));
                    databaseProperties.setDatabaseType(this.removeDeployedImplementationType(instanceProperties));
                    databaseProperties.setDatabaseVersion(this.removeDatabaseVersion(instanceProperties));
                    databaseProperties.setDatabaseInstance(this.removeDatabaseInstance(instanceProperties));
                    databaseProperties.setDatabaseImportedFrom(this.removeDatabaseImportedFrom(instanceProperties));
                    databaseProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    databaseProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties(OpenMetadataType.DATA_STORE_ENCODING_CLASSIFICATION.typeName, entity);
                    databaseProperties.setEncodingType(this.getDataStoreEncodingType(instanceProperties));
                    databaseProperties.setEncodingLanguage(this.getDataStoreEncodingLanguage(instanceProperties));
                    databaseProperties.setEncodingDescription(this.getDataStoreEncodingDescription(instanceProperties));
                    databaseProperties.setEncodingProperties(this.getEncodingProperties(instanceProperties));
                    bean.setDatabaseProperties(databaseProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

