/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.AssetConnectionRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ConnectionRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.EmbeddedConnectionRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.EndpointRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.EndpointResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.EndpointsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.LoggerFactory;

public class ConnectionRESTServices {
    private static final DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ConnectionRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createConnection(String serverName, String userId, ConnectionRequestBody requestBody) {
        String methodName = "createConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnection");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "createConnection");
            if (requestBody != null) {
                String connectionGUID = handler.createConnection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), null, null, null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getSecuredProperties(), requestBody.getConfigurationProperties(), requestBody.getUserId(), requestBody.getClearPassword(), requestBody.getEncryptedPassword(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, null, null, null, null, false, false, handler.getSupportedZones(), new Date(), "createConnection");
                if (connectionGUID != null) {
                    handler.setVendorProperties(userId, connectionGUID, requestBody.getVendorProperties(), false, false, new Date(), "createConnection");
                }
                response.setGUID(connectionGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createConnectionFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createConnectionFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnectionFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnectionFromTemplate");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "createConnectionFromTemplate");
            if (requestBody != null) {
                String connectionGUID = handler.createConnectionFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, "templateGUID", requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getDescription(), "createConnectionFromTemplate");
                response.setGUID(connectionGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createConnectionFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnectionFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConnection(String serverName, String userId, String connectionGUID, boolean isMergeUpdate, ConnectionRequestBody requestBody) {
        String methodName = "updateConnection";
        String connectionGUIDParameterName = "connectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "updateConnection");
            if (requestBody != null) {
                handler.updateConnection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getSecuredProperties(), requestBody.getConfigurationProperties(), requestBody.getUserId(), requestBody.getClearPassword(), requestBody.getEncryptedPassword(), requestBody.getTypeName(), requestBody.getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateConnection");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, connectionGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateConnection");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupConnectorType(String serverName, String userId, String connectionGUID, String connectorTypeGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "setupConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupConnectorType");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupConnectorType");
            if (requestBody != null) {
                handler.addConnectionConnectorType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", connectorTypeGUID, "connectorTypeGUID", null, null, false, false, new Date(), "setupConnectorType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupConnectorType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearConnectorType(String serverName, String userId, String connectionGUID, String connectorTypeGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "clearConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearConnectorType");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearConnectorType");
            if (requestBody != null) {
                handler.removeConnectionConnectorType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", connectorTypeGUID, "connectorTypeGUID", false, false, new Date(), "clearConnectorType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearConnectorType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupEndpoint(String serverName, String userId, String connectionGUID, String endpointGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "setupEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupEndpoint");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupEndpoint");
            if (requestBody != null) {
                handler.addConnectionEndpoint(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", endpointGUID, "endpointGUID", null, null, false, false, new Date(), "setupEndpoint");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEndpoint(String serverName, String userId, String connectionGUID, String endpointGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "clearEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearEndpoint");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearEndpoint");
            if (requestBody != null) {
                handler.removeConnectionEndpoint(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", endpointGUID, "endpointGUID", false, false, new Date(), "clearEndpoint");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupEmbeddedConnection(String serverName, String userId, String connectionGUID, String embeddedConnectionGUID, EmbeddedConnectionRequestBody requestBody) {
        String methodName = "setupEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupEmbeddedConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupEmbeddedConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupEmbeddedConnection");
            if (requestBody != null) {
                handler.addEmbeddedConnection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", requestBody.getPosition(), requestBody.getDisplayName(), requestBody.getArguments(), embeddedConnectionGUID, "embeddedConnectionGUID", null, null, false, false, handler.getSupportedZones(), new Date(), "setupEmbeddedConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupEmbeddedConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupEmbeddedConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEmbeddedConnection(String serverName, String userId, String connectionGUID, String embeddedConnectionGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "clearEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEmbeddedConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearEmbeddedConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearEmbeddedConnection");
            if (requestBody != null) {
                handler.removeEmbeddedConnection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", embeddedConnectionGUID, "embeddedConnectionGUID", false, false, handler.getSupportedZones(), new Date(), "clearEmbeddedConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearEmbeddedConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearEmbeddedConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAssetConnection(String serverName, String userId, String assetGUID, String connectionGUID, AssetConnectionRequestBody requestBody) {
        String methodName = "setupAssetConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupAssetConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAssetConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupAssetConnection");
            if (requestBody != null) {
                handler.addConnectionToAsset(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", assetGUID, "assetGUID", requestBody.getAssetSummary(), null, null, false, false, new Date(), "setupAssetConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupAssetConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupAssetConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAssetConnection(String serverName, String userId, String assetGUID, String connectionGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "clearAssetConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAssetConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAssetConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearAssetConnection");
            if (requestBody != null) {
                handler.removeConnectionToAsset(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", assetGUID, "assetGUID", false, false, new Date(), "clearAssetConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearAssetConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearAssetConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeConnection(String serverName, String userId, String connectionGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "removeConnection";
        String connectionGUIDParameterName = "connectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removeConnection");
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "removeConnection");
                handler.removeConnection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", false, false, new Date(), "removeConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionsResponse findConnections(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findConnections";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findConnections");
        ConnectionsResponse response = new ConnectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findConnections");
            if (requestBody != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "findConnections");
                List connections = handler.findConnections(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findConnections");
                response.setElementList(this.setUpVendorProperties(userId, connections, handler, "findConnections"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findConnections", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findConnections", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionsResponse getConnectionsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getConnectionsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionsByName");
        ConnectionsResponse response = new ConnectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionsByName");
            if (requestBody != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionsByName");
                List connections = handler.getConnectionsByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getConnectionsByName");
                response.setElementList(this.setUpVendorProperties(userId, connections, handler, "getConnectionsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getConnectionsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectionsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionResponse getConnectionByGUID(String serverName, String userId, String guid) {
        String methodName = "getConnectionByGUID";
        String guidParameterName = "connectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionByGUID");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionByGUID");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionByGUID");
            ConnectionElement connection = (ConnectionElement)handler.getConnectionByGUID(userId, guid, "connectionGUID", false, false, new Date(), "getConnectionByGUID");
            response.setElement(this.setUpVendorProperties(userId, connection, handler, "getConnectionByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectionByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEndpoint(String serverName, String userId, EndpointRequestBody requestBody) {
        String methodName = "createEndpoint";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEndpoint");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEndpoint");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "createEndpoint");
            if (requestBody != null) {
                String endpointGUID = handler.createEndpoint(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAddress(), requestBody.getProtocol(), requestBody.getEncryptionMethod(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, new Date(), "createEndpoint");
                if (endpointGUID != null) {
                    handler.setVendorProperties(userId, endpointGUID, requestBody.getVendorProperties(), false, false, new Date(), "createEndpoint");
                }
                response.setGUID(endpointGUID);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEndpointFromTemplate(String serverName, String userId, String networkAddress, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createEndpointFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEndpointFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEndpointFromTemplate");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "createEndpointFromTemplate");
            if (requestBody != null) {
                response.setGUID(handler.createEndpointFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), networkAddress, "createEndpointFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createEndpointFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createEndpointFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateEndpoint(String serverName, String userId, String endpointGUID, boolean isMergeUpdate, EndpointRequestBody requestBody) {
        String methodName = "updateEndpoint";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateEndpoint");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "updateEndpoint");
            if (requestBody != null) {
                handler.updateEndpoint(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), endpointGUID, "endpointGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAddress(), requestBody.getProtocol(), requestBody.getEncryptionMethod(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateEndpoint");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, endpointGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateEndpoint");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeEndpoint(String serverName, String userId, String endpointGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "removeEndpoint";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeEndpoint");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "removeEndpoint");
            if (requestBody != null) {
                handler.removeEndpoint(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), endpointGUID, "endpointGUID", false, false, new Date(), "removeEndpoint");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse findEndpoints(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findEndpoints";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findEndpoints");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findEndpoints");
            if (requestBody != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "findEndpoints");
                List elements = handler.findEndpoints(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findEndpoints");
                response.setElementList(this.setUpVendorProperties(userId, elements, handler, "findEndpoints"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findEndpoints", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findEndpoints", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse getEndpointsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getEndpointsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointsByName");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointsByName");
            if (requestBody != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "getEndpointsByName");
                List elements = handler.getEndpointsByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getEndpointsByName");
                response.setElementList(this.setUpVendorProperties(userId, elements, handler, "getEndpointsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getEndpointsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEndpointsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointResponse getEndpointByGUID(String serverName, String userId, String guid) {
        String methodName = "getEndpointByGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointByGUID");
        EndpointResponse response = new EndpointResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointByGUID");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "getEndpointByGUID");
            EndpointElement element = (EndpointElement)handler.getEndpointByGUID(userId, guid, "endpointGUID", false, false, new Date(), "getEndpointByGUID");
            response.setElement(this.setUpVendorProperties(userId, element, handler, "getEndpointByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEndpointByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypesResponse findConnectorTypes(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findConnectorTypes";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findConnectorTypes");
        ConnectorTypesResponse response = new ConnectorTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findConnectorTypes");
            if (requestBody != null) {
                ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "findConnectorTypes");
                List elements = handler.findConnectorTypes(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findConnectorTypes");
                response.setElementList(this.setUpVendorProperties(userId, elements, handler, "findConnectorTypes"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findConnectorTypes", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findConnectorTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypesResponse getConnectorTypesByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getConnectorTypesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectorTypesByName");
        ConnectorTypesResponse response = new ConnectorTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectorTypesByName");
            if (requestBody != null) {
                ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "getConnectorTypesByName");
                List elements = handler.getConnectorTypesByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getConnectorTypesByName");
                response.setElementList(this.setUpVendorProperties(userId, elements, handler, "getConnectorTypesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getConnectorTypesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectorTypesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypeResponse getConnectorTypeByGUID(String serverName, String userId, String guid) {
        String methodName = "getConnectorTypeByGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectorTypeByGUID");
        ConnectorTypeResponse response = new ConnectorTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectorTypeByGUID");
            ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "getConnectorTypeByGUID");
            ConnectorTypeElement element = (ConnectorTypeElement)handler.getConnectorTypeByGUID(userId, guid, "connectorTypeGUID", false, false, new Date(), "getConnectorTypeByGUID");
            response.setElement(this.setUpVendorProperties(userId, element, handler, "getConnectorTypeByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectorTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<ConnectionElement> setUpVendorProperties(String userId, List<ConnectionElement> retrievedResults, ConnectionHandler<ConnectionElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (ConnectionElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private ConnectionElement setUpVendorProperties(String userId, ConnectionElement element, ConnectionHandler<ConnectionElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            ConnectionProperties properties = element.getConnectionProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    private List<EndpointElement> setUpVendorProperties(String userId, List<EndpointElement> retrievedResults, EndpointHandler<EndpointElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (EndpointElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private EndpointElement setUpVendorProperties(String userId, EndpointElement element, EndpointHandler<EndpointElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            EndpointProperties properties = element.getEndpointProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    private List<ConnectorTypeElement> setUpVendorProperties(String userId, List<ConnectorTypeElement> retrievedResults, ConnectorTypeHandler<ConnectorTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (ConnectorTypeElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private ConnectorTypeElement setUpVendorProperties(String userId, ConnectorTypeElement element, ConnectorTypeHandler<ConnectorTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            ConnectorTypeProperties properties = element.getConnectorTypeProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }
}

