/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseTableElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseViewElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ClassificationProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseForeignKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabasePrimaryKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseQueryProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseSchemaProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseTableProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseViewProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseColumnResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseColumnsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseSchemaResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseSchemasResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseTableResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseTablesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseViewResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseViewsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabasesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.RelationalDataHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.KeyPattern;
import org.slf4j.LoggerFactory;

public class DatabaseManagerRESTServices {
    private static final DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DatabaseManagerRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createDatabase(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabase");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabase");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof DatabaseProperties) {
                    DatabaseProperties databaseProperties = (DatabaseProperties)requestBody.getProperties();
                    String databaseGUID = handler.createDatabase(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseProperties.getQualifiedName(), databaseProperties.getName(), databaseProperties.getVersionIdentifier(), databaseProperties.getDescription(), databaseProperties.getPathName(), databaseProperties.getCreateTime(), databaseProperties.getModifiedTime(), databaseProperties.getEncodingType(), databaseProperties.getEncodingLanguage(), databaseProperties.getEncodingDescription(), databaseProperties.getEncodingProperties(), databaseProperties.getDatabaseType(), databaseProperties.getDatabaseVersion(), databaseProperties.getDatabaseInstance(), databaseProperties.getDatabaseImportedFrom(), databaseProperties.getAdditionalProperties(), databaseProperties.getTypeName(), databaseProperties.getExtendedProperties(), databaseProperties.getVendorProperties(), databaseProperties.getEffectiveFrom(), databaseProperties.getEffectiveTo(), false, false, new Date(), "createDatabase");
                    response.setGUID(databaseGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseProperties.class.getName(), "createDatabase");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabase", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createDatabaseFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseFromTemplate");
            if (requestBody != null) {
                response.setGUID(handler.createDatabaseFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getPathName(), requestBody.getNetworkAddress(), false, false, new Date(), "createDatabaseFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabaseFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabase(String serverName, String userId, String databaseGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabase");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof DatabaseProperties) {
                    DatabaseProperties databaseProperties = (DatabaseProperties)requestBody.getProperties();
                    handler.updateDatabase(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseGUID, databaseProperties.getQualifiedName(), databaseProperties.getName(), databaseProperties.getVersionIdentifier(), databaseProperties.getDescription(), databaseProperties.getPathName(), databaseProperties.getCreateTime(), databaseProperties.getModifiedTime(), databaseProperties.getEncodingType(), databaseProperties.getEncodingLanguage(), databaseProperties.getEncodingDescription(), databaseProperties.getEncodingProperties(), databaseProperties.getDatabaseType(), databaseProperties.getDatabaseVersion(), databaseProperties.getDatabaseInstance(), databaseProperties.getDatabaseImportedFrom(), databaseProperties.getAdditionalProperties(), databaseProperties.getTypeName(), databaseProperties.getExtendedProperties(), databaseProperties.getVendorProperties(), databaseProperties.getEffectiveFrom(), databaseProperties.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateDatabase");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseProperties.class.getName(), "updateDatabase");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDatabase", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishDatabase(String serverName, String userId, String databaseGUID, ClassificationRequestBody requestBody) {
        String methodName = "publishDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "publishDatabase");
            handler.publishDatabase(userId, databaseGUID, false, false, new Date(), "publishDatabase");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawDatabase(String serverName, String userId, String databaseGUID, ClassificationRequestBody requestBody) {
        String methodName = "withdrawDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "withdrawDatabase");
            handler.withdrawDatabase(userId, databaseGUID, false, false, new Date(), "withdrawDatabase");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabase(String serverName, String userId, String databaseGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabase");
            if (requestBody != null) {
                handler.removeDatabase(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseGUID, null, false, false, new Date(), "removeDatabase");
            } else {
                handler.removeDatabase(userId, null, null, databaseGUID, null, false, false, new Date(), "removeDatabase");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabasesResponse findDatabases(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findDatabases";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabases");
        DatabasesResponse response = new DatabasesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabases");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabases");
                List databaseAssets = handler.findDatabases(userId, requestBody.getSearchString(), startFrom, pageSize, false, false, new Date(), "findDatabases");
                response.setElementList(databaseAssets);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findDatabases", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findDatabases", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabasesResponse getDatabasesByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getDatabasesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabasesByName");
        DatabasesResponse response = new DatabasesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabasesByName");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabasesByName");
                List databaseAssets = handler.getDatabasesByName(userId, requestBody.getName(), startFrom, pageSize, false, false, new Date(), "getDatabasesByName");
                response.setElementList(databaseAssets);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDatabasesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabasesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabasesResponse getDatabasesForDatabaseManager(String serverName, String userId, String databaseManagerGUID, String databaseManagerName, int startFrom, int pageSize) {
        String methodName = "getDatabasesForDatabaseManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabasesForDatabaseManager");
        DatabasesResponse response = new DatabasesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabasesForDatabaseManager");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabasesForDatabaseManager");
            List databaseAssets = handler.getDatabasesForDatabaseManager(userId, databaseManagerGUID, databaseManagerName, startFrom, pageSize, false, false, new Date(), "getDatabasesForDatabaseManager");
            response.setElementList(databaseAssets);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabasesForDatabaseManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseResponse getDatabaseByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseByGUID");
        DatabaseResponse response = new DatabaseResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseByGUID");
            DatabaseElement databaseAsset = (DatabaseElement)handler.getDatabaseByGUID(userId, guid, false, false, new Date(), "getDatabaseByGUID");
            response.setElement(databaseAsset);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseSchema(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseSchema");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseSchema");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof DatabaseSchemaProperties) {
                    DatabaseSchemaProperties databaseSchemaProperties = (DatabaseSchemaProperties)requestBody.getProperties();
                    String databaseSchemaGUID = handler.createDatabaseSchema(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getParentGUID(), databaseSchemaProperties.getQualifiedName(), databaseSchemaProperties.getName(), databaseSchemaProperties.getVersionIdentifier(), databaseSchemaProperties.getDescription(), databaseSchemaProperties.getAdditionalProperties(), databaseSchemaProperties.getTypeName(), databaseSchemaProperties.getExtendedProperties(), databaseSchemaProperties.getVendorProperties(), databaseSchemaProperties.getEffectiveFrom(), databaseSchemaProperties.getEffectiveTo(), false, false, new Date(), "createDatabaseSchema");
                    response.setGUID(databaseSchemaGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseSchemaProperties.class.getName(), "createDatabaseSchema");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabaseSchema", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseSchemaFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createDatabaseSchemaFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseSchemaFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseSchemaFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseSchemaFromTemplate");
            if (requestBody != null) {
                response.setGUID(handler.createDatabaseSchemaFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getParentGUID(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), null, null, false, false, new Date(), "createDatabaseSchemaFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabaseSchemaFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseSchemaFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabaseSchema(String serverName, String userId, String databaseSchemaGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabaseSchema");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabaseSchema");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof DatabaseSchemaProperties) {
                    DatabaseSchemaProperties databaseSchemaProperties = (DatabaseSchemaProperties)requestBody.getProperties();
                    handler.updateDatabaseSchema(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseSchemaGUID, databaseSchemaProperties.getQualifiedName(), databaseSchemaProperties.getName(), databaseSchemaProperties.getVersionIdentifier(), databaseSchemaProperties.getDescription(), null, 0, null, null, null, null, databaseSchemaProperties.getAdditionalProperties(), databaseSchemaProperties.getTypeName(), databaseSchemaProperties.getExtendedProperties(), databaseSchemaProperties.getVendorProperties(), databaseSchemaProperties.getEffectiveFrom(), databaseSchemaProperties.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateDatabaseSchema");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseSchemaProperties.class.getName(), "updateDatabaseSchema");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDatabaseSchema", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishDatabaseSchema(String serverName, String userId, String databaseSchemaGUID, ClassificationRequestBody requestBody) {
        String methodName = "publishDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishDatabaseSchema");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "publishDatabaseSchema");
            handler.publishDatabaseSchema(userId, databaseSchemaGUID, false, false, new Date(), "publishDatabaseSchema");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawDatabaseSchema(String serverName, String userId, String databaseSchemaGUID, ClassificationRequestBody requestBody) {
        String methodName = "withdrawDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawDatabase");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "withdrawDatabase");
            handler.withdrawDatabaseSchema(userId, databaseSchemaGUID, false, false, new Date(), "withdrawDatabase");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabaseSchema(String serverName, String userId, String databaseSchemaGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeDatabaseSchema";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabaseSchema");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabaseSchema");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabaseSchema");
            if (requestBody != null) {
                handler.removeDatabaseSchema(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseSchemaGUID, null, false, false, new Date(), "removeDatabaseSchema");
            } else {
                handler.removeDatabaseSchema(userId, null, null, databaseSchemaGUID, null, false, false, new Date(), "removeDatabaseSchema");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeDatabaseSchema", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseSchemasResponse findDatabaseSchemas(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findDatabaseSchemas";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabaseSchemas");
        DatabaseSchemasResponse response = new DatabaseSchemasResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabaseSchemas");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabaseSchemas");
                List databaseSchemaAssets = handler.findDatabaseSchemas(userId, requestBody.getSearchString(), startFrom, pageSize, false, false, new Date(), "findDatabaseSchemas");
                response.setElementList(databaseSchemaAssets);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findDatabaseSchemas", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findDatabaseSchemas", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseSchemasResponse getSchemasForDatabase(String serverName, String userId, String databaseGUID, int startFrom, int pageSize) {
        String methodName = "getSchemasForDatabase";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemasForDatabase");
        DatabaseSchemasResponse response = new DatabaseSchemasResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemasForDatabase");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getSchemasForDatabase");
            List databaseSchemaAssets = handler.getSchemasForDatabase(userId, databaseGUID, startFrom, pageSize, false, false, new Date(), "getSchemasForDatabase");
            response.setElementList(databaseSchemaAssets);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSchemasForDatabase", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseSchemasResponse getDatabaseSchemasByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getDatabaseSchemasByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseSchemasByName");
        DatabaseSchemasResponse response = new DatabaseSchemasResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseSchemasByName");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseSchemasByName");
                List databaseSchemaAssets = handler.getDatabaseSchemasByName(userId, requestBody.getName(), startFrom, pageSize, false, false, new Date(), "getDatabaseSchemasByName");
                response.setElementList(databaseSchemaAssets);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDatabaseSchemasByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseSchemasByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseSchemaResponse getDatabaseSchemaByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseSchemaByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseSchemaByGUID");
        DatabaseSchemaResponse response = new DatabaseSchemaResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseSchemaByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseSchemaByGUID");
            DatabaseSchemaElement databaseSchemaAsset = (DatabaseSchemaElement)handler.getDatabaseSchemaByGUID(userId, guid, false, false, new Date(), "getDatabaseSchemaByGUID");
            response.setElement(databaseSchemaAsset);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseSchemaByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseSchemaType(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createDatabaseSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseSchemaType");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseSchemaType");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof DatabaseSchemaTypeProperties) {
                    DatabaseSchemaTypeProperties databaseSchemaTypeProperties = (DatabaseSchemaTypeProperties)requestBody.getProperties();
                    String databaseTableGUID = handler.createDatabaseSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseSchemaTypeProperties.getQualifiedName(), databaseSchemaTypeProperties.getEffectiveFrom(), databaseSchemaTypeProperties.getEffectiveTo(), new Date(), "createDatabaseSchemaType");
                    response.setGUID(databaseTableGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseSchemaTypeProperties.class.getName(), "createDatabaseSchemaType");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabaseSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachSchemaTypeToDatabaseAsset(String serverName, String userId, String databaseAssetGUID, String schemaTypeGUID, RelationshipRequestBody requestBody) {
        String methodName = "attachSchemaTypeToDatabaseAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachSchemaTypeToDatabaseAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachSchemaTypeToDatabaseAsset");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "attachSchemaTypeToDatabaseAsset");
            if (requestBody != null) {
                handler.attachSchemaTypeToDatabaseAsset(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseAssetGUID, schemaTypeGUID, null, null, false, false, new Date(), "attachSchemaTypeToDatabaseAsset");
            } else {
                handler.attachSchemaTypeToDatabaseAsset(userId, null, null, databaseAssetGUID, schemaTypeGUID, null, null, false, false, new Date(), "attachSchemaTypeToDatabaseAsset");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "attachSchemaTypeToDatabaseAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseTable(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createDatabaseTable";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseTable");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseTable");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseTable");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof DatabaseTableProperties) {
                    DatabaseTableProperties databaseTableProperties = (DatabaseTableProperties)requestBody.getProperties();
                    String databaseTableGUID = handler.createDatabaseTable(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getParentGUID(), databaseTableProperties.getQualifiedName(), databaseTableProperties.getDisplayName(), databaseTableProperties.getDescription(), databaseTableProperties.getIsDeprecated(), databaseTableProperties.getAliases(), databaseTableProperties.getAdditionalProperties(), databaseTableProperties.getTypeName(), databaseTableProperties.getExtendedProperties(), databaseTableProperties.getVendorProperties(), databaseTableProperties.getEffectiveFrom(), databaseTableProperties.getEffectiveTo(), false, false, new Date(), "createDatabaseTable");
                    response.setGUID(databaseTableGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseTableProperties.class.getName(), "createDatabaseTable");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabaseTable", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseTable", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseTableFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createDatabaseTableFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseTableFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseTableFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseTableFromTemplate");
            if (requestBody != null) {
                response.setGUID(handler.createDatabaseTableFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getParentGUID(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), null, null, false, false, new Date(), "createDatabaseTableFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabaseTableFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseTableFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseTableForSchemaType(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createDatabaseTableForSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseTableForSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseTableForSchemaType");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseTableForSchemaType");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof DatabaseTableProperties) {
                    DatabaseTableProperties databaseTableProperties = (DatabaseTableProperties)requestBody.getProperties();
                    String databaseTableGUID = handler.createDatabaseTableForSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getParentGUID(), databaseTableProperties.getQualifiedName(), databaseTableProperties.getDisplayName(), databaseTableProperties.getDescription(), databaseTableProperties.getIsDeprecated(), databaseTableProperties.getAliases(), databaseTableProperties.getAdditionalProperties(), databaseTableProperties.getTypeName(), databaseTableProperties.getExtendedProperties(), databaseTableProperties.getVendorProperties(), databaseTableProperties.getEffectiveFrom(), databaseTableProperties.getEffectiveTo(), false, false, new Date(), "createDatabaseTableForSchemaType");
                    response.setGUID(databaseTableGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseTableProperties.class.getName(), "createDatabaseTableForSchemaType");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabaseTableForSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseTableForSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabaseTable(String serverName, String userId, String databaseTableGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateDatabaseTable";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabaseTable");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabaseTable");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabaseTable");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof DatabaseTableProperties) {
                    DatabaseTableProperties databaseTableProperties = (DatabaseTableProperties)requestBody.getProperties();
                    handler.updateDatabaseTable(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseTableGUID, databaseTableProperties.getQualifiedName(), databaseTableProperties.getDisplayName(), databaseTableProperties.getDescription(), databaseTableProperties.getIsDeprecated(), databaseTableProperties.getAliases(), databaseTableProperties.getAdditionalProperties(), databaseTableProperties.getTypeName(), databaseTableProperties.getExtendedProperties(), databaseTableProperties.getVendorProperties(), databaseTableProperties.getEffectiveFrom(), databaseTableProperties.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateDatabaseTable");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseTableProperties.class.getName(), "updateDatabaseTable");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDatabaseTable", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDatabaseTable", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabaseTable(String serverName, String userId, String databaseTableGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeDatabaseTable";
        String elementGUIDParameterName = "databaseTableGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabaseTable");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabaseTable");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabaseTable");
            if (requestBody != null) {
                handler.removeDatabaseTable(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseTableGUID, "databaseTableGUID", null, false, false, new Date(), "removeDatabaseTable");
            } else {
                handler.removeDatabaseTable(userId, null, null, databaseTableGUID, "databaseTableGUID", null, false, false, new Date(), "removeDatabaseTable");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeDatabaseTable", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseTablesResponse findDatabaseTables(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findDatabaseTables";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabaseTables");
        DatabaseTablesResponse response = new DatabaseTablesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabaseTables");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabaseTables");
                List databaseTableAttributes = handler.findDatabaseTables(userId, requestBody.getSearchString(), startFrom, pageSize, false, false, new Date(), "findDatabaseTables");
                response.setElementList(databaseTableAttributes);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findDatabaseTables", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findDatabaseTables", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseTablesResponse getTablesForDatabaseAsset(String serverName, String userId, String databaseAssetGUID, int startFrom, int pageSize) {
        String methodName = "getTablesForDatabaseAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTablesForDatabaseAsset");
        DatabaseTablesResponse response = new DatabaseTablesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTablesForDatabaseAsset");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getTablesForDatabaseAsset");
            List databaseTableAttributes = handler.getTablesForDatabaseAsset(userId, databaseAssetGUID, startFrom, pageSize, null, null, false, false, new Date(), "getTablesForDatabaseAsset");
            response.setElementList(databaseTableAttributes);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTablesForDatabaseAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseTablesResponse getDatabaseTablesByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getDatabaseTablesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseTablesByName");
        DatabaseTablesResponse response = new DatabaseTablesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseTablesByName");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseTablesByName");
                List databaseTableAttributes = handler.getDatabaseTablesByName(userId, requestBody.getName(), startFrom, pageSize, false, false, new Date(), "getDatabaseTablesByName");
                response.setElementList(databaseTableAttributes);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDatabaseTablesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseTablesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseTableResponse getDatabaseTableByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseTableByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseTableByGUID");
        DatabaseTableResponse response = new DatabaseTableResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseTableByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseTableByGUID");
            DatabaseTableElement databaseTableAttribute = (DatabaseTableElement)handler.getDatabaseTableByGUID(userId, guid, false, false, new Date(), "getDatabaseTableByGUID");
            response.setElement(databaseTableAttribute);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseTableByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseView(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createDatabaseView";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseView");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseView");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseView");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof DatabaseViewProperties) {
                    DatabaseViewProperties databaseViewProperties = (DatabaseViewProperties)requestBody.getProperties();
                    String databaseViewGUID = handler.createDatabaseView(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getParentGUID(), databaseViewProperties.getQualifiedName(), databaseViewProperties.getDisplayName(), databaseViewProperties.getDescription(), databaseViewProperties.getIsDeprecated(), databaseViewProperties.getAliases(), databaseViewProperties.getFormula(), databaseViewProperties.getAdditionalProperties(), databaseViewProperties.getTypeName(), databaseViewProperties.getExtendedProperties(), databaseViewProperties.getVendorProperties(), null, null, false, false, new Date(), "createDatabaseView");
                    response.setGUID(databaseViewGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseViewProperties.class.getName(), "createDatabaseView");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabaseView", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseView", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseViewFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createDatabaseViewFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseViewFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseViewFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseViewFromTemplate");
            if (requestBody != null) {
                response.setGUID(handler.createDatabaseViewFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getParentGUID(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), null, null, false, false, new Date(), "createDatabaseViewFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabaseViewFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseViewFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseViewForSchemaType(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createDatabaseViewForSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseViewForSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseViewForSchemaType");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseViewForSchemaType");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof DatabaseViewProperties) {
                    DatabaseViewProperties databaseViewProperties = (DatabaseViewProperties)requestBody.getProperties();
                    String databaseViewGUID = handler.createDatabaseViewForSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getParentGUID(), databaseViewProperties.getQualifiedName(), databaseViewProperties.getDisplayName(), databaseViewProperties.getDescription(), databaseViewProperties.getIsDeprecated(), databaseViewProperties.getAliases(), databaseViewProperties.getFormula(), databaseViewProperties.getAdditionalProperties(), databaseViewProperties.getTypeName(), databaseViewProperties.getExtendedProperties(), databaseViewProperties.getVendorProperties(), null, null, false, false, new Date(), "createDatabaseViewForSchemaType");
                    response.setGUID(databaseViewGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseViewProperties.class.getName(), "createDatabaseViewForSchemaType");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabaseViewForSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseViewForSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabaseView(String serverName, String userId, String databaseViewGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateDatabaseView";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabaseView");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabaseView");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabaseView");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof DatabaseViewProperties) {
                    DatabaseViewProperties databaseViewProperties = (DatabaseViewProperties)requestBody.getProperties();
                    handler.updateDatabaseView(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseViewGUID, databaseViewProperties.getQualifiedName(), databaseViewProperties.getDisplayName(), databaseViewProperties.getDescription(), databaseViewProperties.getIsDeprecated(), databaseViewProperties.getAliases(), databaseViewProperties.getFormula(), databaseViewProperties.getAdditionalProperties(), databaseViewProperties.getTypeName(), databaseViewProperties.getExtendedProperties(), databaseViewProperties.getVendorProperties(), databaseViewProperties.getEffectiveFrom(), databaseViewProperties.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateDatabaseView");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseViewProperties.class.getName(), "updateDatabaseView");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDatabaseView", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDatabaseView", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabaseView(String serverName, String userId, String databaseViewGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeDatabaseView";
        String elementGUIDParameterName = "databaseViewGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabaseView");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabaseView");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabaseView");
            if (requestBody != null) {
                handler.removeDatabaseTable(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseViewGUID, "databaseViewGUID", null, false, false, new Date(), "removeDatabaseView");
            } else {
                handler.removeDatabaseTable(userId, null, null, databaseViewGUID, "databaseViewGUID", null, false, false, new Date(), "removeDatabaseView");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeDatabaseView", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseViewsResponse findDatabaseViews(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findDatabaseViews";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabaseViews");
        DatabaseViewsResponse response = new DatabaseViewsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabaseViews");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabaseViews");
                List databaseViewAttributes = handler.findDatabaseViews(userId, requestBody.getSearchString(), startFrom, pageSize, false, false, new Date(), "findDatabaseViews");
                response.setElementList(databaseViewAttributes);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findDatabaseViews", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findDatabaseViews", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseViewsResponse getViewsForDatabaseAsset(String serverName, String userId, String databaseAssetGUID, int startFrom, int pageSize) {
        String methodName = "getViewsForDatabaseAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getViewsForDatabaseAsset");
        DatabaseViewsResponse response = new DatabaseViewsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getViewsForDatabaseAsset");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getViewsForDatabaseAsset");
            List databaseViewAttributes = handler.getViewsForDatabaseAsset(userId, databaseAssetGUID, startFrom, pageSize, null, null, false, false, new Date(), "getViewsForDatabaseAsset");
            response.setElementList(databaseViewAttributes);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getViewsForDatabaseAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseViewsResponse getDatabaseViewsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getDatabaseViewsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseViewsByName");
        DatabaseViewsResponse response = new DatabaseViewsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseViewsByName");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseViewsByName");
                List databaseViewAttributes = handler.getDatabaseViewsByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getDatabaseViewsByName");
                response.setElementList(databaseViewAttributes);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDatabaseViewsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseViewsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseViewResponse getDatabaseViewByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseViewByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseViewByGUID");
        DatabaseViewResponse response = new DatabaseViewResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseViewByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseViewByGUID");
            DatabaseViewElement databaseViewAttribute = (DatabaseViewElement)handler.getDatabaseViewByGUID(userId, guid, false, false, new Date(), "getDatabaseViewByGUID");
            response.setElement(databaseViewAttribute);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseViewByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseColumn(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createDatabaseColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseColumn");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseColumn");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof DatabaseColumnProperties) {
                    String databaseColumnGUID;
                    DatabaseColumnProperties databaseColumnProperties = (DatabaseColumnProperties)referenceableProperties;
                    int sortOrder = DataItemSortOrder.UNSORTED.getOrdinal();
                    if (databaseColumnProperties.getSortOrder() != null) {
                        sortOrder = databaseColumnProperties.getSortOrder().getOrdinal();
                    }
                    if ((databaseColumnGUID = handler.createDatabaseColumn(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getParentGUID(), databaseColumnProperties.getQualifiedName(), databaseColumnProperties.getDisplayName(), databaseColumnProperties.getDescription(), databaseColumnProperties.getExternalTypeGUID(), databaseColumnProperties.getDataType(), databaseColumnProperties.getDefaultValue(), databaseColumnProperties.getFixedValue(), databaseColumnProperties.getValidValuesSetGUID(), databaseColumnProperties.getFormula(), databaseColumnProperties.getIsDeprecated(), databaseColumnProperties.getElementPosition(), databaseColumnProperties.getMinCardinality(), databaseColumnProperties.getMaxCardinality(), databaseColumnProperties.getAllowsDuplicateValues(), databaseColumnProperties.getOrderedValues(), databaseColumnProperties.getDefaultValueOverride(), sortOrder, databaseColumnProperties.getMinimumLength(), databaseColumnProperties.getLength(), databaseColumnProperties.getPrecision(), databaseColumnProperties.getIsNullable(), databaseColumnProperties.getNativeJavaClass(), databaseColumnProperties.getAliases(), databaseColumnProperties.getAdditionalProperties(), databaseColumnProperties.getTypeName(), databaseColumnProperties.getExtendedProperties(), databaseColumnProperties.getVendorProperties(), databaseColumnProperties.getEffectiveFrom(), databaseColumnProperties.getEffectiveTo(), false, false, new Date(), "createDatabaseColumn")) != null && databaseColumnProperties.getQueries() != null) {
                        for (DatabaseQueryProperties queryProperties : databaseColumnProperties.getQueries()) {
                            if (queryProperties == null) continue;
                            handler.createDatabaseColumnQuery(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseColumnGUID, queryProperties.getQueryId(), queryProperties.getQuery(), queryProperties.getQueryTargetGUID(), null, null, false, false, new Date(), "createDatabaseColumn");
                        }
                    }
                    response.setGUID(databaseColumnGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseColumnProperties.class.getName(), "createDatabaseColumn");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabaseColumn", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseColumnFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createDatabaseColumnFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseColumnFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseColumnFromTemplate");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "createDatabaseColumnFromTemplate");
            if (requestBody != null) {
                response.setGUID(handler.createDatabaseColumnFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getParentGUID(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), null, null, false, false, new Date(), "createDatabaseColumnFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDatabaseColumnFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseColumnFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDatabaseColumn(String serverName, String userId, String databaseColumnGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateDatabaseColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDatabaseColumn");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDatabaseColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "updateDatabaseColumn");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof DatabaseColumnProperties) {
                    DatabaseColumnProperties databaseColumnProperties = (DatabaseColumnProperties)referenceableProperties;
                    int sortOrder = DataItemSortOrder.UNSORTED.getOrdinal();
                    if (databaseColumnProperties.getSortOrder() != null) {
                        sortOrder = databaseColumnProperties.getSortOrder().getOrdinal();
                    }
                    handler.updateDatabaseColumn(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseColumnGUID, databaseColumnProperties.getQualifiedName(), databaseColumnProperties.getDisplayName(), databaseColumnProperties.getDescription(), databaseColumnProperties.getExternalTypeGUID(), databaseColumnProperties.getDataType(), databaseColumnProperties.getDefaultValue(), databaseColumnProperties.getFixedValue(), databaseColumnProperties.getValidValuesSetGUID(), databaseColumnProperties.getFormula(), databaseColumnProperties.getIsDeprecated(), databaseColumnProperties.getElementPosition(), databaseColumnProperties.getMinCardinality(), databaseColumnProperties.getMaxCardinality(), databaseColumnProperties.getAllowsDuplicateValues(), databaseColumnProperties.getOrderedValues(), databaseColumnProperties.getDefaultValueOverride(), sortOrder, databaseColumnProperties.getMinimumLength(), databaseColumnProperties.getLength(), databaseColumnProperties.getPrecision(), databaseColumnProperties.getIsNullable(), databaseColumnProperties.getNativeJavaClass(), databaseColumnProperties.getAliases(), databaseColumnProperties.getAdditionalProperties(), databaseColumnProperties.getTypeName(), databaseColumnProperties.getExtendedProperties(), databaseColumnProperties.getVendorProperties(), databaseColumnProperties.getEffectiveFrom(), databaseColumnProperties.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateDatabaseColumn");
                    if (databaseColumnProperties.getQueries() != null) {
                        for (DatabaseQueryProperties queryProperties : databaseColumnProperties.getQueries()) {
                            if (queryProperties == null) continue;
                            handler.createDatabaseColumnQuery(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseColumnGUID, queryProperties.getQueryId(), queryProperties.getQuery(), queryProperties.getQueryTargetGUID(), null, null, false, false, new Date(), "updateDatabaseColumn");
                        }
                    }
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseColumnProperties.class.getName(), "updateDatabaseColumn");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDatabaseColumn", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDatabaseColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDatabaseColumn(String serverName, String userId, String databaseColumnGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeDatabaseColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDatabaseColumn");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDatabaseColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeDatabaseColumn");
            if (requestBody != null) {
                handler.removeDatabaseColumn(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseColumnGUID, false, false, new Date(), "removeDatabaseColumn");
            } else {
                handler.removeDatabaseColumn(userId, null, null, databaseColumnGUID, false, false, new Date(), "removeDatabaseColumn");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeDatabaseColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseColumnsResponse findDatabaseColumns(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findDatabaseColumns";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDatabaseColumns");
        DatabaseColumnsResponse response = new DatabaseColumnsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDatabaseColumns");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "findDatabaseColumns");
                List databaseColumnAttributes = handler.findDatabaseColumns(userId, requestBody.getSearchString(), startFrom, pageSize, false, false, new Date(), "findDatabaseColumns");
                response.setElementList(databaseColumnAttributes);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findDatabaseColumns", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findDatabaseColumns", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseColumnsResponse getColumnsForDatabaseTable(String serverName, String userId, String databaseTableGUID, int startFrom, int pageSize) {
        String methodName = "getColumnsForDatabaseTable";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getColumnsForDatabaseTable");
        DatabaseColumnsResponse response = new DatabaseColumnsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getColumnsForDatabaseTable");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getColumnsForDatabaseTable");
            List databaseColumnAttributes = handler.getColumnsForDatabaseTable(userId, databaseTableGUID, startFrom, pageSize, false, false, new Date(), "getColumnsForDatabaseTable");
            response.setElementList(databaseColumnAttributes);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getColumnsForDatabaseTable", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseColumnsResponse getDatabaseColumnsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getDatabaseColumnsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseColumnsByName");
        DatabaseColumnsResponse response = new DatabaseColumnsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseColumnsByName");
            if (requestBody != null) {
                RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseColumnsByName");
                List databaseColumnAttributes = handler.getDatabaseColumnsByName(userId, requestBody.getName(), startFrom, pageSize, false, false, new Date(), "getDatabaseColumnsByName");
                response.setElementList(databaseColumnAttributes);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDatabaseColumnsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseColumnsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DatabaseColumnResponse getDatabaseColumnByGUID(String serverName, String userId, String guid) {
        String methodName = "getDatabaseColumnByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDatabaseColumnByGUID");
        DatabaseColumnResponse response = new DatabaseColumnResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDatabaseColumnByGUID");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "getDatabaseColumnByGUID");
            DatabaseColumnElement schemaAttribute = (DatabaseColumnElement)handler.getDatabaseColumnByGUID(userId, guid, false, false, new Date(), "getDatabaseColumnByGUID");
            response.setElement(schemaAttribute);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDatabaseColumnByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setPrimaryKeyOnColumn(String serverName, String userId, String databaseColumnGUID, ClassificationRequestBody requestBody) {
        String methodName = "setPrimaryKeyOnColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setPrimaryKeyOnColumn");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setPrimaryKeyOnColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "setPrimaryKeyOnColumn");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof DatabasePrimaryKeyProperties) {
                    DatabasePrimaryKeyProperties databasePrimaryKeyProperties = (DatabasePrimaryKeyProperties)classificationProperties;
                    int keyPattern = KeyPattern.LOCAL_KEY.getOrdinal();
                    if (databasePrimaryKeyProperties.getKeyPattern() != null) {
                        keyPattern = databasePrimaryKeyProperties.getKeyPattern().getOrdinal();
                    }
                    handler.setPrimaryKeyOnColumn(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseColumnGUID, databasePrimaryKeyProperties.getName(), keyPattern, databasePrimaryKeyProperties.getEffectiveFrom(), databasePrimaryKeyProperties.getEffectiveTo(), true, false, false, new Date(), "setPrimaryKeyOnColumn");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabasePrimaryKeyProperties.class.getName(), "setPrimaryKeyOnColumn");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setPrimaryKeyOnColumn", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setPrimaryKeyOnColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removePrimaryKeyFromColumn(String serverName, String userId, String databaseColumnGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removePrimaryKeyFromColumn";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removePrimaryKeyFromColumn");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removePrimaryKeyFromColumn");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removePrimaryKeyFromColumn");
            if (requestBody != null) {
                handler.removePrimaryKeyFromColumn(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), databaseColumnGUID, false, false, new Date(), "removePrimaryKeyFromColumn");
            } else {
                handler.removePrimaryKeyFromColumn(userId, null, null, databaseColumnGUID, false, false, new Date(), "removePrimaryKeyFromColumn");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removePrimaryKeyFromColumn", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addForeignKeyRelationship(String serverName, String userId, String primaryKeyColumnGUID, String foreignKeyColumnGUID, RelationshipRequestBody requestBody) {
        String methodName = "addForeignKeyRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addForeignKeyRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addForeignKeyRelationship");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "addForeignKeyRelationship");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof DatabaseForeignKeyProperties) {
                    DatabaseForeignKeyProperties databaseForeignKeyProperties = (DatabaseForeignKeyProperties)requestBody.getProperties();
                    handler.addForeignKeyRelationship(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), primaryKeyColumnGUID, foreignKeyColumnGUID, databaseForeignKeyProperties.getName(), databaseForeignKeyProperties.getDescription(), databaseForeignKeyProperties.getConfidence(), databaseForeignKeyProperties.getSteward(), databaseForeignKeyProperties.getSource(), databaseForeignKeyProperties.getEffectiveFrom(), databaseForeignKeyProperties.getEffectiveTo(), false, false, new Date(), "addForeignKeyRelationship");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DatabaseForeignKeyProperties.class.getName(), "addForeignKeyRelationship");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addForeignKeyRelationship", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addForeignKeyRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeForeignKeyRelationship(String serverName, String userId, String primaryKeyColumnGUID, String foreignKeyColumnGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeForeignKeyRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeForeignKeyRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeForeignKeyRelationship");
            RelationalDataHandler<DatabaseElement, DatabaseSchemaElement, DatabaseTableElement, DatabaseViewElement, DatabaseColumnElement, SchemaTypeElement> handler = instanceHandler.getRelationalDataHandler(userId, serverName, "removeForeignKeyRelationship");
            if (requestBody != null) {
                handler.removeForeignKeyRelationship(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), primaryKeyColumnGUID, foreignKeyColumnGUID, false, false, new Date(), "removeForeignKeyRelationship");
            } else {
                handler.removeForeignKeyRelationship(userId, null, null, primaryKeyColumnGUID, foreignKeyColumnGUID, false, false, new Date(), "removeForeignKeyRelationship");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeForeignKeyRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

