/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.EventTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.TopicElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.EventTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TopicProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.EventTypeRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.EventTypeResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.EventTypesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TopicRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TopicResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.TopicsResponse;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EventTypeHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.slf4j.LoggerFactory;

public class EventBrokerRESTServices {
    private static final DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(EventBrokerRESTServices.class), instanceHandler.getServiceName());
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createTopic(String serverName, String userId, boolean eventBrokerIsHome, TopicRequestBody requestBody) {
        String methodName = "createTopic";
        String eventBrokerGUIDParameterName = "eventBrokerGUID";
        String topicGUIDParameterName = "topicGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createTopic");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createTopic");
            AssetHandler<TopicElement> handler = instanceHandler.getTopicHandler(userId, serverName, "createTopic");
            if (requestBody != null) {
                String topicGUID;
                String typeName = OpenMetadataType.TOPIC.typeName;
                if (requestBody.getTypeName() != null) {
                    typeName = requestBody.getTypeName();
                }
                HashMap<String, String> extendedProperties = requestBody.getExtendedProperties();
                if (requestBody.getTopicType() != null) {
                    if (extendedProperties == null) {
                        extendedProperties = new HashMap<String, String>();
                    }
                    extendedProperties.put(OpenMetadataProperty.TOPIC_TYPE.name, requestBody.getTopicType());
                }
                if (requestBody.getTopicName() != null) {
                    if (extendedProperties == null) {
                        extendedProperties = new HashMap();
                    }
                    extendedProperties.put(OpenMetadataProperty.TOPIC_NAME.name, requestBody.getTopicType());
                }
                if (eventBrokerIsHome) {
                    topicGUID = handler.createAssetInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getAdditionalProperties(), typeName, extendedProperties, InstanceStatus.ACTIVE, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), new Date(), "createTopic");
                    if (topicGUID != null && requestBody.getExternalSourceGUID() != null) {
                        handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getExternalSourceGUID(), "eventBrokerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, topicGUID, "topicGUID", OpenMetadataType.TOPIC.typeName, false, false, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "createTopic");
                    }
                } else {
                    topicGUID = handler.createAssetInRepository(userId, null, null, requestBody.getQualifiedName(), requestBody.getName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getAdditionalProperties(), typeName, extendedProperties, InstanceStatus.ACTIVE, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), new Date(), "createTopic");
                    if (topicGUID != null && requestBody.getExternalSourceGUID() != null) {
                        handler.linkElementToElement(userId, null, null, requestBody.getExternalSourceGUID(), "eventBrokerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, topicGUID, "topicGUID", OpenMetadataType.TOPIC.typeName, false, false, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "createTopic");
                    }
                }
                if (topicGUID != null) {
                    handler.setVendorProperties(userId, topicGUID, requestBody.getVendorProperties(), false, false, new Date(), "createTopic");
                }
                response.setGUID(topicGUID);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createTopic", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createTopic", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createTopicFromTemplate(String serverName, String userId, String templateGUID, boolean eventBrokerIsHome, TemplateRequestBody requestBody) {
        String methodName = "createTopicFromTemplate";
        String eventBrokerGUIDParameterName = "eventBrokerGUID";
        String topicGUIDParameterName = "topicGUID";
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createTopicFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createTopicFromTemplate");
            AssetHandler<TopicElement> handler = instanceHandler.getTopicHandler(userId, serverName, "createTopicFromTemplate");
            if (requestBody != null) {
                String topicGUID = handler.addAssetFromTemplate(userId, handler.getExternalSourceID(eventBrokerIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(eventBrokerIsHome, requestBody.getExternalSourceName()), templateGUID, "templateGUID", OpenMetadataType.TOPIC.typeGUID, OpenMetadataType.TOPIC.typeName, requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), null, requestBody.getNetworkAddress(), false, false, new Date(), "createTopicFromTemplate");
                if (topicGUID != null && requestBody.getExternalSourceGUID() != null) {
                    handler.linkElementToElement(userId, handler.getExternalSourceID(eventBrokerIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(eventBrokerIsHome, requestBody.getExternalSourceName()), requestBody.getExternalSourceGUID(), "eventBrokerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, topicGUID, "topicGUID", OpenMetadataType.TOPIC.typeName, false, false, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "createTopicFromTemplate");
                }
                response.setGUID(topicGUID);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createTopicFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createTopicFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateTopic(String serverName, String userId, String topicGUID, boolean isMergeUpdate, TopicRequestBody requestBody) {
        String methodName = "updateTopic";
        String topicGUIDParameterName = "topicGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateTopic");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTopic");
            AssetHandler<TopicElement> handler = instanceHandler.getTopicHandler(userId, serverName, "updateTopic");
            if (requestBody != null) {
                String typeName = OpenMetadataType.TOPIC.typeName;
                if (requestBody.getTypeName() != null) {
                    typeName = requestBody.getTypeName();
                }
                HashMap<String, String> extendedProperties = requestBody.getExtendedProperties();
                if (requestBody.getTopicName() != null) {
                    if (extendedProperties == null) {
                        extendedProperties = new HashMap<String, String>();
                    }
                    extendedProperties.put(OpenMetadataProperty.TOPIC_NAME.name, requestBody.getTopicType());
                }
                if (requestBody.getTopicType() != null) {
                    if (extendedProperties == null) {
                        extendedProperties = new HashMap();
                    }
                    extendedProperties.put(OpenMetadataProperty.TOPIC_TYPE.name, requestBody.getTopicType());
                }
                handler.updateAsset(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), topicGUID, "topicGUID", requestBody.getQualifiedName(), requestBody.getName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getAdditionalProperties(), typeName, extendedProperties, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateTopic");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, topicGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateTopic");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateTopic", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateTopic", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishTopic(String serverName, String userId, String topicGUID, NullRequestBody nullRequestBody) {
        String methodName = "publishTopic";
        String topicGUIDParameterName = "topicGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishTopic");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishTopic");
            AssetHandler<TopicElement> handler = instanceHandler.getTopicHandler(userId, serverName, "publishTopic");
            handler.publishAsset(userId, topicGUID, "topicGUID", false, false, new Date(), "publishTopic");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishTopic", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawTopic(String serverName, String userId, String topicGUID, NullRequestBody nullRequestBody) {
        String methodName = "withdrawTopic";
        String topicGUIDParameterName = "topicGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawTopic");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawTopic");
            AssetHandler<TopicElement> handler = instanceHandler.getTopicHandler(userId, serverName, "withdrawTopic");
            handler.withdrawAsset(userId, topicGUID, "topicGUID", false, false, new Date(), "withdrawTopic");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawTopic", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTopic(String serverName, String userId, String topicGUID, String qualifiedName, MetadataSourceRequestBody requestBody) {
        String methodName = "removeTopic";
        String topicGUIDParameterName = "topicGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeTopic");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTopic");
                AssetHandler<TopicElement> handler = instanceHandler.getTopicHandler(userId, serverName, "removeTopic");
                handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), topicGUID, "topicGUID", OpenMetadataType.TOPIC.typeGUID, OpenMetadataType.TOPIC.typeName, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, false, false, new Date(), "removeTopic");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "removeTopic", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeTopic", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TopicsResponse findTopics(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findTopics";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findTopics");
        TopicsResponse response = new TopicsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTopics");
            if (requestBody != null) {
                AssetHandler<TopicElement> handler = instanceHandler.getTopicHandler(userId, serverName, "findTopics");
                List topicAssets = handler.findAssets(userId, OpenMetadataType.TOPIC.typeGUID, OpenMetadataType.TOPIC.typeName, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findTopics");
                response.setElementList(this.setUpVendorProperties(userId, topicAssets, handler, "findTopics"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findTopics", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findTopics", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TopicsResponse getTopicsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getTopicsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTopicsByName");
        TopicsResponse response = new TopicsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTopicsByName");
            if (requestBody != null) {
                AssetHandler<TopicElement> handler = instanceHandler.getTopicHandler(userId, serverName, "getTopicsByName");
                List topicAssets = handler.getAssetsByName(userId, OpenMetadataType.TOPIC.typeGUID, OpenMetadataType.TOPIC.typeName, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getTopicsByName");
                response.setElementList(this.setUpVendorProperties(userId, topicAssets, handler, "getTopicsByName"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getTopicsByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTopicsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TopicsResponse getTopicsForEventBroker(String serverName, String userId, String eventBrokerGUID, String eventBrokerName, int startFrom, int pageSize) {
        String methodName = "getTopicsForEventBroker";
        String eventBrokerGUIDParameterName = "eventBrokerGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTopicsForEventBroker");
        TopicsResponse response = new TopicsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTopicsForEventBroker");
            AssetHandler<TopicElement> handler = instanceHandler.getTopicHandler(userId, serverName, "getTopicsForEventBroker");
            List topicAssets = handler.getAttachedElements(userId, eventBrokerGUID, "eventBrokerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, OpenMetadataType.TOPIC.typeName, null, null, 0, false, false, startFrom, pageSize, new Date(), "getTopicsForEventBroker");
            response.setElementList(this.setUpVendorProperties(userId, topicAssets, handler, "getTopicsForEventBroker"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTopicsForEventBroker", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TopicResponse getTopicByGUID(String serverName, String userId, String guid) {
        String methodName = "getTopicByGUID";
        String guidParameterName = "topicGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTopicByGUID");
        TopicResponse response = new TopicResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTopicByGUID");
            AssetHandler<TopicElement> handler = instanceHandler.getTopicHandler(userId, serverName, "getTopicByGUID");
            TopicElement topicAsset = (TopicElement)handler.getBeanFromRepository(userId, guid, "topicGUID", OpenMetadataType.TOPIC.typeName, false, false, new Date(), "getTopicByGUID");
            response.setElement(this.setUpVendorProperties(userId, topicAsset, handler, "getTopicByGUID"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTopicByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEventType(String serverName, String userId, String topicGUID, EventTypeRequestBody requestBody) {
        String methodName = "createEventType";
        String topicGUIDParameterName = "topicGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEventType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEventType");
            EventTypeHandler<EventTypeElement> handler = instanceHandler.getEventTypeHandler(userId, serverName, "createEventType");
            if (requestBody != null) {
                String eventTypeGUID = handler.createEventType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), topicGUID, "topicGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, false, false, new Date(), "createEventType");
                handler.setVendorProperties(userId, eventTypeGUID, requestBody.getVendorProperties(), false, false, new Date(), "createEventType");
                response.setGUID(eventTypeGUID);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createEventType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEventTypeFromTemplate(String serverName, String userId, String templateGUID, String topicGUID, TemplateRequestBody requestBody) {
        String methodName = "createEventTypeFromTemplate";
        String topicGUIDParameterName = "topicGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEventTypeFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEventTypeFromTemplate");
            EventTypeHandler<EventTypeElement> handler = instanceHandler.getEventTypeHandler(userId, serverName, "createEventTypeFromTemplate");
            if (requestBody != null) {
                response.setGUID(handler.createEventTypeFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), topicGUID, "topicGUID", templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), null, null, false, false, new Date(), "createEventTypeFromTemplate"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createEventTypeFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createEventTypeFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateEventType(String serverName, String userId, String eventTypeGUID, boolean isMergeUpdate, EventTypeRequestBody requestBody) {
        String methodName = "updateEventType";
        String eventTypeGUIDParameterName = "eventTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateEventType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateEventType");
            EventTypeHandler<EventTypeElement> handler = instanceHandler.getEventTypeHandler(userId, serverName, "updateEventType");
            if (requestBody != null) {
                handler.updateEventType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), eventTypeGUID, "eventTypeGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, isMergeUpdate, false, false, new Date(), "updateEventType");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, eventTypeGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateEventType");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateEventType", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateEventType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeEventType(String serverName, String userId, String eventTypeGUID, String qualifiedName, MetadataSourceRequestBody requestBody) {
        String methodName = "removeEventType";
        String eventTypeGUIDParameterName = "eventTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeEventType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeEventType");
            EventTypeHandler<EventTypeElement> handler = instanceHandler.getEventTypeHandler(userId, serverName, "removeEventType");
            if (requestBody != null) {
                handler.removeEventType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), eventTypeGUID, "eventTypeGUID", qualifiedName, false, false, new Date(), "removeEventType");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "removeEventType", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeEventType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EventTypesResponse findEventTypes(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findEventTypes";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findEventTypes");
        EventTypesResponse response = new EventTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findEventTypes");
            if (requestBody != null) {
                EventTypeHandler<EventTypeElement> handler = instanceHandler.getEventTypeHandler(userId, serverName, "findEventTypes");
                List eventTypes = handler.findEventTypes(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findEventTypes");
                this.setUpVendorProperties(userId, eventTypes, handler, "findEventTypes");
                response.setElementList(eventTypes);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findEventTypes", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findEventTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EventTypesResponse getEventTypesForEventSet(String serverName, String userId, String topicGUID, int startFrom, int pageSize) {
        String methodName = "getEventTypesForEventSet";
        String topicGUIDParameterName = "topicGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEventTypesForEventSet");
        EventTypesResponse response = new EventTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEventTypesForEventSet");
            EventTypeHandler<EventTypeElement> handler = instanceHandler.getEventTypeHandler(userId, serverName, "getEventTypesForEventSet");
            List eventTypes = handler.getEventTypesForEventSet(userId, topicGUID, "topicGUID", startFrom, pageSize, false, false, new Date(), "getEventTypesForEventSet");
            this.setUpVendorProperties(userId, eventTypes, handler, "getEventTypesForEventSet");
            response.setElementList(eventTypes);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEventTypesForEventSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EventTypesResponse getEventTypesForTopic(String serverName, String userId, String topicGUID, int startFrom, int pageSize) {
        String methodName = "getEventTypesForTopic";
        String topicGUIDParameterName = "topicGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEventTypesForTopic");
        EventTypesResponse response = new EventTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEventTypesForTopic");
            EventTypeHandler<EventTypeElement> handler = instanceHandler.getEventTypeHandler(userId, serverName, "getEventTypesForTopic");
            List eventTypes = handler.getEventTypesForTopic(userId, topicGUID, "topicGUID", startFrom, pageSize, false, false, new Date(), "getEventTypesForTopic");
            this.setUpVendorProperties(userId, eventTypes, handler, "getEventTypesForTopic");
            response.setElementList(eventTypes);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEventTypesForTopic", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EventTypesResponse getEventTypesByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getEventTypesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEventTypesByName");
        EventTypesResponse response = new EventTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEventTypesByName");
            if (requestBody != null) {
                EventTypeHandler<EventTypeElement> handler = instanceHandler.getEventTypeHandler(userId, serverName, "getEventTypesByName");
                List eventTypes = handler.getEventTypesByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getEventTypesByName");
                this.setUpVendorProperties(userId, eventTypes, handler, "getEventTypesByName");
                response.setElementList(eventTypes);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getEventTypesByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEventTypesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EventTypeResponse getEventTypeByGUID(String serverName, String userId, String guid) {
        String methodName = "getEventTypeByGUID";
        String eventTypeGUIDParameterName = "eventTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEventTypeByGUID");
        EventTypeResponse response = new EventTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEventTypeByGUID");
            EventTypeHandler<EventTypeElement> handler = instanceHandler.getEventTypeHandler(userId, serverName, "getEventTypeByGUID");
            EventTypeElement eventType = (EventTypeElement)handler.getEventTypeByGUID(userId, guid, "eventTypeGUID", false, false, new Date(), "getEventTypeByGUID");
            this.setUpVendorProperties(userId, eventType, handler, "getEventTypeByGUID");
            response.setElement(eventType);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEventTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<TopicElement> setUpVendorProperties(String userId, List<TopicElement> retrievedResults, AssetHandler<TopicElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (TopicElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private TopicElement setUpVendorProperties(String userId, TopicElement element, AssetHandler<TopicElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            TopicProperties properties = element.getProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    private void setUpVendorProperties(String userId, List<EventTypeElement> retrievedResults, EventTypeHandler<EventTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (EventTypeElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
    }

    private void setUpVendorProperties(String userId, EventTypeElement element, EventTypeHandler<EventTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            EventTypeProperties properties = element.getProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
    }
}

