/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.listener;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.events.DataManagerOutboundEventType;
import org.odpi.openmetadata.accessservices.datamanager.ffdc.DataManagerAuditCode;
import org.odpi.openmetadata.accessservices.datamanager.outtopic.DataManagerOutTopicPublisher;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerServicesInstance;
import org.odpi.openmetadata.commonservices.generichandlers.DataManagerOMASConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataManagerOMRSTopicListener
extends OMRSTopicListenerBase {
    private static final Logger log = LoggerFactory.getLogger(DataManagerOMRSTopicListener.class);
    private final List<String> supportedZones;
    private final DataManagerOutTopicPublisher publisher;
    private final OMRSRepositoryHelper repositoryHelper;
    private final String serverUserId;
    private final DataManagerOMASConverter<ElementStub> converter;
    private final OpenMetadataAPIGenericHandler<ElementStub> genericHandler;

    public DataManagerOMRSTopicListener(List<String> supportedZones, DataManagerOutTopicPublisher publisher, String serverUserId, AuditLog auditLog, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, DataManagerServicesInstance instance) {
        super(serviceName, auditLog);
        this.repositoryHelper = repositoryHelper;
        this.supportedZones = supportedZones;
        this.publisher = publisher;
        this.serverUserId = serverUserId;
        this.converter = new DataManagerOMASConverter(repositoryHelper, serviceName, serverName);
        this.genericHandler = instance.getGenericHandler();
    }

    private void processEntityEvent(DataManagerOutboundEventType eventType, String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, EntityProxy entityProxy, String classificationName, String methodName) {
        String entityGUIDParameterName = "entity.getGUID()";
        String instanceTypeName = null;
        if (entity != null) {
            instanceTypeName = this.getInstanceTypeName(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, (InstanceHeader)entity, methodName);
        } else if (entityProxy != null) {
            instanceTypeName = this.getInstanceTypeName(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, (InstanceHeader)entityProxy, methodName);
        }
        if (instanceTypeName != null) {
            try {
                Date effectiveTime = new Date();
                ElementStub elementStub = entity != null ? this.converter.getElementStub(ElementStub.class, entity, methodName) : this.converter.getElementStub(ElementStub.class, entityProxy, methodName);
                if (this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
                    if (entity != null) {
                        this.genericHandler.validateAnchorEntity(this.serverUserId, entity.getGUID(), instanceTypeName, entity, "entity.getGUID()", false, false, false, false, this.supportedZones, effectiveTime, methodName);
                    } else {
                        this.genericHandler.validateAnchorEntity(this.serverUserId, entityProxy.getGUID(), "entity.getGUID()", instanceTypeName, false, false, false, false, this.supportedZones, effectiveTime, methodName);
                    }
                    this.publisher.sendEntityEvent(eventType, elementStub.getGUID(), instanceTypeName, classificationName, elementStub);
                }
            }
            catch (InvalidParameterException | UserNotAuthorizedException error) {
                if (entity != null) {
                    this.auditLog.logMessage(methodName, DataManagerAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{eventType.getEventTypeName(), entity.getGUID(), instanceTypeName, error.getClass().getName(), error.getMessage()}));
                } else {
                    this.auditLog.logMessage(methodName, DataManagerAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{eventType.getEventTypeName(), entityProxy.getGUID(), instanceTypeName, error.getClass().getName(), error.getMessage()}));
                }
            }
            catch (Exception error) {
                if (entity != null) {
                    this.auditLog.logException(methodName, DataManagerAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{eventType.getEventTypeName(), entity.getGUID(), instanceTypeName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
                }
                this.auditLog.logException(methodName, DataManagerAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{eventType.getEventTypeName(), entityProxy.getGUID(), instanceTypeName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    private void processRelationshipEvent(DataManagerOutboundEventType eventType, String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship, String methodName) {
        String entityProxyOneGUIDParameterName = "relationship.getEntityProxyOne().getGUID()";
        String entityProxyTwoGUIDParameterName = "relationship.getEntityProxyTwo().getGUID()";
        Date effectiveTime = new Date();
        String instanceTypeName = this.getInstanceTypeName(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, (InstanceHeader)relationship, methodName);
        if (instanceTypeName != null) {
            try {
                ElementStub relationshipElementStub = this.converter.getElementStub(ElementStub.class, relationship, methodName);
                ElementStub endOneElementStub = this.converter.getElementStub(ElementStub.class, relationship.getEntityOneProxy(), methodName);
                ElementStub endTwoElementStub = this.converter.getElementStub(ElementStub.class, relationship.getEntityTwoProxy(), methodName);
                if (this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, OpenMetadataType.DATA_CONTENT_FOR_DATA_SET_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "AssetSchemaType") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, OpenMetadataType.SEMANTIC_ASSIGNMENT.typeName) || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, OpenMetadataType.API_ENDPOINT_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "SchemaAttributeType") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "AttributeForSchema") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "DerivedSchemaTypeQueryTarget") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "LinkedExternalSchemaType") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "MapFromElementType") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "MapToElementType") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "APIHeader") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "APIRequest") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "APIResponse") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "APIOperations") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, OpenMetadataType.GRAPH_EDGE_LINK_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "ForeignKey") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "NestedFile") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "LinkedFile") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "FolderHierarchy") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "LinkedMedia") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "TopicSubscribers") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, OpenMetadataType.ASSOCIATED_LOG_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "SchemaTypeOption")) {
                    this.genericHandler.validateAnchorEntity(this.serverUserId, relationship.getEntityOneProxy().getGUID(), "relationship.getEntityProxyOne().getGUID()", OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, false, false, this.supportedZones, effectiveTime, methodName);
                    this.genericHandler.validateAnchorEntity(this.serverUserId, relationship.getEntityTwoProxy().getGUID(), "relationship.getEntityProxyTwo().getGUID()", OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, false, false, this.supportedZones, effectiveTime, methodName);
                    this.publisher.sendRelationshipEvent(eventType, relationship.getGUID(), instanceTypeName, relationshipElementStub, endOneElementStub, endTwoElementStub);
                }
            }
            catch (InvalidParameterException | UserNotAuthorizedException relationshipElementStub) {
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, DataManagerAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{relationship.getGUID(), instanceTypeName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processNewEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.NEW_ELEMENT_CREATED;
        log.debug("Processing new Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, null, "processNewEntityEvent");
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        String methodName = "processUpdatedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_UPDATED;
        log.debug("Processing updated Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, newEntity, null, null, "processUpdatedEntityEvent");
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entityProxy, Classification classification) {
        String methodName = "processClassifiedEntityEvent(proxy)";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_CLASSIFIED;
        log.debug("Processing classified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, null, entityProxy, classification.getName(), "processClassifiedEntityEvent(proxy)");
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_CLASSIFIED;
        log.debug("Processing classified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, classification.getName(), "processClassifiedEntityEvent");
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processClassifiedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_CLASSIFIED;
        log.debug("Processing classified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, null, "processClassifiedEntityEvent");
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entityProxy, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent(proxy)";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_DECLASSIFIED;
        log.debug("Processing declassified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, null, entityProxy, null, "processDeclassifiedEntityEvent(proxy)");
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_DECLASSIFIED;
        log.debug("Processing declassified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, originalClassification.getName(), "processDeclassifiedEntityEvent");
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeclassifiedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_DECLASSIFIED;
        log.debug("Processing declassified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, null, "processDeclassifiedEntityEvent");
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entityProxy, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent(proxy)";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_RECLASSIFIED;
        log.debug("Processing reclassified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, null, entityProxy, originalClassification.getName(), "processReclassifiedEntityEvent(proxy)");
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_RECLASSIFIED;
        log.debug("Processing reclassified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, originalClassification.getName(), "processReclassifiedEntityEvent");
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processReclassifiedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_RECLASSIFIED;
        log.debug("Processing reclassified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, null, "processReclassifiedEntityEvent");
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_DELETED;
        log.debug("Processing deleted Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, null, "processDeletedEntityEvent");
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletePurgedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_DELETED;
        log.debug("Processing delete-purge entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, null, "processDeletePurgedEntityEvent");
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        String methodName = "processReIdentifiedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_GUID_CHANGED;
        log.debug("Processing re-identified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, null, "processReIdentifiedEntityEvent");
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        String methodName = "processReTypedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_TYPE_CHANGED;
        log.debug("Processing re-typed Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, null, "processReTypedEntityEvent");
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        String methodName = "processReHomedEntityEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_HOME_CHANGED;
        log.debug("Processing re-homed Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, null, "processReHomedEntityEvent");
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processNewRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.NEW_ELEMENT_CREATED;
        log.debug("Processing new relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processNewRelationshipEvent");
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        String methodName = "processUpdatedRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_UPDATED;
        log.debug("Processing updated relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, newRelationship, "processUpdatedRelationshipEvent");
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletedRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_DELETED;
        log.debug("Processing deleted relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processDeletedRelationshipEvent");
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processUpdatedRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_DELETED;
        log.debug("Processing delete-purge relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processUpdatedRelationshipEvent");
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        String methodName = "processReIdentifiedRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_GUID_CHANGED;
        log.debug("Processing re-identified relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processReIdentifiedRelationshipEvent");
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        String methodName = "processReTypedRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_TYPE_CHANGED;
        log.debug("Processing re-typed relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processReTypedRelationshipEvent");
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        String methodName = "processReHomedRelationshipEvent";
        DataManagerOutboundEventType eventType = DataManagerOutboundEventType.ELEMENT_GUID_CHANGED;
        log.debug("Processing re-homed relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processReHomedRelationshipEvent");
    }
}

