/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.APIManagerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ApplicationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataProcessingEngineRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.DatabaseManagerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.EventBrokerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FileManagerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FileSystemRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionResponse;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SoftwareCapabilityElement;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.slf4j.LoggerFactory;

public class DataManagerRESTServices {
    private static final DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DataManagerRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public OCFConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        OCFConnectionResponse response = new OCFConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createFileSystemInCatalog(String serverName, String userId, FileSystemRequestBody requestBody) {
        String methodName = "createFileSystemInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFileSystemInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFileSystemInCatalog");
            if (requestBody != null) {
                SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createFileSystemInCatalog");
                response.setGUID(handler.createFileSystem(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getResourceName(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getFormat(), requestBody.getEncryption(), requestBody.getAdditionalProperties(), requestBody.getVendorProperties(), null, null, false, false, new Date(), "createFileSystemInCatalog"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createFileSystemInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createFileManagerInCatalog(String serverName, String userId, FileManagerRequestBody requestBody) {
        String methodName = "createFileManagerInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFileManagerInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFileManagerInCatalog");
            if (requestBody != null) {
                SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createFileManagerInCatalog");
                response.setGUID(handler.createSoftwareCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), OpenMetadataType.DATA_MANAGER.typeName, "FileManager", requestBody.getQualifiedName(), requestBody.getResourceName(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), requestBody.getVendorProperties(), null, null, false, false, new Date(), "createFileManagerInCatalog"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createFileManagerInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDatabaseManagerInCatalog(String serverName, String userId, DatabaseManagerRequestBody requestBody) {
        String methodName = "createDatabaseManagerInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDatabaseManagerInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDatabaseManagerInCatalog");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createDatabaseManagerInCatalog");
            response.setGUID(handler.createSoftwareCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), OpenMetadataType.DATABASE_MANAGER.typeName, null, requestBody.getQualifiedName(), requestBody.getResourceName(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), requestBody.getVendorProperties(), null, null, false, false, new Date(), "createDatabaseManagerInCatalog"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDatabaseManagerInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createAPIManagerInCatalog(String serverName, String userId, APIManagerRequestBody requestBody) {
        String methodName = "createAPIManagerInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createAPIManagerInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createAPIManagerInCatalog");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createAPIManagerInCatalog");
            response.setGUID(handler.createSoftwareCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), OpenMetadataType.API_MANAGER.typeName, null, requestBody.getQualifiedName(), requestBody.getResourceName(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), requestBody.getVendorProperties(), null, null, false, false, new Date(), "createAPIManagerInCatalog"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createAPIManagerInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEventBrokerInCatalog(String serverName, String userId, EventBrokerRequestBody requestBody) {
        String methodName = "createEventBrokerInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEventBrokerInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEventBrokerInCatalog");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createEventBrokerInCatalog");
            response.setGUID(handler.createSoftwareCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), OpenMetadataType.EVENT_BROKER.typeName, null, requestBody.getQualifiedName(), requestBody.getResourceName(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), requestBody.getVendorProperties(), null, null, false, false, new Date(), "createEventBrokerInCatalog"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createEventBrokerInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createApplicationInCatalog(String serverName, String userId, ApplicationRequestBody requestBody) {
        String methodName = "createApplicationInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createApplicationInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createApplicationInCatalog");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createApplicationInCatalog");
            response.setGUID(handler.createSoftwareCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), OpenMetadataType.APPLICATION.typeName, null, requestBody.getQualifiedName(), requestBody.getResourceName(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), requestBody.getVendorProperties(), null, null, false, false, new Date(), "createApplicationInCatalog"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createApplicationInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDataProcessingEngineInCatalog(String serverName, String userId, DataProcessingEngineRequestBody requestBody) {
        String methodName = "createDataProcessingEngineInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDataProcessingEngineInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataProcessingEngineInCatalog");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "createDataProcessingEngineInCatalog");
            response.setGUID(handler.createSoftwareCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), OpenMetadataType.ENGINE.typeName, null, requestBody.getQualifiedName(), requestBody.getResourceName(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), requestBody.getVendorProperties(), null, null, false, false, new Date(), "createDataProcessingEngineInCatalog"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDataProcessingEngineInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getMetadataSourceGUID(String serverName, String userId, NameRequestBody requestBody) {
        String methodName = "getMetadataSourceGUID";
        String parameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataSourceGUID");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataSourceGUID");
            if (requestBody != null) {
                SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareServerCapabilityHandler(userId, serverName, "getMetadataSourceGUID");
                response.setGUID(handler.getBeanGUIDByQualifiedName(userId, OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, requestBody.getName(), "qualifiedName", false, false, new Date(), "getMetadataSourceGUID"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMetadataSourceGUID", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataSourceGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

