/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataContainerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataContainerResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataContainersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FormRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FormResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FormsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.QueriesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.QueryRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.QueryResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReportRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReportResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReportsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.DisplayDataContainerHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataContainerElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.FormElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.QueryElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ReportElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.display.FormProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.display.QueryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.display.ReportProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.display.DataContainerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.slf4j.LoggerFactory;

public class DisplayApplicationRESTServices {
    private static final DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DisplayApplicationRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createForm(String serverName, String userId, boolean applicationIsHome, FormRequestBody requestBody) {
        String methodName = "createForm";
        String applicationGUIDParameterName = "applicationGUID";
        String formGUIDParameterName = "formGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createForm");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createForm");
            AssetHandler<FormElement> handler = instanceHandler.getFormHandler(userId, serverName, "createForm");
            if (requestBody != null) {
                String formGUID;
                String typeName = OpenMetadataType.FORM.typeName;
                if (requestBody.getTypeName() != null) {
                    typeName = requestBody.getTypeName();
                }
                if ((formGUID = handler.createAssetInRepository(userId, handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceName()), requestBody.getQualifiedName(), requestBody.getName(), requestBody.getResourceName(), requestBody.getVersionIdentifier(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getAdditionalProperties(), typeName, requestBody.getExtendedProperties(), InstanceStatus.ACTIVE, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), new Date(), "createForm")) != null) {
                    handler.attachAssetToSoftwareServerCapability(userId, handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceName()), formGUID, "formGUID", requestBody.getExternalSourceGUID(), "applicationGUID", null, null, false, false, new Date(), "createForm");
                    handler.setVendorProperties(userId, formGUID, requestBody.getVendorProperties(), false, false, new Date(), "createForm");
                }
                response.setGUID(formGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createForm", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createForm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createFormFromTemplate(String serverName, String userId, String templateGUID, boolean applicationIsHome, TemplateRequestBody requestBody) {
        String methodName = "createFormFromTemplate";
        String applicationGUIDParameterName = "applicationGUID";
        String formGUIDParameterName = "formGUID";
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFormFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFormFromTemplate");
            AssetHandler<FormElement> handler = instanceHandler.getFormHandler(userId, serverName, "createFormFromTemplate");
            if (requestBody != null) {
                String formGUID = handler.addAssetFromTemplate(userId, handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceName()), templateGUID, "templateGUID", OpenMetadataType.FORM.typeGUID, OpenMetadataType.FORM.typeName, requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), null, null, requestBody.getNetworkAddress(), false, false, new Date(), "createFormFromTemplate");
                if (formGUID != null) {
                    handler.attachAssetToSoftwareServerCapability(userId, handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceName()), formGUID, "formGUID", requestBody.getExternalSourceGUID(), "applicationGUID", null, null, false, false, new Date(), "createFormFromTemplate");
                }
                response.setGUID(formGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createFormFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createFormFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateForm(String serverName, String userId, String formGUID, boolean isMergeUpdate, FormRequestBody requestBody) {
        String methodName = "updateForm";
        String formGUIDParameterName = "formGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateForm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateForm");
            AssetHandler<FormElement> handler = instanceHandler.getFormHandler(userId, serverName, "updateForm");
            if (requestBody != null) {
                String typeName = OpenMetadataType.FORM.typeName;
                if (requestBody.getTypeName() != null) {
                    typeName = requestBody.getTypeName();
                }
                handler.updateAsset(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), formGUID, "formGUID", requestBody.getQualifiedName(), requestBody.getName(), requestBody.getResourceName(), requestBody.getVersionIdentifier(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getAdditionalProperties(), typeName, requestBody.getExtendedProperties(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateForm");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, formGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateForm");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateForm", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateForm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishForm(String serverName, String userId, String formGUID, NullRequestBody nullRequestBody) {
        String methodName = "publishForm";
        String formGUIDParameterName = "formGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishForm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishForm");
            AssetHandler<FormElement> handler = instanceHandler.getFormHandler(userId, serverName, "publishForm");
            handler.publishAsset(userId, formGUID, "formGUID", false, false, new Date(), "publishForm");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "publishForm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawForm(String serverName, String userId, String formGUID, NullRequestBody nullRequestBody) {
        String methodName = "withdrawForm";
        String formGUIDParameterName = "formGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawForm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawForm");
            AssetHandler<FormElement> handler = instanceHandler.getFormHandler(userId, serverName, "withdrawForm");
            handler.withdrawAsset(userId, formGUID, "formGUID", false, false, new Date(), "withdrawForm");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "withdrawForm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeForm(String serverName, String userId, String formGUID, String qualifiedName, MetadataSourceRequestBody requestBody) {
        String methodName = "removeForm";
        String formGUIDParameterName = "formGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeForm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeForm");
            AssetHandler<FormElement> handler = instanceHandler.getFormHandler(userId, serverName, "removeForm");
            if (requestBody != null) {
                handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), formGUID, "formGUID", OpenMetadataType.FORM.typeGUID, OpenMetadataType.FORM.typeName, false, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, false, false, new Date(), "removeForm");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeForm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FormsResponse findForms(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findForms";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findForms");
        FormsResponse response = new FormsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findForms");
            if (requestBody != null) {
                AssetHandler<FormElement> handler = instanceHandler.getFormHandler(userId, serverName, "findForms");
                List formAssets = handler.findAssets(userId, OpenMetadataType.FORM.typeGUID, OpenMetadataType.FORM.typeName, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findForms");
                response.setElements(this.setUpFormVendorProperties(userId, formAssets, handler, "findForms"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findForms", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findForms", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FormsResponse getFormsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getFormsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFormsByName");
        FormsResponse response = new FormsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFormsByName");
            if (requestBody != null) {
                AssetHandler<FormElement> handler = instanceHandler.getFormHandler(userId, serverName, "getFormsByName");
                List formAssets = handler.getAssetsByName(userId, OpenMetadataType.FORM.typeGUID, OpenMetadataType.FORM.typeName, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getFormsByName");
                response.setElements(this.setUpFormVendorProperties(userId, formAssets, handler, "getFormsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getFormsByName", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getFormsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FormsResponse getFormsForApplication(String serverName, String userId, String applicationGUID, String applicationName, int startFrom, int pageSize) {
        String methodName = "getFormsForApplication";
        String applicationGUIDParameterName = "applicationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFormsForApplication");
        FormsResponse response = new FormsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFormsForApplication");
            AssetHandler<FormElement> handler = instanceHandler.getFormHandler(userId, serverName, "getFormsForApplication");
            List formAssets = handler.getAttachedElements(userId, applicationGUID, "applicationGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, OpenMetadataType.FORM.typeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, new Date(), "getFormsForApplication");
            response.setElements(this.setUpFormVendorProperties(userId, formAssets, handler, "getFormsForApplication"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getFormsForApplication", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FormResponse getFormByGUID(String serverName, String userId, String guid) {
        String methodName = "getFormByGUID";
        String guidParameterName = "formGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFormByGUID");
        FormResponse response = new FormResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFormByGUID");
            AssetHandler<FormElement> handler = instanceHandler.getFormHandler(userId, serverName, "getFormByGUID");
            FormElement formAsset = (FormElement)handler.getBeanFromRepository(userId, guid, "formGUID", OpenMetadataType.FORM.typeName, false, false, new Date(), "getFormByGUID");
            response.setElement(this.setUpVendorProperties(userId, formAsset, handler, "getFormByGUID"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getFormByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createReport(String serverName, String userId, boolean applicationIsHome, ReportRequestBody requestBody) {
        String methodName = "createReport";
        String applicationGUIDParameterName = "applicationGUID";
        String reportGUIDParameterName = "reportGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createReport");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createReport");
            AssetHandler<ReportElement> handler = instanceHandler.getReportHandler(userId, serverName, "createReport");
            if (requestBody != null) {
                String reportGUID;
                HashMap<String, Object> extendedProperties;
                String typeName = OpenMetadataType.DEPLOYED_REPORT.typeName;
                if (requestBody.getTypeName() != null) {
                    typeName = requestBody.getTypeName();
                }
                if ((extendedProperties = requestBody.getExtendedProperties()) == null) {
                    extendedProperties = new HashMap<String, Object>();
                }
                if (requestBody.getId() != null) {
                    extendedProperties.put(OpenMetadataProperty.ID.name, requestBody.getId());
                }
                if (requestBody.getAuthor() != null) {
                    extendedProperties.put(OpenMetadataProperty.AUTHOR.name, requestBody.getAuthor());
                }
                if (requestBody.getUrl() != null) {
                    extendedProperties.put(OpenMetadataProperty.URL.name, requestBody.getUrl());
                }
                if (requestBody.getCreateTime() != null) {
                    extendedProperties.put(OpenMetadataProperty.CREATED_TIME.name, requestBody.getCreateTime());
                }
                if (requestBody.getLastModifiedTime() != null) {
                    extendedProperties.put(OpenMetadataProperty.LAST_MODIFIED_TIME.name, requestBody.getLastModifiedTime());
                }
                if (requestBody.getLastModifier() != null) {
                    extendedProperties.put(OpenMetadataProperty.LAST_MODIFIER.name, requestBody.getLastModifier());
                }
                if (extendedProperties.isEmpty()) {
                    extendedProperties = null;
                }
                if ((reportGUID = handler.createAssetInRepository(userId, handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceName()), requestBody.getQualifiedName(), requestBody.getName(), requestBody.getResourceName(), requestBody.getVersionIdentifier(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getAdditionalProperties(), typeName, extendedProperties, InstanceStatus.ACTIVE, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), new Date(), "createReport")) != null && requestBody.getExternalSourceGUID() != null) {
                    handler.linkElementToElement(userId, handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceName()), requestBody.getExternalSourceGUID(), "applicationGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, reportGUID, "reportGUID", OpenMetadataType.DEPLOYED_REPORT.typeName, false, false, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "createReport");
                }
                if (reportGUID != null && requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, reportGUID, requestBody.getVendorProperties(), false, false, new Date(), "createReport");
                }
                response.setGUID(reportGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createReport", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createReportFromTemplate(String serverName, String userId, String templateGUID, boolean applicationIsHome, TemplateRequestBody requestBody) {
        String methodName = "createReportFromTemplate";
        String applicationGUIDParameterName = "applicationGUID";
        String reportGUIDParameterName = "reportGUID";
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createReportFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createReportFromTemplate");
            AssetHandler<ReportElement> handler = instanceHandler.getReportHandler(userId, serverName, "createReportFromTemplate");
            if (requestBody != null) {
                String reportGUID = handler.addAssetFromTemplate(userId, handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceName()), templateGUID, "templateGUID", OpenMetadataType.DEPLOYED_REPORT.typeGUID, OpenMetadataType.DEPLOYED_REPORT.typeName, requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), null, null, requestBody.getNetworkAddress(), false, false, new Date(), "createReportFromTemplate");
                if (reportGUID != null && requestBody.getExternalSourceGUID() != null) {
                    handler.linkElementToElement(userId, handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceName()), requestBody.getExternalSourceGUID(), "applicationGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, reportGUID, "reportGUID", OpenMetadataType.DEPLOYED_REPORT.typeName, false, false, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "createReportFromTemplate");
                }
                response.setGUID(reportGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createReportFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createReportFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateReport(String serverName, String userId, String reportGUID, boolean isMergeUpdate, ReportRequestBody requestBody) {
        String methodName = "updateReport";
        String reportGUIDParameterName = "reportGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateReport");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateReport");
            AssetHandler<ReportElement> handler = instanceHandler.getReportHandler(userId, serverName, "updateReport");
            if (requestBody != null) {
                HashMap<String, Object> extendedProperties;
                String typeName = OpenMetadataType.DEPLOYED_REPORT.typeName;
                if (requestBody.getTypeName() != null) {
                    typeName = requestBody.getTypeName();
                }
                if ((extendedProperties = requestBody.getExtendedProperties()) == null) {
                    extendedProperties = new HashMap<String, Object>();
                }
                if (requestBody.getId() != null) {
                    extendedProperties.put(OpenMetadataProperty.ID.name, requestBody.getId());
                }
                if (requestBody.getAuthor() != null) {
                    extendedProperties.put(OpenMetadataProperty.AUTHOR.name, requestBody.getAuthor());
                }
                if (requestBody.getUrl() != null) {
                    extendedProperties.put(OpenMetadataProperty.URL.name, requestBody.getUrl());
                }
                if (requestBody.getCreateTime() != null) {
                    extendedProperties.put(OpenMetadataProperty.CREATED_TIME.name, requestBody.getCreateTime());
                }
                if (requestBody.getLastModifiedTime() != null) {
                    extendedProperties.put(OpenMetadataProperty.LAST_MODIFIED_TIME.name, requestBody.getLastModifiedTime());
                }
                if (requestBody.getLastModifier() != null) {
                    extendedProperties.put(OpenMetadataProperty.LAST_MODIFIER.name, requestBody.getLastModifier());
                }
                if (extendedProperties.isEmpty()) {
                    extendedProperties = null;
                }
                handler.updateAsset(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), reportGUID, "reportGUID", requestBody.getQualifiedName(), requestBody.getName(), requestBody.getResourceName(), requestBody.getVersionIdentifier(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getAdditionalProperties(), typeName, extendedProperties, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateReport");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, reportGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateReport");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateReport", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishReport(String serverName, String userId, String reportGUID, NullRequestBody nullRequestBody) {
        String methodName = "publishReport";
        String reportGUIDParameterName = "reportGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishReport");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishReport");
            AssetHandler<ReportElement> handler = instanceHandler.getReportHandler(userId, serverName, "publishReport");
            handler.publishAsset(userId, reportGUID, "reportGUID", false, false, new Date(), "publishReport");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "publishReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawReport(String serverName, String userId, String reportGUID, NullRequestBody nullRequestBody) {
        String methodName = "withdrawReport";
        String reportGUIDParameterName = "reportGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawReport");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawReport");
            AssetHandler<ReportElement> handler = instanceHandler.getReportHandler(userId, serverName, "withdrawReport");
            handler.withdrawAsset(userId, reportGUID, "reportGUID", false, false, new Date(), "withdrawReport");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "withdrawReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeReport(String serverName, String userId, String reportGUID, String qualifiedName, MetadataSourceRequestBody requestBody) {
        String methodName = "removeReport";
        String reportGUIDParameterName = "reportGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeReport");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeReport");
            AssetHandler<ReportElement> handler = instanceHandler.getReportHandler(userId, serverName, "removeReport");
            if (requestBody != null) {
                handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), reportGUID, "reportGUID", OpenMetadataType.DEPLOYED_REPORT.typeGUID, OpenMetadataType.DEPLOYED_REPORT.typeName, false, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, false, false, new Date(), "removeReport");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ReportsResponse findReports(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findReports";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findReports");
        ReportsResponse response = new ReportsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findReports");
            if (requestBody != null) {
                AssetHandler<ReportElement> handler = instanceHandler.getReportHandler(userId, serverName, "findReports");
                List reportAssets = handler.findAssets(userId, OpenMetadataType.DEPLOYED_REPORT.typeGUID, OpenMetadataType.DEPLOYED_REPORT.typeName, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findReports");
                response.setElements(this.setUpReportVendorProperties(userId, reportAssets, handler, "findReports"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findReports", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findReports", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ReportsResponse getReportsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getReportsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getReportsByName");
        ReportsResponse response = new ReportsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getReportsByName");
            if (requestBody != null) {
                AssetHandler<ReportElement> handler = instanceHandler.getReportHandler(userId, serverName, "getReportsByName");
                List reportAssets = handler.getAssetsByName(userId, OpenMetadataType.DEPLOYED_REPORT.typeGUID, OpenMetadataType.DEPLOYED_REPORT.typeName, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getReportsByName");
                response.setElements(this.setUpReportVendorProperties(userId, reportAssets, handler, "getReportsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getReportsByName", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getReportsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ReportsResponse getReportsForApplication(String serverName, String userId, String applicationGUID, String applicationName, int startFrom, int pageSize) {
        String methodName = "getReportsForApplication";
        String applicationGUIDParameterName = "applicationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getReportsForApplication");
        ReportsResponse response = new ReportsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getReportsForApplication");
            AssetHandler<ReportElement> handler = instanceHandler.getReportHandler(userId, serverName, "getReportsForApplication");
            List reportAssets = handler.getAttachedElements(userId, applicationGUID, "applicationGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, OpenMetadataType.DEPLOYED_REPORT.typeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, new Date(), "getReportsForApplication");
            response.setElements(this.setUpReportVendorProperties(userId, reportAssets, handler, "getReportsForApplication"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getReportsForApplication", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ReportResponse getReportByGUID(String serverName, String userId, String guid) {
        String methodName = "getReportByGUID";
        String guidParameterName = "reportGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getReportByGUID");
        ReportResponse response = new ReportResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getReportByGUID");
            AssetHandler<ReportElement> handler = instanceHandler.getReportHandler(userId, serverName, "getReportByGUID");
            ReportElement reportAsset = (ReportElement)handler.getBeanFromRepository(userId, guid, "reportGUID", OpenMetadataType.DEPLOYED_REPORT.typeName, false, false, new Date(), "getReportByGUID");
            response.setElement(this.setUpVendorProperties(userId, reportAsset, handler, "getReportByGUID"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getReportByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createQuery(String serverName, String userId, boolean applicationIsHome, QueryRequestBody requestBody) {
        String methodName = "createQuery";
        String applicationGUIDParameterName = "applicationGUID";
        String queryGUIDParameterName = "queryGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createQuery");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createQuery");
            AssetHandler<QueryElement> handler = instanceHandler.getQueryHandler(userId, serverName, "createQuery");
            if (requestBody != null) {
                String queryGUID;
                String typeName = OpenMetadataType.INFORMATION_VIEW.typeName;
                if (requestBody.getTypeName() != null) {
                    typeName = requestBody.getTypeName();
                }
                if ((queryGUID = handler.createAssetInRepository(userId, handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceName()), requestBody.getQualifiedName(), requestBody.getName(), requestBody.getResourceName(), requestBody.getVersionIdentifier(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getAdditionalProperties(), typeName, requestBody.getExtendedProperties(), InstanceStatus.ACTIVE, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), new Date(), "createQuery")) != null && requestBody.getExternalSourceGUID() != null) {
                    handler.linkElementToElement(userId, handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceName()), requestBody.getExternalSourceGUID(), "applicationGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, queryGUID, "queryGUID", OpenMetadataType.INFORMATION_VIEW.typeName, false, false, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "createQuery");
                }
                if (queryGUID != null && requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, queryGUID, requestBody.getVendorProperties(), false, false, new Date(), "createQuery");
                }
                response.setGUID(queryGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createQuery", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createQuery", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createQueryFromTemplate(String serverName, String userId, String templateGUID, boolean applicationIsHome, TemplateRequestBody requestBody) {
        String methodName = "createQueryFromTemplate";
        String applicationGUIDParameterName = "applicationGUID";
        String queryGUIDParameterName = "queryGUID";
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createQueryFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createQueryFromTemplate");
            AssetHandler<QueryElement> handler = instanceHandler.getQueryHandler(userId, serverName, "createQueryFromTemplate");
            if (requestBody != null) {
                String queryGUID = handler.addAssetFromTemplate(userId, handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceName()), templateGUID, "templateGUID", OpenMetadataType.INFORMATION_VIEW.typeGUID, OpenMetadataType.INFORMATION_VIEW.typeName, requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), null, requestBody.getPathName(), requestBody.getNetworkAddress(), false, false, new Date(), "createQueryFromTemplate");
                if (queryGUID != null && requestBody.getExternalSourceGUID() != null) {
                    handler.linkElementToElement(userId, handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(applicationIsHome, requestBody.getExternalSourceName()), requestBody.getExternalSourceGUID(), "applicationGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, queryGUID, "queryGUID", OpenMetadataType.INFORMATION_VIEW.typeName, false, false, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "createQueryFromTemplate");
                }
                response.setGUID(queryGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createQueryFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createQueryFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateQuery(String serverName, String userId, String queryGUID, boolean isMergeUpdate, QueryRequestBody requestBody) {
        String methodName = "updateQuery";
        String queryGUIDParameterName = "queryGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateQuery");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateQuery");
            AssetHandler<QueryElement> handler = instanceHandler.getQueryHandler(userId, serverName, "updateQuery");
            if (requestBody != null) {
                String typeName = OpenMetadataType.INFORMATION_VIEW.typeName;
                if (requestBody.getTypeName() != null) {
                    typeName = requestBody.getTypeName();
                }
                handler.updateAsset(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), queryGUID, "queryGUID", requestBody.getQualifiedName(), requestBody.getName(), requestBody.getResourceName(), requestBody.getVersionIdentifier(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getAdditionalProperties(), typeName, requestBody.getExtendedProperties(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateQuery");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, queryGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateQuery");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateQuery", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateQuery", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishQuery(String serverName, String userId, String queryGUID, NullRequestBody nullRequestBody) {
        String methodName = "publishQuery";
        String queryGUIDParameterName = "queryGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishQuery");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishQuery");
            AssetHandler<QueryElement> handler = instanceHandler.getQueryHandler(userId, serverName, "publishQuery");
            handler.publishAsset(userId, queryGUID, "queryGUID", false, false, new Date(), "publishQuery");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "publishQuery", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawQuery(String serverName, String userId, String queryGUID, NullRequestBody nullRequestBody) {
        String methodName = "withdrawQuery";
        String queryGUIDParameterName = "queryGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawQuery");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawQuery");
            AssetHandler<QueryElement> handler = instanceHandler.getQueryHandler(userId, serverName, "withdrawQuery");
            handler.withdrawAsset(userId, queryGUID, "queryGUID", false, false, new Date(), "withdrawQuery");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "withdrawQuery", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeQuery(String serverName, String userId, String queryGUID, String qualifiedName, MetadataSourceRequestBody requestBody) {
        String methodName = "removeQuery";
        String queryGUIDParameterName = "queryGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeQuery");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeQuery");
            AssetHandler<QueryElement> handler = instanceHandler.getQueryHandler(userId, serverName, "removeQuery");
            handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), queryGUID, "queryGUID", OpenMetadataType.INFORMATION_VIEW.typeGUID, OpenMetadataType.INFORMATION_VIEW.typeName, false, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, false, false, new Date(), "removeQuery");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeQuery", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public QueriesResponse findQueries(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findQueries";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findQueries");
        QueriesResponse response = new QueriesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findQueries");
            if (requestBody != null) {
                AssetHandler<QueryElement> handler = instanceHandler.getQueryHandler(userId, serverName, "findQueries");
                List queryAssets = handler.findAssets(userId, OpenMetadataType.INFORMATION_VIEW.typeGUID, OpenMetadataType.INFORMATION_VIEW.typeName, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findQueries");
                response.setElements(this.setUpQueryVendorProperties(userId, queryAssets, handler, "findQueries"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findQueries", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findQueries", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public QueriesResponse getQueriesByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getQueriesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getQueriesByName");
        QueriesResponse response = new QueriesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getQueriesByName");
            if (requestBody != null) {
                AssetHandler<QueryElement> handler = instanceHandler.getQueryHandler(userId, serverName, "getQueriesByName");
                List queryAssets = handler.getAssetsByName(userId, OpenMetadataType.INFORMATION_VIEW.typeGUID, OpenMetadataType.INFORMATION_VIEW.typeName, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getQueriesByName");
                response.setElements(this.setUpQueryVendorProperties(userId, queryAssets, handler, "getQueriesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getQueriesByName", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getQueriesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public QueriesResponse getQueriesForApplication(String serverName, String userId, String applicationGUID, String applicationName, int startFrom, int pageSize) {
        String methodName = "getQueriesForApplication";
        String applicationGUIDParameterName = "applicationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getQueriesForApplication");
        QueriesResponse response = new QueriesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getQueriesForApplication");
            AssetHandler<QueryElement> handler = instanceHandler.getQueryHandler(userId, serverName, "getQueriesForApplication");
            List queryAssets = handler.getAttachedElements(userId, applicationGUID, "applicationGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, OpenMetadataType.INFORMATION_VIEW.typeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, new Date(), "getQueriesForApplication");
            response.setElements(this.setUpQueryVendorProperties(userId, queryAssets, handler, "getQueriesForApplication"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getQueriesForApplication", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public QueryResponse getQueryByGUID(String serverName, String userId, String guid) {
        String methodName = "getQueryByGUID";
        String guidParameterName = "queryGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getQueryByGUID");
        QueryResponse response = new QueryResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getQueryByGUID");
            AssetHandler<QueryElement> handler = instanceHandler.getQueryHandler(userId, serverName, "getQueryByGUID");
            QueryElement queryAsset = (QueryElement)handler.getBeanFromRepository(userId, guid, "queryGUID", OpenMetadataType.INFORMATION_VIEW.typeName, false, false, new Date(), "getQueryByGUID");
            response.setElement(this.setUpVendorProperties(userId, queryAsset, handler, "getQueryByGUID"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getQueryByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDataContainer(String serverName, String userId, String parentGUID, boolean applicationIsHome, DataContainerRequestBody requestBody) {
        String methodName = "createDataContainer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDataContainer");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataContainer");
            DisplayDataContainerHandler<DataContainerElement, SchemaTypeElement> handler = instanceHandler.getDisplayDataContainerHandler(userId, serverName, "createDataContainer");
            if (requestBody != null) {
                String typeName = OpenMetadataType.DISPLAY_DATA_CONTAINER.typeName;
                if (requestBody.getTypeName() != null) {
                    typeName = requestBody.getTypeName();
                }
                String dataFieldGUID = applicationIsHome ? handler.createDataContainer(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getIsDeprecated(), requestBody.getElementPosition(), requestBody.getMinCardinality(), requestBody.getMaxCardinality(), requestBody.getAdditionalProperties(), typeName, requestBody.getExtendedProperties(), requestBody.getVendorProperties(), null, null, false, false, new Date(), "createDataContainer") : handler.createDataContainer(userId, null, null, parentGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getIsDeprecated(), requestBody.getElementPosition(), requestBody.getMinCardinality(), requestBody.getMaxCardinality(), requestBody.getAdditionalProperties(), typeName, requestBody.getExtendedProperties(), requestBody.getVendorProperties(), null, null, false, false, new Date(), "createDataContainer");
                if (requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, parentGUID, requestBody.getVendorProperties(), false, false, new Date(), "createDataContainer");
                }
                response.setGUID(dataFieldGUID);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createDataContainer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDataContainerFromTemplate(String serverName, String userId, String templateGUID, String parentGUID, boolean applicationIsHome, TemplateRequestBody requestBody) {
        String methodName = "createDataContainerFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDataContainerFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataContainerFromTemplate");
            DisplayDataContainerHandler<DataContainerElement, SchemaTypeElement> handler = instanceHandler.getDisplayDataContainerHandler(userId, serverName, "createDataContainerFromTemplate");
            if (requestBody != null) {
                if (applicationIsHome) {
                    response.setGUID(handler.createDataContainerFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentGUID, templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), null, null, false, false, new Date(), "createDataContainerFromTemplate"));
                } else {
                    response.setGUID(handler.createDataContainerFromTemplate(userId, null, null, parentGUID, templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), null, null, false, false, new Date(), "createDataContainerFromTemplate"));
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDataContainerFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createDataContainerFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDataContainer(String serverName, String userId, String dataContainerGUID, boolean isMergeUpdate, DataContainerRequestBody requestBody) {
        String methodName = "updateDataContainer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDataContainer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDataContainer");
            DisplayDataContainerHandler<DataContainerElement, SchemaTypeElement> handler = instanceHandler.getDisplayDataContainerHandler(userId, serverName, "updateDataContainer");
            if (requestBody != null) {
                handler.updateDataContainer(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataContainerGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getIsDeprecated(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), requestBody.getVendorProperties(), null, null, isMergeUpdate, false, false, new Date(), "updateDataContainer");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDataContainer", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateDataContainer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDataContainer(String serverName, String userId, String dataContainerGUID, String qualifiedName, MetadataSourceRequestBody requestBody) {
        String methodName = "removeDataContainer";
        String dataFieldGUIDParameterName = "dataContainerGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDataContainer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDataContainer");
            DisplayDataContainerHandler<DataContainerElement, SchemaTypeElement> handler = instanceHandler.getDisplayDataContainerHandler(userId, serverName, "removeDataContainer");
            if (requestBody != null) {
                handler.removeDataContainer(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataContainerGUID, "dataContainerGUID", qualifiedName, false, false, new Date(), "removeDataContainer");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeDataContainer", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeDataContainer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataContainersResponse findDataContainers(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findDataContainers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDataContainers");
        DataContainersResponse response = new DataContainersResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDataContainers");
            if (requestBody != null) {
                DisplayDataContainerHandler<DataContainerElement, SchemaTypeElement> handler = instanceHandler.getDisplayDataContainerHandler(userId, serverName, "findDataContainers");
                List elements = handler.findDataContainers(userId, requestBody.getSearchString(), startFrom, pageSize, false, false, new Date(), "findDataContainers");
                response.setElements(this.setUpVendorProperties(userId, elements, handler, "findDataContainers"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findDataContainers", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findDataContainers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataContainersResponse getDataContainersForParent(String serverName, String userId, String parentGUID, int startFrom, int pageSize) {
        String methodName = "getDataContainersForParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataContainersForParent");
        DataContainersResponse response = new DataContainersResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataContainersForParent");
            DisplayDataContainerHandler<DataContainerElement, SchemaTypeElement> handler = instanceHandler.getDisplayDataContainerHandler(userId, serverName, "getDataContainersForParent");
            List elements = handler.getContainersForParent(userId, null, null, parentGUID, startFrom, pageSize, null, null, false, false, new Date(), "getDataContainersForParent");
            response.setElements(this.setUpVendorProperties(userId, elements, handler, "getDataContainersForParent"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataContainersForParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataContainersResponse getDataContainersByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getDataContainersByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataContainersByName");
        DataContainersResponse response = new DataContainersResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataContainersByName");
            if (requestBody != null) {
                DisplayDataContainerHandler<DataContainerElement, SchemaTypeElement> handler = instanceHandler.getDisplayDataContainerHandler(userId, serverName, "getDataContainersByName");
                List elements = handler.getDataContainersByName(userId, requestBody.getName(), startFrom, pageSize, false, false, new Date(), "getDataContainersByName");
                response.setElements(this.setUpVendorProperties(userId, elements, handler, "getDataContainersByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDataContainersByName", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataContainersByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataContainerResponse getDataContainerByGUID(String serverName, String userId, String guid) {
        String methodName = "getDataContainerByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataContainerByGUID");
        DataContainerResponse response = new DataContainerResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataContainerByGUID");
            DisplayDataContainerHandler<DataContainerElement, SchemaTypeElement> handler = instanceHandler.getDisplayDataContainerHandler(userId, serverName, "getDataContainerByGUID");
            DataContainerElement element = (DataContainerElement)handler.getDataContainerByGUID(userId, guid, false, false, new Date(), "getDataContainerByGUID");
            response.setElement(this.setUpVendorProperties(userId, element, handler, "getDataContainerByGUID"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataContainerByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<FormElement> setUpFormVendorProperties(String userId, List<FormElement> retrievedResults, AssetHandler<FormElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (FormElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private FormElement setUpVendorProperties(String userId, FormElement element, AssetHandler<FormElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            FormProperties properties = element.getProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    private List<ReportElement> setUpReportVendorProperties(String userId, List<ReportElement> retrievedResults, AssetHandler<ReportElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (ReportElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private ReportElement setUpVendorProperties(String userId, ReportElement element, AssetHandler<ReportElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            ReportProperties properties = element.getProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    private List<QueryElement> setUpQueryVendorProperties(String userId, List<QueryElement> retrievedResults, AssetHandler<QueryElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (QueryElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private QueryElement setUpVendorProperties(String userId, QueryElement element, AssetHandler<QueryElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            QueryProperties properties = element.getProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    private List<DataContainerElement> setUpVendorProperties(String userId, List<DataContainerElement> retrievedResults, DisplayDataContainerHandler<DataContainerElement, SchemaTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (DataContainerElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private DataContainerElement setUpVendorProperties(String userId, DataContainerElement element, DisplayDataContainerHandler<DataContainerElement, SchemaTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            DataContainerProperties properties = element.getProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }
}

