/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ArchiveRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFileRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFileResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFilesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFolderRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FileFolderResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FileSystemResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PathNameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.FilesAndFoldersHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataFileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.FileFolderElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.FileSystemElement;
import org.slf4j.LoggerFactory;

public class FilesRESTServices {
    private static final DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(FilesRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public GUIDListResponse createFolderStructureInCatalog(String serverName, String userId, String parentGUID, PathNameRequestBody requestBody) {
        String requestBodyParameterName = "requestBody";
        String methodName = "createFolderStructureInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFolderStructureInCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFolderStructureInCatalog");
            this.invalidParameterHandler.validateObject((Object)requestBody, "requestBody", "createFolderStructureInCatalog");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "createFolderStructureInCatalog");
            response.setGUIDs(handler.createFolderStructureInCatalog(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentGUID, requestBody.getPathName(), null, null, false, false, new Date(), "createFolderStructureInCatalog"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createFolderStructureInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachFolderToFileSystem(String serverName, String userId, String fileSystemGUID, String folderGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "attachFolderToFileSystem";
        String fileSystemGUIDParameterName = "fileSystemGUID";
        String folderGUIDParameterName = "folderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachFolderToFileSystem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachFolderToFileSystem");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "attachFolderToFileSystem");
            String externalSourceGUID = null;
            String externalSourceName = null;
            if (requestBody != null) {
                externalSourceGUID = requestBody.getExternalSourceGUID();
                externalSourceName = requestBody.getExternalSourceName();
            }
            handler.attachFolderToFileSystem(userId, externalSourceGUID, externalSourceName, fileSystemGUID, "fileSystemGUID", folderGUID, "folderGUID", null, null, false, false, new Date(), "attachFolderToFileSystem");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "attachFolderToFileSystem", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachFolderFromFileSystem(String serverName, String userId, String fileSystemGUID, String folderGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "detachFolderFromFileSystem";
        String fileSystemGUIDParameterName = "fileSystemGUID";
        String folderGUIDParameterName = "folderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachFolderFromFileSystem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachFolderFromFileSystem");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "detachFolderFromFileSystem");
            String externalSourceGUID = null;
            String externalSourceName = null;
            if (requestBody != null) {
                externalSourceGUID = requestBody.getExternalSourceGUID();
                externalSourceName = requestBody.getExternalSourceName();
            }
            handler.detachFolderFromFileSystem(userId, externalSourceGUID, externalSourceName, fileSystemGUID, "fileSystemGUID", folderGUID, "folderGUID", false, false, new Date(), "detachFolderFromFileSystem");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "detachFolderFromFileSystem", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse addDataFileToCatalog(String serverName, String userId, DataFileRequestBody requestBody) {
        String methodName = "addDataFileToCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addDataFileToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addDataFileToCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addDataFileToCatalog");
                String pathName = requestBody.getPathName();
                if (pathName == null) {
                    pathName = requestBody.getQualifiedName();
                }
                response.setGUIDs(handler.addFileToCatalog(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getName(), requestBody.getResourceName(), requestBody.getVersionIdentifier(), requestBody.getResourceDescription(), pathName, requestBody.getCreateTime(), requestBody.getModifiedTime(), requestBody.getEncodingType(), requestBody.getEncodingLanguage(), requestBody.getEncodingDescription(), requestBody.getEncodingProperties(), requestBody.getFileName(), requestBody.getFileType(), requestBody.getFileExtension(), requestBody.getDeployedImplementationType(), requestBody.getAdditionalProperties(), requestBody.getConnectorProviderClassName(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, false, false, new Date(), "addDataFileToCatalog"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addDataFileToCatalog", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addDataFileToCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse addDataFileToCatalogFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "addDataFileToCatalogFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addDataFileToCatalogFromTemplate");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addDataFileToCatalogFromTemplate");
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addDataFileToCatalogFromTemplate");
                String pathName = requestBody.getPathName();
                if (pathName == null) {
                    pathName = requestBody.getQualifiedName();
                }
                response.setGUIDs(handler.addFileToCatalogFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getQualifiedName(), pathName, requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), false, false, new Date(), "addDataFileToCatalogFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addDataFileToCatalogFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addDataFileToCatalogFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDataFileInCatalog(String serverName, String userId, String dataFileGUID, boolean isMergeUpdate, DataFileRequestBody requestBody) {
        String methodName = "updateDataFileInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDataFileInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDataFileInCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "updateDataFileInCatalog");
                handler.updateFileInCatalog(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataFileGUID, isMergeUpdate, requestBody.getQualifiedName(), requestBody.getName(), requestBody.getResourceName(), requestBody.getVersionIdentifier(), requestBody.getResourceDescription(), requestBody.getCreateTime(), requestBody.getModifiedTime(), requestBody.getEncodingType(), requestBody.getEncodingLanguage(), requestBody.getEncodingDescription(), requestBody.getEncodingProperties(), requestBody.getFileName(), requestBody.getFileType(), requestBody.getFileExtension(), requestBody.getDeployedImplementationType(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), null, null, false, false, new Date(), "updateDataFileInCatalog");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDataFileInCatalog", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateDataFileInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse archiveDataFileInCatalog(String serverName, String userId, String dataFileGUID, ArchiveRequestBody requestBody) {
        String methodName = "archiveDataFileInCatalog";
        String dataFileGUIDParameterName = "dataFileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "archiveDataFileInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "archiveDataFileInCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "archiveDataFileInCatalog");
                handler.archiveFileInCatalog(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataFileGUID, "dataFileGUID", requestBody.getArchiveDate(), requestBody.getArchiveProcess(), requestBody.getArchiveProperties(), false, new Date(), "archiveDataFileInCatalog");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "archiveDataFileInCatalog", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "archiveDataFileInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteDataFileFromCatalog(String serverName, String userId, String dataFileGUID, PathNameRequestBody requestBody) {
        String methodName = "deleteDataFileInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteDataFileInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteDataFileInCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "deleteDataFileInCatalog");
                handler.deleteFileFromCatalog(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataFileGUID, false, false, new Date(), "deleteDataFileInCatalog");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteDataFileInCatalog", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "deleteDataFileInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse addDataFolderAssetToCatalog(String serverName, String userId, DataFolderRequestBody requestBody) {
        String methodName = "addDataFolderAssetToCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addDataFolderAssetToCatalog");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addDataFolderAssetToCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addDataFolderAssetToCatalog");
                response.setGUIDs(handler.addDataFolderAssetToCatalog(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getPathName(), requestBody.getName(), requestBody.getResourceName(), requestBody.getVersionIdentifier(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getCreateTime(), requestBody.getModifiedTime(), requestBody.getEncodingType(), requestBody.getEncodingLanguage(), requestBody.getEncodingDescription(), requestBody.getEncodingProperties(), requestBody.getAdditionalProperties(), requestBody.getConnectorProviderClassName(), requestBody.getTypeName(), requestBody.getExtendedProperties(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, new Date(), "addDataFolderAssetToCatalog"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addDataFolderAssetToCatalog", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addDataFolderAssetToCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse addDataFolderToCatalogFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "addDataFolderToCatalogFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addDataFolderToCatalogFromTemplate");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addDataFolderToCatalogFromTemplate");
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "addDataFolderToCatalogFromTemplate");
                response.setGUIDs(handler.addFolderToCatalogFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getQualifiedName(), requestBody.getPathName(), requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), false, false, new Date(), "addDataFolderToCatalogFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addDataFolderToCatalogFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addDataFolderToCatalogFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDataFolderInCatalog(String serverName, String userId, String dataFolderGUID, boolean isMergeUpdate, DataFolderRequestBody requestBody) {
        String methodName = "updateDataFolderInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDataFolderInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDataFolderInCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "updateDataFolderInCatalog");
                handler.updateFolderInCatalog(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataFolderGUID, isMergeUpdate, requestBody.getPathName(), requestBody.getName(), requestBody.getResourceName(), requestBody.getVersionIdentifier(), requestBody.getResourceDescription(), requestBody.getCreateTime(), requestBody.getModifiedTime(), requestBody.getEncodingType(), requestBody.getEncodingLanguage(), requestBody.getEncodingDescription(), requestBody.getEncodingProperties(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), null, null, false, false, new Date(), "updateDataFolderInCatalog");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDataFolderInCatalog", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateDataFolderInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse archiveDataFolderInCatalog(String serverName, String userId, String dataFolderGUID, ArchiveRequestBody requestBody) {
        String methodName = "archiveDataFolderInCatalog";
        String dataFolderGUIDParameterName = "dataFolderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "archiveDataFolderInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "archiveDataFolderInCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "archiveDataFolderInCatalog");
                handler.archiveFolderInCatalog(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataFolderGUID, "dataFolderGUID", requestBody.getArchiveDate(), requestBody.getArchiveProcess(), requestBody.getArchiveProperties(), false, new Date(), "archiveDataFolderInCatalog");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "archiveDataFolderInCatalog", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "archiveDataFolderInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteDataFolderFromCatalog(String serverName, String userId, String dataFolderGUID, boolean cascadedDelete, PathNameRequestBody requestBody) {
        String methodName = "deleteDataFolderInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteDataFolderInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteDataFolderInCatalog");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "deleteDataFolderInCatalog");
                handler.deleteFolderFromCatalog(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataFolderGUID, cascadedDelete, false, false, new Date(), "deleteDataFolderInCatalog");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteDataFolderInCatalog", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "deleteDataFolderInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachDataFileAssetToFolder(String serverName, String userId, String folderGUID, String fileGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "attachDataFileAssetToFolder";
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachDataFileAssetToFolder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachDataFileAssetToFolder");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "attachDataFileAssetToFolder");
            String externalSourceGUID = null;
            String externalSourceName = null;
            if (requestBody != null) {
                externalSourceGUID = requestBody.getExternalSourceGUID();
                externalSourceName = requestBody.getExternalSourceName();
            }
            handler.attachDataFileAssetToFolder(userId, externalSourceGUID, externalSourceName, folderGUID, "folderGUID", fileGUID, "fileGUID", null, null, false, false, new Date(), "attachDataFileAssetToFolder");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "attachDataFileAssetToFolder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachDataFileAssetFromFolder(String serverName, String userId, String folderGUID, String fileGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "detachDataFileAssetFromFolder";
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachDataFileAssetFromFolder");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachDataFileAssetFromFolder");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "detachDataFileAssetFromFolder");
            String externalSourceGUID = null;
            String externalSourceName = null;
            if (requestBody != null) {
                externalSourceGUID = requestBody.getExternalSourceGUID();
                externalSourceName = requestBody.getExternalSourceName();
            }
            handler.detachDataFileAssetFromFolder(userId, externalSourceGUID, externalSourceName, folderGUID, "folderGUID", fileGUID, "fileGUID", false, false, new Date(), "detachDataFileAssetFromFolder");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "detachDataFileAssetFromFolder", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse moveDataFileInCatalog(String serverName, String userId, String folderGUID, String fileGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "moveDataFileInCatalog";
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "moveDataFileInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "moveDataFileInCatalog");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "moveDataFileInCatalog");
            String externalSourceGUID = null;
            String externalSourceName = null;
            if (requestBody != null) {
                externalSourceGUID = requestBody.getExternalSourceGUID();
                externalSourceName = requestBody.getExternalSourceName();
            }
            handler.moveDataFileInCatalog(userId, externalSourceGUID, externalSourceName, folderGUID, "folderGUID", fileGUID, "fileGUID", null, null, false, false, new Date(), "moveDataFileInCatalog");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "moveDataFileInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse moveDataFolderInCatalog(String serverName, String userId, String newParentFolderGUID, String movingFolderGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "moveDataFileInCatalog";
        String newParentFolderGUIDParameterName = "newParentFolderGUID";
        String movingFolderGUIDParameterName = "movingFolderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "moveDataFileInCatalog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "moveDataFileInCatalog");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "moveDataFileInCatalog");
            String externalSourceGUID = null;
            String externalSourceName = null;
            if (requestBody != null) {
                externalSourceGUID = requestBody.getExternalSourceGUID();
                externalSourceName = requestBody.getExternalSourceName();
            }
            handler.moveDataFolderInCatalog(userId, externalSourceGUID, externalSourceName, newParentFolderGUID, "newParentFolderGUID", movingFolderGUID, "movingFolderGUID", null, null, false, false, new Date(), "moveDataFileInCatalog");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "moveDataFileInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FileSystemResponse getFileSystemByGUID(String serverName, String userId, String fileSystemGUID) {
        String methodName = "getFileSystemByGUID";
        String guidParameterName = "fileSystemGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFileSystemByGUID");
        FileSystemResponse response = new FileSystemResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystemByGUID");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFileSystemByGUID");
            FileSystemElement element = (FileSystemElement)handler.getFileSystemByGUID(userId, fileSystemGUID, "fileSystemGUID", false, false, new Date(), "getFileSystemByGUID");
            response.setElement(element);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getFileSystemByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FileSystemResponse getFileSystemByUniqueName(String serverName, String userId, String uniqueName) {
        String methodName = "getFileSystemByUniqueName";
        String parameterName = "uniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFileSystemByUniqueName");
        FileSystemResponse response = new FileSystemResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystemByUniqueName");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFileSystemByUniqueName");
            FileSystemElement element = (FileSystemElement)handler.getFileSystemByUniqueName(userId, uniqueName, "uniqueName", false, false, new Date(), "getFileSystemByUniqueName");
            response.setElement(element);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getFileSystemByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getFileSystems(String serverName, String userId, int startingFrom, int maxPageSize) {
        String methodName = "getFileSystems";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFileSystems");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFileSystems");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFileSystems");
            response.setGUIDs(handler.getFileSystems(userId, startingFrom, maxPageSize, false, false, new Date(), "getFileSystems"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getFileSystems", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FileFolderResponse getFolderByGUID(String serverName, String userId, String folderGUID) {
        String methodName = "getFolderByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFolderByGUID");
        FileFolderResponse response = new FileFolderResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderByGUID");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderByGUID");
            FileFolderElement fileFolder = (FileFolderElement)handler.getFolderByGUID(userId, folderGUID, false, false, new Date(), "getFolderByGUID");
            response.setElement(fileFolder);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getFolderByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FileFolderResponse getFolderByPathName(String serverName, String userId, PathNameRequestBody requestBody) {
        String methodName = "getFolderByPathName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFolderByPathName");
        FileFolderResponse response = new FileFolderResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderByPathName");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderByPathName");
                FileFolderElement fileFolder = (FileFolderElement)handler.getFolderByPathName(userId, requestBody.getPathName(), false, false, new Date(), "getFolderByPathName");
                response.setElement(fileFolder);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getFolderByPathName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getTopLevelFolders(String serverName, String userId, String fileSystemGUID, int startingFrom, int maxPageSize) {
        String methodName = "getTopLevelFolders";
        String guidParameterName = "fileSystemGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTopLevelFolders");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTopLevelFolders");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getTopLevelFolders");
            response.setGUIDs(handler.getTopLevelFolders(userId, fileSystemGUID, "fileSystemGUID", startingFrom, maxPageSize, false, false, new Date(), "getTopLevelFolders"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getTopLevelFolders", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getNestedFolders(String serverName, String userId, String parentFolderGUID, int startingFrom, int maxPageSize) {
        String methodName = "getNestedFolders";
        String guidParameterName = "parentFolderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNestedFolders");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNestedFolders");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getNestedFolders");
            response.setGUIDs(handler.getNestedFolders(userId, parentFolderGUID, "parentFolderGUID", startingFrom, maxPageSize, false, false, new Date(), "getNestedFolders"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getNestedFolders", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFilesResponse getFolderFiles(String serverName, String userId, String folderGUID, int startingFrom, int maxPageSize) {
        String methodName = "getFolderFiles";
        String guidParameterName = "folderGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFolderFiles");
        DataFilesResponse response = new DataFilesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFolderFiles");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getFolderFiles");
            response.setElements(handler.getFolderFiles(userId, folderGUID, "folderGUID", startingFrom, maxPageSize, false, false, new Date(), "getFolderFiles"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getFolderFiles", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFileResponse getDataFileByGUID(String serverName, String userId, String fileGUID) {
        String methodName = "getDataFileByGUID";
        String guidParameterName = "fileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFileByGUID");
        DataFileResponse response = new DataFileResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFileByGUID");
            FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getDataFileByGUID");
            DataFileElement dataFile = (DataFileElement)handler.getDataFileByGUID(userId, fileGUID, "fileGUID", false, false, new Date(), "getDataFileByGUID");
            response.setDataFile(dataFile);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataFileByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFileResponse getDataFileByPathName(String serverName, String userId, PathNameRequestBody requestBody) {
        String methodName = "getDataFileByPathName";
        String nameParameterName = "fullPath";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFileByPathName");
        DataFileResponse response = new DataFileResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFileByPathName");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getDataFileByPathName");
                DataFileElement dataFile = (DataFileElement)handler.getDataFileByPathName(userId, requestBody.getPathName(), "fullPath", false, false, new Date(), "getDataFileByPathName");
                response.setDataFile(dataFile);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataFileByPathName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFilesResponse getDataFilesByPathName(String serverName, String userId, int startingFrom, int maxPageSize, PathNameRequestBody requestBody) {
        String methodName = "getDataFileByPathName";
        String nameParameterName = "fullPath";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFileByPathName");
        DataFilesResponse response = new DataFilesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFileByPathName");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "getDataFileByPathName");
                List dataFiles = handler.findDataFilesByPathName(userId, requestBody.getPathName(), "fullPath", startingFrom, maxPageSize, false, false, new Date(), "getDataFileByPathName");
                response.setElements(dataFiles);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataFileByPathName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFilesResponse findDataFilesByPathName(String serverName, String userId, int startingFrom, int maxPageSize, PathNameRequestBody requestBody) {
        String methodName = "findDataFilesByPathName";
        String nameParameterName = "fullPath";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDataFilesByPathName");
        DataFilesResponse response = new DataFilesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDataFilesByPathName");
            if (requestBody != null) {
                FilesAndFoldersHandler<FileSystemElement, FileFolderElement, DataFileElement> handler = instanceHandler.getFilesAndFoldersHandler(userId, serverName, "findDataFilesByPathName");
                List dataFiles = handler.findDataFilesByName(userId, requestBody.getPathName(), "fullPath", startingFrom, maxPageSize, false, false, new Date(), "findDataFilesByPathName");
                response.setElements(dataFiles);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findDataFilesByPathName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

