/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.ffdc.DataManagerErrorCode;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.server.DataManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.DerivedSchemaTypeQueryTargetRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.EnumSchemaTypeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FormulaRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LiteralSchemaTypeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.MapSchemaTypeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PrimitiveSchemaTypeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaAttributeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaAttributeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaAttributesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaTypeChoiceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SchemaTypesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StructSchemaTypeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ValidValueSetsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ElementStubConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValuesHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ValidValueSetElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaAttributeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.LoggerFactory;

public class SchemaManagerRESTServices {
    private static final DataManagerInstanceHandler instanceHandler = new DataManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(SchemaManagerRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public GUIDResponse createPrimitiveSchemaType(String serverName, String userId, PrimitiveSchemaTypeRequestBody requestBody) {
        String methodName = "createPrimitiveSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createPrimitiveSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createPrimitiveSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createPrimitiveSchemaType");
            if (requestBody != null) {
                String schemaTypeGUID = handler.addPrimitiveSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getDataType(), requestBody.getDefaultValue(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, false, false, new Date(), "createPrimitiveSchemaType");
                handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), false, false, new Date(), "createPrimitiveSchemaType");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createPrimitiveSchemaType", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createPrimitiveSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createLiteralSchemaType(String serverName, String userId, LiteralSchemaTypeRequestBody requestBody) {
        String methodName = "createLiteralSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createLiteralSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createLiteralSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createLiteralSchemaType");
            if (requestBody != null) {
                String schemaTypeGUID = handler.addLiteralSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getDataType(), requestBody.getFixedValue(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, false, false, new Date(), "createLiteralSchemaType");
                handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), false, false, new Date(), "createLiteralSchemaType");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createLiteralSchemaType", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createLiteralSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEnumSchemaType(String serverName, String userId, String validValuesSetGUID, EnumSchemaTypeRequestBody requestBody) {
        String methodName = "createEnumSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEnumSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEnumSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createEnumSchemaType");
            if (requestBody != null) {
                String schemaTypeGUID = handler.addEnumSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getDataType(), requestBody.getDefaultValue(), validValuesSetGUID, requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, false, false, new Date(), "createEnumSchemaType");
                handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), false, false, new Date(), "createEnumSchemaType");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createEnumSchemaType", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createEnumSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueSetsResponse getValidValueSetByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getValidValueSetByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueSetByName");
        ValidValueSetsResponse response = new ValidValueSetsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueSetByName");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueSetElement> handler = instanceHandler.getValidValuesSetHandler(userId, serverName, "getValidValueSetByName");
                response.setElements(handler.getValidValueByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "getValidValueSetByName"), new Date(), "getValidValueSetByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getValidValueSetByName", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getValidValueSetByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueSetsResponse findValidValueSet(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findValidValueSet";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findValidValueSet");
        ValidValueSetsResponse response = new ValidValueSetsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findValidValueSet");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueSetElement> handler = instanceHandler.getValidValuesSetHandler(userId, serverName, "findValidValueSet");
                response.setElements(handler.findValidValues(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "findValidValueSet"), new Date(), "findValidValueSet"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findValidValueSet", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findValidValueSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createStructSchemaType(String serverName, String userId, StructSchemaTypeRequestBody requestBody) {
        String methodName = "createStructSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createStructSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createStructSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createStructSchemaType");
            if (requestBody != null) {
                String schemaTypeGUID = handler.addStructSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, false, false, new Date(), "createStructSchemaType");
                handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), false, false, new Date(), "createStructSchemaType");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createStructSchemaType", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createStructSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaTypeChoice(String serverName, String userId, SchemaTypeChoiceRequestBody requestBody) {
        String methodName = "createSchemaTypeChoice";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaTypeChoice");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaTypeChoice");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createSchemaTypeChoice");
            if (requestBody != null) {
                String schemaTypeGUID = handler.addSchemaTypeChoice(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, false, false, new Date(), "createSchemaTypeChoice");
                handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), false, false, new Date(), "createSchemaTypeChoice");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSchemaTypeChoice", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createSchemaTypeChoice", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createMapSchemaType(String serverName, String userId, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID, MapSchemaTypeRequestBody requestBody) {
        String methodName = "createMapSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createMapSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createMapSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createMapSchemaType");
            if (requestBody != null) {
                String schemaTypeGUID = handler.addMapSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), mapFromSchemaTypeGUID, mapToSchemaTypeGUID, requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, false, false, new Date(), "createMapSchemaType");
                handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), false, false, new Date(), "createMapSchemaType");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createMapSchemaType", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createMapSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaTypeFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createSchemaTypeFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaTypeFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaTypeFromTemplate");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "createSchemaTypeFromTemplate");
            if (requestBody != null) {
                String schemaTypeGUID = handler.createSchemaTypeFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), "createSchemaTypeFromTemplate");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSchemaTypeFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createSchemaTypeFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateSchemaType(String serverName, String userId, String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeRequestBody requestBody) {
        String methodName = "updateSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "updateSchemaType");
            if (requestBody != null) {
                handler.updateSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaTypeGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getVersionNumber(), requestBody.getIsDeprecated(), requestBody.getAuthor(), requestBody.getUsage(), requestBody.getEncodingStandard(), requestBody.getNamespace(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, isMergeUpdate, false, false, new Date(), "updateSchemaType");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, schemaTypeGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateSchemaType");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateSchemaType", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSchemaType(String serverName, String userId, String schemaTypeGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "removeSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "removeSchemaType");
            if (requestBody != null) {
                handler.removeSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaTypeGUID, false, false, new Date(), "removeSchemaType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeSchemaType", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupSchemaElementRelationship(String serverName, String userId, String endOneGUID, String relationshipTypeName, String endTwoGUID, RelationshipRequestBody requestBody) {
        VoidResponse response;
        RESTCallToken token;
        block7: {
            String methodName = "setupSchemaElementRelationship";
            String endOneParameterName = "endOneGUID";
            String endTwoParameterName = "endTwoGUID";
            String relationshipTypeParameterName = "relationshipTypeName";
            String propertiesParameterName = "properties";
            token = restCallLogger.logRESTCall(serverName, userId, "setupSchemaElementRelationship");
            response = new VoidResponse();
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "setupSchemaElementRelationship");
                SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "setupSchemaElementRelationship");
                this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "setupSchemaElementRelationship");
                String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, instanceHandler.getServiceName(), "setupSchemaElementRelationship", instanceHandler.getRepositoryHelper(userId, serverName, "setupSchemaElementRelationship"));
                if (requestBody != null) {
                    if (requestBody.getProperties() != null) {
                        InstanceProperties instanceProperties = null;
                        if (!requestBody.getProperties().getExtendedProperties().isEmpty()) {
                            try {
                                instanceProperties = instanceHandler.getRepositoryHelper(userId, serverName, "setupSchemaElementRelationship").addPropertyMapToInstance(instanceHandler.getServiceName(), null, requestBody.getProperties().getExtendedProperties(), "setupSchemaElementRelationship");
                            }
                            catch (Exception badPropertyException) {
                                throw new InvalidParameterException(DataManagerErrorCode.BAD_PARAMETER.getMessageDefinition(new String[]{relationshipTypeName, badPropertyException.getClass().getName(), badPropertyException.getMessage()}), this.getClass().getName(), "setupSchemaElementRelationship", badPropertyException, "properties");
                            }
                        }
                        handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), endOneGUID, "endOneGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, endTwoGUID, "endTwoGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, false, false, relationshipTypeGUID, relationshipTypeName, instanceProperties, requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), new Date(), "setupSchemaElementRelationship");
                        break block7;
                    }
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), endOneGUID, "endOneGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, endTwoGUID, "endTwoGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, false, false, relationshipTypeGUID, relationshipTypeName, (InstanceProperties)null, null, null, new Date(), "setupSchemaElementRelationship");
                    break block7;
                }
                handler.linkElementToElement(userId, null, null, endOneGUID, "endOneGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, endTwoGUID, "endTwoGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, false, false, relationshipTypeGUID, relationshipTypeName, (InstanceProperties)null, null, null, new Date(), "setupSchemaElementRelationship");
            }
            catch (Throwable error) {
                this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupSchemaElementRelationship", auditLog);
            }
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSchemaElementRelationship(String serverName, String userId, String endOneGUID, String relationshipTypeName, String endTwoGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "clearSchemaElementRelationship";
        String endOneParameterName = "endOneGUID";
        String endTwoParameterName = "endTwoGUID";
        String relationshipTypeParameterName = "relationshipTypeName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearSchemaElementRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSchemaElementRelationship");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "clearSchemaElementRelationship");
            this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "clearSchemaElementRelationship");
            String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, instanceHandler.getServiceName(), "clearSchemaElementRelationship", instanceHandler.getRepositoryHelper(userId, serverName, "clearSchemaElementRelationship"));
            if (requestBody != null) {
                handler.unlinkElementFromElement(userId, false, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), endOneGUID, "endOneGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, endTwoGUID, "endTwoGUID", OpenMetadataType.SCHEMA_ELEMENT.typeGUID, OpenMetadataType.SCHEMA_ELEMENT.typeName, false, false, relationshipTypeGUID, relationshipTypeName, new Date(), "clearSchemaElementRelationship");
            } else {
                handler.unlinkElementFromElement(userId, false, null, null, endOneGUID, "endOneGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, endTwoGUID, "endTwoGUID", OpenMetadataType.SCHEMA_ELEMENT.typeGUID, OpenMetadataType.SCHEMA_ELEMENT.typeName, false, false, relationshipTypeGUID, relationshipTypeName, new Date(), "clearSchemaElementRelationship");
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearSchemaElementRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypesResponse findSchemaType(String serverName, String userId, String typeName, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findSchemaType");
        SchemaTypesResponse response = new SchemaTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findSchemaType");
            if (requestBody != null) {
                SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "findSchemaType");
                List results = handler.findSchemaTypes(userId, typeName, requestBody.getSearchString(), startFrom, pageSize, false, false, new Date(), "findSchemaType");
                response.setElements(this.setUpVendorProperties(userId, results, handler, "findSchemaType"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findSchemaType", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypeResponse getSchemaTypeForElement(String serverName, String userId, String parentElementGUID, String parentElementTypeName) {
        String methodName = "findSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findSchemaType");
        SchemaTypeResponse response = new SchemaTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findSchemaType");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "findSchemaType");
            SchemaTypeElement result = (SchemaTypeElement)handler.getSchemaTypeForElement(userId, parentElementGUID, parentElementTypeName, false, false, new Date(), "findSchemaType");
            response.setElement(this.setUpVendorProperties(userId, result, handler, "findSchemaType"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypesResponse getSchemaTypeByName(String serverName, String userId, String typeName, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getSchemaTypeByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeByName");
        SchemaTypesResponse response = new SchemaTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeByName");
            if (requestBody != null) {
                SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "getSchemaTypeByName");
                List results = handler.getSchemaTypeByName(userId, typeName, requestBody.getName(), startFrom, pageSize, false, false, new Date(), "getSchemaTypeByName");
                response.setElements(this.setUpVendorProperties(userId, results, handler, "getSchemaTypeByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getSchemaTypeByName", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSchemaTypeByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypeResponse getSchemaTypeByGUID(String serverName, String userId, String schemaTypeGUID) {
        String methodName = "getSchemaTypeByGUID";
        String guidParameterName = "schemaTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeByGUID");
        SchemaTypeResponse response = new SchemaTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeByGUID");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "getSchemaTypeByGUID");
            SchemaTypeElement result = (SchemaTypeElement)handler.getSchemaType(userId, schemaTypeGUID, "schemaTypeGUID", false, false, new Date(), "getSchemaTypeByGUID");
            response.setElement(this.setUpVendorProperties(userId, result, handler, "getSchemaTypeByGUID"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSchemaTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubResponse getSchemaTypeParent(String serverName, String userId, String schemaTypeGUID) {
        String methodName = "getSchemaTypeByGUID";
        String guidParameterName = "schemaTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeByGUID");
        ElementStubResponse response = new ElementStubResponse();
        AuditLog auditLog = null;
        try {
            ElementStub parent = null;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeByGUID");
            SchemaTypeHandler<SchemaTypeElement> handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "getSchemaTypeByGUID");
            ElementStubConverter<ElementStub> converter = instanceHandler.getElementStubConverter(userId, serverName, "getSchemaTypeByGUID");
            List relationships = handler.getAttachmentLinks(userId, schemaTypeGUID, "schemaTypeGUID", OpenMetadataType.SCHEMA_TYPE.typeName, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, null, OpenMetadataType.ASSET.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, 0, 2, new Date(), "getSchemaTypeByGUID");
            if (relationships != null) {
                parent = (ElementStub)converter.getNewBean(ElementStub.class, (Relationship)relationships.get(0), true, "getSchemaTypeByGUID");
            } else {
                relationships = handler.getAttachmentLinks(userId, schemaTypeGUID, "schemaTypeGUID", OpenMetadataType.SCHEMA_TYPE.typeName, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeName, null, OpenMetadataType.PORT.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, 0, 2, new Date(), "getSchemaTypeByGUID");
                if (relationships != null) {
                    parent = (ElementStub)converter.getNewBean(ElementStub.class, (Relationship)relationships.get(0), true, "getSchemaTypeByGUID");
                }
            }
            response.setElement(parent);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSchemaTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaAttribute(String serverName, String userId, String schemaElementGUID, SchemaAttributeRequestBody requestBody) {
        String methodName = "createSchemaAttribute";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaAttribute");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaAttribute");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "createSchemaAttribute");
            if (requestBody != null) {
                String schemaAttributeGUID;
                int sortOrder = DataItemSortOrder.UNSORTED.getOrdinal();
                if (requestBody.getSortOrder() != null) {
                    sortOrder = requestBody.getSortOrder().getOrdinal();
                }
                if ((schemaAttributeGUID = handler.createNestedSchemaAttribute(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaElementGUID, "schemaElementGUID", requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getExternalTypeGUID(), requestBody.getDataType(), requestBody.getDefaultValue(), requestBody.getFixedValue(), requestBody.getValidValuesSetGUID(), null, requestBody.getIsDeprecated(), requestBody.getElementPosition(), requestBody.getMinCardinality(), requestBody.getMaxCardinality(), requestBody.getAllowsDuplicateValues(), requestBody.getOrderedValues(), requestBody.getDefaultValueOverride(), sortOrder, requestBody.getMinimumLength(), requestBody.getLength(), requestBody.getPrecision(), requestBody.getIsNullable(), requestBody.getNativeJavaClass(), requestBody.getAliases(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, false, false, new Date(), "createSchemaAttribute")) != null && requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, schemaAttributeGUID, requestBody.getVendorProperties(), false, false, new Date(), "createSchemaAttribute");
                }
                response.setGUID(schemaAttributeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSchemaAttribute", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createSchemaAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaAttributeFromTemplate(String serverName, String userId, String schemaElementGUID, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createSchemaAttributeFromTemplate";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaAttributeFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaAttributeFromTemplate");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "createSchemaAttributeFromTemplate");
            if (requestBody != null) {
                String schemaTypeGUID = handler.createSchemaAttributeFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaElementGUID, "schemaElementGUID", templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), false, false, new Date(), "createSchemaAttributeFromTemplate");
                response.setGUID(schemaTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSchemaAttributeFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createSchemaAttributeFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupSchemaType(String serverName, String userId, String relationshipTypeName, String schemaAttributeGUID, String schemaTypeGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "setupSchemaType";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupSchemaType");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "setupSchemaType");
            if (requestBody != null) {
                if (relationshipTypeName != null) {
                    TypeDef relationshipTypeDef = handler.getRepositoryHelper().getTypeDefByName(instanceHandler.getServiceName(), relationshipTypeName);
                    if (relationshipTypeDef != null) {
                        handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaAttributeGUID, "schemaAttributeGUID", OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, schemaTypeGUID, "schemaTypeGUID", OpenMetadataType.SCHEMA_TYPE.typeName, false, false, relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), (InstanceProperties)null, null, null, new Date(), "setupSchemaType");
                    }
                } else {
                    this.restExceptionHandler.handleMissingValue("relationshipTypeName", "setupSchemaType");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupSchemaType", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSchemaTypes(String serverName, String userId, String schemaAttributeGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "clearSchemaTypes";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearSchemaTypes");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSchemaTypes");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "clearSchemaTypes");
            if (requestBody != null) {
                handler.removeSchemaTypes(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaAttributeGUID, "schemaAttributeGUID", false, false, new Date(), "clearSchemaTypes");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearSchemaTypes", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearSchemaTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateSchemaAttribute(String serverName, String userId, String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeRequestBody requestBody) {
        String methodName = "updateSchemaAttribute";
        String elementGUIDParameterName = "schemaAttributeGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateSchemaAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateSchemaAttribute");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "updateSchemaAttribute");
            if (requestBody != null) {
                int sortOrder = DataItemSortOrder.UNSORTED.getOrdinal();
                if (requestBody.getSortOrder() != null) {
                    sortOrder = requestBody.getSortOrder().getOrdinal();
                }
                handler.updateSchemaAttribute(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaAttributeGUID, "schemaAttributeGUID", requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getExternalTypeGUID(), requestBody.getDataType(), requestBody.getDefaultValue(), requestBody.getFixedValue(), requestBody.getValidValuesSetGUID(), null, requestBody.getIsDeprecated(), requestBody.getElementPosition(), requestBody.getMinCardinality(), requestBody.getMaxCardinality(), requestBody.getAllowsDuplicateValues(), requestBody.getOrderedValues(), requestBody.getDefaultValueOverride(), sortOrder, requestBody.getMinimumLength(), requestBody.getLength(), requestBody.getPrecision(), requestBody.getIsNullable(), requestBody.getNativeJavaClass(), requestBody.getAliases(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, isMergeUpdate, false, false, new Date(), "updateSchemaAttribute");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, schemaAttributeGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateSchemaAttribute");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateSchemaAttribute", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateSchemaAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSchemaAttribute(String serverName, String userId, String schemaAttributeGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "removeSchemaAttribute";
        String elementGUIDParameterName = "schemaAttributeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSchemaAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSchemaAttribute");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "removeSchemaAttribute");
            if (requestBody != null) {
                handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaAttributeGUID, "schemaAttributeGUID", OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, false, null, null, false, false, new Date(), "removeSchemaAttribute");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeSchemaAttribute", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeSchemaAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributesResponse findSchemaAttributes(String serverName, String userId, String typeName, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findSchemaAttributes";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findSchemaAttributes");
        SchemaAttributesResponse response = new SchemaAttributesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findSchemaAttributes");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "findSchemaAttributes");
            TypeDef typeDef = handler.getTypeDefByName(typeName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName);
            if (typeDef != null) {
                List results = handler.findSchemaAttributes(userId, requestBody.getSearchString(), "searchString", typeDef.getGUID(), typeDef.getName(), null, null, startFrom, pageSize, false, false, new Date(), "findSchemaAttributes");
                response.setElements(this.setUpVendorProperties(userId, results, handler, "findSchemaAttributes"));
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findSchemaAttributes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributesResponse getNestedAttributes(String serverName, String userId, String parentSchemaElementGUID, int startFrom, int pageSize) {
        String methodName = "getNestedAttributes";
        String elementGUIDParameterName = "schemaAttributeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNestedAttributes");
        SchemaAttributesResponse response = new SchemaAttributesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNestedAttributes");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "getNestedAttributes");
            List results = handler.getAttachedSchemaAttributes(userId, parentSchemaElementGUID, "schemaAttributeGUID", OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, startFrom, pageSize, false, false, new Date(), "getNestedAttributes");
            response.setElements(this.setUpVendorProperties(userId, results, handler, "getNestedAttributes"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getNestedAttributes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributesResponse getSchemaAttributesByName(String serverName, String userId, String typeName, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getSchemaAttributesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaAttributesByName");
        SchemaAttributesResponse response = new SchemaAttributesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaAttributesByName");
            if (requestBody != null) {
                SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "getSchemaAttributesByName");
                TypeDef typeDef = handler.getTypeDefByName(typeName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName);
                if (typeDef != null) {
                    List results = handler.getSchemaAttributesByName(userId, typeDef.getGUID(), typeDef.getName(), requestBody.getName(), null, null, startFrom, pageSize, false, false, new Date(), "getSchemaAttributesByName");
                    response.setElements(this.setUpVendorProperties(userId, results, handler, "getSchemaAttributesByName"));
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getSchemaAttributesByName", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSchemaAttributesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributeResponse getSchemaAttributeByGUID(String serverName, String userId, String schemaAttributeGUID) {
        String methodName = "getSchemaAttributeByGUID";
        String guidParameterName = "schemaAttributeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaAttributeByGUID");
        SchemaAttributeResponse response = new SchemaAttributeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaAttributeByGUID");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "getSchemaAttributeByGUID");
            SchemaAttributeElement result = (SchemaAttributeElement)handler.getSchemaAttribute(userId, schemaAttributeGUID, "schemaAttributeGUID", OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, null, null, false, false, new Date(), "getSchemaAttributeByGUID");
            response.setElement(this.setUpVendorProperties(userId, result, handler, "getSchemaAttributeByGUID"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSchemaAttributeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupCalculatedValue(String serverName, String userId, String schemaElementGUID, FormulaRequestBody requestBody) {
        String methodName = "setupCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupCalculatedValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupCalculatedValue");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "setupCalculatedValue");
            SchemaAttributeBuilder builder = new SchemaAttributeBuilder(handler.getRepositoryHelper(), instanceHandler.getServiceName(), serverName);
            handler.setClassificationInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaElementGUID, "schemaElementGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeGUID, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, builder.getCalculatedValueProperties(requestBody.getFormula(), "setupCalculatedValue"), false, false, false, new Date(), "setupCalculatedValue");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupCalculatedValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearCalculatedValue(String serverName, String userId, String schemaElementGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "clearCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearCalculatedValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearCalculatedValue");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "clearCalculatedValue");
            handler.removeClassificationFromRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), schemaElementGUID, "schemaElementGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeGUID, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, false, false, new Date(), "clearCalculatedValue");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearCalculatedValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupQueryTargetRelationship(String serverName, String userId, String derivedElementGUID, String queryTargetGUID, DerivedSchemaTypeQueryTargetRequestBody requestBody) {
        String methodName = "setupQueryTargetRelationship";
        String schemaElementGUIDParameterName = "derivedElementGUID";
        String queryTargetGUIDParameterName = "queryTargetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupQueryTargetRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupQueryTargetRelationship");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "setupQueryTargetRelationship");
            handler.setupQueryTargetRelationship(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), derivedElementGUID, "derivedElementGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, requestBody.getQueryId(), requestBody.getQuery(), queryTargetGUID, "queryTargetGUID", null, null, false, false, new Date(), "setupQueryTargetRelationship");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupQueryTargetRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateQueryTargetRelationship(String serverName, String userId, String derivedElementGUID, String queryTargetGUID, DerivedSchemaTypeQueryTargetRequestBody requestBody) {
        String methodName = "updateQueryTargetRelationship";
        String schemaElementGUIDParameterName = "derivedElementGUID";
        String queryTargetGUIDParameterName = "queryTargetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateQueryTargetRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateQueryTargetRelationship");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "updateQueryTargetRelationship");
            handler.updateQueryTargetRelationship(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), derivedElementGUID, "derivedElementGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, requestBody.getQueryId(), requestBody.getQuery(), queryTargetGUID, "queryTargetGUID", null, null, true, false, false, new Date(), "updateQueryTargetRelationship");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateQueryTargetRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearQueryTargetRelationship(String serverName, String userId, String derivedElementGUID, String queryTargetGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "clearQueryTargetRelationship";
        String schemaElementGUIDParameterName = "derivedElementGUID";
        String queryTargetGUIDParameterName = "queryTargetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearQueryTargetRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearQueryTargetRelationship");
            SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "clearQueryTargetRelationship");
            handler.clearQueryTargetRelationship(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), derivedElementGUID, "derivedElementGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, queryTargetGUID, "queryTargetGUID", "clearQueryTargetRelationship");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearQueryTargetRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<SchemaTypeElement> setUpVendorProperties(String userId, List<SchemaTypeElement> retrievedResults, SchemaTypeHandler<SchemaTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (SchemaTypeElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private SchemaTypeElement setUpVendorProperties(String userId, SchemaTypeElement element, SchemaTypeHandler<SchemaTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            SchemaTypeProperties properties = element.getSchemaTypeProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    private List<SchemaAttributeElement> setUpVendorProperties(String userId, List<SchemaAttributeElement> retrievedResults, SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (SchemaAttributeElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private SchemaAttributeElement setUpVendorProperties(String userId, SchemaAttributeElement element, SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            SchemaAttributeProperties properties = element.getSchemaAttributeProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }
}

